/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.utils;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonUserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUserUtils.class);
    private TransactionTemplate transactionTemplate;
    private static DirectoryManager directoryManager;
    private static UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserManager userManager;

    @Autowired
    public CommonUserUtils(TransactionTemplate transactionTemplate, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService) {
        this.transactionTemplate = transactionTemplate;
        CommonUserUtils.directoryManager = directoryManager;
        CommonUserUtils.settings = settings;
        this.crowdService = crowdService;
        this.userManager = this.userManager;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex) {
        List<Object> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            userListToReturn = users.stream().map(UserTemplate::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public int getTotalSearchResults(String searchQuery) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                totalUserCount += directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public List<User> getActiveUsers() {
        ArrayList<User> users = new ArrayList<User>();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)""), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"")}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return users;
    }

    private void updateAndLogUserUpdate(UserTemplate user) {
        try {
            directoryManager.updateUser(user.getDirectoryId(), user);
            LOGGER.info("Status updated of user: " + user.getName());
        }
        catch (Exception e) {
            LOGGER.error("Exception while updating user " + user.getName());
        }
    }

    public URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

