/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PremiumFeaturesAction
extends HttpServlet {
    private static final String PREMIUMPLUGIN_ACTION_PATH = "/templates/premium.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(PremiumFeaturesAction.class);
    private TemplateRenderer renderer;
    private UserManagementPluginSettings settings;
    private UserManager userManager;
    private CommonUserUtils commonUserUtils;
    private LoginUriProvider loginUriProvider;

    public PremiumFeaturesAction(TemplateRenderer renderer, UserManagementPluginSettings settings, UserManager userManager, CommonUserUtils commonUserUtils, LoginUriProvider loginUriProvider) {
        this.renderer = renderer;
        this.settings = settings;
        this.userManager = userManager;
        this.commonUserUtils = commonUserUtils;
        this.loginUriProvider = loginUriProvider;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("Premium Features doGet() method call");
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(PREMIUMPLUGIN_ACTION_PATH, this.initializePremiumFeaturesConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    HashMap<String, Object> initializePremiumFeaturesConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        return context;
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }
}

