<html>
<head>
	<title>Bulk User Management</title>
    <meta name="decorator" content="atl.general">
    <meta name="section" content="users">
<style>
    <#include "/css/bulkUserManagement.css" parse=true>
</style>
<script>
    <#include "/js/bulkUserManagement.js" parse=true>
</script>
</head>
<body>
<#include "/templates/header.ftl" parse=true>
<div class="aui-tabs horizontal-tabs"  id="tabs-example1" role="application">
            <ul class="tabs-menu" role="tablist" style="margin-top: 20px; font-size: 16px;">
                <li class="menu-item active-tab" role="presentation">
                        <a href="#userManagement" id="aui-uid-0" role="tab" aria-selected="true">
                            <strong>User Management</strong>
                        </a>
                    </li>
                    <li class="menu-item premium-tab" role="presentation" >
                        <a href="#licensing-plans" id="aui-uid-1" role="tab" aria-selected="true">
                            <strong><b>Premium Features</b></strong>
                        </a>
                    </li>
                    <li class="menu-item" role="presentation">
                        <a href="#troubleshooting" id="aui-uid-2" role="tab" aria-selected="true">
                            <strong>Troubleshooting</strong>
                        </a>
                    </li>
            </ul>
	<div class="tabs-pane active-pane" id="userManagement" aria-labelledby="aui-uid-0" role="tabpanel" aria-hidden="true" style="min-width:980px;">
        <div class="aui-message aui-message-warning" style="background-color: #fffae6;">

            <p style="font-size:12pt;">You are using the free version of the plugin, you can apply each operation on<b> 10 users</b>. Upgrade to the premium version for unlimited access.</p>
        </div>

        <input type="hidden" id="showPopup" value="${showPopup}"></input>


           <!-- Popup message  -->
        <div id="overlay" class="overlay"></div>
        <div id="popup" class="popup">
            <span class="close-button closeButton">&times;</span>
            <span style="display: flex; align-items: center;">
                <img src="${settings.getBaseUrl()}/rest/plugins/1.0/com.miniorange.usermanagement.crowd-user-management-key/media/plugin-logo" style="margin-right: 10px;">
                <h2>Welcome to miniOrange Crowd Bulk User Management Add-On</h2>
            </span>

            <p class="desc" style = "text-align:justify;" >Explore miniOrange Crowd Bulk User Management to enhance cost-efficiency,
                improve security, and facilitate agile collaboration within the Atlassian environment.
                Bulk User Management solution automates various tasks, savings on license cost,
                and enhanced security measures.</p><br>
            <p class="desc">
                Currently, you have access to the <strong>free features</strong> of the plugin, which include :
                <ul>
                <li>Activate Users</li>
                 <li>Deactivate Users</li>
                <li>Delete Users</li>
                </ul>
            </p>
            <p class="desc">
                <strong class="blue-text">Additionally, with our Premium Plugin, enjoy exclusive access to advanced features:</strong>
            </p>
            <ul>
                <li>Efficient Bulk User Activation and Deactivation</li>
                <li>Bulk deletion/deactivation of idle users to optimize user licenses</li>
                <li>Optimize User Management: Automated Scheduling for Easy Deactivation</li>
                <li>Simplify import/export of users in CSV format with single click</li>
                <li>Seamless support for remote external directories</li>
                <li>User search capabilities based on filter criteria like user status, groups, names, and emails</li>

            </ul>
            <input type="button" class="aui-button aui-button-primary closeButton" value="Close" style="float: right;" />

        </div>

        <form class="aui" id="managementForm" action="">
            <input type="hidden" name="page" value="${page}"/>
            <div style="margin-top:50px">
				<aui-select name="bulkAction" id="bulkAction" placeholder="Select Action">
					<aui-option value="activate">Activate Users</aui-option>
					<aui-option value="deactivate">Deactivate Users</aui-option>
					<aui-option value="delete">Delete Users</aui-option>
				</aui-select>&nbsp;
				<input type="button" id="apply" class="aui-button aui-button-primary" value="Apply" />
				<button data-aui-trigger aria-controls="auto_deactivator" style="float: right;" class="aui-button auto_deactivator">Auto Deactivation</button>
				<aui-inline-dialog responds-to="hover" id="auto_deactivator" alignment="bottom center" style="background-color: aliceblue;font-weight: 500;">
					<p class="desc">Available with Premium version.</p>
				</aui-inline-dialog>

				<hr class="header"/>

            </div>
            <table style="margin-top:20px" class="aui aui-table-interactive large-rows fit-columns">
            <thead>
                <tr>
                    <th style="width:5%;">

                        <span>
                            <input type="checkbox" id="selectAll" value="true" title="Select All"/>
                        </span>
                    </th>
                    <th style="width:15%;">
                        <span>Name</span>
                    </th>
                    <th style="width:15%;">
                        <span>Username</span>
                    </th>
                    <th style="width:20%;">
                        <span>Email</span>
                    </th>
                    <th style="width:25%;">
                        <span>Directory</span>
                    </th>
                    <th style="width: 10%;">
                        <span>Status</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                <#assign userlistsize = userTemplates.size()>
                <#assign count = 0>
                <#assign userPerPage=20>
                <#assign userLoopCount = 0>
                <#foreach user in userTemplates>
                <#assign endIndex = startIndex + userPerPage>
                <#assign userIndex = "userIndex" + userLoopCount>

                <#if userLoopCount gte startIndex &&  userLoopCount lt endIndex>
                    <tr class="table-body" style="height:45px">
                    <td>
                        <input class="checkbox" type="checkbox" id="${(user.getName())! ""}" data-directory="${(user.getDirectoryId())! ""}" value="true" />
                    </td>
                    <td class="display-name" class="apply-overflow">
                        <div>
                            <span class="aui-icon aui-iconfont-user aui-icon-small"></span>
                                <a data-test="entity-link" href="${settings.getBaseUrl()}/console/secure/user/view!execute.action?name=${(user.getName())! ""}&amp;directoryID=${((user.getDirectoryId())! "")?replace(",","")}" target="_blank" title="${(user.getName())!""}">${(user.getDisplayName())!""}</a>
                        </div>
                    </td>
                    <td class="user-name" title="${(user.getName())! ""}" class="apply-overflow">${(user.getName())! ""}</td>
                    <td title="${(user.getEmailAddress())! ""}" class="apply-overflow">${(user.getEmailAddress())! ""}</td>
                    <td class="apply-overflow">
                        <div>
                            <span class="aui-icon aui-iconfont-nav-children-large aui-icon-small"></span>
                            <a data-test="entity-link" href="${settings.getBaseUrl()}/console/secure/directory/viewinternal.action?ID=${((user.getDirectoryId())! "")?replace(",","")}" target="_blank" title=" ">${(directoryManager.findDirectoryById(user.getDirectoryId()).getName())! ""} </a>
                        </div>
                    </td>

                    <td>
                        <#if user.isActive() >
                        <span class="aui-lozenge aui-lozenge-success" >
                            Active</span>
                        <#else>
                        <span class="aui-lozenge aui-lozenge-error">
                            inactive</span>
                        </#if>
                    </td>
                    </tr>
                </#if>
                <#assign userLoopCount=userLoopCount+1>
                <#assign count =count+1>
                </#foreach>
            </tbody>
            </table>
            <div style="margin:20px">
				<p class="desc">Displaying Users <b>${startIndex+1}</b> to <b><#if endIndex gt numberOfUsers>${numberOfUsers}<#else>${endIndex}</#if></b> of <b>${numberOfUsers}</b></p>
				<span style="margin:20px;float:right; font-size:16px; position:relative ; bottom:45px ;">
					<a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=1" <#if page==1> hidden </#if> ><b>First</b></a>&nbsp;
					<a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=${page-1}" <#if page==1> hidden </#if> ><b>Prev</b></a>&nbsp;
						<#if (numberOfPages<30) >
                        <#list 1..numberOfPages+1 as index>
                            <#if index== page>
                            <span><b>${index}</b></span>
                            <#else>
                            <a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=${index}">${index}</a>&nbsp;
                            </#if>
                        </#list>
                    <#else>
                        <#if (page-11>1)>
                            <span>....</span>
                        </#if>
                        <#list page-11..page+12 as index>
                            <#if index== page>
                            <span><b>${index}</b></span>
                            </#if>
                            <#if (index>0) && (page!=index) && (index< numberOfPages+2) >
                                <a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=${index}">${index}</a>&nbsp;
                            </#if>
                        </#list>
                        <#if (page+12<numberOfPages+1)>
                            <span>....</span>
                        </#if>
                    </#if>
					<a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=${page+1}" <#if page == numberOfPages+1> hidden </#if> ><b>Next</b></a>&nbsp;
					<a href="${settings.getBaseUrl()}/console/secure/plugins/crowd-user-management/configure.action?page=${numberOfPages+1}" <#if page==numberOfPages+1> hidden </#if> ><b>Last</b></a>&nbsp;
				</span>
            </div>
        </form>
    </div>
	<div class="tabs-pane" id="licensing-plans" aria-labelledby="aui-uid-1" role="tabpanel" aria-hidden="false" style="min-width:980px;">
		<#include "/templates/premiumFeatures.ftl" parse=true>
	</div>
	<div class="tabs-pane" id="troubleshooting" aria-labelledby="aui-uid-2" role="tabpanel" aria-hidden="false" style="min-width:980px;">
    	<#include "/templates/troubleshooting.ftl" parse=true>
    </div>

</div>

</body>
</html>