/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.service.HomeDirectoryService;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.common.utils.CommonUserUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxCallServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxCallServlet.class);
    private CrowdService crowdService;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private I18nHelper i18nHelper;
    private UserManagementPluginSettings settings;
    private CommonUserUtils commonUserUtils;
    @ComponentImport
    private HomeDirectoryService homeDirectoryService;

    @Inject
    public AjaxCallServlet(CommonUserUtils commonUserUtils, HomeDirectoryService homeDirectoryService, UserManager userManager, DirectoryManager directoryManager, I18nHelper i18nHelper, UserManagementPluginSettings settings, CrowdService crowdService) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.i18nHelper = i18nHelper;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
        this.homeDirectoryService = homeDirectoryService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doPost Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String userName = req.getParameter("userName");
            String directoryId = req.getParameter("directoryId").replaceAll(",", "");
            String action = req.getParameter("action");
            Long dictId = Long.parseLong(directoryId.replaceAll(",", "").replaceAll(" ", ""));
            LOGGER.debug("directory Id :" + dictId);
            if (userName != null && action != null && this.settings.isLicenseValid()) {
                switch (action) {
                    case "activate": 
                    case "deactivate": {
                        this.activateOrDeactivateUser(userName, dictId, action, resp);
                        break;
                    }
                    case "delete": {
                        this.deleteUsers(userName, dictId, resp);
                        break;
                    }
                    case "RemoveGroupsFromUser": {
                        this.RemoveGroupsFromUser(action, req, resp);
                        break;
                    }
                    case "AddGroupsInUser": {
                        this.AddGroupsInUser(dictId, req, resp);
                        break;
                    }
                    default: {
                        LOGGER.error("Invalid action");
                        this.sendErrorResponse("Invalid Action", 400, resp);
                        break;
                    }
                }
            } else {
                LOGGER.error("Invalid License/Username");
                this.sendErrorResponse("Invalid License check logs for more details", 400, resp);
            }
        } else {
            LOGGER.error("Admin access required");
            this.sendErrorResponse("Admin Access Required", 400, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doGet Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String search = StringUtils.trim((String)req.getParameter("search"));
            String action = req.getParameter("action");
            LOGGER.debug("Action:" + action + " userName:" + search);
            switch (action) {
                case "CheckEvalLicense": {
                    if (this.settings.isLicenseValid()) break;
                    LOGGER.error("Evaluation license found for app. Operations will be allowed for only 10 users");
                    try {
                        this.sendErrorResponse("Error_User_eval_License", 400, resp);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case "getUsers": {
                    this.getUsers(search, resp);
                    break;
                }
                case "fetchGroups": {
                    this.fetchGroups(search, resp);
                    break;
                }
                case "changeSortLastLoginButton": {
                    this.changeSortLastLoginButton(req, resp);
                    break;
                }
                case "bulkCreationGroup": {
                    this.bulkCreationGroup(req, resp);
                    break;
                }
                case "ChangeGroupManagementSelectedAction": {
                    this.changeGroupManagementSelectedAction(req, resp);
                    break;
                }
                case "changeGroupManagementCreationSelectedAction": {
                    this.changeGroupManagementCreationSelectedAction(req, resp);
                    break;
                }
                case "BulkDeletionGroup": {
                    this.bulkDeletionGroup(req, resp);
                    break;
                }
                case "regexTestingExcludeGroups": {
                    this.showRegexTestForExcludeGroups(req, resp);
                    break;
                }
                case "enableDebugLogs": {
                    this.enableDebugLogs(req, resp);
                    break;
                }
                case "downloadCrowdLogs": {
                    this.downloadCrowdLogs(req, resp);
                }
            }
        } else {
            LOGGER.debug("Not an admin user");
        }
    }

    public void showRegexTestForExcludeGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = request.getParameter("regexp");
        String groupName = request.getParameter("groupName");
        Boolean result = Boolean.FALSE;
        regexp = StringEscapeUtils.escapeJavaScript((String)regexp);
        groupName = StringEscapeUtils.escapeJavaScript((String)groupName);
        if (StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = this.testRegexForExcludeGroups(regexp, groupName);
            LOGGER.debug(" Regex test result is :- " + result);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            if (result == Boolean.TRUE) {
                output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Result</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td align=\"center\" style=\"color:green;\">SUCCESS</td>\n        <td align=\"center\">PATTERN FOUND</td>\n    </tr>    \n    </tbody></table>");
            } else {
                output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Result</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td align=\"center\" style=\"color:red;\">FAILURE</td>\n        <td align=\"center\">PATTERN NOT FOUND</td>\n    </tr>    \n    </tbody></table>");
            }
        }
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    private Boolean testRegexForExcludeGroups(String regExp, String groupname) {
        try {
            Pattern pattern = Pattern.compile(regExp, 2);
            Matcher matcher = pattern.matcher(groupname);
            return matcher.find();
        }
        catch (Exception e) {
            LOGGER.error("Exception while applying regex on exclude group name...", (Throwable)e);
            return false;
        }
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean enableDebugLogs = BooleanUtils.toBoolean((String)req.getParameter("enableDebugLogs"));
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"com.miniorange.usermanagement");
        if (enableDebugLogs.booleanValue()) {
            logger.setLevel(Level.DEBUG);
        } else {
            logger.setLevel(Level.INFO);
        }
        this.settings.setEnableDebugLogs(enableDebugLogs);
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    private void downloadCrowdLogs(HttpServletRequest req, HttpServletResponse resp) {
        File dataFolder = new File(this.homeDirectoryService.getLocalHome());
        File logsFolder = null;
        File crowdLogsFile = null;
        try {
            for (File f : dataFolder.listFiles()) {
                if (!f.isDirectory() || !StringUtils.equalsIgnoreCase((CharSequence)f.getName(), (CharSequence)"logs")) continue;
                logsFolder = f;
                break;
            }
            for (File f : logsFolder.listFiles()) {
                if (!f.isFile() || !StringUtils.equalsIgnoreCase((CharSequence)f.getName(), (CharSequence)"atlassian-crowd.log")) continue;
                crowdLogsFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-crowd.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile((File)crowdLogsFile, (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            LOGGER.error("Error in retrieving the Logs file");
        }
    }

    private void changeSortLastLoginButton(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String CreationSelectedAction = req.getParameter("selectedAction");
            this.settings.setSortByLastLogin(BooleanUtils.toBoolean((String)CreationSelectedAction));
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while updating Sort By Last Login " + e.getMessage());
            this.sendErrorResponse("Error", 500, resp);
        }
    }

    private void fetchGroups(String search, HttpServletResponse resp) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)search, (CharSequence)"*")) {
                search = "";
            }
            this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
            ArrayList finalGroups = new ArrayList();
            List allDirectories = this.directoryManager.findAllDirectories();
            for (Directory directory : allDirectories) {
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), query);
                finalGroups.addAll(groups);
            }
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            HashSet<String> uniqueGroupNames = new HashSet<String>();
            for (Group groupName : finalGroups) {
                String name = groupName.getName();
                if (uniqueGroupNames.contains(name)) continue;
                uniqueGroupNames.add(name);
                HashMap<String, String> groupResultsMap = new HashMap<String, String>();
                groupResultsMap.put("id", name);
                groupResultsMap.put("text", name);
                resultArray.put(groupResultsMap);
            }
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkCreationGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            LOGGER.debug("Bulk group Creation called");
            String groupsToAdd = request.getParameter("groupsToAdd");
            Object[] roleValuesList = StringUtils.split((String)groupsToAdd.trim(), (String)";");
            String selectDirectory = request.getParameter("selectedDirectory");
            if (StringUtils.isNotBlank((CharSequence)selectDirectory)) {
                selectDirectory = selectDirectory.trim();
            }
            LOGGER.debug("selectDirectory : " + selectDirectory);
            LOGGER.debug("groupsToAdd : " + groupsToAdd + " : List : " + Arrays.toString(roleValuesList));
            Directory directory = null;
            try {
                if (!selectDirectory.contains("directoryNotSelected") && selectDirectory != "") {
                    directory = this.directoryManager.findDirectoryByName(selectDirectory);
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
                return;
            }
            long directoryID = directory.getId();
            String groupsAlreadyExist = "";
            Object groupsCreated = "";
            LOGGER.debug(" directoryID : " + directoryID);
            try {
                for (Object groupName : roleValuesList) {
                    if (((String)groupName).length() <= 0) continue;
                    Boolean groupExist = Boolean.FALSE;
                    try {
                        this.directoryManager.findGroupByName(directoryID, ((String)groupName).trim());
                        groupExist = Boolean.TRUE;
                        LOGGER.debug("Group Exist :" + (String)groupName);
                    }
                    catch (Exception groupTemplate) {
                    }
                    finally {
                        if (!groupExist.booleanValue()) {
                            LOGGER.debug("Creating new Group with name : " + (String)groupName);
                            GroupTemplate groupTemplate = new GroupTemplate(((String)groupName).trim(), directoryID);
                            this.directoryManager.addGroup(directoryID, groupTemplate);
                            LOGGER.debug("Group added " + (String)groupName);
                            groupsCreated = ((String)groupsCreated).isEmpty() ? groupName : (String)groupsCreated + ", " + (String)groupName;
                        } else {
                            groupsAlreadyExist = groupsAlreadyExist + ',' + ((String)groupName).trim();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while creating groups : " + e.getMessage());
            }
            JSONObject data = new JSONObject();
            data.put("groupsAlreadyExist", groupsAlreadyExist);
            data.put("groupsCreated", groupsCreated);
            LOGGER.debug("Sending groups creation response :");
            this.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void changeGroupManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String selectedAction = request.getParameter("selectedAction");
            this.settings.setUserManagementSelectedAction(selectedAction);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Group management selection :" + e.getMessage());
            this.sendErrorResponse("Error in Group management selection", 500, response);
        }
    }

    private void changeGroupManagementCreationSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String CreationSelectedAction = request.getParameter("CreationSelectedAction");
            this.settings.setCreationSelection(CreationSelectedAction);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorResponse("Error in Group creation selection", 500, response);
        }
    }

    private void getUsers(String searchString, HttpServletResponse resp) {
        try {
            List<UserTemplate> users = this.commonUserUtils.getAllUsers(searchString, false, false, 0L, 0);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (UserTemplate user : users) {
                HashMap<String, Object> userResultsMap = new HashMap<String, Object>();
                userResultsMap.put("id", user.getName());
                userResultsMap.put("text", user.getName());
                resultArray.put(userResultsMap);
            }
            data.put("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching users via Ajax calls", (Throwable)e);
        }
    }

    private void AddGroupsInUser(Long directoryId, HttpServletRequest request, HttpServletResponse response) {
        String userName = request.getParameter("userName").trim();
        String GroupsList = request.getParameter("groupsToAdd").trim();
        LOGGER.debug("username: " + userName + " GroupList: " + GroupsList + " directoryId: " + directoryId);
        ArrayList<String> groupsToadd = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
        try {
            if (!GroupsList.isEmpty()) {
                for (String group : groupsToadd) {
                    this.AddUserInGroup(directoryId, group, userName, request, response);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void AddUserInGroup(Long directoryId, String group, String userName, HttpServletRequest request, HttpServletResponse response) throws DirectoryPermissionException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException, IOException {
        try {
            LOGGER.debug("group to add is:" + group + "in directory: " + directoryId + " for use:" + userName);
            boolean isUserPresentInGroup = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, group);
            LOGGER.debug("is user already present in group: " + isUserPresentInGroup);
            if (!isUserPresentInGroup) {
                this.directoryManager.addUserToGroup(directoryId.longValue(), userName, group);
                LOGGER.debug("group: " + group + " Added Successfully in user: " + userName);
            }
        }
        catch (DirectoryNotFoundException e) {
            LOGGER.error("directory with the given directoryId cannot be found.", (Throwable)e);
        }
        catch (GroupNotFoundException e) {
            LOGGER.error("Group does not exist in the directory", (Throwable)e);
            this.sendErrorResponseForUsers(group, "Group does not exist in the directory", 500, response);
        }
        catch (UserNotFoundException e) {
            LOGGER.error("User does not exist in the directory", (Throwable)e);
        }
    }

    private void RemoveGroupsFromUser(String action, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Remove groups from user");
        String userName = request.getParameter("userName").trim();
        String GroupsList = request.getParameter("groupsToRemove").trim();
        Long directoryId = Long.valueOf(request.getParameter("directoryId").replaceAll(",", ""));
        LOGGER.debug("username: " + userName + " GroupList: " + GroupsList + " directoryId: " + directoryId);
        try {
            boolean isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            if (isAdmin && action.equals("RemoveGroupsFromUser")) {
                this.sendErrorResponse("Error_User_Is_Admin", 500, response);
                return;
            }
            if (!GroupsList.isEmpty()) {
                ArrayList<String> groupsToRemove = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
                LOGGER.debug("groups to remove :" + groupsToRemove);
                for (String group : groupsToRemove) {
                    this.removeUserFromGroups(directoryId, userName, group, response);
                }
            }
            LOGGER.debug("Removed Groups Successfully of user: " + userName);
        }
        catch (Exception e) {
            LOGGER.error("error is: " + e);
        }
    }

    public void removeUserFromGroups(Long directoryId, String username, String groupToRemove, HttpServletResponse response) throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, IOException {
        LOGGER.debug("Removing user from group" + groupToRemove);
        try {
            UserKey userKey = new UserKey(username);
            boolean isGroupPresent = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), username, groupToRemove);
            if (isGroupPresent) {
                this.directoryManager.removeUserFromGroup(directoryId.longValue(), username, groupToRemove);
                LOGGER.debug("removed user" + username + "from group: " + groupToRemove);
            }
        }
        catch (UserNotFoundException e) {
            LOGGER.debug(" user does not exist in the directory" + (Object)((Object)e));
            this.sendErrorResponse("user does not exist in the directory", 500, response);
        }
        catch (GroupNotFoundException e) {
            LOGGER.debug(groupToRemove + "group does not exist in the directory");
            this.sendErrorResponseForUsers(groupToRemove, "Error_Group_Not_Exists", 500, response);
        }
    }

    private void activateOrDeactivateUser(String userName, Long directoryId, String action, HttpServletResponse resp) throws IOException {
        try {
            if (this.i18nHelper.getText("plugin.version").equals("1")) {
                if (action.equals("deactivate") && this.settings.getUserDeactivatedCount() >= 10) {
                    this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                    return;
                }
                if (action.equals("deactivate")) {
                    this.settings.setUserDeactivatedCount(this.settings.getUserDeactivatedCount() + 1);
                }
                if (action.equals("activate") && this.settings.getUserActivatedCount() >= 10) {
                    this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                    return;
                }
                if (action.equals("activate")) {
                    this.settings.setUserActivatedCount(this.settings.getUserActivatedCount() + 1);
                }
            }
            LOGGER.debug("Perform:" + action + " on:" + userName);
            User user = this.directoryManager.findRemoteUserByName(directoryId, userName);
            UserTemplate userTemplate = new UserTemplate(user);
            boolean isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            if (isAdmin && action.equals("deactivate")) {
                this.sendErrorResponse("User " + userName + " is admin", 500, resp);
                return;
            }
            if (!isAdmin && action.equals("deactivate")) {
                userTemplate.setActive(false);
                this.commonUserUtils.handleCacheForActivateDeactivateUser(userTemplate.getName(), false);
            } else if (!userTemplate.isActive()) {
                userTemplate.setActive(true);
                this.commonUserUtils.handleCacheForActivateDeactivateUser(userTemplate.getName(), true);
            } else {
                this.sendSuccessFullResponse("User " + userName + " is Active", resp);
            }
            this.directoryManager.updateUser(directoryId.longValue(), userTemplate);
            this.sendSuccessFullResponse("User " + userName + " " + action + "d Successfully", resp);
        }
        catch (Exception e) {
            LOGGER.error("Cannot " + action + " user " + userName, (Throwable)e);
            this.sendErrorResponse("Failed to " + action + " user " + userName, 500, resp);
        }
    }

    private void bulkDeletionGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String groupsToDelete = request.getParameter("groupsToDelete");
            String directoryName = request.getParameter("selectedDirectory");
            Directory directory = null;
            try {
                if (directoryName != "") {
                    directory = this.directoryManager.findDirectoryByName(directoryName);
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
            }
            ArrayList<String> groupToDeleteList = this.settings.convertSelect2StringToList(groupsToDelete);
            for (String groupsName : groupToDeleteList) {
                LOGGER.debug("Deleting Group :" + groupsName);
                this.directoryManager.removeGroup(directory.getId().longValue(), groupsName);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void deleteUsers(String userName, Long directoryId, HttpServletResponse resp) throws IOException {
        try {
            boolean isAdmin;
            LOGGER.debug("Deleting user:" + userName);
            if (this.i18nHelper.getText("plugin.version").equals("1")) {
                if (this.settings.getUserDeletedCount() >= 10) {
                    this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                    return;
                }
                this.settings.setUserDeletedCount(this.settings.getUserDeletedCount() + 1);
            }
            if (!(isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators"))) {
                this.directoryManager.removeUser(directoryId.longValue(), userName);
                this.commonUserUtils.handleCacheForDelete(userName);
                this.sendSuccessFullResponse("Successfully Deleted user " + userName, resp);
            } else {
                this.sendErrorResponse("User " + userName + " is admin", 500, resp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error deleting user:" + userName, (Throwable)e);
            e.printStackTrace();
            this.sendErrorResponse("Error deleting user " + userName, 500, resp);
        }
    }

    private void sendErrorResponseForUsers(String group, String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(group.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(" ".getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendErrorResponse(String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }
}

