/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.common.utils.CommonUserUtils;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUserManagementAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkUserManagementAction.class);
    private List<UserTemplate> userTemplates;
    private int page;
    private int numberOfPages;
    private int numberOfUsers;
    private Boolean enableDebugLogs;
    private String showPopup;
    private int startIndex;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private CommonUserUtils commonUserUtils;
    private UserManagementPluginSettings settings;

    public BulkUserManagementAction(UserManagementPluginSettings settings, UserManager userManager, DirectoryManager directoryManager, CommonUserUtils commonUserUtils) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
    }

    public Boolean doValidate() {
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            return true;
        }
        return false;
    }

    public String execute() throws ExecutionException, InterruptedException {
        LOGGER.debug("Bulk user Management Execute() called");
        if (!this.doValidate().booleanValue()) {
            HttpServletRequest req = this.getHttpRequest();
            this.page = req.getParameter("page") != null ? Integer.parseInt(req.getParameter("page")) : 1;
            this.startIndex = (this.page - 1) * 20;
            this.numberOfUsers = this.commonUserUtils.getTotalSearchResults("");
            this.numberOfPages = (int)Math.ceil(this.numberOfUsers / 20);
            this.userTemplates = this.commonUserUtils.getAllUsers("", false, false, 0L, this.startIndex);
            LOGGER.debug("Number Of Results:" + this.numberOfPages);
            this.enableDebugLogs = this.settings.getEnableDebugLogs();
            if (this.enableDebugLogs.booleanValue()) {
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"com.miniorange.usermanagement");
                logger.setLevel(Level.DEBUG);
            }
            this.showPopup = this.settings.getShowPopup();
            if (this.showPopup.equals("true")) {
                this.settings.setShowPopup("false");
            }
            return "success";
        }
        return "upm";
    }

    public CommonUserUtils getCommonUserUtils() {
        return this.commonUserUtils;
    }

    public void setCommonUserUtils(CommonUserUtils commonUserUtils) {
        this.commonUserUtils = commonUserUtils;
    }

    public List<UserTemplate> getUserTemplates() {
        return this.userTemplates;
    }

    public void setUserTemplates(List<UserTemplate> userTemplates) {
        this.userTemplates = userTemplates;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }

    public void setNumberOfUsers(int numberOfUsers) {
        this.numberOfUsers = numberOfUsers;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public String getShowPopup() {
        return this.showPopup;
    }

    public void setShowPopup(String showPopup) {
        this.showPopup = showPopup;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }
}

