/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common.utils;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUserUtils.class);
    private TransactionTemplate transactionTemplate;
    private static DirectoryManager directoryManager;
    private static UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserManager userManager;
    private MailManager mailManager;
    private final Cache<String, List<UserTemplate>> userCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, List<UserTemplate>> userCacheWithLogin = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Inject
    public CommonUserUtils(TransactionTemplate transactionTemplate, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService, UserManager userManager, MailManager mailManager) {
        this.transactionTemplate = transactionTemplate;
        CommonUserUtils.directoryManager = directoryManager;
        CommonUserUtils.settings = settings;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.mailManager = mailManager;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex) {
        List<Object> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            userListToReturn = users.stream().map(UserTemplate::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public List<UserTemplate> getAllUsersWithGroupsForAll(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex, String loginBasedFilter) {
        LOGGER.debug("Fetching all users having groups: getAllUsersWithGroupsForAll");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "group" + groupSearchList.hashCode() + searchQuery + "loginBasedFilter" + loginBasedFilter;
        ArrayList userListHavingGroups = new ArrayList();
        ArrayList<UserTemplate> userListHavingGroupsToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        List<Object> resultList = new ArrayList();
        int totalUser = this.getTotalSearchResults(searchQuery);
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(totalUser);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (StringUtils.isEmpty((CharSequence)startDate) && StringUtils.isEmpty((CharSequence)endDate)) {
                startDate = settings.getStart_date_lastLoginTime();
                endDate = settings.getEnd_date_lastLoginTime();
            }
            LOGGER.debug("start date: " + startDate + " end date: " + endDate);
            LocalDate currentDate = LocalDate.now();
            List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
            if (cachedUserList != null) {
                LOGGER.debug("Fetching user data from cache");
                userListHavingGroupsToReturn.addAll(cachedUserList);
            } else {
                users.parallelStream().forEach(user -> {
                    for (String group : groupSearchList) {
                        try {
                            if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                            userListHavingGroups.add(new UserTemplate(user));
                            break;
                        }
                        catch (Exception e) {
                            LOGGER.error("Getting error while fetching groups:" + e);
                        }
                    }
                });
                userListHavingGroupsToReturn.addAll(userListHavingGroups);
                this.userCache.put((Object)cacheKey, userListHavingGroups);
            }
            if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                return userListHavingGroupsToReturn;
            }
            ArrayList<User> usersWithGroup = new ArrayList<User>();
            usersWithGroup.addAll(userListHavingGroupsToReturn);
            resultList = this.fetchAllUsers(usersWithGroup);
            userListToReturn.addAll((Collection)resultList.get(0));
            userListToReturn.addAll((Collection)resultList.get(1));
            if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                LOGGER.debug("Retrieving users within the specified date range.");
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return new ArrayList<UserTemplate>();
                }
                return resultList.get(0) != null ? this.fetchUsersWithinStartAndLastDate((List)resultList.get(0), startDate, endDate) : null;
            }
            if (loginBasedFilter.equals("neverLoggedInUser")) {
                return (List)resultList.get(1);
            }
            if (loginBasedFilter.equals("loggedInUser")) {
                return (List)resultList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public int getTotalSearchResults(String searchQuery) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                totalUserCount += directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public int getUserInGroupCount(String groupName, long directoryId, int endIndex) {
        int totalUserCount = 0;
        List<UserTemplate> totalUser = this.getAllUsersWithGroupsForAll("", false, new ArrayList<String>(Arrays.asList(groupName)), true, directoryId, " ", " ", 0, "bothUser");
        try {
            totalUserCount = totalUser.size();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public static Date getLastLoginDate(String userName, long directoryId) {
        try {
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            String lastLoginTime = userWithAttributes.getValue("lastAuthenticated");
            if (lastLoginTime != null) {
                long loginTime = Long.parseLong(lastLoginTime);
                return new Date(loginTime);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
        }
        return null;
    }

    public static Date getLastActivationDate(String userName, long directoryId) {
        String lastActivatedTime = null;
        try {
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            lastActivatedTime = userWithAttributes.getValue("lastAuthenticated");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
        }
        if (lastActivatedTime == null) {
            return null;
        }
        Date loginDate = new Date(Long.parseLong(lastActivatedTime));
        return loginDate;
    }

    public List<User> getActiveUsers() {
        ArrayList<User> users = new ArrayList<User>();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)""), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"")}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return users;
    }

    public void deactivateUsers() {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                Calendar targeted = Calendar.getInstance();
                int days = (int)settings.getNumberOfDays();
                targeted.add(5, -days);
                Date targetDate = targeted.getTime();
                LOGGER.debug("targeted date is: " + targetDate);
                List<List<UserTemplate>> users = CommonUserUtils.this.fetchAllUsers(CommonUserUtils.this.getActiveUsers());
                List<UserTemplate> userWithoutLastLogin = users.get(1);
                List<UserTemplate> userWithLastLogin = users.get(0);
                List<String> excludeUsers = settings.getExcludeUsersList();
                LOGGER.debug("List of users to be excluded: " + excludeUsers);
                if (settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                    CommonUserUtils.this.deactivationProcessForUsers(userWithoutLastLogin, excludeUsers);
                }
                List<UserTemplate> usersBeforeTarget = CommonUserUtils.usersLoggedInBeforeTargetedDate(userWithLastLogin);
                List<UserTemplate> mailusersBeforeTarget = CommonUserUtils.mailBeforeTargetedDate(userWithLastLogin);
                CommonUserUtils.this.deactivationProcessForUsers(usersBeforeTarget, excludeUsers);
                CommonUserUtils.this.sendMailBeforeDeactivation(mailusersBeforeTarget, excludeUsers);
                return null;
            }
        });
    }

    public static List<UserTemplate> usersLoggedInBeforeTargetedDate(List<UserTemplate> users) {
        LOGGER.debug("Retrieving users who have logged in prior to the targeted date.");
        Calendar targeted = Calendar.getInstance();
        int days = (int)settings.getNumberOfDays();
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        LOGGER.debug("targeted date is: " + targetDate);
        int index = CommonUserUtils.getIndex(users, targetDate);
        int size = users.size();
        List<UserTemplate> usersBeforeTarget = users.subList(index, size);
        return usersBeforeTarget;
    }

    public static List<UserTemplate> mailBeforeTargetedDate(List<UserTemplate> users) {
        LOGGER.debug("Retrieving users who have logged in prior to the targeted date.");
        Calendar targeted = Calendar.getInstance();
        int days = (int)(settings.getNumberOfDays() - settings.getMailPeriod());
        int mailDays = (int)settings.getMailPeriod();
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        LOGGER.debug("targeted date is: " + targetDate);
        int index = CommonUserUtils.getIndex(users, targetDate);
        int size = users.size();
        List<UserTemplate> usersBeforeTarget = users.subList(index, size);
        return usersBeforeTarget;
    }

    private static int getIndex(List<UserTemplate> users, Date targetDate) {
        int left = 0;
        int right = users.size() - 1;
        try {
            while (left <= right) {
                int mid = left + (right - left) / 2;
                User user = (User)users.get(mid);
                Date loginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                if (loginDate.after(targetDate)) {
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
            }
        }
        catch (NullPointerException e) {
            LOGGER.debug("login date of user is null");
        }
        return left;
    }

    public void sendMailBeforeDeactivation(List<UserTemplate> users, List<String> excludeUsers) {
        LOGGER.debug("Executing the user's mail notification process");
        Date currentDate = new Date();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (UserTemplate user : users) {
            executor.submit(() -> {
                try {
                    Date lastActive = CommonUserUtils.getLastActivationDate(user.getName(), user.getDirectoryId());
                    if (!(directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), "crowd-administrators") || excludeUsers.contains(user.getName()) || CommonUserUtils.isUserInExcludeGroups(user))) {
                        if (settings.getMailNotification().booleanValue()) {
                            long sendMailBeforeOneDay = (settings.getMailPeriod() - settings.getNumberOfDays()) * 3600L * 1000L * 24L;
                            if (lastActive == null || currentDate.getTime() - lastActive.getTime() > sendMailBeforeOneDay) {
                                this.sendEmailToUser((User)user, lastActive.getTime());
                            }
                        }
                    } else {
                        LOGGER.debug("Skipping deactivation for user " + user.getName() + ". Reason: Admin user or in exclude user list");
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("getting exception while sending mail to users : " + e);
                }
            });
        }
        executor.shutdown();
    }

    public void deactivationProcessForUsers(List<UserTemplate> users, List<String> excludeUsers) {
        LOGGER.debug("Executing the user's deactivation process");
        Date currentDate = new Date();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (UserTemplate user : users) {
            executor.submit(() -> {
                try {
                    this.processUserDeactivation(user, currentDate, excludeUsers);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while processing user deactivation for user " + user.getName(), (Throwable)e);
                }
            });
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.MINUTES)) {
                LOGGER.error("Executor did not terminate in time.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Executor was interrupted while awaiting termination.", (Throwable)e);
        }
    }

    private void processUserDeactivation(UserTemplate user, Date currentDate, List<String> excludeUsers) {
        try {
            User remoteUser = directoryManager.findRemoteUserByName(Long.valueOf(user.getDirectoryId()), user.getName());
            UserTemplate userTemplate = new UserTemplate(remoteUser);
            Date lastActive = CommonUserUtils.getLastActivationDate(user.getName(), user.getDirectoryId());
            if (!(directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), "crowd-administrators") || excludeUsers.contains(user.getName()) || CommonUserUtils.isUserInExcludeGroups(user))) {
                if (lastActive == null || currentDate.getTime() - lastActive.getTime() > settings.getDoNotDeactivatePeriod() * 3600L * 1000L * 24L) {
                    userTemplate.setActive(false);
                    this.updateAndLogUserUpdate(userTemplate);
                }
            } else {
                LOGGER.debug("Skipping deactivation for user " + user.getName() + ". Reason: Admin user or in exclude user list");
            }
        }
        catch (Exception e) {
            LOGGER.debug("getting exception while processing user deactivation: " + e);
        }
    }

    private void updateAndLogUserUpdate(UserTemplate user) {
        try {
            directoryManager.updateUser(user.getDirectoryId(), user);
            LOGGER.info("Status updated of user: " + user.getName());
        }
        catch (Exception e) {
            LOGGER.error("Exception while updating user " + user.getName());
        }
    }

    public void sendEmailToUser(User user, long lastActive) throws Exception {
        LOGGER.debug("Calling sendOtpOnEmail.");
        String subject = settings.getSubText();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        String body = settings.getMailText();
        String days = String.valueOf(settings.getNumberOfDays());
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getDisplayName());
        body = StringUtils.replace((String)body, (String)"$$last-login-date$$", (String)sdf1.format(lastActive));
        body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
        InternetAddress address = new InternetAddress(user.getEmailAddress());
        try {
            this.mailManager.sendPlainTextEmail(address, subject, body);
        }
        catch (Exception e) {
            LOGGER.debug("Exception :- " + e);
            LOGGER.debug("Exception :- " + e.getMessage());
        }
        LOGGER.debug("Send email successfully");
    }

    private static boolean isUserInExcludeGroups(UserTemplate user) {
        List<String> excludeGroupList = settings.getExcludeGroupsList();
        try {
            for (String group : excludeGroupList) {
                if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                LOGGER.debug("User " + user.getName() + " is a member of the Excluded Group " + group);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred in fetching user groups");
        }
        return false;
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public int getTotalSearchResults(String searchQuery, Boolean isActive) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                totalUserCount += directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public List<UserTemplate> getAllUsersWithAllUserCase(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex, String loginBasedFilter) throws ParseException {
        LOGGER.debug("Retrieve all users with their corresponding user case, applying 'all' user filter.");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "allUserssearchQueryloginBasedFilter" + loginBasedFilter;
        ArrayList<PropertyRestriction> restrictionList = new ArrayList<PropertyRestriction>();
        List<Object> resultList = new ArrayList();
        ArrayList<UserTemplate> tempUsersList = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<User> users = new ArrayList<User>();
        restrictionList.add(Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery));
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf(restrictionList)).returningAtMost(Integer.MAX_VALUE);
        LocalDate currentDate = LocalDate.now();
        LOGGER.info("current date :" + currentDate);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                Iterator iterator = directories.iterator();
                while (iterator.hasNext()) {
                    Directory directory = (Directory)iterator.next();
                    long dictId = directory.getId();
                    users.addAll(directoryManager.searchUsers(dictId, query));
                }
            }
            if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                for (User user : users) {
                    userListToReturn.add(new UserTemplate(user));
                }
                return userListToReturn;
            }
            List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
            List cachedActiveUser = (List)this.userCacheWithLogin.getIfPresent((Object)cacheKey);
            if (cachedUserList != null && cachedActiveUser != null && loginBasedFilter.equals("bothUser")) {
                LOGGER.debug("Fetching user data from cache");
                userListToReturn.addAll(cachedUserList);
                tempUsersList.addAll(cachedActiveUser);
            } else {
                resultList = this.fetchAllUsers(users);
                userListToReturn.addAll((Collection)resultList.get(0));
                userListToReturn.addAll((Collection)resultList.get(1));
                tempUsersList.addAll((Collection)resultList.get(0));
                this.userCache.put((Object)cacheKey, userListToReturn);
                this.userCacheWithLogin.put((Object)cacheKey, resultList.get(0));
            }
            if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                LOGGER.debug("Retrieving users within the specified date range.");
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return new ArrayList<UserTemplate>();
                }
                return tempUsersList.size() != 0 ? this.fetchUsersWithinStartAndLastDate(tempUsersList, startDate, endDate) : null;
            }
            if (loginBasedFilter.equals("neverLoggedInUser")) {
                return (List)resultList.get(1);
            }
            if (loginBasedFilter.equals("loggedInUser")) {
                return (List)resultList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<List<UserTemplate>> fetchAllUsers(List<User> users) {
        LOGGER.debug("Fetching all users ...");
        ArrayList<List<UserTemplate>> resultList = new ArrayList<List<UserTemplate>>();
        List userListToReturnNull = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Long, User> userMapWithLastLogin = new ConcurrentHashMap<Long, User>();
        int batchSize = 2000;
        int numBatches = (int)Math.ceil((double)users.size() / (double)batchSize);
        LOGGER.debug("numbatches: " + numBatches);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<CompletableFuture<Void>> allDirectoryUsers = new ArrayList<CompletableFuture<Void>>();
        for (int j = 0; j < numBatches; ++j) {
            int start = j * batchSize;
            int end = Math.min((j + 1) * batchSize, users.size());
            List<User> batch = users.subList(start, end);
            CompletableFuture<Void> directoryUsers = CompletableFuture.runAsync(() -> {
                HashMap<Long, User> tempUserMap = new HashMap<Long, User>();
                for (User user : batch) {
                    Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                    if (lastLoginDate == null) {
                        userListToReturnNull.add(new UserTemplate(user));
                        continue;
                    }
                    long loginTime = lastLoginDate.getTime();
                    tempUserMap.put(loginTime, user);
                }
                userMapWithLastLogin.putAll(tempUserMap);
            }, executorService);
            allDirectoryUsers.add(directoryUsers);
        }
        CompletableFuture.allOf(allDirectoryUsers.toArray(new CompletableFuture[0])).join();
        executorService.shutdown();
        LOGGER.debug("number of users having last login is:" + userMapWithLastLogin.size());
        resultList.add(userMapWithLastLogin != null ? this.sortUsersByLastLogin(userMapWithLastLogin) : null);
        resultList.add(userListToReturnNull);
        return resultList;
    }

    public List<UserTemplate> fetchUsersWithinStartAndLastDate(List<UserTemplate> userListToReturn, String startDate, String endDate) throws ParseException {
        LOGGER.debug("Fetching users within the specified date range..");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date start_Date = formatter.parse(startDate);
        Date end_Date = formatter.parse(endDate);
        List<UserTemplate> filteredUserList = userListToReturn.parallelStream().filter(user -> {
            Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
            if (lastLoginDate != null) {
                long loginTime = lastLoginDate.getTime();
                return loginTime >= start_Date.getTime() && loginTime <= end_Date.getTime() + TimeUnit.DAYS.toMillis(1L);
            }
            return false;
        }).collect(Collectors.toList());
        return filteredUserList;
    }

    public List<UserTemplate> sortUsersByLastLogin(Map<Long, User> userListWithLastLogin) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(userListWithLastLogin);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>(sortedMap.size());
        for (User user : sortedMap.values()) {
            userListToReturn.add(new UserTemplate(user));
        }
        return userListToReturn;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate, String loginBasedFilter) throws ParseException {
        LOGGER.debug("getAllUser with case: active/inactive");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "status_is:" + isActive + searchQuery + "loginBasedFilter" + loginBasedFilter;
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        List<Object> resultList = new ArrayList();
        ArrayList<UserTemplate> tempUsersList = new ArrayList<UserTemplate>();
        ArrayList<User> users = new ArrayList<User>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LocalDate currentDate = LocalDate.now();
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                Iterator iterator = directories.iterator();
                while (iterator.hasNext()) {
                    Directory directory = (Directory)iterator.next();
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (limit.booleanValue()) {
                if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                    for (User user : users) {
                        userListToReturn.add(new UserTemplate(user));
                    }
                    return userListToReturn;
                }
                List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
                List cachedActiveUser = (List)this.userCacheWithLogin.getIfPresent((Object)cacheKey);
                if (cachedUserList != null && cachedActiveUser != null && loginBasedFilter.equals("bothUser")) {
                    LOGGER.debug("Fetching user data from cache");
                    userListToReturn.addAll(cachedUserList);
                    tempUsersList.addAll(cachedActiveUser);
                } else {
                    resultList = this.fetchAllUsers(users);
                    tempUsersList.addAll((Collection)resultList.get(0));
                    userListToReturn.addAll((Collection)resultList.get(0));
                    userListToReturn.addAll((Collection)resultList.get(1));
                    this.userCache.put((Object)cacheKey, userListToReturn);
                    this.userCacheWithLogin.put((Object)cacheKey, tempUsersList);
                }
                if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                    LOGGER.debug("Retrieving users within the specified date range.");
                    if (loginBasedFilter.equals("neverLoggedInUser")) {
                        return new ArrayList<UserTemplate>();
                    }
                    return tempUsersList.size() != 0 ? this.fetchUsersWithinStartAndLastDate(tempUsersList, startDate, endDate) : null;
                }
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return (List)resultList.get(1);
                }
                if (loginBasedFilter.equals("loggedInUser")) {
                    return (List)resultList.get(0);
                }
            } else {
                for (User user : users.subList(startIndex, users.size())) {
                    userListToReturn.add(new UserTemplate(user));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<UserTemplate> getAllUsersWithGroups(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate, String loginBasedFilter) {
        LOGGER.debug("Fetching active/inactive users having groups: getAllUsersWithGroups");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "status_is:" + isActive + "group:" + groupSearchList.hashCode() + searchQuery + "loginBasedFilter:" + loginBasedFilter;
        int totalUser = this.getTotalSearchResults(searchQuery);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListHavingGroupsToReturn = new ArrayList<UserTemplate>();
        ArrayList userListHavingGroups = new ArrayList();
        List<Object> resultList = new ArrayList();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(totalUser);
        LocalDate currentDate = LocalDate.now();
        LOGGER.info("current date :" + currentDate);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (limit.booleanValue()) {
                List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
                if (cachedUserList != null) {
                    LOGGER.debug("Fetching user data from cache");
                    userListHavingGroupsToReturn.addAll(cachedUserList);
                } else {
                    users.parallelStream().forEach(user -> {
                        for (String group : groupSearchList) {
                            try {
                                if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                                userListHavingGroups.add(new UserTemplate(user));
                                break;
                            }
                            catch (Exception e) {
                                LOGGER.debug("Getting error while fetching groups:" + e);
                            }
                        }
                    });
                    userListHavingGroupsToReturn.addAll(userListHavingGroups);
                    this.userCache.put((Object)cacheKey, userListHavingGroups);
                }
                if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                    return userListHavingGroupsToReturn;
                }
                ArrayList<User> usersWithGroup = new ArrayList<User>();
                usersWithGroup.addAll(userListHavingGroupsToReturn);
                resultList = this.fetchAllUsers(usersWithGroup);
                userListToReturn.addAll((Collection)resultList.get(0));
                userListToReturn.addAll((Collection)resultList.get(1));
                if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                    LOGGER.debug("Retrieving users within the specified date range.");
                    if (loginBasedFilter.equals("neverLoggedInUser")) {
                        return new ArrayList<UserTemplate>();
                    }
                    return resultList.get(0) != null ? this.fetchUsersWithinStartAndLastDate((List)resultList.get(0), startDate, endDate) : null;
                }
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return (List)resultList.get(1);
                }
                if (loginBasedFilter.equals("loggedInUser")) {
                    return (List)resultList.get(0);
                }
                return userListToReturn;
            }
            block3: for (User user2 : users.subList(startIndex, users.size())) {
                for (String group : groupSearchList) {
                    if (!directoryManager.isUserDirectGroupMember(user2.getDirectoryId(), user2.getName(), group)) continue;
                    userListToReturn.add(new UserTemplate(user2));
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public void handleCacheForDelete(String user) {
        Set cacheKeys = this.userCache.asMap().keySet();
        for (String cacheKey : cacheKeys) {
            List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
            if (cachedUserList != null) {
                for (UserTemplate u : cachedUserList) {
                    if (!u.getName().equals(user)) continue;
                    cachedUserList.remove(u);
                    break;
                }
            }
            this.userCache.put((Object)cacheKey, (Object)cachedUserList);
        }
    }

    public void handleCacheForActivateDeactivateUser(String user, boolean status) {
        LOGGER.debug("Managing cache during user deactivation ");
        try {
            Set cacheKeys = this.userCache.asMap().keySet();
            ArrayList<String> cacheKey1 = new ArrayList<String>();
            ArrayList<String> cacheKey2 = new ArrayList<String>();
            HashMap<String, Object> cachedUserListwithInactiveUser = new HashMap<String, Object>();
            HashMap<String, Object> cachedUserListwithActiveUser = new HashMap<String, Object>();
            for (String cacheKey : cacheKeys) {
                if (cacheKey.contains("status_is:false")) {
                    cacheKey1.add(cacheKey);
                    cachedUserListwithInactiveUser.put(cacheKey, this.userCache.getIfPresent((Object)cacheKey));
                }
                if (!cacheKey.contains("status_is:true")) continue;
                cacheKey2.add(cacheKey);
                cachedUserListwithActiveUser.put(cacheKey, this.userCache.getIfPresent((Object)cacheKey));
            }
            for (String cacheKey : cacheKeys) {
                List list;
                List cachedUserList = (List)this.userCache.getIfPresent((Object)cacheKey);
                if (cachedUserList == null) continue;
                for (UserTemplate u : cachedUserList) {
                    List<UserTemplate> list2;
                    if (!u.getName().equals(user)) continue;
                    u.setActive(status);
                    if (cacheKey.contains("status_is:false") && status) {
                        for (Map.Entry entry : cachedUserListwithActiveUser.entrySet()) {
                            List<UserTemplate> list22 = this.addUserInOrder((List)entry.getValue(), u);
                            entry.setValue(list22);
                        }
                        for (Map.Entry entry : cachedUserListwithInactiveUser.entrySet()) {
                            list2 = (List)entry.getValue();
                            list2.remove(u);
                            entry.setValue(list2);
                        }
                    }
                    if (!cacheKey.contains("status_is:true") || status) break;
                    for (Map.Entry entry : cachedUserListwithActiveUser.entrySet()) {
                        list2 = (List<UserTemplate>)entry.getValue();
                        list2.remove(u);
                        entry.setValue(list2);
                    }
                    for (Map.Entry entry : cachedUserListwithInactiveUser.entrySet()) {
                        list2 = this.addUserInOrder((List)entry.getValue(), u);
                        entry.setValue(list2);
                    }
                }
                this.userCache.put((Object)cacheKey, (Object)cachedUserList);
                for (String c : cacheKey1) {
                    list = (List)cachedUserListwithInactiveUser.get(c);
                    this.userCache.put((Object)c, (Object)list);
                }
                for (String c : cacheKey2) {
                    list = (List)cachedUserListwithActiveUser.get(c);
                    this.userCache.put((Object)c, (Object)list);
                }
            }
        }
        catch (NullPointerException e) {
            LOGGER.debug("exception occur while updating caches are: " + e);
        }
    }

    public List<UserTemplate> addUserInOrder(List<UserTemplate> userList, UserTemplate user) {
        Date userTime = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
        if (userTime == null) {
            userList.add(user);
            return userList;
        }
        int left = 0;
        int right = userList.size() - 1;
        int insertIndex = userList.size();
        while (left <= right) {
            int mid = left + (right - left) / 2;
            UserTemplate midUser = userList.get(mid);
            Date midUserTime = CommonUserUtils.getLastLoginDate(midUser.getName(), midUser.getDirectoryId());
            if (midUserTime == null || midUserTime.compareTo(userTime) < 0) {
                insertIndex = mid;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        userList.add(insertIndex, user);
        return userList;
    }

    public void removeGroupsFromUser() throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                ArrayList<User> tempUser = new ArrayList<User>();
                ArrayList groupsThatFollowRegex = new ArrayList();
                List<String> groupsToRemove = settings.getGroupsToRemoveList();
                boolean enableRegexForGroupsToRemove = settings.getEnableRegexForGroups();
                String regexPatternForExcludeGroups = settings.getRegexPattenForGroups();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                if (BooleanUtils.toBoolean((Boolean)enableRegexForGroupsToRemove) && StringUtils.isNotBlank((CharSequence)regexPatternForExcludeGroups)) {
                    try {
                        List existingGroups = CommonUserUtils.this.fetchGroups();
                        existingGroups.stream().filter(group -> CommonUserUtils.this.checkExcludeGroupRegex(group, regexPatternForExcludeGroups)).forEach(group -> {
                            groupsThatFollowRegex.add(group);
                            groupsToRemove.add((String)group);
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while fetching all the groups");
                    }
                }
                LOGGER.debug("groups to remove are: " + groupsToRemove);
                List<String> excludeUsers = settings.getExcludeUsersList();
                LOGGER.debug("exclude users are: " + excludeUsers);
                tempUser.addAll(CommonUserUtils.this.getAllUsersWithGroupsForAll("", false, groupsToRemove, false, 0L, "", "", 0, "bothUser"));
                List<UserTemplate> userWithLastLogin = CommonUserUtils.this.fetchAllUsers(tempUser).get(0);
                List<UserTemplate> usersBeforeTarget = CommonUserUtils.usersLoggedInBeforeTargetedDate(userWithLastLogin);
                for (UserTemplate user : usersBeforeTarget) {
                    executor.execute(() -> {
                        String userName = user.getName();
                        LOGGER.debug("Removing group for user = " + userName);
                        long directoryId = user.getDirectoryId();
                        try {
                            boolean isAdmin = directoryManager.isUserDirectGroupMember(directoryId, userName, "crowd-administrators");
                            if (!isAdmin && !excludeUsers.contains(userName)) {
                                CommonUserUtils.this.removeUserFromGroup(directoryId, user, groupsToRemove);
                            } else {
                                LOGGER.debug("Skipping groups to remove for user " + user.getName() + ". Reason: Admin user/ Excluded User ");
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("group does not exist in the directory");
                        }
                    });
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private void removeUserFromGroup(long directoryId, UserTemplate user, List<String> groupsToRemove) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, MembershipNotFoundException, DirectoryPermissionException, ReadOnlyGroupException, GroupNotFoundException {
        String userName = user.getName();
        UserKey userKey = new UserKey(userName);
        LOGGER.debug("Username =" + userName);
        if (!groupsToRemove.isEmpty()) {
            for (String group : groupsToRemove) {
                LOGGER.debug("Group to remove =" + group);
                boolean isGroupPresent = directoryManager.isUserDirectGroupMember(directoryId, userName, group);
                if (!isGroupPresent) continue;
                directoryManager.removeUserFromGroup(directoryId, userName, group);
                LOGGER.debug("removed user" + userName + "from group: " + group);
            }
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            for (String attribute : userWithAttributes.getKeys()) {
                if (!attribute.startsWith("autoGroupsAdded")) continue;
                LOGGER.debug("attribute is: " + attribute + " userName is: " + userName + " directory id: " + directoryId);
                directoryManager.removeUserAttributes(directoryId, userName, attribute);
            }
        }
    }

    public void doActionOnUser() throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        String actionOnUser = settings.getActionOnUser();
        if (actionOnUser.equals("autoDeactivateUser")) {
            LOGGER.debug("Within the auto-deactivation process for users.");
            this.deactivateUsers();
            LOGGER.info("User Auto-deactivation completed...");
        } else if (actionOnUser.equals("removeGroupsFromUsers")) {
            LOGGER.debug("Within the process of removing groups from users.");
            this.removeGroupsFromUser();
            LOGGER.info("Group Removal Process Completed...");
        } else if (actionOnUser.equals("removeGroupsAndAutoDeactivate")) {
            LOGGER.debug("Within the automated process of deactivating users and removing groups.");
            this.removeGroupsFromUser();
            this.deactivateUsers();
            LOGGER.info("Auto-deactivation and Group Removal Process Completed...");
        }
    }

    private boolean checkExcludeGroupRegex(String groupName, String regexPattern) {
        try {
            Pattern pattern = Pattern.compile(regexPattern, 2);
            Matcher matcher = pattern.matcher(groupName);
            return matcher.find();
        }
        catch (Exception e) {
            LOGGER.error("Exception while applying regex on exclude group name...", (Throwable)e);
            return false;
        }
    }

    private List<String> fetchGroups() throws DirectoryNotFoundException, OperationFailedException {
        this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        HashSet<String> uniqueGroupNames = new HashSet<String>();
        List allDirectories = directoryManager.findAllDirectories();
        for (Directory directory : allDirectories) {
            List groups = directoryManager.searchGroups(directory.getId().longValue(), query);
            for (Group group : groups) {
                uniqueGroupNames.add(group.getName());
            }
        }
        return new ArrayList<String>(uniqueGroupNames);
    }
}

