/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.miniorange.usermanagement.common.utils.MoEncryptionUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagementPluginSettings {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementPluginSettings.class);
    private PluginSettingsFactory pluginSettingsFactory;
    private PropertyManager propertyManager;
    private CrowdService crowdService;
    private I18nHelper i18nHelper;
    private CrowdLicenseManager crowdLicenseManager;
    private PluginSettings pluginSettings;

    public UserManagementPluginSettings(PluginSettingsFactory pluginSettingsFactory, PropertyManager propertyManager, CrowdLicenseManager crowdLicenseManager, CrowdService crowdService, I18nHelper i18nHelper) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.propertyManager = propertyManager;
        this.crowdLicenseManager = crowdLicenseManager;
        this.crowdService = crowdService;
        this.i18nHelper = i18nHelper;
    }

    public long getNumberOfDays() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.NUMBER_OF_USER_INACTIVE_DAYS")), (CharSequence)"30");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setNumberOfDays(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.NUMBER_OF_USER_INACTIVE_DAYS", (Object)String.valueOf(numberOfDays));
    }

    public long getDoNotDeactivatePeriod() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.DO_NOT_DEACTIVATE_DAYS")), (CharSequence)"0");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setDoNotDeactivatePeriod(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.DO_NOT_DEACTIVATE_DAYS", (Object)String.valueOf(numberOfDays));
    }

    public long getMailPeriod() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.MAIL_PERIOD")), (CharSequence)"1");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setMailPeriod(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_PERIOD", (Object)String.valueOf(numberOfDays));
    }

    public String getActionOnUser() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.ACTION_ON_USER");
        return getAction == null ? "none" : getAction;
    }

    public void setActionOnUser(String actionOnUser) {
        this.pluginSettings.put("miniorange.usermanagement.ACTION_ON_USER", (Object)(actionOnUser != null ? actionOnUser : "none"));
    }

    public String getMailText() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_TEXT");
        return getAction == null ? "Hello $$username$$,\nWe noticed that you logged in on $$last-login-date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$. If you have any questions or require further information, please don't hesitate to contact your Administrator.\nThank you." : getAction;
    }

    public void setMailText(String mailtext) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_TEXT", (Object)(mailtext != null ? mailtext : "Hello $$username$$,\nWe noticed that you logged in on $$last-login-date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$. If you have any questions or require further information, please don't hesitate to contact your Administrator.\nThank you."));
    }

    public String getSubText() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_SUBJECT_TEXT");
        return getAction == null ? "Deactivating User" : getAction;
    }

    public void setSubText(String mailtext) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_SUBJECT_TEXT", (Object)(mailtext != null ? mailtext : "Deactivating User"));
    }

    public List<String> getGroupsToRemoveList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_REMOVE");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setGroupsToRemoveList(List<String> excludeGroupsList) {
        this.pluginSettings.put("miniorange.usermanagement.GROUPS_TO_REMOVE", excludeGroupsList);
    }

    public Boolean getAutoDeActivateUsers() {
        String autodeactivatecheck = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DEACTIVATE_USER");
        if (StringUtils.isBlank((CharSequence)autodeactivatecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)autodeactivatecheck);
    }

    public void setAutoDeActivateUsers(Boolean autodeactivatecheck) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DEACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAutoDeactivateNeverLoggedInUser() {
        String neverloggedinusers = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS");
        if (StringUtils.isBlank((CharSequence)neverloggedinusers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)neverloggedinusers);
    }

    public String getStart_date_lastLoginTime() {
        String start_date_lastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.START_DATE_LASTLOGINTIME")), (CharSequence)"1970-01-01");
        return start_date_lastLoginTime;
    }

    public void setStart_date_lastLoginTime(String start_date_lastLoginTime) {
        this.pluginSettings.put("miniorange.usermanagement.START_DATE_LASTLOGINTIME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)start_date_lastLoginTime, (CharSequence)"1970-01-01"))));
    }

    public Boolean getEnableRegexForGroups() {
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.ENABLE_REGEX_FOR_EXCLUDE_GROUPS")), (CharSequence)"false")));
    }

    public void setEnableRegexForGroups(Boolean regexPattern) {
        this.pluginSettings.put("miniorange.usermanagement.ENABLE_REGEX_FOR_EXCLUDE_GROUPS", (Object)BooleanUtils.toString((Boolean)regexPattern, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPattenForGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.REGEX_PATTERN_FOR_EXCLUDE_GROUPS")), (CharSequence)"");
    }

    public void setRegexPatternForGroups(String regexPatternForExcludeGroups) {
        this.pluginSettings.put("miniorange.usermanagement.REGEX_PATTERN_FOR_EXCLUDE_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForExcludeGroups, (CharSequence)""))));
    }

    public String getEnd_date_lastLoginTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        String end_date_lastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.END_DATE_LASTLOGINTIME")), (CharSequence)currentDate);
        return end_date_lastLoginTime;
    }

    public void setEnd_date_lastLoginTime(String end_date_lastLoginTime) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        this.pluginSettings.put("miniorange.usermanagement.END_DATE_LASTLOGINTIME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)end_date_lastLoginTime, (CharSequence)currentDate))));
    }

    public void setAutoDeactivateNeverLoggedInUser(Boolean autodeactivatecheck) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS", (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getMailNotification() {
        String mailNotificationCheck = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_NOTIFICATIoN_CHECK");
        if (StringUtils.isBlank((CharSequence)mailNotificationCheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)mailNotificationCheck);
    }

    public void setMailNotification(Boolean mailNotificationCheck) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_NOTIFICATIoN_CHECK", (Object)BooleanUtils.toString((Boolean)mailNotificationCheck, (String)"true", (String)"false", (String)"false"));
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public String getCustomerID() {
        String customerId = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_ID")));
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_ID", (Object)customerId);
    }

    public String getCustomerEmail() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_EMAIL")));
    }

    public void setCustomerEmail(String email) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_EMAIL", (Object)StringUtils.trimToEmpty((String)email));
    }

    public String getCustomerAPIKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_API_KEY")));
    }

    public void setCustomerAPIKey(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_API_KEY", (Object)customerId);
    }

    public String getCustomerTokenKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_TOKEN_KEY")));
    }

    public void setCustomerTokenKey(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_TOKEN_KEY", (Object)customerId);
    }

    public Boolean isCustomerRegistered() {
        if (StringUtils.isBlank((CharSequence)this.getCustomerID()) || StringUtils.isBlank((CharSequence)this.getCustomerEmail()) || StringUtils.isBlank((CharSequence)this.getCustomerAPIKey()) || StringUtils.isBlank((CharSequence)this.getCustomerTokenKey())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getLicencedUsers() {
        try {
            String licencedUsers = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), (String)this.pluginSettings.get("miniorange.usermanagement.LICENCED_USERS"));
            return Integer.valueOf(licencedUsers);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setLicencedUsers(Integer userCount) {
        String licencedUsers = userCount.toString();
        String value = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licencedUsers);
        this.pluginSettings.put("miniorange.usermanagement.LICENCED_USERS", (Object)value);
    }

    public String getCustomerLicenseKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_LICENSE_KEY")));
    }

    public void setCustomerLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_LICENSE_KEY", (Object)StringUtils.trimToEmpty((String)licenseKey));
    }

    public void setLicenseVerified(Boolean backdoorEnabled) {
        String value = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"false"));
        this.pluginSettings.put("miniorange.usermanagement.LICENSE_VERIFIED", (Object)value);
    }

    public Boolean getLicenseVerified() {
        String value = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.LICENSE_VERIFIED")));
        return StringUtils.isNotBlank((CharSequence)value) ? BooleanUtils.toBoolean((String)MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), value)) : false;
    }

    public String getLicenseType() {
        String licenseTypeValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.IS_TRIAL_LICENSE"))));
        return licenseTypeValue;
    }

    public void setLicenseType(String licenseType) {
        String licenseTypeValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseType);
        this.pluginSettings.put("miniorange.usermanagement.IS_TRIAL_LICENSE", (Object)licenseTypeValue);
    }

    public String getLicenseExpireDate() {
        String licenseExpireDateValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.LICENSE_EXPIRE_DATE"))));
        return licenseExpireDateValue;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        String licenseExpireDateValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseExpireDate);
        this.pluginSettings.put("miniorange.usermanagement.LICENSE_EXPIRE_DATE", (Object)licenseExpireDateValue);
    }

    public Boolean isNoOfUserExceed() {
        try {
            Integer licencedUsers = this.getLicencedUsers();
            int crowdUserTier = this.crowdLicenseManager.getCurrentResourceUsageTotal();
            if (crowdUserTier > licencedUsers) {
                LOGGER.debug("No of Crowd user exceeded");
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while licensed user check ", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public Boolean getSortByLastLogin() {
        String sortByLastLogin = (String)this.pluginSettings.get("miniorange.usermanagement.SORT_BY_LAST_LOGIN_TIME");
        if (StringUtils.isBlank((CharSequence)sortByLastLogin)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)sortByLastLogin);
    }

    public void setSortByLastLogin(Boolean sortByLastLogin) {
        this.pluginSettings.put("miniorange.usermanagement.SORT_BY_LAST_LOGIN_TIME", (Object)BooleanUtils.toString((Boolean)sortByLastLogin, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean isLicenseExpired() {
        try {
            String licenseExpireDateString = this.getLicenseExpireDate();
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            LOGGER.debug("licenseExpireDate = " + licenseExpireDate.toString());
            Date currentDate = new Date();
            LOGGER.debug("currentDate = " + currentDate);
            if (!currentDate.before(licenseExpireDate)) {
                LOGGER.debug("License is expired");
                this.setLicenseVerified(Boolean.FALSE);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public Boolean isTrialLicense() {
        String licenseType = this.getLicenseType();
        if (StringUtils.equalsIgnoreCase((CharSequence)licenseType, (CharSequence)"TRIAL")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isLicenseValid() {
        if (this.i18nHelper.getText("plugin.version").equals("1")) {
            return true;
        }
        if (this.isCustomerRegistered().booleanValue() && this.getLicenseVerified().booleanValue() && !this.isLicenseExpired().booleanValue()) {
            if (this.getLicenseType().contains("TRIAL")) {
                return true;
            }
            if (!this.isNoOfUserExceed().booleanValue()) {
                LOGGER.debug("user count?" + this.isNoOfUserExceed());
                return true;
            }
            return false;
        }
        LOGGER.debug("Invalid License");
        return false;
    }

    public List<String> getDefaultGroupsForInitialConfiguration() {
        ArrayList<String> groupList = new ArrayList<String>();
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (groupList.contains(group.getName())) continue;
            groupList.add(group.getName());
        }
        ArrayList<String> excludeGroup = new ArrayList<String>();
        if (groupList.size() > 0) {
            excludeGroup.add((String)groupList.get(0));
        }
        LOGGER.debug("Exclude Group::" + excludeGroup);
        return excludeGroup;
    }

    public void removeCustomerAccount() {
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_TOKEN_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_LICENSE_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.LICENSE_VERIFIED");
        this.pluginSettings.remove("miniorange.usermanagement.ACTIVE_USERS");
        this.pluginSettings.remove("miniorange.usermanagement.LICENCED_USERS");
        this.pluginSettings.remove("miniorange.usermanagement.LICENSE_EXPIRE_DATE");
        this.pluginSettings.remove("miniorange.usermanagement.IS_TRIAL_LICENSE");
    }

    public String getSpBaseUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.SP_BASE_URL")), (CharSequence)this.getBaseUrl());
    }

    public String getBaseUrl() {
        try {
            String baseURL = this.propertyManager.getBaseUrl().toString();
            return baseURL;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting base URL", (Throwable)e);
            return null;
        }
    }

    public ArrayList<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)groups)) {
            return groupsList;
        }
        Collections.addAll(groupsList, StringUtils.split((String)groups, (String)","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public Boolean getReActivateUser() {
        String reActivateUser = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_REACTIVATE_USER");
        if (StringUtils.isBlank((CharSequence)reActivateUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)reActivateUser);
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_REACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)reActivateUser, (String)"true", (String)"false", (String)"false"));
    }

    public int getUserDeactivatedCount() {
        String deactivatedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_DEACTIVATED");
        if (deactivatedUsers != null) {
            return Integer.parseInt(deactivatedUsers);
        }
        return 0;
    }

    public void setUserDeactivatedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_DEACTIVATED", (Object)value);
    }

    public int getUserActivatedCount() {
        String activatedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_ACTIVATED");
        if (activatedUsers != null) {
            return Integer.parseInt(activatedUsers);
        }
        return 0;
    }

    public void setUserActivatedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_ACTIVATED", (Object)value);
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        text = Jsoup.parse(text).text();
        return text;
    }

    public int getUserDeletedCount() {
        String deletedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_DELETED");
        if (deletedUsers != null) {
            return Integer.parseInt(deletedUsers);
        }
        return 0;
    }

    public void setUserDeletedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_DELETED", (Object)value);
    }

    public List<String> getExcludeUsersList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.EXCLUDE_USERS_LIST");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setExcludeUsersList(List<String> excludeUsersList) {
        this.pluginSettings.put("miniorange.usermanagement.EXCLUDE_USERS_LIST", excludeUsersList);
    }

    public List<String> getExcludeGroupsList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.EXCLUDE_GROUPS_LIST");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setExcludeGroupsList(List<String> excludeGroupsList) {
        this.pluginSettings.put("miniorange.usermanagement.EXCLUDE_GROUPS_LIST", excludeGroupsList);
    }

    public void setRefreshInterval(String refreshInterval) {
        this.pluginSettings.put("miniorange.usermanagement.REFRESH_INTERVAL", (Object)StringUtils.trimToEmpty((String)refreshInterval));
    }

    public String getRefreshInterval() {
        String refreshInterval = (String)this.pluginSettings.get("miniorange.usermanagement.REFRESH_INTERVAL");
        return refreshInterval == null ? "daily" : refreshInterval;
    }

    public void setCustomRefreshInterval(String customRefreshInterval) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL", (Object)(customRefreshInterval != null ? customRefreshInterval : "60"));
    }

    public int getCustomRefreshInterval() {
        String refreshIntervalUnit = (String)this.pluginSettings.get("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL");
        return refreshIntervalUnit == null ? 60 : Integer.parseInt(refreshIntervalUnit);
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL_UNIT", (Object)StringUtils.trimToEmpty((String)customRefreshIntervalUnit));
    }

    public String getCustomRefreshIntervalUnit() {
        String refreshIntervalUnit = (String)this.pluginSettings.get("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL_UNIT");
        return refreshIntervalUnit == null ? "minutes" : refreshIntervalUnit;
    }

    public String getUserManagementSelectedAction() {
        String groupManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.GROUP_MANAGEMENT_SELECTION")), (CharSequence)"groupCreationAction");
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        return groupManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String groupManagementSelectedAction) {
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.usermanagement.GROUP_MANAGEMENT_SELECTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupManagementSelectedAction, (CharSequence)"groupCreationAction"))));
    }

    public String getCreationSelection() {
        String groupCreation = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.GROUP_CREATION_SELECTION")), (CharSequence)"manuallyAdding");
        return groupCreation;
    }

    public void setCreationSelection(String groupCreation) {
        this.pluginSettings.put("miniorange.usermanagement.GROUP_CREATION_SELECTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupCreation, (CharSequence)"manuallyAdding"))));
    }

    public String getGroupsToCreate() {
        String groupToCreate = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.MANUALLY_GROUP_CREATION")), (CharSequence)"");
        return groupToCreate;
    }

    public void setGroupsToCreate(String groupToCreate) {
        this.pluginSettings.put("miniorange.usermanagement.MANUALLY_GROUP_CREATION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupToCreate, (CharSequence)""))));
    }

    public Object getGroupsToDelete() {
        if (this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_DELETE") == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_DELETE");
    }

    public void setGroupsToDelete(ArrayList<String> defaultGroups) {
        this.pluginSettings.put("miniorange.usermanagement.GROUPS_TO_DELETE", defaultGroups);
    }

    public String getCsvUploadStatus() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CSV_UPLOAD_STATUS")), (String)"notUploaded");
    }

    public void setCsvUploadStatus(String csvUploadStatus) {
        this.pluginSettings.put("miniorange.usermanagement.CSV_UPLOAD_STATUS", (Object)StringUtils.trimToEmpty((String)csvUploadStatus));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)this.pluginSettings.get("miniorange.usermanagement.ENABLE_DEBUG_LOGS"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.usermanagement.ENABLE_DEBUG_LOGS", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public String getShowPopup() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.SHOW_POPUP_MSG")), (String)"true");
    }

    public void setShowPopup(String showPopup) {
        this.pluginSettings.put("miniorange.usermanagement.SHOW_POPUP_MSG", (Object)StringUtils.trimToEmpty((String)showPopup));
    }
}

