/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common.utils;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUserUtils.class);
    private UserManager userManager;
    private TransactionTemplate transactionTemplate;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private CrowdService crowdService;

    public CommonUserUtils(UserManager userManager, TransactionTemplate transactionTemplate, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService) {
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.crowdService = crowdService;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex) {
        LOGGER.debug("Fetching users with searchQuery=" + searchQuery + " :from Index=" + startIndex);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("Search user Query=" + query);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(this.directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = this.directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    LOGGER.debug("Directory=" + directory.getName());
                    users.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            ArrayList<Object> sortedUserList = new ArrayList<Object>();
            ArrayList<User> userListToReturnNull = new ArrayList<User>();
            HashMap<Long, User> userMapWithLastLogin = new HashMap<Long, User>();
            if (sortByLastLogin.booleanValue()) {
                for (User user : users) {
                    if (this.getLastLoginDate(user.getName(), user.getDirectoryId()) == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    userMapWithLastLogin.put(this.getLastLoginDate(user.getName(), user.getDirectoryId()).getTime(), user);
                }
                Set userUnsortedSet = userMapWithLastLogin.entrySet();
                ArrayList userSortList = new ArrayList(userUnsortedSet);
                Collections.sort(userSortList, Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : userSortList) {
                    sortedUserList.add(entry.getValue());
                }
                Collections.reverse(sortedUserList);
                sortedUserList.addAll(userListToReturnNull);
                for (User user : sortedUserList) {
                    userListToReturn.add(new UserTemplate(user));
                }
            } else {
                for (User user : users) {
                    userListToReturn.add(new UserTemplate(user));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public List<UserTemplate> getAllUsersWithGroupsForAll(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex) {
        LOGGER.debug("inside getAllUsersWithGroupsForAll with userFilter ALL");
        LOGGER.debug("Fetching users with searchQuery=" + searchQuery + " :from Index=" + startIndex);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<User> userListToReturnNotNull = new ArrayList<User>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("Search user Query=" + query);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(this.directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = this.directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    LOGGER.debug("Directory=" + directory.getName());
                    users.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (StringUtils.isEmpty((CharSequence)startDate) && StringUtils.isEmpty((CharSequence)endDate)) {
                startDate = this.settings.getStart_date_lastLoginTime();
                endDate = this.settings.getEnd_date_lastLoginTime();
            }
            LOGGER.debug("start date: " + startDate + " end date: " + endDate);
            ArrayList<User> userListToReturnNull = new ArrayList<User>();
            HashMap<Long, User> userMapWithLastLogin = new HashMap<Long, User>();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date start_Date = formatter.parse(startDate);
            Date end_Date = formatter.parse(endDate);
            for (User user : users) {
                Date date = this.getLastLoginDate(user.getName(), user.getDirectoryId());
                if (date == null) {
                    userListToReturnNull.add(user);
                    continue;
                }
                try {
                    if (date.getTime() < start_Date.getTime() || date.getTime() > end_Date.getTime() + 86400000L) continue;
                    userListToReturnNotNull.add(user);
                    userMapWithLastLogin.put(this.getLastLoginDate(user.getName(), user.getDirectoryId()).getTime(), user);
                }
                catch (Exception e) {
                    LOGGER.error("Error in Login Date" + e.getMessage());
                }
            }
            List<Object> userSortedList = new ArrayList();
            if (sortByLastLogin.booleanValue()) {
                userSortedList = this.sortUsersByLastLogin(userMapWithLastLogin, userListToReturnNull);
                for (UserTemplate userTemplate : userSortedList) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(userTemplate.getDirectoryId(), userTemplate.getName(), group)) continue;
                        userListToReturn.add(userTemplate);
                    }
                }
            } else {
                for (User user : userListToReturnNotNull) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListToReturn.add(new UserTemplate(user));
                    }
                }
                for (User user : userListToReturnNull) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListToReturn.add(new UserTemplate(user));
                    }
                }
            }
            return userListToReturn;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
            return userListToReturn;
        }
    }

    public int getTotalSearchResults(String searchQuery) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = this.directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                LOGGER.debug("Directory=" + directory.getName());
                totalUserCount += this.directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public int getUserInGroupCount(String groupName, long directoryId) {
        int totalUserCount = 0;
        List<UserTemplate> totalUser = this.getAllUsersWithGroupsForAll("", false, new ArrayList<String>(Arrays.asList(groupName)), true, directoryId, " ", " ", 0);
        try {
            totalUserCount = totalUser.size();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public Date getLastLoginDate(String userName, long directoryId) {
        String lastLoginTime = null;
        try {
            UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(directoryId, userName);
            lastLoginTime = userWithAttributes.getValue("lastAuthenticated");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
        }
        if (lastLoginTime == null) {
            return null;
        }
        Date loginDate = new Date(Long.parseLong(lastLoginTime));
        return loginDate;
    }

    public void deactivateUsers() {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                try {
                    LOGGER.debug("Deactivating users:" + CommonUserUtils.this.directoryManager);
                    Date currentDate = new Date();
                    List<UserTemplate> users = CommonUserUtils.this.getAllUsers("", false, false, 0L, 0, true, false, "", "");
                    List<String> excludeUsers = CommonUserUtils.this.settings.getExcludeUsersList();
                    LOGGER.debug("Active users=" + users.size());
                    for (UserTemplate user : users) {
                        Date loginDate = CommonUserUtils.this.getLastLoginDate(user.getName(), user.getDirectoryId());
                        if (!(CommonUserUtils.this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), "crowd-administrators") || excludeUsers.contains(user.getName()) || CommonUserUtils.this.isUserInExcludeGroups(user))) {
                            if ((!CommonUserUtils.this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || loginDate != null) && (loginDate == null || currentDate.getTime() - loginDate.getTime() <= CommonUserUtils.this.settings.getNumberOfDays() * 3600L * 1000L * 24L)) continue;
                            LOGGER.debug("Deactivating user=" + user.getName());
                            user.setActive(false);
                            CommonUserUtils.this.directoryManager.updateUser(user.getDirectoryId(), user);
                            continue;
                        }
                        LOGGER.debug("Skipping deactivation for user " + user.getName() + ". Reason: Admin user or in exclude user list");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("In catch:An error occurred while deactivating user", (Throwable)e);
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private boolean isUserInExcludeGroups(UserTemplate user) {
        List<String> excludeGroupList = this.settings.getExcludeGroupsList();
        try {
            for (String group : excludeGroupList) {
                if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                LOGGER.debug("User " + user.getName() + " is a member of the Excluded Group " + group);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred in fetching user groups");
        }
        return false;
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public int getTotalSearchResults(String searchQuery, Boolean isActive) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = this.directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                LOGGER.debug("Directory=" + directory.getName());
                totalUserCount += this.directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public List<UserTemplate> getAllUsersWithAllUserCase(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex) {
        LOGGER.debug("inside getAllUsersWithUserCase with userfilter all");
        LOGGER.debug("Fetching users with searchQuery=" + searchQuery + " :from Index=" + startIndex);
        List<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<User> userListToReturnNotNull = new ArrayList<User>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("Search user Query=" + query);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(this.directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = this.directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    long dictId = directory.getId();
                    users.addAll(this.directoryManager.searchUsers(dictId, query));
                }
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date start_Date = formatter.parse(startDate);
            Date end_Date = formatter.parse(endDate);
            ArrayList<User> userListToReturnNull = new ArrayList<User>();
            HashMap<Long, User> userMapWithLastLogin = new HashMap<Long, User>();
            for (User user : users) {
                Date lastLoginDate = this.getLastLoginDate(user.getName(), user.getDirectoryId());
                if (lastLoginDate == null) {
                    userListToReturnNull.add(user);
                    continue;
                }
                try {
                    if (lastLoginDate.getTime() < start_Date.getTime() || lastLoginDate.getTime() > end_Date.getTime() + 86400000L) continue;
                    userListToReturnNotNull.add(user);
                    userMapWithLastLogin.put(this.getLastLoginDate(user.getName(), user.getDirectoryId()).getTime(), user);
                }
                catch (Exception e) {
                    LOGGER.error("Error in Login Date" + e.getMessage());
                }
            }
            if (BooleanUtils.toBoolean((Boolean)sortByLastLogin)) {
                userListToReturn = this.sortUsersByLastLogin(userMapWithLastLogin, userListToReturnNull);
                return userListToReturn;
            }
            for (User user : userListToReturnNotNull) {
                userListToReturn.add(new UserTemplate(user));
            }
            for (User user : userListToReturnNull) {
                userListToReturn.add(new UserTemplate(user));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<UserTemplate> sortUsersByLastLogin(Map<Long, User> userListWithLastLogin, List<User> userListToReturnNull) {
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        Set<Map.Entry<Long, User>> sorted = userListWithLastLogin.entrySet();
        ArrayList<Map.Entry<Long, User>> sortedList = new ArrayList<Map.Entry<Long, User>>(sorted);
        Collections.sort(sortedList, Comparator.comparing(Map.Entry::getKey));
        for (Map.Entry entry : sortedList) {
            userListToReturn.add(new UserTemplate((User)entry.getValue()));
        }
        Collections.reverse(userListToReturn);
        for (User user : userListToReturnNull) {
            userListToReturn.add(new UserTemplate(user));
        }
        return userListToReturn;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate) {
        LOGGER.debug("inside getAllUser with case: active/inactive");
        LOGGER.debug("Fetching users with searchQuery=" + searchQuery + " :from Index=" + startIndex);
        List<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturnNotNull = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LOGGER.debug("Search user Query=" + query);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(this.directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = this.directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    LOGGER.debug("Directory = " + directory.getName());
                    users.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            ArrayList<User> userListToReturnNull = new ArrayList<User>();
            HashMap<Long, User> userMapWithLastLogin = new HashMap<Long, User>();
            if (limit.booleanValue()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Date start_Date = formatter.parse(startDate);
                Date end_Date = formatter.parse(endDate);
                for (User user : users) {
                    Date lastLoginDate = this.getLastLoginDate(user.getName(), user.getDirectoryId());
                    if (lastLoginDate == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    try {
                        if (lastLoginDate.getTime() < start_Date.getTime() || lastLoginDate.getTime() > end_Date.getTime() + 86400000L) continue;
                        userListToReturnNotNull.add(new UserTemplate(user));
                        userMapWithLastLogin.put(this.getLastLoginDate(user.getName(), user.getDirectoryId()).getTime(), user);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in Login Date" + e.getMessage());
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)sortByLastLogin)) {
                    userListToReturn = this.sortUsersByLastLogin(userMapWithLastLogin, userListToReturnNull);
                    return userListToReturn;
                }
                for (User user : userListToReturnNotNull) {
                    userListToReturn.add(new UserTemplate(user));
                }
                for (User user : userListToReturnNull) {
                    userListToReturn.add(new UserTemplate(user));
                }
                return userListToReturn;
            }
            for (User user : users.subList(startIndex, users.size())) {
                userListToReturn.add(new UserTemplate(user));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<UserTemplate> getAllUsersWithGroups(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate) {
        LOGGER.debug("inside getAllUsersWithGroups with active/inactive case");
        LOGGER.debug("Fetching users with searchQuery=" + searchQuery + " :from Index=" + startIndex);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturnNotNull = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(this.directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = this.directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (limit.booleanValue()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                Date start_Date = formatter.parse(startDate);
                Date end_Date = formatter.parse(endDate);
                ArrayList<User> userListToReturnNull = new ArrayList<User>();
                HashMap<Long, User> userMapWithLastLogin = new HashMap<Long, User>();
                for (User user : users) {
                    Date date = this.getLastLoginDate(user.getName(), user.getDirectoryId());
                    if (date == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    try {
                        if (date.getTime() < start_Date.getTime() || date.getTime() > end_Date.getTime() + 86400000L) continue;
                        userListToReturnNotNull.add(new UserTemplate(user));
                        userMapWithLastLogin.put(this.getLastLoginDate(user.getName(), user.getDirectoryId()).getTime(), user);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in Login Date" + e.getMessage());
                    }
                }
                List<Object> userSortedList = new ArrayList();
                if (BooleanUtils.toBoolean((Boolean)sortByLastLogin)) {
                    userSortedList = this.sortUsersByLastLogin(userMapWithLastLogin, userListToReturnNull);
                    for (UserTemplate userTemplate : userSortedList) {
                        for (String group : groupSearchList) {
                            if (!this.directoryManager.isUserDirectGroupMember(userTemplate.getDirectoryId(), userTemplate.getName(), group)) continue;
                            userListToReturn.add(userTemplate);
                        }
                    }
                    return userListToReturn;
                }
                for (User user : userListToReturnNotNull) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListToReturn.add(new UserTemplate(user));
                    }
                }
                for (User user : userListToReturnNull) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListToReturn.add(new UserTemplate(user));
                    }
                }
            } else {
                for (User user : users.subList(startIndex, users.size())) {
                    for (String group : groupSearchList) {
                        if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListToReturn.add(new UserTemplate(user));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }
}

