AJS.$(function(){

    AJS.$("#selectAll").on('click', function () {
        var selectAll = AJS.$("#selectAll").is(':checked'); ;
        var inputs = document.querySelectorAll("input[type='checkbox']");
        for(var i = 0; i < inputs.length; i++) {
            inputs[i].checked = selectAll;
        }
    });

    AJS.$("#miniOrange_Support").on('click',function(e){
        e.preventDefault();
        AJS.dialog2("#troubleshoot-dialog").show();
    });

    AJS.$("#premium").on('click',function(e){
        e.preventDefault();
        AJS.dialog2("#premium-dialog").show();
    });

    AJS.$("#apply").on('click', function () {
        var bulkAction = AJS.$("#bulkAction").val();
        var element = AJS.$("input[class='checkbox']:checked");
        switch(bulkAction){
            case "activate":
            for(var i = 0; i < element.length; i++)
                    activateUsers(element[i].id,element[i].getAttribute("data-directory"));
            break;
            case "deactivate":
                for(var i = 0; i < element.length; i++)
                    deActivateUsers(element[i].id,element[i].getAttribute("data-directory"));
                break;

            case "delete":
                var dialog = new AJS.Dialog({
                        width: 400,
                        height: 150,
                        id: "delete-dialog",
                        closeOnOutsideClick: true
                    });
                    dialog.addPanel("Panel 1", "<p>Are you sure you want to delete the users? <b> </b></p>", "panel-body");
                    dialog.addButton("Yes", function (dialog){
                        for(var i = 0; i < element.length; i++){
                            deleteUsers(element[i].id,element[i].getAttribute("data-directory"));
                        }
                        dialog.hide();
                    });
                    dialog.addLink("No", function (dialog) {
                        dialog.hide();
                    }, "#");

                    dialog.show();
                    break;
            default:
                AJS.flag({
                    title: 'Error',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please select a valid Action.</p>'
                });
                break;
        }
        setTimeout(function() {
            location.reload();
        }, 2000);

    });

    function deActivateUsers(userName,directoryId){
        console.log("deActivating user");
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"deactivate",
                     "userName":userName,
                     "directoryId":directoryId
                     },
            async:false,
            type:'POST',
            success: function (response) {
                showSuccessMessage(response);
            },
            error: function (response) {
                if(response.status ==200)
                    showSuccessMessage(response);
                else showErrorMessage(response);
            }
        });
    }

    function activateUsers(userName,directoryId){
        console.log("Activating user");
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"activate",
                     "userName":userName,
                     "directoryId":directoryId},
            async:false,
            type:'POST',
            success: function (response) {
                showSuccessMessage(response);
            },
            error: function (response) {
                if(response.status ==200)
                    showSuccessMessage(response);
                else showErrorMessage(response);
            }
        });
    }

    function deleteUsers(userName,directoryId){
        console.log("Deleting user:"+userName);
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"delete",
                     "userName":userName,
                     "directoryId":directoryId
                     },
            async:false,
            type:'POST',
            success: function (response) {
                showSuccessMessage(response);
            },
            error: function (response) {
                if(response.status ==200)
                    showSuccessMessage(response);
                else showErrorMessage(response);
            }
        });
    }

    function showErrorMessage(message) {
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close: 'auto',
            body: '<p>'+message.responseText+'</p><br/>'
        });
    }

    function showSuccessMessage(message) {
        AJS.flag({
            title: 'Success!',
            type: 'success',
            close: 'auto',
            body: '<p>' + message.responseText + '</p><br/>'
        });

    }

})