/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common.servlet;

import au.com.bytecode.opencsv.CSVReader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCSVServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadCSVServlet.class);
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private Boolean groupsCsvUpload;
    private DirectoryManager directoryManager;
    private UserManager userManager;
    private CrowdService crowdService;
    private UserManagementPluginSettings settings;

    UploadCSVServlet(DirectoryManager directoryManager, UserManager userManager, CrowdService crowdService, UserManagementPluginSettings settings) {
        this.directoryManager = directoryManager;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.settings = settings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block76: {
            HttpServletRequest req = ServletActionContext.getRequest();
            this.groupsCsvUpload = Boolean.parseBoolean(req.getParameter("groupsCsvUpload"));
            LOGGER.debug("Groups upload by csv: " + this.groupsCsvUpload);
            if (this.groupsCsvUpload == null) {
                this.groupsCsvUpload = false;
            }
            try {
                MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
                UploadedFile uploadedFile = wrapper.getFiles("csvFile")[0];
                File file = (File)uploadedFile.getContent();
                if (file == null) {
                    LOGGER.error("Uploaded CSV file is null");
                    break block76;
                }
                CSVReader csvReader = new CSVReader(new FileReader(file));
                int UserNameIndex = 10;
                int UserEmailIndex = 10;
                int FullNameIndex = 10;
                int GroupsIndex = 10;
                int StatusIndex = 10;
                int DirectoryIndex = 10;
                String[] nextLine = csvReader.readNext();
                if (nextLine != null) {
                    int colCount = nextLine.length;
                    block34: for (int i = 0; i < colCount; ++i) {
                        switch (nextLine[i].toString()) {
                            case "Username": 
                            case "username": {
                                UserNameIndex = i;
                                continue block34;
                            }
                            case "Email": 
                            case "email": {
                                UserEmailIndex = i;
                                continue block34;
                            }
                            case "FullName": 
                            case "fullname": {
                                FullNameIndex = i;
                                continue block34;
                            }
                            case "Groups": 
                            case "groups": {
                                GroupsIndex = i;
                                continue block34;
                            }
                            case "Status": 
                            case "status": {
                                StatusIndex = i;
                                continue block34;
                            }
                            case "Directory": 
                            case "directory": {
                                DirectoryIndex = i;
                            }
                        }
                    }
                }
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug("Uploaded CSV file size = " + rows.size());
                if (rows != null) {
                    LOGGER.debug("CSV file is not null starting thread");
                    String UserName = "";
                    String UserEmail = "";
                    String FullName = "";
                    String Groups = "";
                    String Status = "";
                    String Directory2 = "";
                    int updations = 0;
                    int creations = 0;
                    this.totalCreations = creations;
                    this.totalUpdations = updations;
                    for (int i = 0; i < rows.size(); ++i) {
                        String str;
                        if (!this.groupsCsvUpload.booleanValue()) {
                            if (UserNameIndex != 10) {
                                UserName = rows.get(i)[UserNameIndex].toString().trim();
                                if (UserName.isEmpty()) {
                                    LOGGER.error(" Username is empty cant create user  ");
                                    continue;
                                }
                            } else {
                                LOGGER.error(" Username is empty cant create user  ");
                                continue;
                            }
                            if (UserEmailIndex != 10) {
                                UserEmail = rows.get(i)[UserEmailIndex].toString();
                                if (UserEmail.isEmpty()) {
                                    LOGGER.error(" Email is empty cant create user  ");
                                    continue;
                                }
                            } else {
                                LOGGER.error(" Email is empty cant create user  ");
                                continue;
                            }
                            FullName = FullNameIndex != 10 ? rows.get(i)[FullNameIndex].toString() : UserName;
                        }
                        List<Object> defaultGroupList = new ArrayList();
                        if (GroupsIndex != 10) {
                            Groups = rows.get(i)[GroupsIndex].toString().replaceAll(",+\\s+", ",");
                            if (!Groups.isEmpty()) {
                                defaultGroupList = Arrays.asList(StringUtils.split((String)Groups, (String)","));
                            } else {
                                Groups = "";
                                defaultGroupList = Collections.singletonList("");
                            }
                        } else {
                            Groups = "";
                            defaultGroupList = Collections.singletonList("");
                        }
                        if (defaultGroupList.size() > 0 && (str = (String)defaultGroupList.get(0)).length() > 0) {
                            str = str.substring(1);
                            defaultGroupList.set(0, str);
                            str = (String)defaultGroupList.get(defaultGroupList.size() - 1);
                            str = str.substring(0, str.length() - 1);
                            defaultGroupList.set(defaultGroupList.size() - 1, str);
                        }
                        Status = StatusIndex != 10 ? rows.get(i)[StatusIndex].toString() : "";
                        Long Directory_ID = null;
                        Directory UserDirectory = null;
                        if (DirectoryIndex != 10) {
                            Directory2 = rows.get(i)[DirectoryIndex].toString();
                            if (!Directory2.isEmpty()) {
                                try {
                                    UserDirectory = this.directoryManager.findDirectoryByName(Directory2.trim());
                                    Directory_ID = UserDirectory.getId();
                                }
                                catch (DirectoryNotFoundException e) {
                                    LOGGER.error("Directory of user  Doesn't exist", (Throwable)e);
                                    Directory2 = "";
                                }
                            } else {
                                Directory2 = "";
                            }
                        } else {
                            Directory2 = "";
                        }
                        InetAddress ip = InetAddress.getLocalHost();
                        List<Object> groupsKeepAsItIs = defaultGroupList;
                        Boolean isUserPresent = Boolean.FALSE;
                        com.atlassian.crowd.model.user.User user = null;
                        if (!this.groupsCsvUpload.booleanValue() && Directory_ID != null) {
                            try {
                                user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                isUserPresent = Boolean.TRUE;
                            }
                            catch (UserNotFoundException userNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (isUserPresent.booleanValue()) {
                            LOGGER.debug("User " + UserName + " Already Exists. Updating user info.");
                            LOGGER.debug("user email = " + UserEmail + " full name = " + FullName);
                            if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                                UserTemplate userTemplate = new UserTemplate((User)user);
                                if (user.isActive() && (Status.equalsIgnoreCase("Inactive") || Status.equalsIgnoreCase("false"))) {
                                    LOGGER.debug("deactivating user from import action :" + user);
                                    userTemplate.setActive(false);
                                }
                                if (!user.isActive() && (Status.equalsIgnoreCase("Active") || Status.equalsIgnoreCase("true"))) {
                                    LOGGER.debug("activating user from import action :" + user);
                                    userTemplate.setActive(true);
                                }
                                if (this.canGroupsBeUpdated((User)user) && GroupsIndex != 10) {
                                    Object gp2;
                                    MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(UserName).returningAtMost(Integer.MAX_VALUE);
                                    Iterable groups = this.crowdService.search((Query)query);
                                    ArrayList<String> currentGroups = new ArrayList<String>();
                                    for (Object gp2 : groups) {
                                        currentGroups.add(gp2.getName());
                                    }
                                    LOGGER.debug("Current Groups of the user " + currentGroups);
                                    ArrayList<String> groupsToRemove = new ArrayList<String>();
                                    gp2 = currentGroups.iterator();
                                    while (gp2.hasNext()) {
                                        String groupName = (String)gp2.next();
                                        if (groupsKeepAsItIs.contains(groupName) || groupName.contains("crowd-administrators")) continue;
                                        groupsToRemove.add(groupName);
                                    }
                                    LOGGER.debug("Groups to Remove from " + UserName + " are :- " + groupsToRemove);
                                    this.removeUserFromGroups((User)user, groupsToRemove, ip.getHostAddress());
                                    ArrayList groupsToAssign = (ArrayList)this.createAndAssignNewGroupsUser(groupsKeepAsItIs, userTemplate.getDirectoryId());
                                    if (!((Object)currentGroups).toString().equals(groupsToAssign.toString())) {
                                        LOGGER.debug("groupsToAssign := " + groupsToAssign);
                                        this.addUserToGroups((User)user, groupsToAssign);
                                        this.totalUpdations = ++updations;
                                    }
                                }
                                if (!user.getDisplayName().equals(FullName) || !user.getEmailAddress().equals(UserEmail)) {
                                    Long dirId = userTemplate.getDirectoryId();
                                    userTemplate.setEmailAddress(UserEmail);
                                    userTemplate.setDisplayName(FullName);
                                    this.totalUpdations = ++updations;
                                }
                                this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                            }
                        } else {
                            if (Directory2.isEmpty()) {
                                Directory internalDir = (Directory)this.directoryManager.findAllDirectories().get(0);
                                Directory_ID = internalDir.getId();
                            }
                            if (!this.groupsCsvUpload.booleanValue()) {
                                LOGGER.debug("User " + UserName + " does Not Exist. Creating User ");
                                try {
                                    UserTemplate newuserTemplate = new UserTemplate(UserName, Directory_ID.longValue());
                                    newuserTemplate.setDisplayName(FullName);
                                    newuserTemplate.setEmailAddress(UserEmail);
                                    newuserTemplate.setDirectoryId(Directory_ID.longValue());
                                    if (Status.equalsIgnoreCase("Inactive") || Status.equalsIgnoreCase("false")) {
                                        newuserTemplate.setActive(Boolean.FALSE.booleanValue());
                                    } else {
                                        newuserTemplate.setActive(Boolean.TRUE.booleanValue());
                                    }
                                    this.directoryManager.addUser(Directory_ID.longValue(), newuserTemplate, PasswordCredential.NONE);
                                    this.totalCreations = ++creations;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                try {
                                    user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            LOGGER.debug("Creating groups");
                            LOGGER.debug("Group/s " + defaultGroupList + "    Directory_ID : " + Directory_ID);
                            ArrayList groupsToAssignToNewUser = (ArrayList)this.createAndAssignNewGroupsUser(defaultGroupList, Directory_ID);
                            if (!this.groupsCsvUpload.booleanValue()) {
                                try {
                                    this.addUserToGroups((User)user, groupsToAssignToNewUser);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL") && this.totalCreations + this.totalUpdations == 10) break;
                    }
                }
                if (this.groupsCsvUpload.booleanValue()) {
                    LOGGER.debug("Groups Imported Successfully");
                } else {
                    LOGGER.debug("Users Imported Successfully");
                }
                LOGGER.debug("Updations = " + this.totalUpdations + " Creations = " + this.totalCreations);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while Uploading CSV" + e);
                this.settings.setCsvUploadStatus("error");
            }
        }
        this.settings.setCsvUploadStatus("success");
        if (this.groupsCsvUpload.booleanValue()) {
            response.sendRedirect(this.settings.getBaseUrl() + "/console/secure/plugins/crowd-bulkgroupmanagement/bulkgroupmanagement.action");
        } else {
            response.sendRedirect(this.settings.getBaseUrl() + "/console/secure/plugins/crowd-importexport/importexport.action");
        }
    }

    private boolean canGroupsBeUpdated(User user) {
        LOGGER.debug("checking if groups of the user can be updated");
        Directory directory = null;
        try {
            directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        }
        catch (Exception e) {
            LOGGER.error("Issue in updating groups for user " + user.getName());
            return false;
        }
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(User user, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        try {
            LOGGER.debug("Removing user from groups");
            for (String group : groupsToRemove) {
                LOGGER.debug("Removing user " + user + " from " + group);
                LOGGER.debug("Removing user [" + user + "] from group [" + group + "]");
                Group grp = this.crowdService.getGroup(group);
                this.crowdService.removeUserFromGroup(user, grp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while removing groups for user " + user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList, Long directoryID) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        try {
            for (String groupName : roleValuesList) {
                if (groupName.length() <= 0) continue;
                Boolean groupExist = Boolean.FALSE;
                try {
                    this.directoryManager.findGroupByName(directoryID.longValue(), groupName.trim());
                    groupExist = Boolean.TRUE;
                    LOGGER.debug(groupName + " : this group is already present");
                }
                finally {
                    if (!groupExist.booleanValue()) {
                        LOGGER.debug("Creating new Group with name : " + groupName);
                        GroupTemplate groupTemplate = new GroupTemplate(groupName.trim(), directoryID.longValue());
                        this.directoryManager.addGroup(directoryID.longValue(), groupTemplate);
                    }
                }
                groupsToAssign.add(groupName.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return groupsToAssign;
    }

    public void addUserToGroups(User user, List<String> groupsToAssign) throws OperationNotPermittedException {
        LOGGER.debug("Adding user to groups");
        try {
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                LOGGER.debug("Adding user " + user.getName() + " to " + group + ";");
                Group grp = this.crowdService.getGroup(group);
                this.crowdService.addUserToGroup(user, grp);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error adding user to groups");
            e.printStackTrace();
        }
    }

    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }
}

