$(document).ready(function(){
    $(window).scrollTop(0);

    if(document.getElementById("isSslSetup").value === "true")
    {
        if(document.getElementById("idWebAuthn").checked === true)
        {
            document.getElementById("yubikeytoggleParentId").className = "for-toolTip";
            document.getElementById("yubikeytoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("yubikeytoggleParentId").classList.remove("for-toolTip");
            document.getElementById("yubikeytoggleParentId").removeAttribute("data-tooltip");
        }

        if(document.getElementById("idYubikeyHardwareTokenAsU2F").checked === true)
        {
            document.getElementById("webAuthntoggleParentId").className = "for-toolTip";
            document.getElementById("webAuthntoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("webAuthntoggleParentId").classList.remove("for-toolTip");
            document.getElementById("webAuthntoggleParentId").removeAttribute("data-tooltip");
        }

    }

    AJS.$(document).on('change', '#smsGateway', function () {
        if(AJS.$("#smsGateway").val() == "miniOrange Gateway"){
            AJS.$("#custom_gateway_div").hide();
            AJS.$("#miniorange_gateway_div").show();
        }else{
            AJS.$("#miniorange_gateway_div").hide();
            AJS.$("#custom_gateway_div").show();
        }
    });


    AJS.$("#mobileAuthenticatorDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#mobileAuthenticatorDivId").hide();
    });
    AJS.$("#webAuthnSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#webAuthnSettingsDivId").hide();
    });
    AJS.$("#testOtpOverEmailSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#testOtpOverEmailSettingsDivId").hide();
    });
    AJS.$("#otpOverEmailSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#otpOverEmailSettingsDivId").hide();
    });
    AJS.$("#otpOverSmsSettingsDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#otpOverSmsSettingsDivId").hide();
    });
    AJS.$("#duoPushNotificationDivId_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#duoPushNotificationDivId").hide();
    });


});

AJS.$(document).ready(function() {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#CONFIGURE2FA").addClass("aui-nav-selected");
    AJS.$('input').css("box-shadow","none");

    AJS.$("#customMailServerId").click(function () {
            if(this.checked) {
                AJS.$("#displayCustomMailServerSettings").show();
                AJS.$("#protocolId").prop('disabled', false);
                AJS.$("#hostNameId").prop('disabled', false);
                AJS.$("#smtpPortId").prop('disabled', false);
                AJS.$("#fromAddressId").prop('disabled', false);
                AJS.$("#mailServerUsernameId").prop('disabled', false);
                AJS.$("#mailServerPasswordId").prop('disabled', false);
                AJS.$("#customMailServerTlsId").prop('disabled', false);
            } else {
                AJS.$("#displayCustomMailServerSettings").hide();
                AJS.$("#protocolId").prop('disabled', true);
                AJS.$("#hostNameId").prop('disabled', true);
                AJS.$("#smtpPortId").prop('disabled', true);
                AJS.$("#fromAddressId").prop('disabled', true);
                AJS.$("#mailServerUsernameId").prop('disabled', true);
                AJS.$("#mailServerPasswordId").prop('disabled', true);
                AJS.$("#customMailServerTlsId").prop('disabled', true);
            }
        });

    AJS.$(document).on("change", "#idYubikeyHardwareTokenAsU2F", function () {
        if(document.getElementById("idYubikeyHardwareTokenAsU2F").checked === true)
        {
            document.getElementById("webAuthntoggleParentId").className = "for-toolTip";
            document.getElementById("webAuthntoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("webAuthntoggleParentId").classList.remove("for-toolTip");
            document.getElementById("webAuthntoggleParentId").removeAttribute("data-tooltip");
        }
    });

    AJS.$(document).on("change", "#idWebAuthn", function () {
        if(document.getElementById("idWebAuthn").checked === true)
        {
            document.getElementById("yubikeytoggleParentId").className = "for-toolTip";
            document.getElementById("yubikeytoggleParentId").setAttribute('data-tooltip','Web Authentication and Yubikey Hardware Token cannot be enabled simultaneously. Please select either of them.');
        }
        else{
            document.getElementById("yubikeytoggleParentId").classList.remove("for-toolTip");
            document.getElementById("yubikeytoggleParentId").removeAttribute("data-tooltip");
        }

    });
    setMethodIcons();

});

function saveMobileAuthnSettings() {
    console.log(document.getElementById("appLabel").value);
    console.log(document.getElementById("showSupportedAppPopup").checked);
    console.log(document.getElementById("enableShareSecretKey").checked);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "ConfigureMobileAuthnSettings",
            "appLabel": document.getElementById("appLabel").value,
            "showSupportedAppPopup": document.getElementById("showSupportedAppPopup").checked,
            "enableShareSecretKey": document.getElementById("enableShareSecretKey").checked
        },
        type: "GET",
        success: function (response) {
            console.log("success");
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Mobile Authenticator Settings Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        error: function (response) {
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Mobile Authenticator Settings Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        async: true
    });


}

function saveDuoPushSettings() {
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "ConfigureDuoPushSettings",
            "duoPushNotificationIntegrationKey": document.getElementById("duoPushNotificationIntegrationKey").value,
            "duoPushNotificationSecretKey": document.getElementById("duoPushNotificationSecretKey").value,
            "duoPushNotificationHostName": document.getElementById("duoPushNotificationHostName").value
        },
        type: "GET",
        success: function (response) {
            console.log("success");
            performSaveDuoSettings(response);
        },
        error: function (response) {
            performSaveDuoSettings(response);
        },
        async: true
    });


}

function performSaveDuoSettings(response) {
    console.log("*****************"+response.status);
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Two Factor Settings Updated',
            type: 'success',
            close: 'auto',
            body: '<p>Duo Push Notification Settings Updated.</p>'
        });
        setTimeout(function () {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Issue with updating Two Factor Settings',
            type: 'error',
            close: 'auto',
            body: '<p>Invalid Duo Push Credentials </p>'
        });
    }
}

function saveOtpOverEmailSettings() {
    var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
    var fromAddress = document.getElementById("fromAddressId").value;
    var protocol = document.getElementById("protocolId").value;
    var hostName = document.getElementById("hostNameId").value;
    var smtpPort = document.getElementById("smtpPortId").value;
    var customMailServer = document.getElementById("customMailServerId").checked;

    // Validate OTP Length
    var otpLength = parseInt(document.getElementById("otpLength").value);

    if (otpLength < 4 || !otpLength) {
        require('aui/flag')({
            title: 'Invalid OTP Length',
            type: 'error',
            close: 'auto',
            body: '<p>OTP Length must be at least 4 characters. </p>'
        });
        return;
    }

    // Validate OTP Validity Duration
    var otpValidityDuration = parseInt(document.getElementById("otpValidityDuration").value);
    if (otpValidityDuration < 1 || !otpValidityDuration) {
        require('aui/flag')({
            title: 'Invalid OTP Validity Duration',
            type: 'error',
            close: 'auto',
            body: '<p>OTP Validity Duration must be at least 1 minute. </p>'
        });
        return;
    }
    if (customMailServer) {
        // Validate that required fields are filled
        if (!protocol || !hostName || !smtpPort || !fromAddress) {
            require('aui/flag')({
                title: 'Problem while saving Otp Over Email Settings',
                type: 'error',
                close: 'auto',
                body: '<p>Please fill in all required fields for the custom mail server configuration.</p>'
            });
            return;
        }
        // Validate the fromAddress for correct email format
        if (fromAddress && !fromAddress.match(mailformat)) {
            require('aui/flag')({
                title: 'Problem while saving Otp Over Email Settings',
                type: 'error',
                close: 'auto',
                body: '<p>Make sure you are adding a correct Email Address.</p>'
            });
            return;
        }
    }

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "ConfigureOtpOverEmailSettings",
            "emailSubject": document.getElementById("emailSubject").value,
            "emailTemplate": document.getElementById("emailTemplate").value,
            "otpLength": document.getElementById("otpLength").value,
            "otpValidityDuration": document.getElementById("otpValidityDuration").value,
            "customMailServer": document.getElementById("customMailServerId").checked,
            "protocol": document.getElementById("protocolId").value,
            "hostName": document.getElementById("hostNameId").value,
            "smtpPort": document.getElementById("smtpPortId").value,
            "fromAddress": document.getElementById("fromAddressId").value,
            "mailServerUsername": document.getElementById("mailServerUsernameId").value,
            "mailServerPassword": document.getElementById("mailServerPasswordId").value,
            "customMailServerTls": document.getElementById("customMailServerTlsId").checked


        },
        type: "POST",
        success: function (response) {
            console.log("success");
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Otp Over Email Method Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        error: function (response) {
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Otp Over Email Method Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        async: true
    });

}

function ShowPassword(){
    var passwordId = document.getElementById("mailServerPasswordId");
    if (passwordId.type === "password") {
        passwordId.type = "text";
    } else {
        passwordId.type = "password";
    }
}


function sendTestOtpOverEmail(){
    var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
    if(document.getElementById("toAddressId").value==null || (document.getElementById("toAddressId").value!=null &&
        !document.getElementById("toAddressId").value.match(mailformat))){
        require('aui/flag')({
            title: 'Problem while sending test email',
            type: 'error',
            close: 'manual',
            body: '<p>Make sure you are adding correct Email Address.  </p>'
        });
        return ;
    }

    document.getElementById("mailServerLogsId").value="";

    var myFlag = AJS.flag({
        title: 'Sending test email',
        type: 'info',
        body: '<p id="spinner-flag"><aui-spinner size="large"></aui-spinner></p>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "SendTestOtpOverEmail",
            "ToEmail": document.getElementById("toAddressId").value
        },
        type: "POST",
        success: function (response) {
            console.log("success");
            if(response.Error.includes("Error")){
                document.getElementById("mailServerLogsId").value = response.Error;
            }else{
                document.getElementById("mailServerLogsId").value = "Your test email has been sent successfully to "+document.getElementById("toAddressId").value;
            }
            myFlag.close();
        },
        error: function (response) {
            console.log("error");
            document.getElementById("mailServerLogsId").value = response.Error;
            myFlag.close();
        },
        async: true
    });
}

function CopyErrorLogs(){

    var copyText = document.getElementById("mailServerLogsId");
    // Select the text field
    copyText.select();
    // Copy the text inside the text field
    navigator.clipboard.writeText(copyText.value);

    document.getElementById("copyIconDivId").setAttribute('data-tooltip','Copied!');

}

function saveWebAuthnSettings() {
    console.log(document.getElementById("attestationType").value);
    console.log(document.getElementById("authenticatorType").value);
    console.log(document.getElementById("userVerification").value);
    console.log(document.getElementById("residentKey").value);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "ConfigureWebAuthnSettings",
            "attestationType": document.getElementById("attestationType").value,
            "authenticatorType": document.getElementById("authenticatorType").value,
            "userVerification": document.getElementById("userVerification").value,
            "residentKey": document.getElementById("residentKey").value
        },
        type: "GET",
        success: function (response) {
            console.log("success");
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Web Authn Settings Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        error: function (response) {
            if (response.status === 200){
                require('aui/flag')({
                    title: 'Two Factor Settings Updated',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Web Authn Settings Updated.</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 2000);
            }
        },
        async: true
    });


}

function previewTemplate(templateId) {
    var templateValue = document.getElementById(templateId).value;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/testtemplatechanges",
        timeout: 0,
        data: {
            "templatePage": templateValue
        },
        type: "POST",
        success: function (response) {
        },
        error: function (response) {
        }
    });
    var url = AJS.contextPath() + '/plugins/servlet/twofactor/testtemplatechanges';
    var myWindow = window.open(url, "Test Template Changes", "width=1000, height=500");
}

function setMethodIcons() {
    var googleAuthenticatorIcon = document.getElementById("googleAuthenticatorIconId").value;
    document.getElementById("imgGoogleAuthenticator").src = googleAuthenticatorIcon;
    document.getElementById("imgGoogleAuthenticatorPopup").src = googleAuthenticatorIcon;

    var otpOverEmailIconIcon = document.getElementById("otpOverEmailIconId").value;
    document.getElementById("imgOtpOverEmail").src = otpOverEmailIconIcon;
    document.getElementById("imgOtpOverEmailPopup").src = otpOverEmailIconIcon;

    var otpOverSmsIcon = document.getElementById("otpOverSmsIconId").value;
    document.getElementById("imgOtpOverSms").src = otpOverSmsIcon;
    document.getElementById("imgOtpOverSmsPopup").src = otpOverSmsIcon;

    var securityQuestionIcon = document.getElementById("securityQuestionIconId").value;
    document.getElementById("imgSecurityQuestion").src = securityQuestionIcon;

    var backupCodeIcon = document.getElementById("backupCodeIconId").value;
    document.getElementById("imgBackupCode").src = backupCodeIcon;

    var hardwareTokenIcon = document.getElementById("hardwareTokenIconId").value;
    document.getElementById("imgHardwareToken").src = hardwareTokenIcon;

    var webAuthenticationIcon = document.getElementById("webAuthnIconId").value;
    document.getElementById("imgWebAuthn").src = webAuthenticationIcon;
    document.getElementById("imgWebAuthnPopup").src = webAuthenticationIcon;

    var pushNotificationIcon = document.getElementById("pushNotificationIconId").value;
    document.getElementById("imgPushNotification").src = pushNotificationIcon;
    document.getElementById("imgPushNotificationPopup").src = pushNotificationIcon;

}

function enableRegistrationUsingOwnSecretKey() {
    console.log("calling enableRegistrationUsingOwnSecretKey");
    AJS.$("#qrCodeOtp").val("");
    AJS.$("#google-authenticator-secondary-div").hide();
    AJS.$("#google-authenticator-own-secret-key-secondary-div").show();
}

function enableRegistrationUsingQrCode() {
    console.log("calling enableRegistrationUsingQrCode");
    AJS.$("#ownSecretKey").val("");
    AJS.$("#otpUsingOwnSecretKey").val("");
    AJS.$("#google-authenticator-own-secret-key-secondary-div").hide();
    AJS.$("#google-authenticator-secondary-div").show();
}

// 2FA for Crowd Software

function confirmEnableOrDisable2FAForSoftware() {
    var dialog = new AJS.Dialog({
        width: 500,
        height: 150,
        id: "confirm-dialog",
        closeOnOutsideClick: true
    });

    console.log("status="+document.getElementById("enableTwoFactor").checked);
    if (!document.getElementById("enableTwoFactor").checked) {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Enable 2FA for Crowd</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside enable yes");
            enable2faForSoftware();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside enable no");
            AJS.$("#enableTwoFactor").prop("checked", false);
        }, "#");

        dialog.show();
    }
    else {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Disable 2FA for Crowd Software</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside disable yes");
            disable2faForSoftware();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside disable no");
            AJS.$("#enableTwoFactor").prop("checked", true);
        }, "#");

        dialog.show();
    }
}

function enable2faForSoftware() {
    console.log("Calling enable2faForSoftware");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForSoftware"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForSoftware(response);
        },
        error: function (response) {
            performEnable2faForSoftware(response);
        },
        async: true
    });
}

function performEnable2faForSoftware(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA for Crowd Software',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully enabled 2FA for Crowd Software.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA for Crowd Software',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for Crowd Software.</p>'
        });
    }
}

function disable2faForSoftware() {
    console.log("Calling disable2faForSoftware");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForSoftware"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForSoftware(response);
        },
        error: function (response) {
            performDisable2faForSoftware(response);
        },
        async: true
    });
}

function performDisable2faForSoftware(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA for Crowd Software',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully disabled 2FA for Crowd Software.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA for Crowd Software',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for Crowd Software.</p>'
        });
    }
}


// End of 2FA for Crowd Software

// 2FA for all users

function confirmEnableOrDisable2FAForAllUsers() {
    var dialog = new AJS.Dialog({
        width: 500,
        height: 150,
        id: "confirm-dialog",
        closeOnOutsideClick: true
    });

    console.log("status="+document.getElementById("enable2FAForAllUsers").checked);
    if (!document.getElementById("enable2FAForAllUsers").checked) {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Enable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside enable yes");
            enable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside enable no");
            AJS.$("#enable2FAForAllUsers").prop("checked", false);
        }, "#");

        dialog.show();
    }
    else {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Disable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            console.log("inside disable yes");
            disable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            console.log("inside disable no");
            AJS.$("#enable2FAForAllUsers").prop("checked", true);
        }, "#");

        dialog.show();
    }
}

function enable2faForAllUsers() {
    console.log("Calling enable2faForAllUsers");
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently enabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForAllUsers(response);
        },
        error: function (response) {
            performEnable2faForAllUsers(response);
        },
        async: true
    });
}

function performEnable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully enabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for All Users</p>'
        });
    }
}

function disable2faForAllUsers() {
    console.log("Calling disable2faForAllUsers");
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForAllUsers(response);
        },
        error: function (response) {
            performDisable2faForAllUsers(response);
        },
        async: true
    });
}

function performDisable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully disabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for All Users</p>'
        });
    }
}

function displayMobileAuthenticatorSettings()
{
    AJS.dialog2("+#totpSettingsDiv").show();
}

function saveToggleButton(val){

    var enabled = document.getElementById(val).checked;
    var main = false;
    if(!val.includes("BackupCode"))
    {
        if(document.getElementById(val).checked) {
            AJS.$("#"+val+"Backup").prop('disabled', false);
            AJS.$("#"+val+"Main").prop('disabled', false);

        } else {
            AJS.$("#"+val+"Backup").prop('disabled', true);
            AJS.$("#"+val+"Main").prop('disabled', true);
            AJS.$("#"+val+"Backup").prop('checked', false);
            AJS.$("#"+val+"Main").prop('checked', false);

        }

        if(enabled === true)
        {
            AJS.$("#"+val+"Main").prop('checked', true);
            main=true;
        }
    }else{
        if(document.getElementById(val).checked) {
            AJS.$("#"+val+"Backup").prop('disabled', false);
        } else {
            AJS.$("#"+val+"Backup").prop('disabled', true);
            AJS.$("#"+val+"Backup").prop('checked', false);
        }
        if(enabled === true)
        {
            AJS.$("#"+val+"Backup").prop('checked', true);
            main=false;
        }
    }
    var selectedMethod = val;

    if(val.includes("WebAuthn") || val.includes("YubikeyHardwareToken")){
        if(enabled)
        {
            if(val.includes("WebAuthn"))
            {
                AJS.$("#idYubikeyHardwareTokenAsU2F").prop('disabled', true);
            }else{
                AJS.$("#idWebAuthn").prop('disabled', true);
            }
        }else{
            if(val.includes("WebAuthn"))
            {
                AJS.$("#idYubikeyHardwareTokenAsU2F").prop('disabled', false);
            }else{
                AJS.$("#idWebAuthn").prop('disabled', false);
            }
        }
    }



    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "SavedMethodSettings",
            "selectedMethod": selectedMethod,
            "enabled": enabled,
            "Main":main
        },
        type: "GET",
        success: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            console.log(methodHead);
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Enabling 2FA Method',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Successfully Enabled : '+methodHead+' as a '+ response.type+ '</p>'
                });
            }
            else{
                if(response.disablingLast2FAMethod===true)
                {
                    require('aui/flag')({
                        title: 'Disabling 2FA Method',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Please select at least 1 2FA method for User.</p>'
                    });
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                }else if(response.disablingLastConfiguredFallBackMethod === true) {
                                     require('aui/flag')({
                                         title: 'Error in disabling 2FA Method',
                                         type: 'error',
                                         close: 'manual',
                                         body: '<p>This is the only primary method added to Fall back methods. Please add any other primary method to fallback methods to disable this Method.</p>'
                                     });
                } else if(response.disablingMfaMethodsBasedOnGroupsMethod === true) {
                                     require('aui/flag')({
                                         title: 'Disabling 2FA Method',
                                         type: 'warning',
                                         close: 'manual',
                                         body: '<p>Disabled : '+methodHead+ '</p><br>This method is configured within the <a href=\'advancedsettings#mfaMethodsBasedOnGroups\' target=\"_blank\">Restrict 2FA Methods Based on Groups</a> feature, review this features settings for consistency.'
                                     });
                }else{
                    require('aui/flag')({
                        title: 'Disabling 2FA Method',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Disabled : '+methodHead+ '</p>'
                    });
                }
            }
        },
        error: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Error while Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+ '</p>'
                });
            }
        },
        async: true
    });

}

function hoverOut(val){
    document.getElementById(val+"Icon").style.color = "";
    document.getElementById(val+"Icon").style.textShadow = "";
}

function hoverIn(val){
    document.getElementById(val+"Icon").style.color = "#0065ff";
    document.getElementById(val+"Icon").style.textShadow = "2px 2px 8px #348bff";
}


function saveRadioButton(val){
    var selectedMethod = val;
    var enabled = true;
    var Main = val.includes("Main");
    console.log("main :"+Main);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "SavedMethodSettings",
            "selectedMethod": selectedMethod,
            "enabled": enabled,
            "Main": Main,
            "FromRadio" : true
        },
        type: "GET",
        success: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(response.enablingBackupWithout2FA===true)
            {
                require('aui/flag')({
                    title: 'Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+' as a '+ response.type+ ' as no 2FA method is enabled. '+ '</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 3000);

            }else if(response.disablingLastConfiguredFallBackMethod === true) {
                                             require('aui/flag')({
                                                 title: 'Enabling 2FA Method as Backup Method',
                                                 type: 'error',
                                                 close: 'auto',
                                                 body: '<p>Only primary method added to Fall back method. Please add any other primary method to fallback method to use this method as backup Method.</p>'
                                             });
                                             setTimeout(function () {
                                                 location.reload();
                                             }, 4000);
            }else{
                if(enabled)
                {
                    require('aui/flag')({
                        title: 'Enabling 2FA Method',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Enabled : '+methodHead+' as a '+ response.type+ '</p>'
                    });
                }
            }
        },
        error: function (response) {
            methodHead = document.getElementById(response.methodName+"Heading").innerHTML;
            if(enabled)
            {
                require('aui/flag')({
                    title: 'Error while Enabling 2FA Method',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Error while enabling '+methodHead+ '</p>'
                });
            }
        },
        async: true
    });
}

// End of 2FA for all users


AJS.$(function () {
    console.log("showWelcomePrompt :"+ document.getElementById("showWelcomePrompt").value);
    if (document.getElementById("showWelcomePrompt").value == "true") {
        AJS.dialog2("#intro_for_new_users_dialog").show();
    }
    AJS.$("#intro_for_new_users_dialog_close_button").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#intro_for_new_users_dialog").hide();
    });
});
function redirectTo(divId){
    if(divId.includes("excludeGroups"))
    {
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/userdetails"+"?userManagementSelectedAction=GroupAction"+"#"+divId);
    }else if(divId.includes("usermanagement")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/userdetails"+"?userManagementSelectedAction=UserAction");
    }else if(divId.includes("disable2faForSsoUsers")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/advancedsettings#"+divId);
    }else if(divId.includes("IpRestriction")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/adaptiveauthentication");
    }else if(divId.includes("configure2fabyuser")){
        window.open(AJS.contextPath() + "/plugins/servlet/"+divId);
    }else if(divId.includes("oneTime2FAInCrowdAuthenticationSetup")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/advancedsettings#"+divId);
    }else if(divId.includes("securityQuestionTemplateDiv")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/lookandfeeltemplates#"+divId);
    }else if(divId.includes("AddSmtpMailServer")){
        window.open(AJS.contextPath()+"/console/secure/admin/mailserver.action");
    }else if(divId.includes("mfaMethodsBasedOnGroups")){
        window.open(AJS.contextPath() + "/plugins/servlet/twofactor/advancedsettings#"+divId);
    }

}
function openCloseElemenet(elementId){
    document.getElementById(elementId).classList.toggle("arrow_rotate");
}
function displaySettings(divId)
{
//    alert("divId -> "+divId);
    console.log(divId);
    AJS.dialog2("#"+divId).show();
}

function validateDefaultCountryCode(input) {
    var Regex =/^(\+\d{1,3})$/gm;
    var submitButton = document.querySelector('#OtpOverSmsSubmitButtonId[value="Save"]');
    const defaultCountryCodeResult = document.getElementById("defaultCountryCodeResult");
    if (Regex.test(input)) {
        defaultCountryCodeResult.innerHTML = "Valid Country Code.";
        defaultCountryCodeResult.style.color = "green";
        submitButton.disabled = false;
    } else {
        defaultCountryCodeResult.innerHTML = "Invalid Country Code.";
        defaultCountryCodeResult.style.color = "red";
        submitButton.disabled = true;
    }
}

