/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.net.DefaultSocketFactory;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;

public abstract class SocketClient {
    public static final String NETASCII_EOL = "\r\n";
    private static final SocketFactory DEFAULT_SOCKET_FACTORY = SocketFactory.getDefault();
    private static final ServerSocketFactory DEFAULT_SERVER_SOCKET_FACTORY = ServerSocketFactory.getDefault();
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private ProtocolCommandSupport commandSupport;
    protected int _timeout_ = 0;
    protected Socket _socket_ = null;
    protected String _hostname_ = null;
    protected int _defaultPort_ = 0;
    protected InputStream _input_ = null;
    protected OutputStream _output_ = null;
    protected SocketFactory _socketFactory_;
    protected ServerSocketFactory _serverSocketFactory_;
    protected int connectTimeout = 60000;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private Proxy connProxy;
    private Charset charset = Charset.defaultCharset();

    public SocketClient() {
        this._socketFactory_ = DEFAULT_SOCKET_FACTORY;
        this._serverSocketFactory_ = DEFAULT_SERVER_SOCKET_FACTORY;
    }

    private void _connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SocketException, IOException {
        this._socket_ = this._socketFactory_.createSocket();
        if (this.receiveBufferSize != -1) {
            this._socket_.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != -1) {
            this._socket_.setSendBufferSize(this.sendBufferSize);
        }
        if (localAddr != null) {
            this._socket_.bind(new InetSocketAddress(localAddr, localPort));
        }
        this._socket_.connect(new InetSocketAddress(host, port), this.connectTimeout);
        this._connectAction_();
    }

    protected void _connectAction_() throws IOException {
        this.applySocketAttributes();
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
    }

    public void addProtocolCommandListener(ProtocolCommandListener listener) {
        this.getCommandSupport().addProtocolCommandListener(listener);
    }

    protected void applySocketAttributes() throws SocketException {
        this._socket_.setSoTimeout(this._timeout_);
    }

    private void closeQuietly(Closeable close) {
        if (close != null) {
            try {
                close.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void connect(InetAddress host) throws SocketException, IOException {
        this._hostname_ = null;
        this.connect(host, this._defaultPort_);
    }

    public void connect(InetAddress host, int port) throws SocketException, IOException {
        this._hostname_ = null;
        this._connect(host, port, null, -1);
    }

    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SocketException, IOException {
        this._hostname_ = null;
        this._connect(host, port, localAddr, localPort);
    }

    public void connect(String hostname) throws SocketException, IOException {
        this.connect(hostname, this._defaultPort_);
    }

    public void connect(String hostname, int port) throws SocketException, IOException {
        this._hostname_ = hostname;
        this._connect(InetAddress.getByName(hostname), port, null, -1);
    }

    public void connect(String hostname, int port, InetAddress localAddr, int localPort) throws SocketException, IOException {
        this._hostname_ = hostname;
        this._connect(InetAddress.getByName(hostname), port, localAddr, localPort);
    }

    protected void createCommandSupport() {
        this.commandSupport = new ProtocolCommandSupport(this);
    }

    public void disconnect() throws IOException {
        this.closeQuietly(this._socket_);
        this.closeQuietly(this._input_);
        this.closeQuietly(this._output_);
        this._socket_ = null;
        this._hostname_ = null;
        this._input_ = null;
        this._output_ = null;
    }

    protected void fireCommandSent(String command, String message) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireCommandSent(command, message);
        }
    }

    protected void fireReplyReceived(int replyCode, String reply) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireReplyReceived(replyCode, reply);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Deprecated
    public String getCharsetName() {
        return this.charset.name();
    }

    protected ProtocolCommandSupport getCommandSupport() {
        return this.commandSupport;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getDefaultPort() {
        return this._defaultPort_;
    }

    public int getDefaultTimeout() {
        return this._timeout_;
    }

    public boolean getKeepAlive() throws SocketException {
        return this._socket_.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this._socket_.getLocalAddress();
    }

    public int getLocalPort() {
        return this._socket_.getLocalPort();
    }

    public Proxy getProxy() {
        return this.connProxy;
    }

    protected int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public InetAddress getRemoteAddress() {
        return this._socket_.getInetAddress();
    }

    public int getRemotePort() {
        return this._socket_.getPort();
    }

    protected int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this._serverSocketFactory_;
    }

    public int getSoLinger() throws SocketException {
        return this._socket_.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this._socket_.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this._socket_.getTcpNoDelay();
    }

    public boolean isAvailable() {
        if (this.isConnected()) {
            try {
                if (this._socket_.getInetAddress() == null) {
                    return false;
                }
                if (this._socket_.getPort() == 0) {
                    return false;
                }
                if (this._socket_.getRemoteSocketAddress() == null) {
                    return false;
                }
                if (this._socket_.isClosed()) {
                    return false;
                }
                if (this._socket_.isInputShutdown()) {
                    return false;
                }
                if (this._socket_.isOutputShutdown()) {
                    return false;
                }
                this._socket_.getInputStream();
                this._socket_.getOutputStream();
            }
            catch (IOException ioex) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        if (this._socket_ == null) {
            return false;
        }
        return this._socket_.isConnected();
    }

    public void removeProtocolCommandListener(ProtocolCommandListener listener) {
        this.getCommandSupport().removeProtocolCommandListener(listener);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDefaultPort(int port) {
        this._defaultPort_ = port;
    }

    public void setDefaultTimeout(int timeout2) {
        this._timeout_ = timeout2;
    }

    public void setKeepAlive(boolean keepAlive) throws SocketException {
        this._socket_.setKeepAlive(keepAlive);
    }

    public void setProxy(Proxy proxy) {
        this.setSocketFactory(new DefaultSocketFactory(proxy));
        this.connProxy = proxy;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.receiveBufferSize = size;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.sendBufferSize = size;
    }

    public void setServerSocketFactory(ServerSocketFactory factory2) {
        this._serverSocketFactory_ = factory2 == null ? DEFAULT_SERVER_SOCKET_FACTORY : factory2;
    }

    public void setSocketFactory(SocketFactory factory2) {
        this._socketFactory_ = factory2 == null ? DEFAULT_SOCKET_FACTORY : factory2;
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
        this._socket_.setSoLinger(on, val);
    }

    public void setSoTimeout(int timeout2) throws SocketException {
        this._socket_.setSoTimeout(timeout2);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this._socket_.setTcpNoDelay(on);
    }

    public boolean verifyRemote(Socket socket) {
        InetAddress host1 = socket.getInetAddress();
        InetAddress host2 = this.getRemoteAddress();
        return host1.equals(host2);
    }
}

