/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborException;
import com.google.common.primitives.Bytes;
import com.miniorange.twofactor.crowd.webauthn.dto.Credential;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAssertionResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAttestationResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.EccKey;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredential;
import com.miniorange.twofactor.crowd.webauthn.utils.RsaKey;
import jakarta.servlet.ServletException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

public abstract class Server {
    private static Log LOGGER = LogFactory.getLog(Server.class);

    public static void verifySessionAndChallenge(AuthenticatorResponse assertionResponse, String currentUser, String sessionId) throws Exception {
        if (sessionId == null) {
            return;
        }
        long id = 0L;
        try {
            id = Long.valueOf(sessionId);
        }
        catch (NumberFormatException e) {
            throw new Exception("Provided session id invalid");
        }
    }

    public static Credential validateAndFindCredential(PublicKeyCredential cred, String currentUser, String sessionId) throws Exception {
        if (!(cred.getResponse() instanceof AuthenticatorAssertionResponse)) {
            throw new Exception("Invalid authenticator response");
        }
        AuthenticatorAssertionResponse assertionResponse = (AuthenticatorAssertionResponse)cred.getResponse();
        LOGGER.debug("assertion Response :- " + String.valueOf(assertionResponse));
        Credential credential = null;
        if (credential == null) {
            throw new Exception("Received response from credential not associated with user");
        }
        return credential;
    }

    public static void verifyAssertion(PublicKeyCredential cred, String currentUser, String sessionId, Credential savedCredential) throws ServletException {
        AuthenticatorAssertionResponse assertionResponse = (AuthenticatorAssertionResponse)cred.getResponse();
        LOGGER.debug("SavedCredentials :- " + String.valueOf(savedCredential));
        try {
            byte[] signedBytes;
            String signatureAlgorithm;
            PublicKey publicKey;
            if (!(savedCredential.getCredential().getResponse() instanceof AuthenticatorAttestationResponse)) {
                throw new ServletException("Stored attestation missing");
            }
            AuthenticatorAttestationResponse storedAttData = (AuthenticatorAttestationResponse)savedCredential.getCredential().getResponse();
            if (storedAttData.decodedObject.getAuthenticatorData().getAttData().getPublicKey() instanceof EccKey) {
                publicKey = Server.getECPublicKey((EccKey)storedAttData.decodedObject.getAuthenticatorData().getAttData().getPublicKey());
                signatureAlgorithm = "SHA256withECDSA";
            } else {
                publicKey = Server.getRSAPublicKey((RsaKey)storedAttData.decodedObject.getAuthenticatorData().getAttData().getPublicKey());
                signatureAlgorithm = "SHA256withRSA";
            }
            byte[] clientDataHash = Server.sha256Digest(assertionResponse.getClientDataBytes());
            try {
                signedBytes = Bytes.concat(assertionResponse.getAuthDataBytes(), clientDataHash);
            }
            catch (NullPointerException e) {
                try {
                    signedBytes = Bytes.concat(assertionResponse.getAuthenticatorData().encode(), clientDataHash);
                }
                catch (CborException e1) {
                    throw new ServletException("Authenticator data invalid", (Throwable)e);
                }
            }
            if (!Server.verifySignature(publicKey, signedBytes, assertionResponse.getSignature(), signatureAlgorithm)) {
                throw new ServletException("Signature invalid");
            }
        }
        catch (Exception e) {
            throw new ServletException("Failure while verifying signature", (Throwable)e);
        }
    }

    public static PublicKey getECPublicKey(EccKey eccKey) throws Exception {
        BigInteger x = new BigInteger(eccKey.getX());
        BigInteger y = new BigInteger(eccKey.getY());
        ECPoint w = new ECPoint(x, y);
        String curveName = "P-256";
        try {
            return Server.getECPublicKey(w, curveName);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.debug("PublicGetEcPUblicKey");
            throw new Exception("Error when generate EC public key", e);
        }
    }

    public static PublicKey getECPublicKey(ECPoint w, String stdCurveName) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)stdCurveName);
        ECNamedCurveSpec params = new ECNamedCurveSpec(parameterSpec.getName(), parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, (ECParameterSpec)params);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(keySpec);
    }

    public static PublicKey getRSAPublicKey(RsaKey rsaKey) throws Exception {
        BigInteger modulus = new BigInteger(Bytes.concat({0}, rsaKey.getN()));
        BigInteger publicExponent = new BigInteger(rsaKey.getE());
        try {
            return Server.getRSAPublicKey(modulus, publicExponent);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.debug("getRsaPublicKey");
            throw new Exception("Error when generate RSA public key", e);
        }
    }

    public static PublicKey getRSAPublicKey(BigInteger n, BigInteger e) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static byte[] sha256Digest(byte[] input) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(input, 0, input.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] signedBytes, byte[] signature) throws Exception {
        try {
            Signature ecdsaSignature = Signature.getInstance("SHA256withECDSA");
            ecdsaSignature.initVerify(publicKey);
            ecdsaSignature.update(signedBytes);
            return ecdsaSignature.verify(signature);
        }
        catch (InvalidKeyException e) {
            LOGGER.debug("VerifySignatyre");
            throw new Exception("Error when verifying signature", e);
        }
        catch (SignatureException e) {
            throw new Exception("Error when verifying signature", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Error when verifying signature", e);
        }
    }

    public static boolean verifySignature(X509Certificate attestationCertificate, byte[] signedBytes, byte[] signature) throws Exception {
        return Server.verifySignature(attestationCertificate.getPublicKey(), signedBytes, signature);
    }

    public static boolean verifySignature(X509Certificate attestationCertificate, byte[] signedBytes, byte[] signature, String signatureAlgorithm) throws Exception {
        return Server.verifySignature(attestationCertificate.getPublicKey(), signedBytes, signature, signatureAlgorithm);
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] message, byte[] signature, String signatureAlgorithm) throws Exception {
        if (signatureAlgorithm == null || signatureAlgorithm.isEmpty()) {
            throw new Exception("Signature algorithm is null or empty");
        }
        try {
            Signature sig = Signature.getInstance(signatureAlgorithm);
            sig.initVerify(publicKey);
            sig.update(message);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.debug("verifySignature2nd");
            throw new Exception("Error when verifying signature", e);
        }
    }
}

