/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import com.miniorange.twofactor.crowd.webauthn.utils.AttestationStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FidoU2fAttestationStatement
extends AttestationStatement {
    public byte[] sig;
    public byte[] attestnCert;
    public List<byte[]> caCert;

    public FidoU2fAttestationStatement(byte[] sig, byte[] attestnCert, List<byte[]> caCert) {
        this.sig = sig;
        this.attestnCert = attestnCert;
        this.caCert = caCert;
    }

    public FidoU2fAttestationStatement() {
    }

    public static FidoU2fAttestationStatement decode(DataItem attStmt) {
        FidoU2fAttestationStatement result = new FidoU2fAttestationStatement();
        Map given = null;
        if (attStmt instanceof ByteString) {
            byte[] temp = ((ByteString)attStmt).getBytes();
            List<DataItem> dataItems = null;
            try {
                dataItems = CborDecoder.decode(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            given = (Map)dataItems.get(0);
        } else {
            given = (Map)attStmt;
        }
        for (DataItem data : given.getKeys()) {
            if (!(data instanceof UnicodeString)) continue;
            if (((UnicodeString)data).getString().equals("x5c")) {
                Array array = (Array)given.get(data);
                List<DataItem> list = array.getDataItems();
                if (list.size() > 0) {
                    result.attestnCert = ((ByteString)list.get(0)).getBytes();
                }
                result.caCert = new ArrayList<byte[]>();
                for (int i = 1; i < list.size(); ++i) {
                    result.caCert.add(((ByteString)list.get(i)).getBytes());
                }
                continue;
            }
            if (!((UnicodeString)data).getString().equals("sig")) continue;
            result.sig = ((ByteString)given.get(data)).getBytes();
        }
        return result;
    }

    @Override
    DataItem encode() throws CborException {
        Map result = new Map();
        Array x5c = new Array();
        x5c.add(new ByteString(this.attestnCert));
        for (byte[] cert : this.caCert) {
            x5c.add(new ByteString(cert));
        }
        result.put(new UnicodeString("x5c"), x5c);
        result.put(new UnicodeString("sig"), new ByteString(this.sig));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FidoU2fAttestationStatement)) {
            return false;
        }
        FidoU2fAttestationStatement other = (FidoU2fAttestationStatement)obj;
        if (!Arrays.equals(this.attestnCert, other.attestnCert)) {
            return false;
        }
        if (!Arrays.equals(this.sig, other.sig)) {
            return false;
        }
        if (this.caCert.size() == other.caCert.size()) {
            return false;
        }
        for (int i = 0; i < this.caCert.size(); ++i) {
            if (Arrays.equals(this.caCert.get(i), other.caCert.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.sig), Arrays.hashCode(this.attestnCert), this.caCert);
    }

    @Override
    public String getName() {
        return "FIDO U2F Authenticator";
    }
}

