/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import com.google.common.io.BaseEncoding;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;

public class CableSessionData {
    public int version;
    public byte[] clientEid;
    public byte[] authenticatorEid;
    public byte[] sessionPreKey;

    public CableSessionData() {
    }

    public CableSessionData(int version, byte[] clientEid, byte[] authenticatorEid, byte[] sessionPreKey) {
        this.version = version;
        this.clientEid = clientEid;
        this.authenticatorEid = authenticatorEid;
        this.sessionPreKey = sessionPreKey;
    }

    public JsonObject getJsonObject() {
        JsonObject result = new JsonObject();
        result.addProperty("version", this.version);
        result.addProperty("clientEid", BaseEncoding.base64().encode(this.clientEid));
        result.addProperty("authenticatorEid", BaseEncoding.base64().encode(this.authenticatorEid));
        result.addProperty("sessionPreKey", BaseEncoding.base64().encode(this.sessionPreKey));
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.version, Arrays.hashCode(this.clientEid), Arrays.hashCode(this.authenticatorEid), Arrays.hashCode(this.sessionPreKey));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CableSessionData that = (CableSessionData)o;
        return this.version == that.version && Arrays.equals(this.clientEid, that.clientEid) && Arrays.equals(this.authenticatorEid, that.authenticatorEid) && Arrays.equals(this.sessionPreKey, that.sessionPreKey);
    }
}

