/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborException;
import com.atlassian.json.jsonorg.JSONObject;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.webauthn.utils.AttestationObject;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.CollectedClientData;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private static Log LOGGER = LogFactory.getLog(AuthenticatorAttestationResponse.class);
    public AttestationObject decodedObject;
    public String[] transports;

    public AuthenticatorAttestationResponse() {
    }

    public AuthenticatorAttestationResponse(String clientDataJSON, String attestationObject) throws Exception {
        this.clientData = CollectedClientData.decode(clientDataJSON);
        this.clientDataBytes = clientDataJSON.getBytes(StandardCharsets.UTF_8);
        try {
            this.decodedObject = AttestationObject.decode(BaseEncoding.base64().decode(attestationObject));
        }
        catch (CborException e) {
            throw new Exception("Cannot decode attestation object");
        }
    }

    public AuthenticatorAttestationResponse(JsonElement data) throws Exception {
        Gson gson = new Gson();
        AttestationResponseJson parsedObject = gson.fromJson(data, AttestationResponseJson.class);
        this.clientDataBytes = BaseEncoding.base64().decode(parsedObject.clientDataJSON);
        byte[] attestationObject = BaseEncoding.base64().decode(parsedObject.attestationObject);
        try {
            this.decodedObject = AttestationObject.decode(attestationObject);
        }
        catch (CborException e) {
            throw new Exception("Cannot decode attestation object");
        }
        JSONObject jsonObject = new JSONObject(new String(this.clientDataBytes, StandardCharsets.UTF_8));
        this.clientData = new CollectedClientData();
        this.clientData.setChallenge(jsonObject.getString("challenge"));
        this.clientData.setOrigin(jsonObject.getString("origin"));
        this.clientData.setType(jsonObject.getString("type"));
        this.transports = parsedObject.transports;
    }

    public String encode() {
        JsonObject json = new JsonObject();
        json.addProperty("clientDataJSON", BaseEncoding.base64().encode(this.clientDataBytes));
        try {
            json.addProperty("attestationObject", BaseEncoding.base64().encode(this.decodedObject.encode()));
        }
        catch (CborException e) {
            return null;
        }
        return json.getAsString();
    }

    public AttestationObject getAttestationObject() {
        return this.decodedObject;
    }

    public String[] getTransports() {
        return this.transports;
    }

    private static class AttestationResponseJson {
        String clientDataJSON;
        String attestationObject;
        String[] transports;

        private AttestationResponseJson() {
        }
    }
}

