/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.DataItem;
import com.miniorange.twofactor.crowd.webauthn.utils.AndroidSafetyNetAttestationStatement;
import com.miniorange.twofactor.crowd.webauthn.utils.FidoU2fAttestationStatement;
import com.miniorange.twofactor.crowd.webauthn.utils.NoneAttestationStatement;
import com.miniorange.twofactor.crowd.webauthn.utils.PackedAttestationStatement;

public abstract class AttestationStatement {
    public static AttestationStatement decode(String fmt, DataItem attStmt) {
        switch (fmt) {
            case "fido-u2f": {
                return FidoU2fAttestationStatement.decode(attStmt);
            }
            case "packed": {
                return PackedAttestationStatement.decode(attStmt);
            }
            case "android-safetynet": {
                try {
                    return AndroidSafetyNetAttestationStatement.decode(attStmt);
                }
                catch (Exception e) {
                    break;
                }
            }
            case "none": {
                return new NoneAttestationStatement();
            }
        }
        return null;
    }

    abstract DataItem encode() throws CborException;

    public abstract String getName();
}

