/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import com.miniorange.twofactor.crowd.webauthn.utils.AttestationStatement;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorData;
import java.io.ByteArrayOutputStream;
import java.util.List;

public class AttestationObject {
    AuthenticatorData authData;
    String fmt;
    AttestationStatement attStmt;

    public AttestationObject() {
    }

    public AttestationObject(AuthenticatorData authData, String fmt, AttestationStatement attStmt) {
        this.authData = authData;
        this.fmt = fmt;
        this.attStmt = attStmt;
    }

    public static AttestationObject decode(byte[] attestationObject) throws CborException, Exception {
        AttestationObject result = new AttestationObject();
        List<DataItem> dataItems = CborDecoder.decode(attestationObject);
        if (dataItems.size() == 1 && dataItems.get(0) instanceof Map) {
            DataItem attStmt = null;
            Map attObjMap = (Map)dataItems.get(0);
            for (DataItem key : attObjMap.getKeys()) {
                if (!(key instanceof UnicodeString)) continue;
                switch (((UnicodeString)key).getString()) {
                    case "fmt": {
                        UnicodeString value = (UnicodeString)attObjMap.get(key);
                        result.fmt = value.getString();
                        break;
                    }
                    case "authData": {
                        byte[] authData = ((ByteString)attObjMap.get(key)).getBytes();
                        result.authData = AuthenticatorData.decode(authData);
                        break;
                    }
                    case "attStmt": {
                        attStmt = attObjMap.get(key);
                    }
                }
            }
            if (attStmt != null) {
                result.attStmt = AttestationStatement.decode(result.fmt, attStmt);
            }
        }
        return result;
    }

    public byte[] encode() throws CborException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        List<DataItem> cbor = new CborBuilder().addMap().put("fmt", this.fmt).put("authData", this.authData.encode()).put(new UnicodeString("attStmt"), this.attStmt.encode()).end().build();
        new CborEncoder(output).encode(cbor);
        return output.toByteArray();
    }

    public AuthenticatorData getAuthenticatorData() {
        return this.authData;
    }

    public String getFormat() {
        return this.fmt;
    }

    public AttestationStatement getAttestationStatement() {
        return this.attStmt;
    }
}

