/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborException;
import com.google.common.primitives.Bytes;
import com.miniorange.twofactor.crowd.webauthn.utils.CredentialPublicKey;
import com.miniorange.twofactor.crowd.webauthn.utils.EccKey;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class AttestationData {
    byte[] aaguid;
    byte[] credentialId;
    CredentialPublicKey publicKey;

    public AttestationData() {
        this.aaguid = new byte[16];
        this.credentialId = new byte[0];
        this.publicKey = new EccKey();
    }

    public AttestationData(byte[] aaguid, byte[] credentialId, CredentialPublicKey publicKey) {
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.publicKey = publicKey;
    }

    public static AttestationData decode(byte[] data) throws Exception, CborException {
        AttestationData result = new AttestationData();
        int index = 0;
        if (data.length < 18) {
            throw new Exception("Invalid input");
        }
        System.arraycopy(data, 0, result.aaguid, 0, 16);
        index += 16;
        int length = (data[index++] & 0xFF) << 8;
        result.credentialId = new byte[length += data[index++] & 0xFF];
        System.arraycopy(data, index, result.credentialId, 0, length);
        byte[] cbor = new byte[data.length - (index += length)];
        System.arraycopy(data, index, cbor, 0, data.length - index);
        result.publicKey = CredentialPublicKey.decode(cbor);
        return result;
    }

    public byte[] encode() throws CborException {
        return Bytes.concat(this.aaguid, ByteBuffer.allocate(2).putShort((short)this.credentialId.length).array(), this.credentialId, this.publicKey.encode());
    }

    public boolean equals(Object obj) {
        try {
            AttestationData other = (AttestationData)obj;
            return Arrays.equals(this.encode(), other.encode());
        }
        catch (CborException | ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.aaguid), Arrays.hashCode(this.credentialId), this.publicKey);
    }

    public byte[] getAaguid() {
        return this.aaguid;
    }

    public byte[] getCredentialId() {
        return this.credentialId;
    }

    public CredentialPublicKey getPublicKey() {
        return this.publicKey;
    }
}

