/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

public enum Algorithm {
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512"),
    UNDEFINED("undefined");

    private final String name;

    private Algorithm(String name) {
        this.name = name;
    }

    public static boolean isEccAlgorithm(Algorithm alg) {
        return alg == ES256 || alg == ES384 || alg == ES512;
    }

    public static boolean isRsaAlgorithm(Algorithm alg) {
        return alg == RS256 || alg == RS384 || alg == RS512 || alg == PS256 || alg == PS384 || alg == PS512;
    }

    public static Algorithm decode(String s2) {
        for (Algorithm t2 : Algorithm.values()) {
            if (!t2.name.equals(s2)) continue;
            return t2;
        }
        if (s2.equals("-7")) {
            return ES256;
        }
        throw new IllegalArgumentException(s2 + " not a valid Algorithm");
    }

    public static Algorithm decode(int alg) {
        switch (alg) {
            case -7: {
                return ES256;
            }
            case -35: {
                return ES384;
            }
            case -36: {
                return ES512;
            }
            case -37: {
                return PS256;
            }
            case -38: {
                return PS384;
            }
            case -39: {
                return PS512;
            }
            case -257: {
                return RS256;
            }
            case -258: {
                return RS384;
            }
            case -259: {
                return RS512;
            }
            case -260: {
                return ES256;
            }
            case -261: {
                return ES512;
            }
        }
        return UNDEFINED;
    }

    public int encodeToInt() {
        switch (this.ordinal()) {
            case 0: {
                return -7;
            }
            case 1: {
                return -35;
            }
            case 2: {
                return -36;
            }
            case 6: {
                return -37;
            }
            case 7: {
                return -38;
            }
            case 8: {
                return -39;
            }
            case 3: {
                return -257;
            }
            case 4: {
                return -258;
            }
            case 5: {
                return -259;
            }
        }
        return -1;
    }

    public String toString() {
        return this.name;
    }

    public Object toReadableString() {
        return this.name;
    }
}

