/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.servlets;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoSecureUtil
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoSecureUtil.class);
    private final SecureRandom random = new SecureRandom();
    private static int EC_COORDINATE_LENGTH = 32;
    private static int EC_PUBLIC_KEY_LENGTH = 65;
    private static byte EC_PUBLIC_KEY_PREFIX = (byte)4;
    private static String rawId;
    private MoSettings moSettings;
    private MoTwoFactorCommonPluginSettings settings;

    public MoSecureUtil(MoSettings moSettings, MoTwoFactorCommonPluginSettings settings) {
        this.moSettings = moSettings;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("In MoSecureUtil\t" + request.getParameter("action"));
        switch (request.getParameter("action")) {
            case "cableRegistrationData": {
                this.cableRegistration(request, response);
                break;
            }
            case "getRawId": {
                this.sendRawId(request, response);
                break;
            }
            case "EnableWebAuthnForUser": {
                this.enableWebAuthnForUser(request, response);
                break;
            }
            case "DisableWebAuthnForUser": {
                this.disableWebAuthnForUser(request, response);
                break;
            }
            case "ResetWebAuthnForUser": {
                this.resetWebAuthnForUser(request, response);
                break;
            }
            case "ResetWebAuthnForAllUsers": {
                this.ResetWebAuthnForAllUsers(request, response);
                break;
            }
            case "ResetWebAuthnForSelectedUsers": {
                this.ResetWebAuthnForSelectedUsers(request, response);
                break;
            }
            case "removeWebAuthnOrHardwareCred": {
                this.removeWebAuthnOrHardwareCred(request, response);
                break;
            }
            default: {
                LOGGER.debug("Could not found");
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void resetWebAuthnForUser(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the resetWebAuthn For user :- " + req.getParameter("username"));
            String username = req.getParameter("username");
            LOGGER.debug("username = " + username);
            if (username != null && !username.isEmpty()) {
                HashMap<String, String> map = this.moSettings.getCredParamMap();
                String removedUsername = map.remove(username);
                if (removedUsername == null || removedUsername.isEmpty()) {
                    LOGGER.error("Could not reset for user :- " + username);
                    this.sendErrorResponse(resp);
                } else {
                    this.moSettings.setCredParamMap(map);
                    LOGGER.debug("Reset WebAuthn successful");
                    this.sendSuccessResponse("true", resp);
                }
            } else {
                LOGGER.error("Error occurred in resetting webAuthn for user");
                this.sendErrorResponse(resp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in resetting webAuthn for user");
            this.sendErrorResponse(resp);
        }
    }

    private void ResetWebAuthnForAllUsers(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the resetWebAuthn for all users :- ");
            List<String> configured2FAUsers = this.settings.getListOf2FAConfiguredUsers();
            LOGGER.debug("configured2FAUsers = " + String.valueOf(configured2FAUsers));
            for (String username : configured2FAUsers) {
                LOGGER.debug("username = " + username);
                if (username != null && !username.isEmpty()) {
                    HashMap<String, String> map = this.moSettings.getCredParamMap();
                    String removedUsername = map.remove(username);
                    if (removedUsername.equals(null) || removedUsername.isEmpty()) {
                        LOGGER.debug("Could not reset for user :- " + username);
                        this.sendErrorResponse(resp);
                        continue;
                    }
                    this.moSettings.setCredParamMap(map);
                    this.sendSuccessResponse("true", resp);
                    continue;
                }
                this.sendErrorResponse(resp);
            }
            LOGGER.debug("Reset WebAuthn successful for all users");
        }
        catch (Exception e) {
            LOGGER.error(e);
            this.sendErrorResponse(resp);
        }
    }

    private void removeWebAuthnOrHardwareCred(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the removeWebAuthnOrHardwareCred For user :- " + req.getParameter("username"));
            String username = req.getParameter("username");
            String method = req.getParameter("method");
            String key = req.getParameter("keyToDelete");
            if (username != null && !username.isEmpty()) {
                HashMap<Object, Object> userRawId = new HashMap();
                userRawId = StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"hardwareToken") ? this.moSettings.getUserRawId() : this.moSettings.getUserRawIdForWebAuthn();
                JSONObject credObj = new JSONObject((String)userRawId.get(username));
                this.moSettings.removeUserCred(credObj.getString(key), username);
                credObj.remove(key);
                userRawId.put(username, credObj.toString());
                if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"hardwareToken")) {
                    this.moSettings.setUserRawId(userRawId);
                } else {
                    this.moSettings.setUserRawIdForWebAuthn(userRawId);
                }
                if (credObj.length() > 0) {
                    this.sendSuccessResponse("true", resp);
                } else {
                    this.sendSuccessResponse("false", resp);
                }
            } else {
                this.sendErrorResponse(resp);
            }
        }
        catch (Exception e) {
            LOGGER.debug("\nError occurred", e);
            this.sendErrorResponse(resp);
        }
        LOGGER.debug("Reset WebAuthn successful");
    }

    private void ResetWebAuthnForSelectedUsers(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String[] selectedUser;
            LOGGER.debug("Inside the resetWebAuthn for selected users :- ");
            for (String username : selectedUser = req.getParameterValues("selectedUsers")) {
                LOGGER.debug("username = " + username);
                if (username != null && !username.isEmpty()) {
                    HashMap<String, String> map = this.moSettings.getCredParamMap();
                    String removedUsername = map.remove(username);
                    if (removedUsername.equals(null) || removedUsername.isEmpty()) {
                        LOGGER.debug("Could not reset for user :- " + username);
                        this.sendErrorResponse(resp);
                        continue;
                    }
                    this.moSettings.setCredParamMap(map);
                    this.sendSuccessResponse("true", resp);
                    continue;
                }
                this.sendErrorResponse(resp);
            }
            LOGGER.debug("Reset WebAuthn successful for selected users");
        }
        catch (Exception e) {
            LOGGER.error(e);
            this.sendErrorResponse(resp);
        }
    }

    private void enableWebAuthnForUser(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the enableWebAuthn For user :- " + req.getParameter("username"));
            String username = req.getParameter("username");
            if (username != null && !username.isEmpty()) {
                List<String> userList = this.moSettings.getListOfWebAuthnDisabledUsers();
                userList.remove(username);
                this.moSettings.setListOfWebAuthnDisabledUsers(userList);
                this.sendSuccessResponse("true", resp);
            } else {
                this.sendErrorResponse(resp);
            }
        }
        catch (Exception e) {
            this.sendErrorResponse(resp);
        }
    }

    private void disableWebAuthnForUser(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the disableWebAuthn For user :- " + req.getParameter("username"));
            String username = req.getParameter("username");
            if (username != null && !username.isEmpty()) {
                List<String> userList = this.moSettings.getListOfWebAuthnDisabledUsers();
                userList.add(username);
                this.moSettings.setListOfWebAuthnDisabledUsers(userList);
                this.sendSuccessResponse("true", resp);
            } else {
                this.sendErrorResponse(resp);
            }
        }
        catch (Exception e) {
            this.sendErrorResponse(resp);
        }
    }

    private void sendRawId(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JsonObject result = new JsonObject();
            result.addProperty("rawId", MoSecureUtil.getRawId());
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cableRegistration(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String rpName;
            JSONObject response = new JSONObject();
            if (this.moSettings.getCurrentLoggedInUser() != null && this.moSettings.getCurrentLoggedInUser() != "") {
                response.put("userName", this.moSettings.getCurrentLoggedInUser());
            } else {
                String username = req.getParameter("username");
                response.put("userName", username);
            }
            LOGGER.debug("Username when not logged in is :- " + this.moSettings.getCurrentLoggedInUser());
            byte[] userIdBytes = new byte[32];
            this.random.nextBytes(userIdBytes);
            response.put("userId", BaseEncoding.base64().encode(userIdBytes));
            LOGGER.debug("base URL = " + this.moSettings.getApplicationBaseUrl());
            String rpId = Iterables.get(Splitter.on("//").split(this.moSettings.getApplicationBaseUrl()), 1);
            LOGGER.debug("rpId = " + rpId);
            if (rpId.contains(":")) {
                rpId = Iterables.get(Splitter.on(':').split(rpId), 0);
                LOGGER.debug("effective rpId after removing Port = " + rpId);
            }
            if (rpId.contains("/")) {
                rpId = Iterables.get(Splitter.on('/').split(rpId), 0);
                LOGGER.debug("effective rpId after removing Path = " + rpId);
            }
            rpName = (rpName = this.getServletContext().getInitParameter("name")) == null ? "" : rpName;
            response.put("rpId", rpId);
            response.put("rpName", rpName);
            String methodUnderConsideration = req.getParameter("methodUnderConsideration");
            response.put("methodUnderConsideration", methodUnderConsideration);
            JSONObject result = new JSONObject();
            KeyPair keyPair = this.generateKeyPair();
            JSONObject cableRegistration = new JSONObject();
            JSONArray versionArray = new JSONArray();
            versionArray.put(1L);
            cableRegistration.put("versions", versionArray);
            cableRegistration.put("rpPublicKey", BaseEncoding.base64().encode(MoSecureUtil.compressECPublicKey((ECPublicKey)keyPair.getPublic())));
            LOGGER.debug("Cable Registration is :- \t" + cableRegistration.toString());
            result.put("cableRegistration", cableRegistration);
            response.put("result", result);
            this.sendSuccessResponse(response.toString(), resp);
        }
        catch (Exception e) {
            LOGGER.debug("Exception occurred in the MoSecureUtils is :- " + String.valueOf(e));
        }
    }

    private void sendSuccessResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(HttpServletResponse resp) {
        try {
            resp.setContentType("application/json");
            resp.sendError(500, "Error Occurred please check logs for more information");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private KeyPair generateKeyPair() throws Exception {
        ECGenParameterSpec spec = new ECGenParameterSpec("secp256r1");
        KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
        gen.initialize(spec);
        KeyPair keyPair = gen.generateKeyPair();
        return keyPair;
    }

    public static byte[] compressECPublicKey(ECPublicKey publicKey) {
        byte[] x = publicKey.getW().getAffineX().toByteArray();
        byte[] y = publicKey.getW().getAffineY().toByteArray();
        byte[] output = new byte[EC_PUBLIC_KEY_LENGTH];
        System.arraycopy(y, y.length - EC_COORDINATE_LENGTH, output, output.length - EC_COORDINATE_LENGTH, EC_COORDINATE_LENGTH);
        System.arraycopy(x, x.length - EC_COORDINATE_LENGTH, output, 1, EC_COORDINATE_LENGTH);
        output[0] = EC_PUBLIC_KEY_PREFIX;
        return output;
    }

    public static String getRawId() {
        return rawId;
    }

    public static void setRawId(String rawId) {
        MoSecureUtil.rawId = rawId;
    }
}

