/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.servlets;

import com.google.common.io.BaseEncoding;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import com.miniorange.twofactor.crowd.webauthn.dto.Credential;
import com.miniorange.twofactor.crowd.webauthn.utils.AttestationExtension;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAttestationResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.CableRegistrationData;
import com.miniorange.twofactor.crowd.webauthn.utils.MoHttpUtils;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredential;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredentialResponse;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;

public class MoSaveCredentials
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoSaveCredentials.class);
    private static final int FINGERPRINT = 2;
    private static final int SCREEN_LOCK = 134;
    private static final long serialVersionUID = 1L;
    private static MoSettings moSettings;

    public MoSaveCredentials(MoSettings moSettings) {
        MoSaveCredentials.moSettings = moSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String session;
        String currentUser = "";
        if (request.getParameter("username") == "") {
            LOGGER.debug("IN if conditioon in mosaveCredential");
            currentUser = moSettings.getCurrentLoggedInUser();
        } else {
            LOGGER.debug("IN else conditioon in mosaveCredential");
            currentUser = request.getParameter("username");
        }
        LOGGER.debug("CUrrentUserr in mOsaveCredential" + currentUser);
        String data = request.getParameter("data");
        LOGGER.debug("Data received is :- \t" + data);
        if (data == null) {
            data = "";
        }
        if ((session = request.getParameter("session")) == null) {
            session = "";
        }
        String credentialId = null;
        String type = null;
        String uvm = null;
        JsonElement makeCredentialResponse = null;
        try {
            HashMap<String, AttestationExtension> extensionMap;
            JsonElement typeJson;
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            LOGGER.debug("json object passed is :- " + String.valueOf(json));
            JsonElement idJson = json.get("id");
            if (idJson != null) {
                credentialId = idJson.getAsString();
            }
            if ((typeJson = json.get("type")) != null) {
                type = typeJson.getAsString();
            }
            String rawId = json.get("rawId").getAsString();
            JsonElement uvmJson = json.get("uvm");
            if (uvmJson != null && uvmJson.isJsonArray()) {
                JsonElement uvmElement;
                JsonArray uvmArray = uvmJson.getAsJsonArray();
                if (uvmJson.isJsonArray() && (uvmElement = uvmArray.get(0)) != null) {
                    switch (uvmElement.getAsJsonObject().get("userVerificationMethod").getAsInt()) {
                        case 2: {
                            uvm = "Fingerprint";
                            break;
                        }
                        case 134: {
                            uvm = "Screen Lock";
                            break;
                        }
                        default: {
                            uvm = "Others";
                        }
                    }
                }
            }
            makeCredentialResponse = json.get("response");
            AuthenticatorAttestationResponse attestation = null;
            try {
                attestation = new AuthenticatorAttestationResponse(makeCredentialResponse);
            }
            catch (Exception e) {
                LOGGER.debug("Error OCcurred :- " + String.valueOf(e));
            }
            if (attestation.getAttestationObject().getAuthenticatorData().hasExtensionData() && (extensionMap = attestation.getAttestationObject().getAuthenticatorData().getExtensionData()).containsKey("cableRegistration")) {
                CableRegistrationData cableRegistrationData = (CableRegistrationData)extensionMap.get("cableRegistration");
            }
            String credentialIdRecoded = BaseEncoding.base64Url().encode(BaseEncoding.base64Url().decode(credentialId));
            PublicKeyCredential cred = new PublicKeyCredential(credentialIdRecoded, type, BaseEncoding.base64Url().decode(credentialId), attestation);
            Credential credential = new Credential(cred);
            moSettings.setCredParam(makeCredentialResponse, credentialId, type, currentUser, rawId);
        }
        catch (IllegalStateException e) {
            LOGGER.debug("Passed data not a json object");
            throw new ServletException("Passed data not a json object");
        }
        catch (ClassCastException e) {
            LOGGER.debug("Invalid input");
            throw new ServletException("Invalid input");
        }
        catch (JsonParseException e) {
            LOGGER.debug("Input not valid json");
            throw new ServletException("Input not valid json");
        }
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        try {
            MoHttpUtils.sendPostRequest("/twofactor/inlineregistration_u2fhardwaretoken", postParameters, "application/x-www-form-urlencoded", null);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while sending post request");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("origin"), (CharSequence)"login")) {
            HttpSession httpSession = request.getSession();
            httpSession.setAttribute("validate_WebAuthn_successfully", (Object)"TRUE");
        }
        PublicKeyCredentialResponse rsp = new PublicKeyCredentialResponse(true, "Successfully created credential lets see if it changes");
        response.setContentType("application/json");
        response.getWriter().println(rsp.toJson());
    }

    private void sendSuccessResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }
}

