/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoValidateOtpAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoValidateOtpAction.class);
    private static final String VALIDATEOTP_VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_otp.vm";
    private final TemplateRenderer renderer;
    private String otpToken;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoValidateOtpAction(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoValidateOtpAction doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        List<String> enabled2faMethods = this.settings.get2FAMethodForUserList();
        List<String> enabledBackupMethods = this.settings.getBackupMethodForUserList();
        if (!enabled2faMethods.contains("GoogleAuthenticator") && !enabledBackupMethods.contains("GoogleAuthenticator")) {
            String redirectToAnotherMethodUrl = this.pluginHandler.findValidUrlToRedirect(username, request);
            LOGGER.debug("Redirecting to another enabled and configured method = " + redirectToAnotherMethodUrl);
            response.sendRedirect(redirectToAnotherMethodUrl);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("GoogleAuthenticator", username).booleanValue() && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_Otp").booleanValue()) {
            LOGGER.debug("Valid User");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", new ArrayList());
            context.put("shouldShowLinkToBackupMethod", this.settings.getEnableTwoFactor() != false && this.settings.getEnableBackupMethod() != false && twoFactorCommonUserSettings.getConfigured2FAMethodsByUser().contains("SecurityQuestion"));
            context.put("validateBackupMethodUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_securityquestion"));
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            LOGGER.debug("Enable remember me device : " + BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()));
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            Boolean allowUserSpecificRememberMeDeviceDuration = BooleanUtils.toBoolean((Boolean)this.settings.getAllowUserSpecificRememberMeDeviceDuration()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("allowUserSpecificRememberMeDeviceDuration", allowUserSpecificRememberMeDeviceDuration);
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            int userSpecificRememberMeDeviceDuration = twoFactorUserClass.getUserSpecificRememberMeDeviceDuration();
            if (userSpecificRememberMeDeviceDuration == NumberUtils.INTEGER_ZERO) {
                context.put("userSpecificRememberMeDeviceDuration", this.settings.getRememberMeDeviceDuration());
            } else {
                context.put("userSpecificRememberMeDeviceDuration", userSpecificRememberMeDeviceDuration);
            }
            List<String> configuredMethodList = twoFactorCommonUserSettings.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("GoogleAuthenticator"));
            int enabledAndConfiguredPrimaryAndBackupMethods = 0;
            for (String configuredMethod : configuredMethodList) {
                if ((!this.pluginHandler.isPageAllowed(configuredMethod, username).booleanValue() || !enabled2faMethods.contains(configuredMethod)) && !enabledBackupMethods.contains(configuredMethod)) continue;
                ++enabledAndConfiguredPrimaryAndBackupMethods;
            }
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (enabledAndConfiguredPrimaryAndBackupMethods >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateGoogleAuthenticatorTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATEOTP_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoValidateOtpAction doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("GoogleAuthenticator", username).booleanValue()) {
            LOGGER.debug("User is valid user");
            ArrayList<String> errorMessage = new ArrayList<String>();
            String otp = StringUtils.trimToEmpty((String)request.getParameter("validate_otp"));
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                Long otp_cast = Long.parseLong(otp);
                String encryptedSecret = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getTotpSecret(), (CharSequence)"");
                String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                String decryptedString = MoTwoFactorUtility.decryptString(encryptedSecret, this.settings.getEncryptionKey());
                LOGGER.debug("Decrypted String " + decryptedString);
                String user_secret = decryptedString.replaceAll(userSalt, "");
                MoTwoFactorUtility moTwoFactorUtility = new MoTwoFactorUtility();
                Long time = moTwoFactorUtility.get_interval_time();
                Boolean is_otp_valid = false;
                try {
                    is_otp_valid = moTwoFactorUtility.code_verification(user_secret, otp_cast, time);
                    LOGGER.debug("Is valid OTP " + is_otp_valid);
                }
                catch (Exception e) {
                    LOGGER.error("Error " + String.valueOf(e));
                }
                if (is_otp_valid.booleanValue()) {
                    Boolean rememberMeOnThisDevice = Boolean.parseBoolean(request.getParameter("rememberMeOnThisDevice"));
                    this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Successful", "Mobile Authenticator");
                    LOGGER.debug("rememberMeOnThisDevice : " + rememberMeOnThisDevice);
                    if (BooleanUtils.toBoolean((Boolean)rememberMeOnThisDevice)) {
                        String deviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
                        LOGGER.debug("Current Device Details : " + deviceDetails);
                        List<String> rememberMeDeviceDetails = twoFactorUserClass.getRememberMeDeviceDetails();
                        if (StringUtils.isNotBlank((CharSequence)deviceDetails)) {
                            LOGGER.debug("Device details is not a blank");
                            LOGGER.debug("Stored Device Details : " + String.valueOf(rememberMeDeviceDetails));
                            int rememberDeviceDuration = this.settings.getRememberMeDeviceDuration();
                            Calendar calendar = Calendar.getInstance();
                            if (this.settings.getAllowUserSpecificRememberMeDeviceDuration().booleanValue()) {
                                LOGGER.debug("Inside AllowUserSpecificRememberMeDeviceDuration");
                                String userSpecificRememberMeDeviceDurationString = request.getParameter("userSpecificRememberMeDeviceDuration");
                                LOGGER.debug("userSpecificRememberMeDeviceDurationString" + userSpecificRememberMeDeviceDurationString);
                                if (StringUtils.isNotBlank((CharSequence)userSpecificRememberMeDeviceDurationString)) {
                                    try {
                                        int userSpecificRememberMeDeviceDuration = Integer.parseInt(userSpecificRememberMeDeviceDurationString);
                                        calendar.add(5, userSpecificRememberMeDeviceDuration);
                                        twoFactorUserClass.setUserSpecificRememberMeDeviceDuration(userSpecificRememberMeDeviceDuration);
                                    }
                                    catch (NumberFormatException e) {
                                        calendar.add(5, rememberDeviceDuration);
                                    }
                                } else {
                                    calendar.add(5, rememberDeviceDuration);
                                }
                            } else {
                                calendar.add(5, rememberDeviceDuration);
                            }
                            Date date = calendar.getTime();
                            long newTimeInMili = date.getTime();
                            Boolean containsDeviceInList = Boolean.FALSE;
                            for (int i = 0; i < rememberMeDeviceDetails.size(); ++i) {
                                String device = rememberMeDeviceDetails.get(i);
                                if (!StringUtils.containsIgnoreCase((CharSequence)device, (CharSequence)deviceDetails)) continue;
                                LOGGER.debug("Changing device details time : " + newTimeInMili);
                                containsDeviceInList = Boolean.TRUE;
                                rememberMeDeviceDetails.add(i, deviceDetails.concat("=====" + newTimeInMili));
                                break;
                            }
                            if (!BooleanUtils.toBoolean((Boolean)containsDeviceInList)) {
                                if (deviceDetails.split("\\|\\|").length > 2) {
                                    LOGGER.debug("Adding device details with time : " + newTimeInMili);
                                    rememberMeDeviceDetails.add(deviceDetails.concat("=====" + newTimeInMili));
                                } else {
                                    LOGGER.debug("Invalid Device Details : " + deviceDetails);
                                }
                            }
                            twoFactorUserClass.setRememberMeDeviceDetails(rememberMeDeviceDetails);
                            LOGGER.debug("After change Device Details : " + String.valueOf(rememberMeDeviceDetails));
                            this.settings.setUserSettings(username, twoFactorUserClass);
                        }
                    }
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    session.removeAttribute("executing_2fa_flow");
                    this.settings.addTo2FAConfiguredUsersList(username);
                    this.pluginHandler.redirectToValidUrl(request, response);
                    return;
                }
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "Mobile Authenticator");
                if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                    LOGGER.debug("User has exceeded number of invalid attempts");
                    this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "Mobile Authenticator");
                    this.pluginHandler.performBruteForceUserLockAction(username, request);
                    this.pluginHandler.performUserLogout(request, response, username);
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                    return;
                }
                errorMessage.add("Invalid OTP. Please add valid one.");
                LOGGER.debug("Invalid OTP. Please add valid one.");
                Integer loginAttemptsLeft = this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username);
                if (loginAttemptsLeft == 2) {
                    LOGGER.debug("Only a last 2 login attempts left");
                    errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
                } else if (loginAttemptsLeft == 1) {
                    LOGGER.debug("Last login attempt");
                    errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
                }
            } else {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "Mobile Authenticator");
                if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                    LOGGER.debug("User has exceeded number of invalid attempts");
                    this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "Mobile Authenticator");
                    this.pluginHandler.performBruteForceUserLockAction(username, request);
                    this.pluginHandler.performUserLogout(request, response, username);
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                    return;
                }
                errorMessage.add("Invalid OTP. Please add valid one.");
                LOGGER.debug("Invalid OTP. Please add valid one.");
                Integer loginAttemptsLeft = this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username);
                if (loginAttemptsLeft == 2) {
                    LOGGER.debug("Only a last 2 login attempts left");
                    errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
                } else if (loginAttemptsLeft == 1) {
                    LOGGER.debug("Last login attempt");
                    errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
                }
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            Boolean allowUserSpecificRememberMeDeviceDuration = BooleanUtils.toBoolean((Boolean)this.settings.getAllowUserSpecificRememberMeDeviceDuration()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("allowUserSpecificRememberMeDeviceDuration", allowUserSpecificRememberMeDeviceDuration);
            int userSpecificRememberMeDeviceDuration = twoFactorUserClass.getUserSpecificRememberMeDeviceDuration();
            if (userSpecificRememberMeDeviceDuration == NumberUtils.INTEGER_ZERO) {
                context.put("userSpecificRememberMeDeviceDuration", this.settings.getRememberMeDeviceDuration());
            } else {
                context.put("userSpecificRememberMeDeviceDuration", userSpecificRememberMeDeviceDuration);
            }
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("GoogleAuthenticator"));
            int enabledAndConfiguredPrimaryAndBackupMethods = 0;
            List<String> enabled2faMethods = this.settings.get2FAMethodForUserList();
            List<String> enabledBackupMethods = this.settings.getBackupMethodForUserList();
            for (String configuredMethod : configuredMethodList) {
                if ((!this.pluginHandler.isPageAllowed(configuredMethod, username).booleanValue() || !enabled2faMethods.contains(configuredMethod)) && !enabledBackupMethods.contains(configuredMethod)) continue;
                ++enabledAndConfiguredPrimaryAndBackupMethods;
            }
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (enabledAndConfiguredPrimaryAndBackupMethods >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateGoogleAuthenticatorTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VALIDATEOTP_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    private Boolean isInternetExplorer(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"MSIE") > 0 || StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"Trident/") > 0) {
            LOGGER.debug("Browser is IE");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getOtpToken() {
        return this.otpToken;
    }

    public void setOtpToken(String otpToken) {
        this.otpToken = otpToken;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

