/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUnlockedAccount
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUnlockedAccount.class);
    private MoTwoFactorCommonPluginSettings settings;
    private UserManager userManager;
    private PermissionManager permissionManager;

    public MoTwoFactorUnlockedAccount(MoTwoFactorCommonPluginSettings settings, UserManager userManager, PermissionManager permissionManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("doPost called from MoTwoFactorUnlockedAccount");
        Enumeration headerNames = request.getHeaderNames();
        String key = "";
        String value = "";
        String username = "";
        Boolean isAdmin = Boolean.FALSE;
        while (headerNames.hasMoreElements()) {
            key = (String)headerNames.nextElement();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"Authorization", (CharSequence)key)) continue;
            value = request.getHeader(key);
            value = value.split(" ")[1];
            byte[] valueDecoded = Base64.getDecoder().decode(value);
            value = new String(valueDecoded);
            String[] arr = value.split(":");
            username = arr[0];
            String pwd = arr[1];
            UserProfile crowdUser = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username}) || StringUtils.isNotEmpty((CharSequence)username)) {
                crowdUser = this.userManager.getUserProfile(username);
            }
            if (crowdUser == null) break;
            LOGGER.debug("User exist with username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.userManager.authenticate(this.userManager.getUserProfile(username).getUsername(), pwd))) {
                isAdmin = this.userManager.isAdmin(username) || this.userManager.isSystemAdmin(username);
                break;
            }
            LOGGER.debug("Invalid Username & Password");
            isAdmin = Boolean.FALSE;
            break;
        }
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            Map<String, String> lockedUser = this.settings.getLockedUserDetails();
            lockedUser.remove(username);
            this.settings.setLockedUserDetails(lockedUser);
            LOGGER.info("Unlock the user");
            JSONObject json = new JSONObject();
            try {
                json.put("success", "Successfully Unlock User");
                response.setContentType("application/json");
                response.getOutputStream().write(json.toString().getBytes());
                response.getOutputStream().close();
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while Unlocking user.");
            }
        } else {
            LOGGER.error("User is not an admin user so unable to unlock the user");
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

