/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorTemporaryUserLocked
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorTemporaryUserLocked.class);
    private static final String USERLOCKED_VM_PATH = "/templates/com/miniorange/twofactor/crowd/userlocked_showinfo.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorTemporaryUserLocked(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorTemporaryUserLocked doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        HashMap<String, String> context = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            if (lockedUserDetails.containsKey(username)) {
                this.pluginHandler.performUserLogout(request, response, username);
            } else {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
                return;
            }
        }
        String expiryTime = "";
        if (StringUtils.isNotBlank((CharSequence)username)) {
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            LOGGER.debug("lockedUserDetails : " + String.valueOf(lockedUserDetails));
            String fieldValue = lockedUserDetails.get(username);
            LOGGER.debug("fieldValue : " + fieldValue);
            long storedTime = Long.parseLong(fieldValue.split("=====")[0]);
            Instant instant = Instant.ofEpochMilli(storedTime);
            LocalDateTime date = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
            expiryTime = date.toString();
        }
        context.put("expiryTime", expiryTime);
        context.put("username", username);
        String template = this.pluginSettings.getLockedUserTemplate();
        if (StringUtils.isNotBlank((CharSequence)template)) {
            String result = this.renderer.renderFragment(template, context);
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(result);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render(USERLOCKED_VM_PATH, context, (Writer)response.getWriter());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

