/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorRedirecttoAdminPages
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorRedirecttoAdminPages.class);
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public MoTwoFactorRedirecttoAdminPages(MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("doGet called in MoTwoFactorRedirecttoAdminPages...");
        List<String> pages = this.pluginHandler.getUserAccessiblePages();
        if (!pages.isEmpty()) {
            String page = pages.get(0);
            String url = this.pluginConfiguration.getBaseUrl();
            if (page.contains("Audit_Logs")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/auditlogs"));
            } else if (page.contains("IP_Restriction")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/adaptiveauthentication"));
            } else if (page.contains("Basic_Configuration")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/configure"));
            } else if (page.contains("Advanced_Settings")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/advancedsettings"));
            } else if (page.contains("User_Management")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/userdetails"));
            } else if (page.contains("LookAndFeel")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/lookandfeeltemplates"));
            } else if (page.contains("TroubleShooting")) {
                response.sendRedirect(url.concat("/plugins/servlet/twofactor/troubleshooting"));
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("doPost called in MoTwoFactorRedirecttoAdminPages...");
    }
}

