/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorLogoutUserAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLogoutUserAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorUtility moTwoFactorUtility;

    public MoTwoFactorLogoutUserAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorUtility moTwoFactorUtility) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.moTwoFactorUtility = moTwoFactorUtility;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoTwoFactorLogoutUserAction doGet() called...");
        this.handle2FALogout(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoTwoFactorLogoutUserAction doPost() called...");
        this.handle2FALogout(request, response);
    }

    private void handle2FALogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Handling User Logout");
        HttpSession session = request.getSession();
        if (StringUtils.isNotBlank((CharSequence)this.settings.getBypass2FACookieDomain())) {
            MoTwoFactorUtility.clearCookieWithDomain(request, response, "MO2FA_byPass2FA", this.settings.getBypass2FACookieDomain());
        } else {
            MoTwoFactorUtility.clearCookie(request, response, "MO2FA_byPass2FA");
        }
        session.invalidate();
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

