/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationWebAuthnAs2faMethod
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationWebAuthnAs2faMethod.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_webauthnas2famethod.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationWebAuthnAs2faMethod(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationWebAuthnAs2faMethod doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("WebAuthn", username).booleanValue() && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_WebAuthnAs2faMethod").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", new ArrayList());
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("attestationType", this.settings.getAttestationType());
            context.put("authenticatorType", this.settings.getAuthenticatorType());
            context.put("userVerification", this.settings.getUserVerification());
            context.put("residentKey", this.settings.getResidentKey());
            String template = this.pluginSettings.getConfigureWebAuthnAs2faMethodTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                resp.setContentType("text/html;charset=utf-8");
                resp.getWriter().write(result);
                return;
            }
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)resp.getWriter());
            return;
        }
        resp.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationWebAuthnAs2faMethod doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        ArrayList<String> errorMessage = new ArrayList<String>();
        HttpSession httpSessionssion = req.getSession();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("WebAuthn", username).booleanValue()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)((String)httpSessionssion.getAttribute("validate_WebAuthn_successfully")), (CharSequence)"TRUE")) {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Successful", "Web Authentication");
                LOGGER.debug("WebAuthn is configured as 2FA Successfully");
                twoFactorUserClass.setConfigured2FAMethodsByUser("WebAuthn");
                List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
                HttpSession session = req.getSession();
                List<String> enabledMethodList = this.settings.get2FAMethodForUserList();
                if (session.getAttribute("considering_backup_method") != null || StringUtils.isNotBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod()) && enabledMethodList.contains(twoFactorUserClass.getCurrent2FAMethod())) {
                    LOGGER.debug("Configured webauthn as a Backup Method");
                    session.removeAttribute("considering_backup_method");
                } else if (enabledBackupMethodList.size() != 0) {
                    LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                    twoFactorUserClass.setCurrent2FAMethod("WebAuthn");
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(req, twoFactorUserClass.getConfigured2FAMethodsByUser(), username);
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        resp.sendRedirect(url);
                        return;
                    }
                } else {
                    LOGGER.debug("Setting up wenauthn primary method");
                    twoFactorUserClass.setCurrent2FAMethod("WebAuthn");
                }
                LOGGER.debug("2FA is Configured successfully");
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                    session.setAttribute("2fa_show_remaining_methods", (Object)true);
                }
                session.removeAttribute("validate_WebAuthn_successfully");
                this.settings.addTo2FAConfiguredUsersList(username);
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.pluginHandler.redirectToValidUrl(req, resp);
                return;
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "2FA Configuration Failed", "Web Authentication");
            LOGGER.debug("WebAuthn is Not valid");
            errorMessage.add("WebAuthn is Not valid. Please enter valid system credentials.");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("attestationType", this.settings.getAttestationType());
            context.put("authenticatorType", this.settings.getAuthenticatorType());
            context.put("userVerification", this.settings.getUserVerification());
            context.put("residentKey", this.settings.getResidentKey());
            String template = this.pluginSettings.getConfigureWebAuthnAs2faMethodTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                resp.setContentType("text/html;charset=utf-8");
                resp.getWriter().write(result);
                return;
            }
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)resp.getWriter());
            return;
        }
        resp.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

