/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import com.miniorange.twofactor.crowd.webauthn.dto.Credential;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAssertionResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredential;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredentialResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.Server;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinishAssertion
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(FinishAssertion.class);
    private static final int FINGERPRINT = 2;
    private static final int SCREEN_LOCK = 134;
    private static final long serialVersionUID = 1L;
    private MoSettings moSettings;
    private I18nResolver i18nResolver;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public FinishAssertion(MoSettings moSettings, I18nResolver i18nResolver, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.moSettings = moSettings;
        this.i18nResolver = i18nResolver;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String session;
        String currentUser = this.pluginConfiguration.getCurrentLoggedInUser();
        LOGGER.debug("\n\n\nCurrent user in FinishGetAssertion is :- " + currentUser + "\n\n");
        String data = request.getParameter("data");
        if (data == null) {
            data = "";
        }
        if ((session = request.getParameter("session")) == null) {
            session = "";
        }
        String credentialId = null;
        String type = null;
        String uvm = null;
        JsonElement assertionJson = null;
        String rawId = null;
        try {
            JsonElement uvmJson;
            JsonElement typeJson;
            JsonElement idJson;
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            JsonElement rawIdJson = json.get("rawId");
            if (rawIdJson != null) {
                rawId = rawIdJson.getAsString();
            }
            if ((idJson = json.get("id")) != null) {
                credentialId = idJson.getAsString();
            }
            if ((typeJson = json.get("type")) != null) {
                type = typeJson.getAsString();
            }
            if ((uvmJson = json.get("uvm")) != null && uvmJson.isJsonArray()) {
                JsonElement uvmElement;
                JsonArray uvmArray = uvmJson.getAsJsonArray();
                if (uvmJson.isJsonArray() && (uvmElement = uvmArray.get(0)) != null) {
                    switch (uvmElement.getAsJsonObject().get("userVerificationMethod").getAsInt()) {
                        case 2: {
                            uvm = "Fingerprint";
                            break;
                        }
                        case 134: {
                            uvm = "Screen Lock";
                            break;
                        }
                        default: {
                            uvm = "Others";
                        }
                    }
                }
            }
            if ((assertionJson = json.get("response")) == null) {
                throw new ServletException("Missing element 'response'");
            }
        }
        catch (IllegalStateException e) {
            throw new ServletException("Passed data not a json object");
        }
        catch (ClassCastException e) {
            throw new ServletException("Invalid input");
        }
        catch (JsonParseException e) {
            throw new ServletException("Input not valid json");
        }
        AuthenticatorAssertionResponse assertion = null;
        try {
            assertion = new AuthenticatorAssertionResponse(assertionJson);
        }
        catch (Exception e) {
            throw new ServletException(e.toString());
        }
        String credentialIdRecoded = Base64.getUrlEncoder().encodeToString(Base64.getUrlDecoder().decode(credentialId));
        PublicKeyCredential cred = new PublicKeyCredential(credentialIdRecoded, type, Base64.getUrlDecoder().decode(credentialId), assertion);
        Credential savedCredential = null;
        try {
            LOGGER.debug("\n\n\nCurrent USer is :- " + currentUser + "\n\n");
            String credKey = currentUser + ";miniOrange;" + rawId;
            savedCredential = this.moSettings.getUserCred(credKey);
        }
        catch (Exception e) {
            LOGGER.debug("\n\n\nEmpty Servlet Exception found " + String.valueOf(e));
        }
        LOGGER.debug("SavedCredential12344 :- " + String.valueOf(savedCredential) + "\n\n\n");
        Server.verifyAssertion(cred, currentUser, session, savedCredential);
        String handle = DatatypeConverter.printHexBinary(savedCredential.getCredential().rawId);
        PublicKeyCredentialResponse rsp = new PublicKeyCredentialResponse(true, "Successful assertion", handle);
        LOGGER.debug("\n\n\nHere inside the finish get Assertion :- " + handle + "\n\n" + this.i18nResolver.getText("my.plugin.platform") + "\n\ncurrent User :- " + currentUser + "\n\n");
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute("validate_WebAuthn_successfully", (Object)"TRUE");
        response.setContentType("application/json");
        response.getWriter().println(rsp.toJson());
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.debug("Redirecting user to " + redirectUrl);
        StringBuffer htmlStart = new StringBuffer("<html><head><script>window.location.href=\"" + redirectUrl + "\"</script></head><body>Please wait...</body></html>");
        response.setContentType("text/html");
        response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
        response.sendRedirect(redirectUrl);
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

