/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.scheduler.AuditLogSchedulerTask;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditLogScheduler
implements LifecycleAware {
    private static final Log LOGGER = LogFactory.getLog(AuditLogScheduler.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private PluginScheduler pluginScheduler;
    private MoLogEntityService logEntityService;
    public static final String KEY = AuditLogSchedulerTask.class.getName() + ":instance";
    private static final String JOB_NAME = AuditLogSchedulerTask.class.getName() + ":job";

    public AuditLogScheduler(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, PluginScheduler pluginScheduler, MoLogEntityService moAuditService) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginScheduler = pluginScheduler;
        this.logEntityService = moAuditService;
    }

    public void schedule() {
        LOGGER.info("Scheduling job");
        try {
            String jobName = JOB_NAME;
            long refreshTimeInMilliSeconds = 86400000L;
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2);
            int dayOfMonth = cal.get(5);
            int hour = cal.get(11);
            int minutes = cal.get(12);
            String customSchedulerTime = this.settings.getCustomSchedulerTime();
            if (StringUtils.isNotBlank((CharSequence)customSchedulerTime)) {
                hour = Integer.parseInt(customSchedulerTime.substring(0, 2));
                minutes = Integer.parseInt(customSchedulerTime.substring(3, 5));
                LOGGER.debug("hour :" + hour);
                LOGGER.debug("minutes :" + minutes);
            } else {
                int currentHour = cal.get(11);
                int currentMinutes = cal.get(12);
                Object currentTime = "";
                currentTime = currentMinutes < 10 ? currentHour + ":0" + currentMinutes : currentHour + ":" + currentMinutes;
                LOGGER.debug("currentTime :" + (String)currentTime);
                this.settings.setCustomSchedulerTime((String)currentTime);
            }
            GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, hour, minutes);
            if (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
                LOGGER.debug("custom time < current time");
                ((Calendar)calendarCustom).add(5, 1);
            }
            this.pluginScheduler.scheduleJob(jobName, AuditLogSchedulerTask.class, (Map)new HashMap<String, Object>(){
                {
                    this.put(KEY, AuditLogScheduler.this);
                }
            }, calendarCustom.getTime(), refreshTimeInMilliSeconds);
            if (!this.settings.getAutoDeleteAuditLogs()) {
                LOGGER.debug("Auto delete audit logs is disabled. Stopping the scheduler");
                this.pluginScheduler.unscheduleJob(jobName);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job.", e);
        }
    }

    public void unschedule() {
        try {
            LOGGER.info("Un-scheduling job");
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while Un-scheduling job." + e.getMessage());
        }
    }

    public void onStart() {
        try {
            if (this.settings.getAutoDeleteAuditLogs()) {
                this.schedule();
                return;
            }
            this.unschedule();
        }
        catch (Exception e) {
            LOGGER.error("Error " + String.valueOf(e));
        }
    }

    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t2) {
            LOGGER.error("No job exist. Can't un-schedule.");
        }
        catch (Throwable t3) {
            LOGGER.error("An Error occurred while un-scheduling job" + t3.getMessage());
        }
    }

    public Boolean deleteAuditLogs() throws ParseException {
        List<String> logsAfterDeletion = this.pluginHandler.autoDeleteAuditLogs(this.settings.getAuditLogs(), this.settings.getDaysForAutoDeleteLogs());
        this.settings.setAuditLogs(logsAfterDeletion);
        int size = this.logEntityService.all().size();
        this.logEntityService.delete(this.settings.getDaysForAutoDeleteLogs());
        if (size > this.settings.getNumberOfLogsToBeRetained()) {
            this.logEntityService.deleteExcessLogs(this.logEntityService.all().size() - this.settings.getNumberOfLogsToBeRetained());
        }
        StringBuilder builder = new StringBuilder();
        LOGGER.debug("Number of logs deleted :" + (size - this.logEntityService.all().size()));
        builder.append("Number of logs deleted :" + (size - this.logEntityService.all().size()) + " ////");
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        long daysForAutoDeleteLogsInLong = this.settings.getDaysForAutoDeleteLogs().intValue();
        long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
        long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
        Date date = new Date(timeInPast);
        builder.append("logs deleted from dates before:" + String.valueOf(date) + " ////");
        this.pluginHandler.storeAdminsAuditLogs("Audit Logs", "Auto Delete Audit logs initiated", builder.toString(), null);
        LOGGER.debug("Successfully deleted logs!");
        return true;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoLogEntityService getLogEntityService() {
        return this.logEntityService;
    }

    public void setLogEntityService(MoLogEntityService logEntityService) {
        this.logEntityService = logEntityService;
    }
}

