/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.eventlistener;

import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUserEvent {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUserEvent.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;

    public MoTwoFactorUserEvent(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent userCreatedEvent) {
        LOGGER.debug("User Created : " + userCreatedEvent.getUser().getName());
        String username = userCreatedEvent.getUser().getName();
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnable2FAForAllUsers())) {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                enable2FAForUsersList.add(username);
            }
            this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
        } else {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                List<String> disable2FAForUsersList;
                String dirOfUser;
                List<String> enable2FAForDirectoryList = this.settings.getEnable2FAForDirectoriesList();
                if (enable2FAForDirectoryList.contains(dirOfUser = userCreatedEvent.getDirectory().getName())) {
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    LOGGER.debug("User added to enable list based on directory: " + dirOfUser);
                }
                if (!enable2FAForUsersList.contains(username) && !(disable2FAForUsersList = this.settings.getDisable2FAForUsersList()).contains(username)) {
                    LOGGER.debug("User added to disable list.");
                    disable2FAForUsersList.add(username);
                    this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
                }
            }
        }
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent groupCreatedEvent) {
        LOGGER.debug("Group Created : " + groupCreatedEvent.getGroup().getName());
        String groupName = groupCreatedEvent.getGroup().getName();
        String dirOfGroup = groupCreatedEvent.getDirectory().getName();
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        List<String> enable2FAForDirectoryList = this.settings.getEnable2FAForDirectoriesList();
        if (dirOfGroup != null && enable2FAForDirectoryList.contains(dirOfGroup)) {
            enable2FAForGroupsList.add(groupName);
            this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
            LOGGER.debug("Group added to enable list based on directory: " + dirOfGroup);
        }
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent groupMembershipCreatedEvent) {
        LOGGER.debug("Group Membership Created : " + groupMembershipCreatedEvent.getEntityName());
        String username = groupMembershipCreatedEvent.getEntityName();
        String groupName = groupMembershipCreatedEvent.getGroupName();
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        if (!this.settings.getEnable2FAForUsersList().contains(username) && enable2FAForGroupsList.contains(groupName)) {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                enable2FAForUsersList.add(username);
            }
            this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent groupMembershipDeletedEvent) {
        LOGGER.debug("Group Membership Deleted : " + groupMembershipDeletedEvent.getEntityName());
        String username = groupMembershipDeletedEvent.getEntityName();
        String groupName = groupMembershipDeletedEvent.getGroupName();
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        List<String> enable2FAUsersList = this.settings.getEnable2FAForUsersList();
        List<String> disable2FAUsersList = this.settings.getDisable2FAForUsersList();
        if (enable2FAUsersList.contains(username) && enable2FAForGroupsList.contains(groupName)) {
            List<String> usersGroups = this.pluginConfiguration.getUsersGroup(username);
            Boolean shouldEnable = Boolean.FALSE;
            for (String group : usersGroups) {
                if (!enable2FAForGroupsList.contains(group) || StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)group)) continue;
                shouldEnable = Boolean.TRUE;
                break;
            }
            if (!BooleanUtils.toBoolean((Boolean)shouldEnable)) {
                LOGGER.debug("Removing user from Enabled list");
                enable2FAUsersList.removeAll(Collections.singleton(username));
                this.settings.setEnable2FAForUsersList(enable2FAUsersList);
                disable2FAUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAUsersList);
            } else {
                LOGGER.debug("User is part of other group for which 2FA is enabled");
            }
        }
    }

    @EventListener
    public void onUserDelete(UsersDeletedEvent usersDeletedEvent) {
        LOGGER.debug("Deleted Users : " + String.valueOf(usersDeletedEvent.getDirectory()));
        String username = usersDeletedEvent.getUsernames().toString();
        this.settings.deleteUserAction(username);
        Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
        configuredMobileNumbers.remove(username);
        this.settings.setConfiguredMobileNumbers(configuredMobileNumbers);
    }

    @EventListener
    public void onGroupDelete(GroupDeletedEvent groupDeletedEvent) {
        String groupName = groupDeletedEvent.getGroupName();
        LOGGER.debug("Deleting Group : " + groupName);
        this.settings.deleteGroupAction(groupName);
    }

    @EventListener
    public void onUserRename(UserRenamedEvent userRenamedEvent) {
        Map<String, String> lockedUserDetails;
        LOGGER.debug("UserRenamedEvent called");
        String oldUsername = userRenamedEvent.getOldUsername();
        String newUsername = userRenamedEvent.getUser().getName();
        MoTwoFactorCommonUserSettings oldUserTwoFactorSettings = this.settings.getUserSettings(oldUsername);
        this.settings.setUserSettings(newUsername, oldUserTwoFactorSettings);
        this.settings.removeUserSettings(oldUsername);
        List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
        if (enable2FAForUsersList.contains(oldUsername)) {
            enable2FAForUsersList.remove(oldUsername);
            if (!enable2FAForUsersList.contains(newUsername)) {
                enable2FAForUsersList.add(newUsername);
            }
            this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
        } else {
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            disable2FAForUsersList.remove(oldUsername);
            if (!disable2FAForUsersList.contains(newUsername)) {
                disable2FAForUsersList.add(newUsername);
            }
            this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
        }
        List<String> configuredUsers = this.settings.getListOf2FAConfiguredUsers();
        if (configuredUsers.contains(oldUsername)) {
            configuredUsers.remove(oldUsername);
            if (!configuredUsers.contains(newUsername)) {
                configuredUsers.add(newUsername);
            }
            this.settings.setListOf2FAConfiguredUsers(configuredUsers);
        }
        if ((lockedUserDetails = this.settings.getLockedUserDetails()).containsKey(oldUsername)) {
            String userDetails = lockedUserDetails.get(oldUsername);
            lockedUserDetails.remove(oldUsername);
            if (!lockedUserDetails.containsKey(newUsername)) {
                lockedUserDetails.put(newUsername, userDetails);
            }
            this.settings.setLockedUserDetails(lockedUserDetails);
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

