/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.common;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorCommonPluginSettings {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorCommonPluginSettings.class);
    private PluginSettings pluginSettings;
    private PluginSettingsFactory pluginSettingsFactory;

    public MoTwoFactorCommonPluginSettings(PluginSettingsFactory pluginSettingsFactory, PluginSettings pluginSettings) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getSecret() {
        return "80000";
    }

    public Boolean getEnableTwoFactor() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR"))), (boolean)false);
    }

    public void setEnableTwoFactor(Boolean enableTwoFactor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR", (Object)BooleanUtils.toString((Boolean)enableTwoFactor, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRedirectionBasedOnAbsoluteUrl() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BASE_URL_TYPE"))), (boolean)false);
    }

    public void setRedirectionBasedOnAbsoluteUrl(Boolean redirectionBasedOnAbsoluteUrl) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BASE_URL_TYPE", (Object)BooleanUtils.toString((Boolean)redirectionBasedOnAbsoluteUrl, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableTwoFactorForSoftware() {
        Object enableTwoFactorForSoftware = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE");
        if (enableTwoFactorForSoftware == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)enableTwoFactorForSoftware));
    }

    public void setEnableTwoFactorForSoftware(Boolean enableTwoFactorSoftware) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE", (Object)BooleanUtils.toString((Boolean)enableTwoFactorSoftware, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableTwoFactorForJsd() {
        Object enableTwoFactorForJSD = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_JSD");
        if (enableTwoFactorForJSD == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)enableTwoFactorForJSD));
    }

    public void setEnableTwoFactorForJsd(Boolean enableTwoFactorJsd) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_JSD", (Object)BooleanUtils.toString((Boolean)enableTwoFactorJsd, (String)"true", (String)"false", (String)"false"));
    }

    public void setConfiguredMobileNumbersMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getConfiguredMobileNumbersMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS_MIGRATED"))), (boolean)false);
    }

    public Map<String, String> getConfiguredMobileNumbers() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS");
        }
        return new HashMap<String, String>();
    }

    public void setConfiguredMobileNumbers(Map<String, String> configuredMobileNumbers) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS", configuredMobileNumbers);
    }

    public Boolean getSendEmailAfterReset2fa() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA"))), (boolean)false);
    }

    public void setSendEmailAfterReset2fa(Boolean sendEmailAfterReset2fa) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA", (Object)BooleanUtils.toString((Boolean)sendEmailAfterReset2fa, (String)"true", (String)"false", (String)"false"));
    }

    public String getReset2faEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE_RESET_2FA")), (CharSequence)"We want to inform you that your Two-Factor Authentication (2FA) settings have been reset by our system administrator.\n\nTo continue accessing service, please configure your second factor again.");
    }

    public void setReset2faEmailTemplate(String reset2faEmailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE_RESET_2FA", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)reset2faEmailTemplate, (CharSequence)"We want to inform you that your Two-Factor Authentication (2FA) settings have been reset by our system administrator.\n\nTo continue accessing service, please configure your second factor again."))));
    }

    public Boolean getHighlightSendEmailAfterReset2faInfo() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA_INFO"))), (boolean)false);
    }

    public void setHighlightSendEmailAfterReset2faInfo(Boolean sendEmailAfterReset2faInfo) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA_INFO", (Object)BooleanUtils.toString((Boolean)sendEmailAfterReset2faInfo, (String)"true", (String)"false", (String)"false"));
    }

    public String getUserManagementSelectedAction() {
        String userManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION")), (CharSequence)"UserAction");
        userManagementSelectedAction = userManagementSelectedAction.replaceAll(" ", "");
        return userManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String userManagementSelectedAction) {
        userManagementSelectedAction = userManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)userManagementSelectedAction, (CharSequence)"UserAction"))));
    }

    public String getAuditLogsSelectedAction() {
        String auditLogsSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUDIT_MANAGEMENT_SELECTED_ACTION")), (CharSequence)"EndUserAuditLogAction");
        auditLogsSelectedAction = auditLogsSelectedAction.replaceAll(" ", "");
        return auditLogsSelectedAction;
    }

    public void setAuditLogsSelectedAction(String auditLogsSelectedAction) {
        auditLogsSelectedAction = auditLogsSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_AUDIT_MANAGEMENT_SELECTED_ACTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)auditLogsSelectedAction, (CharSequence)"EndUserAuditLogAction"))));
    }

    public List<String> getAuditLogs() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_AUDIT_LOGS") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUDIT_LOGS");
        }
        return new ArrayList<String>();
    }

    public void setAuditLogs(List<String> auditLogList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_AUDIT_LOGS", auditLogList);
    }

    public Boolean getEnableBackupMethod() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD"))), (boolean)false);
    }

    public void setEnableBackupMethod(Boolean enableBackupMethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD", (Object)BooleanUtils.toString((Boolean)enableBackupMethod, (String)"true", (String)"false", (String)"false"));
    }

    public String getAppLabel(String defaultValue) {
        String appLabel = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_APP_LABEL")), (CharSequence)defaultValue);
        appLabel = appLabel.replaceAll(" ", "");
        return appLabel;
    }

    public void setAppLabel(String appLabel, String defaultValue) {
        appLabel = appLabel.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_APP_LABEL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)appLabel, (CharSequence)defaultValue))));
    }

    public Boolean getEnableRememberMeDevice() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE"))), (boolean)false);
    }

    public void setEnableRememberMeDevice(Boolean enableRememberMeDevice) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE", (Object)BooleanUtils.toString((Boolean)enableRememberMeDevice, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAllowUserSpecificRememberMeDeviceDuration() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ALLOW_USER_SPECIFIC_REMEMBER_ME_DEVICE_DURATION"))), (boolean)false);
    }

    public void setAllowUserSpecificRememberMeDeviceDuration(Boolean allowUserSpecificRememberMeDeviceDuration) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ALLOW_USER_SPECIFIC_REMEMBER_ME_DEVICE_DURATION", (Object)BooleanUtils.toString((Boolean)allowUserSpecificRememberMeDeviceDuration, (String)"true", (String)"false", (String)"false"));
    }

    public void setBypass2faAfterCrowdSso(Boolean bypass2faAfterCrowdSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO", (Object)BooleanUtils.toString((Boolean)bypass2faAfterCrowdSso, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getBypass2faAfterCrowdSso() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO"))), (boolean)false);
    }

    public Integer getRememberMeDeviceDuration() {
        String rememberMeDeviceDuration = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION");
        if (NumberUtils.isDigits((String)rememberMeDeviceDuration)) {
            return NumberUtils.createInteger((String)rememberMeDeviceDuration);
        }
        return 1;
    }

    public void setRememberMeDeviceDuration(Integer rememberMeDeviceDuration) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION", (Object)String.valueOf(rememberMeDeviceDuration));
    }

    public List<String> getBackupMethodForUserList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER");
        if (value == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)value;
    }

    public void setBackupMethodForUserList(List<String> backupMethodList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER", backupMethodList);
    }

    public void addTo2FAConfiguredUsersList(String username) {
        List<String> configuredUsers = this.getListOf2FAConfiguredUsers();
        if (!configuredUsers.contains(username)) {
            configuredUsers.add(username);
            this.setListOf2FAConfiguredUsers(configuredUsers);
        }
    }

    public List<String> getListOf2FAConfiguredUsers() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setListOf2FAConfiguredUsers(List<String> configuredUsers) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST", configuredUsers);
    }

    public String getEncryptionKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENCRYPTION_KEY")), (CharSequence)"");
    }

    public void setEncryptionKey(String encryptionKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENCRYPTION_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)encryptionKey, (CharSequence)""))));
    }

    public void setUserSettings(String username, MoTwoFactorCommonUserSettings userRelatedSettings) {
        JsonObject jsonObject = this.convertToJsonObject(userRelatedSettings);
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username, (Object)jsonObject.toString());
    }

    public MoTwoFactorCommonUserSettings getUserSettings(String username) {
        Object userRelatedSettings = this.pluginSettings.get("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username);
        if (userRelatedSettings != null) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.getFromJsonObject((String)userRelatedSettings);
            return twoFactorUserClass;
        }
        return new MoTwoFactorCommonUserSettings();
    }

    public void setIsWebAuthnConfigured(String username, Boolean isWebAuthnConfigured) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username, (Object)BooleanUtils.toString((Boolean)isWebAuthnConfigured, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIsWebAuthnConfigured(String username) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username))), (boolean)false);
    }

    public List<String> getEnable2FAForUsersList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setEnable2FAForUsersList(List<String> enable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST", enable2FAFor);
    }

    public List<String> getDisable2FAForUsersList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setDisable2FAForUsersList(List<String> disable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DISABLED_2FA_USERS_LIST", disable2FAFor);
    }

    public List<String> getEnable2FAForGroupsList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST");
        }
        return new ArrayList<String>();
    }

    public void setEnable2FAForGroupsList(List<String> enable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST", enable2FAFor);
    }

    public List<String> getEnable2FAForDirectoriesList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_DIRECTORIES_LIST") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_DIRECTORIES_LIST");
        }
        return new ArrayList<String>();
    }

    public void setEnable2FAForDirectoriesList(List<String> enable2FAFor) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_DIRECTORIES_LIST", enable2FAFor);
    }

    public Boolean getEnable2FAForAllUsers() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS"))), (boolean)false);
    }

    public void setEnable2FAForAllUsers(Boolean enableTwoFactorForAllUsers) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS", (Object)BooleanUtils.toString((Boolean)enableTwoFactorForAllUsers, (String)"true", (String)"false", (String)"false"));
    }

    public String getIpManagementSelectedAction() {
        String ipManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION")), (CharSequence)"WhitelistIpAction");
        ipManagementSelectedAction = ipManagementSelectedAction.replaceAll(" ", "");
        return ipManagementSelectedAction;
    }

    public void setIpManagementSelectedAction(String ipManagementSelectedAction) {
        ipManagementSelectedAction = ipManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)ipManagementSelectedAction, (CharSequence)"WhitelistIpAction"))));
    }

    public String getSkip2faUrls() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SKIP_2FA_URLS")), (CharSequence)"");
    }

    public void setSkip2faUrls(String skip2faUrls) {
        Object[] urls2 = skip2faUrls.split(";");
        for (int index = 0; index < urls2.length; ++index) {
            urls2[index] = StringUtils.trim((String)urls2[index]);
        }
        skip2faUrls = StringUtils.join((Object[])urls2, (String)";");
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SKIP_2FA_URLS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)skip2faUrls, (CharSequence)""))));
    }

    public void setGroupsWithAdminPagesAccess(Map<String, String> groupsWithAdminPagesAccess) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS", groupsWithAdminPagesAccess);
    }

    public Map<String, String> getGroupsWithAdminPagesAccess() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS");
        }
        return new HashMap<String, String>();
    }

    public void setWhitelistIpAddresses(List<String> whitelistIpAddresses) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES", whitelistIpAddresses);
    }

    public List<String> getWhitelistIpAddresses() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES");
        }
        return new ArrayList<String>();
    }

    public void setWhitelistIpAddressWithMessages(Map<String, String> whitelistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", whitelistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getWhitelistIpAddressWithMessages() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        }
        return new HashMap<String, String>();
    }

    public void setWhitelistIpAddressAndMessagesInMap(Map<String, String> whitelistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", whitelistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getWhitelistIpAddressWithMessagesOld() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_WITH_COMMENT") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_WITH_COMMENT");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddressWithMessages(Map<String, String> blacklistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", blacklistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getBlacklistIpAddressWithMessages() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddressAndMessagesInMap(Map<String, String> blacklistIpAddressAndMessagesInMap) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP", blacklistIpAddressAndMessagesInMap);
    }

    public Map<String, String> getBlacklistIpAddressWithMessagesOld() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_WITH_COMMENT") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_WITH_COMMENT");
        }
        return new HashMap<String, String>();
    }

    public void setBlacklistIpAddresses(List<String> blacklistIpAddresses) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES", blacklistIpAddresses);
    }

    public List<String> getBlacklistIpAddresses() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES");
        }
        return new ArrayList<String>();
    }

    public void setLockedUserDetails(Map<String, String> lockedUserDetails) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS", lockedUserDetails);
    }

    public Map<String, String> getLockedUserDetails() {
        HashMap lockedUserDetails = (HashMap)this.pluginSettings.get("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS");
        if (lockedUserDetails == null) {
            return new HashMap<String, String>();
        }
        return lockedUserDetails;
    }

    public Boolean getEnableBruteForceProtection() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION"))), (boolean)false);
    }

    public void setEnableBruteForceProtection(Boolean enableBruteForceProtection) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION", (Object)BooleanUtils.toString((Boolean)enableBruteForceProtection, (String)"true", (String)"false", (String)"false"));
    }

    public Integer getBruteForceNumberOfAttempts() {
        String bruteForceNumberOfAttempts = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS");
        if (NumberUtils.isDigits((String)bruteForceNumberOfAttempts)) {
            return NumberUtils.createInteger((String)bruteForceNumberOfAttempts);
        }
        return 3;
    }

    public void setBruteForceNumberOfAttempts(Integer bruteForceNumberOfAttempts) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS", (Object)String.valueOf(bruteForceNumberOfAttempts));
    }

    public String getBruteForceTimeInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL")), (CharSequence)"30 minutes");
    }

    public void setBruteForceTimeInterval(String bruteForceTimeInterval) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bruteForceTimeInterval, (CharSequence)"30 minutes"))));
    }

    public String getBruteForceCustomTimeInterval() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL")), (CharSequence)"minutes");
    }

    public void setBruteForceCustomTimeInterval(String bruteForceCustomTimeInterval) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bruteForceCustomTimeInterval, (CharSequence)"minutes"))));
    }

    public Integer getBruteForceCustomTimeDuration() {
        String bruteForceNumberOfAttempts = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION");
        if (NumberUtils.isDigits((String)bruteForceNumberOfAttempts)) {
            return NumberUtils.createInteger((String)bruteForceNumberOfAttempts);
        }
        return 30;
    }

    public void setBruteForceCustomTimeDuration(Integer bruteForceNumberOfAttempts) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION", (Object)String.valueOf(bruteForceNumberOfAttempts));
    }

    public List<String> get2FAMethodForUserList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER");
        if (value == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("GoogleAuthenticator");
            return arrayList;
        }
        return (ArrayList)value;
    }

    public void set2FAMethodForUserList(List<String> methodForUserList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER", methodForUserList);
    }

    public Boolean getAllowToReconfigureConfigured2faMethod() {
        String allowToReconfigureConfigured2faMethod = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD");
        if (StringUtils.isBlank((CharSequence)allowToReconfigureConfigured2faMethod)) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)allowToReconfigureConfigured2faMethod);
    }

    public void setAllowToReconfigureConfigured2faMethod(Boolean allowToReconfigureConfigured2faMethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD", (Object)BooleanUtils.toString((Boolean)allowToReconfigureConfigured2faMethod, (String)"true", (String)"false", (String)"false"));
    }

    public void setCombineIpAddressAndIpMessage(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCombineIpAddressAndIpMessage() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED"))), (boolean)false);
    }

    public Boolean getCombineIpAddressAndIpMessageInMapMigration() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_COMMENTS_TO_IN_MAP_MIGRATED"))), (boolean)false);
    }

    public void setCombineIpAddressAndCommentsInMap(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_COMMENTS_TO_IN_MAP_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableEnforce2faMethodForUser() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER"))), (boolean)false);
    }

    public void setDisableUsersListMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DISABLED_USERS_LIST_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getDisableUsersListMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DISABLED_USERS_LIST_MIGRATED"))), (boolean)false);
    }

    public void setEnableEnforce2faMethodForUser(Boolean enableEnforceCurrentmethod) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER", (Object)BooleanUtils.toString((Boolean)enableEnforceCurrentmethod, (String)"true", (String)"false", (String)"false"));
    }

    public String getPrimary2faMethodForUser() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER")), (CharSequence)"GoogleAuthenticator");
    }

    public void setPrimary2faMethodForUser(String primary2faMethodForUser) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)primary2faMethodForUser, (CharSequence)"GoogleAuthenticator"))));
    }

    public String getEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE")), (CharSequence)"Dear $$username$$, <br><br>Your OTP is <b><font size=\"3\" face=\"verdana\" color=\"blue\">$$otp$$</font></b>. <br>Use this passcode to complete your action. <br><br>Thank you.");
    }

    public void setEmailTemplate(String emailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplate, (CharSequence)"Dear $$username$$, <br><br>Your OTP is <b><font size=\"3\" face=\"verdana\" color=\"blue\">$$otp$$</font></b>. <br>Use this passcode to complete your action. <br><br>Thank you."))));
    }

    public String getEmailSubject() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_EMAIL_SUBJECT")), (CharSequence)"OTP Verification");
    }

    public void setEmailSubject(String emailSubject) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EMAIL_SUBJECT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailSubject, (CharSequence)"OTP Verification"))));
    }

    public String getEmailTemplateBruteForce() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE")), (CharSequence)"Due to several failed attempts from $$ipaddress$$, your Crowd account is temporarily locked. If it is not you then please contact your administrator and change your password as soon as possible.");
    }

    public void setEmailTemplateBruteForce(String emailTemplateBruteForce) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplateBruteForce, (CharSequence)"Due to several failed attempts from $$ipaddress$$, your Crowd account is temporarily locked. If it is not you then please contact your administrator and change your password as soon as possible."))));
    }

    public String getEmailTemplateBruteForceForSoloAdmin() {
        return "Dear $$username$$,\n\nYour organization has introduced Two-factor Authentication(2FA) in your system to increase the security of your account.\n \nSeveral failed 2FA attempts were observed from <b>$$ipaddress$$</b> address. <br>If it is not you then it is likely that your account has been hacked. Please change your credentials as soon as possible to ensure security.\n\nBest Regards!";
    }

    public String getSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_TEMPLATE")), (CharSequence)"Dear $$username$$, Your OTP is $$otp$$. Use this Passcode to complete your transaction. Thank you.");
    }

    public void setEnableShareSecretKey(Boolean enableShareSecretKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_SHARE_SECRET_KEY", (Object)BooleanUtils.toString((Boolean)enableShareSecretKey, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableShareSecretKey() {
        Object enableShareSecretkey = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_SHARE_SECRET_KEY");
        if (enableShareSecretkey == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)enableShareSecretkey));
    }

    public void setBypass2FACookieDomain(String bypass2FACookieDomain) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BYPASS_2FA_COOKIE_DOMAIN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bypass2FACookieDomain, (CharSequence)""))));
    }

    public String getBypass2FACookieDomain() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BYPASS_2FA_COOKIE_DOMAIN")), (CharSequence)"");
    }

    public String getSecretKeyForOneTime2FAValidation() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SECRET_KEY_FOR_ONE_TIME_2FA_VALIDATION")), (CharSequence)"MO2FA_BYPASS_2FA");
    }

    public void setSecretKeyForOneTime2FAValidation(String secretKeyForOneTime2FAValidation) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SECRET_KEY_FOR_ONE_TIME_2FA_VALIDATION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)secretKeyForOneTime2FAValidation, (CharSequence)"MO2FA_BYPASS_2FA"))));
    }

    public String getConfigureDuoPushNotificationTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_DUO_PUSH_NOTIFICATION_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_DUO_PUSH_NOTIFICATION_TEMPLATE", (Object)duoPushNotificationTemplate);
    }

    public String getValidateDuoPushNotificationTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_DUO_PUSH_NOTIFICATION_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_DUO_PUSH_NOTIFICATION_TEMPLATE", (Object)duoPushNotificationTemplate);
    }

    public void setSmsTemplate(String emailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_TEMPLATE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)emailTemplate, (CharSequence)"Dear $$username$$, Your OTP is $$otp$$. Use this Passcode to complete your transaction. Thank you."))));
    }

    public Integer getOtpLength() {
        String otpLength = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_LENGTH");
        if (NumberUtils.isDigits((String)otpLength)) {
            return NumberUtils.createInteger((String)otpLength);
        }
        return 6;
    }

    public void setOtpLength(Integer otpLength) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_LENGTH", (Object)String.valueOf(otpLength));
    }

    public Integer getOtpValidityDuration() {
        String otpValidityTime = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION");
        if (NumberUtils.isDigits((String)otpValidityTime)) {
            return NumberUtils.createInteger((String)otpValidityTime);
        }
        return 2;
    }

    public void setOtpValidityDuration(Integer otpValidityTime) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION", (Object)String.valueOf(otpValidityTime));
    }

    public String getSmsGateway() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_GATEWAY")), (CharSequence)"miniOrange Gateway");
    }

    public void setSmsGateway(String smsGateway) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_GATEWAY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)smsGateway, (CharSequence)""))));
    }

    public String getCustomerKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY")), (CharSequence)"");
    }

    public void setCustomerKey(String customerKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customerKey, (CharSequence)""))));
    }

    public String getApiKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY")), (CharSequence)"");
    }

    public void setApiKey(String apiKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)apiKey, (CharSequence)""))));
    }

    public String getSmsGatewayUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL")), (CharSequence)"");
    }

    public void setSmsGatewayUrl(String smsGatewayUrl) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)smsGatewayUrl, (CharSequence)""))));
    }

    public void setShowWelcomePrompt(Boolean showWelcomePrompt) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WELCOME_PROMPT", (Object)BooleanUtils.toString((Boolean)showWelcomePrompt, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowWelcomePrompt() {
        return BooleanUtils.toBoolean((String)StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_WELCOME_PROMPT")), (String)"true"));
    }

    public Boolean getShowSupportedAppPopup() {
        Object showSupportedAppPopup = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP");
        if (showSupportedAppPopup == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)showSupportedAppPopup));
    }

    public void setShowSupportedAppPopup(Boolean showSupportedAppPopup) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP", (Object)BooleanUtils.toString((Boolean)showSupportedAppPopup, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getIgnore2FAAfterSso() {
        Object ignore2FAAfterSso = this.pluginSettings.get("miniorange.twofactor.MO2FA_IGNORE_2FA_AFTER_SSO");
        if (ignore2FAAfterSso == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)ignore2FAAfterSso));
    }

    public void setIgnore2FAAfterSso(Boolean ignore2FAAfterSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_IGNORE_2FA_AFTER_SSO", (Object)BooleanUtils.toString((Boolean)ignore2FAAfterSso, (String)"true", (String)"false", (String)"false"));
    }

    public String getSsoLoginUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SSO_LOGIN_URL")), (CharSequence)"");
    }

    public void setSsoLoginUrl(String ssoUrlsList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SSO_LOGIN_URL", (Object)ssoUrlsList);
    }

    public List<String> getExclude2faForGroupList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS");
        if (value == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)value;
    }

    public void setExclude2faForGroupList(List<String> exclude2faForGroupList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS", exclude2faForGroupList);
    }

    public Boolean getShowAllConfiguredMethodToUser() {
        Object showAllConfiguredMethodToUser = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER");
        if (showAllConfiguredMethodToUser == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)showAllConfiguredMethodToUser));
    }

    public void setShowAllConfiguredMethodToUser(Boolean showAllConfiguredMethodToUser) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER", (Object)BooleanUtils.toString((Boolean)showAllConfiguredMethodToUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getShowRemaining2FAMethodsAfterInlineRegistration() {
        Object showRemaining2FAMethodsAfterConfiguration = this.pluginSettings.get("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION");
        if (showRemaining2FAMethodsAfterConfiguration == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)showRemaining2FAMethodsAfterConfiguration));
    }

    public void setShowRemaining2FAMethodsAfterInlineRegistration(Boolean showRemaining2FAMethodsAfterConfiguration) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION", (Object)BooleanUtils.toString((Boolean)showRemaining2FAMethodsAfterConfiguration, (String)"true", (String)"false", (String)"false"));
    }

    public String getAttestationType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ATTESTATION_TYPE")), (CharSequence)"none");
    }

    public void setAttestationType(String attestationType) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ATTESTATION_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)attestationType, (CharSequence)"none"))));
    }

    public String getAuthenticatorType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE")), (CharSequence)"unspecified");
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)authenticatorType, (CharSequence)"unspecified"))));
    }

    public String getUserVerification() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USER_VERIFICATION")), (CharSequence)"discouraged");
    }

    public void setUserVerification(String userVerification) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USER_VERIFICATION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)userVerification, (CharSequence)"discouraged"))));
    }

    public String getResidentKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_RESIDENT_KEY")), (CharSequence)"false");
    }

    public void setResidentKey(String residentKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_RESIDENT_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)residentKey, (CharSequence)"false"))));
    }

    public Boolean getMultiLingualSupportToggle() {
        Object multiLingualSupportToggle = this.pluginSettings.get("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE");
        if (multiLingualSupportToggle == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)multiLingualSupportToggle));
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE", (Object)BooleanUtils.toString((Boolean)multiLingualSupportToggle, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getFallBackMethods() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_FALL_BACK_METHODS");
        if (value == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        return (List)value;
    }

    public void setFallBackMethods(List<String> FallBackMethods) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_FALL_BACK_METHODS", FallBackMethods);
    }

    public void setMfaMethodsBasedOnGroupsMap(Map<String, String> MfaMethodsBasedOnGroupsNewMap) {
        this.pluginSettings.put("miniorange.twofactor.MFA_METHODS_BASED_ON_GROUPS_MAP", MfaMethodsBasedOnGroupsNewMap);
    }

    public Map<String, String> getMfaMethodsBasedOnGroupsMap() {
        if (this.pluginSettings.get("miniorange.twofactor.MFA_METHODS_BASED_ON_GROUPS_MAP") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MFA_METHODS_BASED_ON_GROUPS_MAP");
        }
        return new HashMap<String, String>();
    }

    public void clearPluginSettings(List<String> allAvailableConfluenceUserNameList) {
        this.pluginSettings.remove("miniorange.twofactor.BASE_URL");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_TOKEN_KEY");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_LICENSE_KEY");
        this.pluginSettings.remove("miniorange.twofactor.LICENSE_VERIFIED");
        this.pluginSettings.remove("miniorange.twofactor.LICENSE_EXPIRE_DATE");
        this.pluginSettings.remove("miniorange.twofactor.IS_TRIAL_LICENSE");
        this.pluginSettings.remove("miniorange.twofactor.LICENCED_USERS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_APP_LABEL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_BACKUP_METHOD");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SOFTWARE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SECURITYQUESTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_DUOPUSH");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_MOBILEAUTHN");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_BACKUP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DEFAULT_COUNTRY_CODE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_YUBIKEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_WEBAUTHN");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVERSMS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVEREMAIL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EMAIL_SUBJECT");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WELCOME_PROMPT");
        for (String user : allAvailableConfluenceUserNameList) {
            this.removeUserSettings(user);
        }
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_GROUPS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_DIRECTORIES_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_USERS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_2FA_USERS_LIST");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BACKUP_METHODS_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_2FA_METHODS_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_CURRENT_2FA_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SECURITY_QUESTION_ANSWER_CONFIGURED_BY_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_TOTP_SECRET");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_SALT");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENCRYPTION_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_REMEMBER_ME_DEVICE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_REMEMBER_ME_DEVICE_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ALLOW_USER_SPECIFIC_REMEMBER_ME_DEVICE_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_MANAGEMENT_SELECTED_ACTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_2FA_FOL_ALL_USERS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_IP_MANAGEMENT_SELECTED_ACTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_USER_MESSAGE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_LOCKED_USERS_DETAILS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_BRUTE_FORCE_PROTECTION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_NUMBER_OF_ATTEMPTS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_TIME_INTERVAL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_INTERVAL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_CUSTOM_TIME_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_2FA_METHODS_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BRUTE_FORCE_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_OTP_VALIDITY_DURATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_OTP_LENGTH");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SKIP_2FA_URLS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WHITELIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLACKLIST_IP_ADDRESSES_AND_MESSAGES_IN_MAP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ALLOW_TO_RECONFIGURE_CONFIGURED_METHOD");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_ENFORCE_2FA_METHOD_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_PRIMARY_2FA_METHOD_FOR_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_SUPPORTED_APP_POPUP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BASE_URL_TYPE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ENABLE_SHARE_SECRET_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EXCLUDE_2FA_FOR_GROUPS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_ALL_CONFIGURED_METHODS_TO_USER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SHOW_REMAINING_2FA_METHODS_AFTER_INLINE_REGISTRATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_COMBINE_IP_ADDRESS_AND_IP_COMMENTS_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ADVANCE_SETTINGS_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_GATEWAY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_CUSTOMER_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MINIORANGE_GATEWAY_API_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_GATEWAY_URL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SMS_TEMPLATE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_BYPASS_2FA_AFTER_CROWDSSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ATTESTATION_TYPE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_AUTHENTICATOR_TYPE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USER_VERIFICATION");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_RESIDENT_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_ADMIN_PAGE_ACCESS");
        this.pluginSettings.remove("miniorange.twofactor.AUTODELETE_AUDITLOGS");
        this.pluginSettings.remove("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_MULTILINGUAL_SUPPORT_TOGGLE");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SECRET_KEY_PROVIDED_BY_CROWD_SSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_IGNORE_2FA_AFTER_SSO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CONFIGURED_MOBILE_NUMBERS_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_EMAIL_TEMPLATE_RESET_2FA");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_SEND_MAIL_AFTER_RESET_2FA_INFO");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_FALL_BACK_METHODS");
        this.pluginSettings.remove("miniorange.twofactor.MFA_METHODS_BASED_ON_GROUPS_MAP");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_DAYS_FOR_AUTO_DELETE_AUDIT_LOGS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_TOGGLE_BUTTON");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_AUDIT_LOGS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_SCHEDULER_TIME");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_AUDIT_LOGS_TO_LOWER_CASE_MIGRATED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_FILTER");
        this.pluginSettings.remove("Skipped 2FA (on Crowd SSO)");
        this.pluginSettings.remove("Skipped 2FA (One time 2FA)");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_NUMBER_OF_LOGS_TO_BE_RETAINED");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_AUDIT_MANAGEMENT_SELECTED_ACTION");
        this.pluginSettings.remove("Skipped 2FA (One time 2FA)");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PROTOCAL");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER__HOSTNAME");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_SMTP_PORT");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_FROM_ADDRESS");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_USERNAME");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PASSWORD");
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_TLS");
        this.pluginSettings.remove("miniorange.twofactor.SECURITY_QUESTIONS_LIST");
    }

    public void removeUserSettings(String username) {
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_USERNAME_PREFIX" + username);
        this.pluginSettings.remove("miniorange.twofactor.MO2FA_IS_WEBAUTHN_CONFIGURED" + username);
        this.pluginSettings.remove(username);
    }

    public MoTwoFactorCommonUserSettings getFromJsonObject(String jsonObject) {
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        MoTwoFactorCommonUserSettings twoFactorUserSettings = gson.fromJson((JsonElement)parser.parse(jsonObject).getAsJsonObject(), MoTwoFactorCommonUserSettings.class);
        return twoFactorUserSettings;
    }

    private JsonObject convertToJsonObject(MoTwoFactorCommonUserSettings userRelatedSettings) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("enable2FaForUser", userRelatedSettings.getEnable2FaForUser());
        jsonObject.addProperty("totpSecret", userRelatedSettings.getTotpSecret());
        jsonObject.addProperty("userSalt", userRelatedSettings.getUserSalt());
        jsonObject.addProperty("current2FAMethod", userRelatedSettings.getCurrent2FAMethod());
        JsonArray configured2FAMethodsByUserArray = new JsonArray();
        for (String string : userRelatedSettings.getConfigured2FAMethodsByUser()) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(string);
            configured2FAMethodsByUserArray.add(jsonPrimitive);
        }
        jsonObject.add("configured2FAMethodsByUser", configured2FAMethodsByUserArray);
        JsonObject securityQuestionAnswerObj = new JsonObject();
        if (userRelatedSettings.getSecurityQuestionAnswer() != null) {
            for (String string : userRelatedSettings.getSecurityQuestionAnswer().keySet()) {
                if (string == null) continue;
                securityQuestionAnswerObj.addProperty(string, userRelatedSettings.getSecurityQuestionAnswer().get(string));
            }
        }
        jsonObject.add("securityQuestionAnswer", securityQuestionAnswerObj);
        JsonArray jsonArray = new JsonArray();
        for (String deviceDetails : userRelatedSettings.getRememberMeDeviceDetails()) {
            JsonPrimitive defaultGroupObject = new JsonPrimitive(deviceDetails);
            jsonArray.add(defaultGroupObject);
        }
        jsonObject.add("rememberMeDeviceDetails", jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (String backupCode : userRelatedSettings.getBackupCodes()) {
            JsonPrimitive backupCodeElement = new JsonPrimitive(backupCode);
            jsonArray2.add(backupCodeElement);
        }
        jsonObject.add("backupCodes", jsonArray2);
        jsonObject.addProperty("countryCode", userRelatedSettings.getCountryCode());
        jsonObject.addProperty("mobileNumber", userRelatedSettings.getMobileNumber());
        return jsonObject;
    }

    public void deleteUserAction(String username) {
        List<String> userList = this.getListOf2FAConfiguredUsers();
        userList.removeAll(Collections.singleton(username));
        this.setListOf2FAConfiguredUsers(userList);
        List<String> twoFactorEnabledUsers = this.getEnable2FAForUsersList();
        twoFactorEnabledUsers.removeAll(Collections.singleton(username));
        this.setEnable2FAForUsersList(twoFactorEnabledUsers);
        List<String> twoFactorDisabledUsers = this.getDisable2FAForUsersList();
        twoFactorDisabledUsers.removeAll(Collections.singleton(username));
        this.setDisable2FAForUsersList(twoFactorDisabledUsers);
        this.removeUserSettings(username);
    }

    public void deleteGroupAction(String groupName) {
        List<String> groupList = this.getEnable2FAForGroupsList();
        groupList.removeAll(Collections.singleton(groupName));
        this.setEnable2FAForGroupsList(groupList);
    }

    public void setRememberMeMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRememberMeMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_REMEMBER_ME_MIGRATED"))), (boolean)false);
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setUsernameMigrated(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getUsernameMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_USERNAME_PREFIX_MIGRATED"))), (boolean)false);
    }

    public void setAuditLogsToLowerCaseMigrated(Boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_AUDIT_LOGS_TO_LOWER_CASE_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAuditLogsToLowerCaseMigrated() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUDIT_LOGS_TO_LOWER_CASE_MIGRATED"))), (boolean)false);
    }

    public String getWelcomeMessageTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE")), (CharSequence)"");
    }

    public void setWelcomeMessageTemplate(String welcomeMessageTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_WELCOME_MESSAGE_TEMPLATE", (Object)welcomeMessageTemplate);
    }

    public String getInlineRegistration_2faMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_2faMethodListTemplate(String inlineRegistration_2faMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_2FA_METHOD_LIST_TEMPLATE", (Object)inlineRegistration_2faMethodListTemplate);
    }

    public String getValidate_2faMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setValidate_2faMethodListTemplate(String validate_2faMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_2FA_METHOD_LIST_TEMPLATE", (Object)validate_2faMethodListTemplate);
    }

    public String getInlineRegistration_backupMethodListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_backupMethodListTemplate(String inlineRegistration_backupMethodListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_BACKUP_METHOD_LIST_TEMPLATE", (Object)inlineRegistration_backupMethodListTemplate);
    }

    public String getInlineRegistration_remaining2faMethodsListTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE")), (CharSequence)"");
    }

    public void setInlineRegistration_remaining2faMethodsListTemplate(String inlineRegistration_remaining2faMethodsListTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_INLINE_REGISTRATION_REMAINING_2FA_METHODS_TEMPLATE", (Object)inlineRegistration_remaining2faMethodsListTemplate);
    }

    public String getConfigureGoogleAuthenticatorTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_GOOGLE_AUTHENTICATOR_TEMPLATE", (Object)googleAuthenticatorTemplate);
    }

    public String getValidateGoogleAuthenticatorTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_GOOGLE_AUTHENTICATOR_TEMPLATE", (Object)googleAuthenticatorTemplate);
    }

    public String getConfigureSecurityQuestionTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_SECURITY_QUESTION_TEMPLATE", (Object)securityQuestionTemplate);
    }

    public String getValidateSecurityQuestionTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_SECURITY_QUESTION_TEMPLATE", (Object)securityQuestionTemplate);
    }

    public String getConfigureWebAuthnHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureWebAuthnHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getConfigureU2FHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureU2FHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_U2F_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getValidateU2FHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateU2FHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_U2F_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public void setValidateWebAuthnHardwareTokenTemplate(String hardwareTokenTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE", (Object)hardwareTokenTemplate);
    }

    public String getValidateWebAuthnHardwareTokenTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_HARDWARE_TOKEN_TEMPLATE")), (CharSequence)"");
    }

    public String getConfigureWebAuthnAs2faMethodTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureWebAuthnAs2faMethodTemplate(String weAuthn2faTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE", (Object)weAuthn2faTemplate);
    }

    public void setValidateWebAuthnAs2faMethodTemplate(String webAuthnAs2faMethodTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE", (Object)webAuthnAs2faMethodTemplate);
    }

    public String getValidateWebAuthnAs2faMethodTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_WEBAUTHN_AS_2FA_METHOD_TEMPLATE")), (CharSequence)"");
    }

    public String getConfigureOtpOverEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_EMAIL_TEMPLATE", (Object)otpOverEmailTemplate);
    }

    public String getValidateOtpOverEmailTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_EMAIL_TEMPLATE", (Object)otpOverEmailTemplate);
    }

    public String getConfigureOtpOverSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_OTP_OVER_SMS_TEMPLATE", (Object)otpOverSmsTemplate);
    }

    public String getValidateOtpOverSmsTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_OTP_OVER_SMS_TEMPLATE", (Object)otpOverSmsTemplate);
    }

    public String getConfigureBackupCodeTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE")), (CharSequence)"");
    }

    public void setConfigureBackupCodeTemplate(String backupCodeTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONFIGURE_BACKUP_CODE_TEMPLATE", (Object)backupCodeTemplate);
    }

    public String getValidateBackupCodeTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE")), (CharSequence)"");
    }

    public void setValidateBackupCodeTemplate(String backupCodeTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_VALIDATE_BACKUP_CODE_TEMPLATE", (Object)backupCodeTemplate);
    }

    public String getLockedUserTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE")), (CharSequence)"");
    }

    public void setLockedUserTemplate(String lockedUserTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_LOCKED_USER_TEMPLATE", (Object)lockedUserTemplate);
    }

    public String getContactAdminTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CONTACT_ADMIN_TEMPLATE")), (CharSequence)"");
    }

    public void setContactAdminTemplate(String contactAdminTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CONTACT_ADMIN_TEMPLATE", (Object)contactAdminTemplate);
    }

    public String getBlocklistIpTemplate() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE")), (CharSequence)"");
    }

    public void setBlocklistIpTemplate(String blocklistIpTemplate) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_BLOCKLIST_IP_TEMPLATE", (Object)blocklistIpTemplate);
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.TROUBLESHOOTING"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.twofactor.TROUBLESHOOTING", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public String getClientIpRequestHeader() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER")), (CharSequence)"X-FORWARDED-FOR");
    }

    public void setClientIpRequestHeader(String clientIpRequestHeader) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CLIENT_IP_REQUEST_HEADER", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)clientIpRequestHeader, (CharSequence)"X-FORWARDED-FOR"))));
    }

    public Integer getDaysForAutoDeleteLogs() {
        String autoDeleteLogsAfterDays = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DAYS_FOR_AUTO_DELETE_AUDIT_LOGS");
        if (NumberUtils.isDigits((String)autoDeleteLogsAfterDays)) {
            return NumberUtils.createInteger((String)autoDeleteLogsAfterDays);
        }
        return 60;
    }

    public void setDaysForAutoDeleteLogs(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DAYS_FOR_AUTO_DELETE_AUDIT_LOGS", (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public boolean getAutoDeleteAuditLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.AUTODELETE_AUDITLOGS"))), (boolean)false);
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.pluginSettings.put("miniorange.twofactor.AUTODELETE_AUDITLOGS", (Object)BooleanUtils.toString((Boolean)autoDeleteAuditLogs, (String)"true", (String)"false", (String)"false"));
    }

    public Integer getAutoDeleteAuditLogsAfterDays() {
        String days = (String)this.pluginSettings.get("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS");
        if (NumberUtils.isDigits((String)days)) {
            return NumberUtils.createInteger((String)days);
        }
        return 60;
    }

    public void setAutoDeleteAuditLogsAfterDays(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put("miniorange.twofactor.AUTODELET_EAUDITLOGS_AFTERDAYS", (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public String getDuoPushNotificationIntegrationKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY")), (CharSequence)"");
    }

    public void setDuoPushNotificationIntegrationKey(String duoPushNotificationIntegrationKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_INTEGRATION_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationIntegrationKey, (CharSequence)""))));
    }

    public String getDuoPushNotificationSecretKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY")), (CharSequence)"");
    }

    public void setDuoPushNotificationSecretKey(String duoPushNotificationSecretKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_SECRET_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationSecretKey, (CharSequence)""))));
    }

    public String getDuoPushNotificationHostName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME")), (CharSequence)"");
    }

    public void setDuoPushNotificationHostName(String duoPushNotificationHostName) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DUO_PUSH_NOTIFICATION_HOSTNAME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)duoPushNotificationHostName, (CharSequence)""))));
    }

    public Map<String, String> getRequestInfo(HttpServletRequest request) {
        if (request != null) {
            String[] VALID_IP_HEADER_CANDIDATES;
            Enumeration headerNames = request.getHeaderNames();
            HashMap<String, String> requestInfo = new HashMap<String, String>();
            requestInfo.put("HTTP Request Header", "");
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = request.getHeader(key);
                requestInfo.put(key, value);
            }
            for (String header : VALID_IP_HEADER_CANDIDATES = new String[]{"X-FORWARDED-FOR", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR", "Set-Cookie"}) {
                if (request.getHeader(header) == null) {
                    requestInfo.put(header, "-");
                    continue;
                }
                requestInfo.put(header, request.getHeader(header));
            }
            LOGGER.debug("requestInfo" + String.valueOf(requestInfo));
            return requestInfo;
        }
        return new HashMap<String, String>();
    }

    public Integer getNumberOfLogsToBeRetained() {
        String numberOfLogsToBeRetained = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_NUMBER_OF_LOGS_TO_BE_RETAINED");
        if (NumberUtils.isDigits((String)numberOfLogsToBeRetained)) {
            return NumberUtils.createInteger((String)numberOfLogsToBeRetained);
        }
        return 20000;
    }

    public void setNumberOfLogsToBeRetained(Integer numberOfLogsToBeRetained) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_NUMBER_OF_LOGS_TO_BE_RETAINED", (Object)String.valueOf(numberOfLogsToBeRetained));
    }

    public Boolean getRecordAuditLogsToggleButton() {
        Object recordAuditLogsToggleButton = this.pluginSettings.get("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_TOGGLE_BUTTON");
        if (recordAuditLogsToggleButton == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)recordAuditLogsToggleButton));
    }

    public void setRecordAuditLogsToggleButton(Boolean recordAuditLogsToggleButton) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_TOGGLE_BUTTON", (Object)BooleanUtils.toString((Boolean)recordAuditLogsToggleButton, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getRecordAuditLogFilter() {
        Object value = this.pluginSettings.get("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_FILTER");
        if (value == null) {
            return this.populateRecordAuditLogs();
        }
        return (ArrayList)value;
    }

    public List<String> populateRecordAuditLogs() {
        ArrayList<String> recordAuditLogsList = new ArrayList<String>();
        recordAuditLogsList.add("Login Successful");
        recordAuditLogsList.add("Login Failed");
        recordAuditLogsList.add("2FA Configuration Successful");
        recordAuditLogsList.add("2FA Configuration Failed");
        recordAuditLogsList.add("Skipped 2FA (Remembered Device)");
        recordAuditLogsList.add("Temporarily Locked");
        recordAuditLogsList.add("Skipped 2FA (Based on group)");
        recordAuditLogsList.add("Skipped 2FA (Whitelisted IP)");
        recordAuditLogsList.add("Skipped 2FA (on SSO)");
        recordAuditLogsList.add("Skipped 2FA (on Crowd SSO)");
        recordAuditLogsList.add("Skipped 2FA (One time 2FA)");
        return recordAuditLogsList;
    }

    public void setRecordAuditLogFilter(List<String> recordAuditLogFilter) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_RECORD_AUDIT_LOG_FILTER", recordAuditLogFilter);
    }

    public String getCustomSchedulerTime() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_SCHEDULER_TIME")), (CharSequence)"");
    }

    public void setCustomSchedulerTime(String customSchedulerTime) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_SCHEDULER_TIME", (Object)customSchedulerTime);
    }

    public Boolean getTwoFactorForMobileAuthn() {
        Object twoFactorForMobileAuthn = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_MOBILEAUTHN");
        if (twoFactorForMobileAuthn == null) {
            return Boolean.TRUE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForMobileAuthn));
    }

    public void setTwoFactorForMobileAuthn(Boolean twoFactorForMobileAuthn) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_MOBILEAUTHN", (Object)BooleanUtils.toString((Boolean)twoFactorForMobileAuthn, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForYubikey() {
        Object twoFactorForYubikey = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_YUBIKEY");
        if (twoFactorForYubikey == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForYubikey));
    }

    public void setTwoFactorForYubikey(Boolean twoFactorForYubikey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_YUBIKEY", (Object)BooleanUtils.toString((Boolean)twoFactorForYubikey, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForDuopush() {
        Object twoFactorForDuopush = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_DUOPUSH");
        if (twoFactorForDuopush == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForDuopush));
    }

    public void setTwoFactorForDuopush(Boolean twoFactorForDuopush) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_DUOPUSH", (Object)BooleanUtils.toString((Boolean)twoFactorForDuopush, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForSecurityQuestion() {
        Object twoFactorForSecurityQuestion = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SECURITYQUESTION");
        if (twoFactorForSecurityQuestion == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForSecurityQuestion));
    }

    public void setTwoFactorForSecurityQuestion(Boolean twoFactorForSecurityQuestion) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_SECURITYQUESTION", (Object)BooleanUtils.toString((Boolean)twoFactorForSecurityQuestion, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForOtpOverEmail() {
        Object twoFactorForOtpOverEmail = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVEREMAIL");
        if (twoFactorForOtpOverEmail == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForOtpOverEmail));
    }

    public void setTwoFactorForOtpOverEmail(Boolean twoFactorForOtpOverEmail) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVEREMAIL", (Object)BooleanUtils.toString((Boolean)twoFactorForOtpOverEmail, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForOtpOverSms() {
        Object ignore2FAAfterSso = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVERSMS");
        if (ignore2FAAfterSso == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)ignore2FAAfterSso));
    }

    public void setTwoFactorForOtpOverSms(Boolean ignore2FAAfterSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_OTPOVERSMS", (Object)BooleanUtils.toString((Boolean)ignore2FAAfterSso, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForWebAuthn() {
        Object twoFactorForWebAuthn = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_WEBAUTHN");
        if (twoFactorForWebAuthn == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForWebAuthn));
    }

    public void setTwoFactorForWebAuthn(Boolean twoFactorForWebAuthn) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_WEBAUTHN", (Object)BooleanUtils.toString((Boolean)twoFactorForWebAuthn, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getTwoFactorForBackup() {
        Object twoFactorForBackup = this.pluginSettings.get("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_BACKUP");
        if (twoFactorForBackup == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)((String)twoFactorForBackup));
    }

    public void setTwoFactorForBackup(Boolean twoFactorForBackup) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ENABLE_TWO_FACTOR_FOR_BACKUP", (Object)BooleanUtils.toString((Boolean)twoFactorForBackup, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getSecurityQuestionsList() {
        Object value = this.pluginSettings.get("miniorange.twofactor.SECURITY_QUESTIONS_LIST");
        if (value == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)value;
    }

    public void setSecurityQuestionsList(List<String> securityQuestionsList) {
        this.pluginSettings.put("miniorange.twofactor.SECURITY_QUESTIONS_LIST", securityQuestionsList);
    }

    public String setCSRFTokenInSession(HttpServletRequest request) {
        try {
            String token = UUID.randomUUID().toString();
            request.getSession().setAttribute("CSRF_TOKEN", (Object)token);
            return token;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while setting up a session token", e);
            return null;
        }
    }

    public boolean isValidCSRFToken(HttpServletRequest request, String CSRF_TOKEN) {
        try {
            String sessionToken;
            if (request.getSession().getAttribute("CSRF_TOKEN") != null && StringUtils.isNotBlank((CharSequence)(sessionToken = request.getSession().getAttribute("CSRF_TOKEN").toString())) && sessionToken.equals(CSRF_TOKEN)) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error Occurred", e);
        }
        return Boolean.FALSE;
    }

    public void setSkip2FAForGivenUrlList(List<String> skip2FAUrlList) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_LIST_OF_SKIP_2FA_URLS", skip2FAUrlList);
    }

    public List<String> getSkip2FAForGivenUrlList() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_LIST_OF_SKIP_2FA_URLS") != null) {
            return (List)this.pluginSettings.get("miniorange.twofactor.MO2FA_LIST_OF_SKIP_2FA_URLS");
        }
        return new ArrayList<String>();
    }

    public void setAdvanceSettingMigrate(boolean isMigrated) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_ADVANCE_SETTINGS_MIGRATED", (Object)BooleanUtils.toString((Boolean)isMigrated, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAdvanceSettingMigrate() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_ADVANCE_SETTINGS_MIGRATED"))), (boolean)false);
    }

    public Map<String, String> getInlineRegistrationUrls() {
        HashMap<String, String> inlineRegistrationurls = new HashMap<String, String>();
        inlineRegistrationurls.put("GoogleAuthenticator", "/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
        inlineRegistrationurls.put("OtpOverEmail", "/plugins/servlet/twofactor/inlineregistration_otpoveremail");
        inlineRegistrationurls.put("OtpOverSms", "/plugins/servlet/twofactor/inlineregistration_otpoversms");
        inlineRegistrationurls.put("SecurityQuestion", "/plugins/servlet/twofactor/inlineregistration_securityquestion");
        inlineRegistrationurls.put("DuoPushNotification", "/plugins/servlet/twofactor/inlineregistration_duopushnotification");
        inlineRegistrationurls.put("YubikeyHardwareTokenAsU2F", "/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
        inlineRegistrationurls.put("WebAuthn", "/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
        inlineRegistrationurls.put("BackupCode", "/plugins/servlet/twofactor/inlineregistration_backupcode");
        return inlineRegistrationurls;
    }

    public Map<String, String> getValidationUrls() {
        HashMap<String, String> validationUrls = new HashMap<String, String>();
        validationUrls.put("GoogleAuthenticator", "/plugins/servlet/twofactor/validate_otp");
        validationUrls.put("OtpOverEmail", "/plugins/servlet/twofactor/validate_otpoveremail");
        validationUrls.put("OtpOverSms", "/plugins/servlet/twofactor/validate_otpoversms");
        validationUrls.put("SecurityQuestion", "/plugins/servlet/twofactor/validate_securityquestion");
        validationUrls.put("DuoPushNotification", "/plugins/servlet/twofactor/validate_duopushnotification");
        validationUrls.put("YubikeyHardwareTokenAsU2F", "/plugins/servlet/twofactor/validate_webauthnhardwaretoken");
        validationUrls.put("WebAuthn", "/plugins/servlet/twofactor/validate_webauthnas2famethod");
        validationUrls.put("BackupCode", "/plugins/servlet/twofactor/validate_backupcode");
        return validationUrls;
    }

    public List<String> getIgnore2faUrlList() {
        ArrayList<String> getIgnore2faUrlList = new ArrayList<String>();
        getIgnore2faUrlList.add("/download/");
        getIgnore2faUrlList.add("/images/");
        getIgnore2faUrlList.add("/favicon.ico");
        getIgnore2faUrlList.add("/rest/");
        getIgnore2faUrlList.add("/download/contextbatch");
        getIgnore2faUrlList.add("/twofactor/unlockuser");
        getIgnore2faUrlList.add("/twofactor/view/moapi");
        getIgnore2faUrlList.add("/twofactor/edit/moapi");
        getIgnore2faUrlList.add("/twofactor/user/moapi");
        getIgnore2faUrlList.add("/console/logoff.action");
        getIgnore2faUrlList.add("/twofactor/userlogout");
        getIgnore2faUrlList.add("/twofactor/loadingPage");
        return getIgnore2faUrlList;
    }

    public boolean validateDefaultCountryCode(String countryCode) {
        if (countryCode != null && countryCode.isEmpty()) {
            return true;
        }
        String countryCodeRegex = "^(\\+\\d{1,3})$";
        Pattern countryCodeRegexPattern = Pattern.compile(countryCodeRegex);
        Matcher countryCodeRegexMatcher = countryCodeRegexPattern.matcher(countryCode);
        return countryCodeRegexMatcher.matches();
    }

    public void setOtpOverSmsGatewayReqHeaders(Map<String, String> otpOverSmsGatewayReqHeaders) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_REQ_HEADERS", otpOverSmsGatewayReqHeaders);
    }

    public Map<String, String> getOtpOverSmsGatewayReqHeaders() {
        if (this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_REQ_HEADERS") != null) {
            return (Map)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_REQ_HEADERS");
        }
        return new HashMap<String, String>();
    }

    public void setOtpOverSmsGatewayMethod(String method) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_GATEWAY_METHOD", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)method, (CharSequence)"GET"))));
    }

    public String getOtpOverSmsGatewayMethod() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_GATEWAY_METHOD")), (CharSequence)"GET");
    }

    public void setOtpOverSmsGatewayAuthMethod(String method) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_AUTH_METHOD", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)method, (CharSequence)"BASIC_AUTH"))));
    }

    public String getOtpOverSmsGatewayAuthMethod() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_AUTH_METHOD")), (CharSequence)"BASIC_AUTH");
    }

    public void setOtpOverSmsGatewayAuthBasicauthUsername(String username) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BASICAUTH_USERNAME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)username, (CharSequence)""))));
    }

    public String getOtpOverSmsGatewayAuthBasicauthUsername() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BASICAUTH_USERNAME")), (CharSequence)"");
    }

    public void setOtpOverSmsGatewayAuthBasicauthPassword(String password) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BASICAUTH_PASSWORD", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)password, (CharSequence)""))));
    }

    public String getOtpOverSmsGatewayAuthBasicauthPassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BASICAUTH_PASSWORD")), (CharSequence)"");
    }

    public void setOtpOverSmsGatewayAuthBearerToken(String bearerToken) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BEARER_TOKEN", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)bearerToken, (CharSequence)""))));
    }

    public String getOtpOverSmsGatewayAuthBearerToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BEARER_TOKEN")), (CharSequence)"");
    }

    public void setOtpOverSmsGatewayAuthAPIKey(String apiKey) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_API_KEY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)apiKey, (CharSequence)""))));
    }

    public String getOtpOverSmsGatewayAuthAPIKey() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_API_KEY")), (CharSequence)"");
    }

    public void setOtpOverSmsGatewayBody(String body) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BODY", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)body, (CharSequence)""))));
    }

    public String getOtpOverSmsGatewayBody() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BODY")), (CharSequence)"");
    }

    public void setOtpOverSmsGatewayBodyType(String body) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BODY_TYPE", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)body, (CharSequence)"TEXT"))));
    }

    public String getOtpOverSmsGatewayBodyType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_OTP_OVER_SMS_BODY_TYPE")), (CharSequence)"TEXT");
    }

    public String getDefaultContryCode() {
        String defaultCountryCode = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_DEFAULT_COUNTRY_CODE");
        if (StringUtils.isNotBlank((CharSequence)defaultCountryCode) && this.validateDefaultCountryCode(defaultCountryCode)) {
            return (String)StringUtils.defaultIfBlank((CharSequence)defaultCountryCode, (CharSequence)"+1");
        }
        return "+1";
    }

    public void setDefaultContryCode(String DefaultContryCode) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_DEFAULT_COUNTRY_CODE", (Object)DefaultContryCode);
    }

    public Integer getAuthenticationLinkValidityDuration() {
        String authenticationLinkValidityTime = (String)this.pluginSettings.get("miniorange.twofactor.MO2FA_AUTHENTICATION_LINK_VALIDITY_DURATION");
        if (NumberUtils.isDigits((String)authenticationLinkValidityTime)) {
            return NumberUtils.createInteger((String)authenticationLinkValidityTime);
        }
        return 2;
    }

    public void setCustomMailServer(Boolean customMailServer) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER", (Object)BooleanUtils.toString((Boolean)customMailServer, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCustomMailServer() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER"))), (boolean)false);
    }

    public String getCustomMailServerProtocol() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PROTOCAL")), (CharSequence)"SMTP");
    }

    public void setCustomMailServerProtocol(String customMailServerProtocol) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerProtocol)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PROTOCAL", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerProtocol, (CharSequence)""))));
        }
    }

    public String getCustomMailServerHostName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER__HOSTNAME")), (CharSequence)"");
    }

    public void setCustomMailServerHostName(String customMailServerHostName) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerHostName)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER__HOSTNAME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerHostName, (CharSequence)""))));
        }
    }

    public String getCustomMailServerSmtpPort() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_SMTP_PORT")), (CharSequence)"");
    }

    public void setCustomMailServerSmtpPort(String customMailServerSmtpPort) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerSmtpPort)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_SMTP_PORT", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerSmtpPort, (CharSequence)""))));
        }
    }

    public String getCustomMailServerFromAddress() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_FROM_ADDRESS")), (CharSequence)"");
    }

    public void setCustomMailServerFromAddress(String customMailServerFromAddress) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerFromAddress)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_FROM_ADDRESS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerFromAddress, (CharSequence)""))));
        }
    }

    public String getCustomMailServerUsername() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_USERNAME")), (CharSequence)"");
    }

    public void setCustomMailServerUsername(String customMailServerUsername) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerUsername)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_USERNAME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerUsername, (CharSequence)""))));
        }
    }

    public String getCustomMailServerPassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PASSWORD")), (CharSequence)"");
    }

    public void setCustomMailServerPassword(String customMailServerPassword) {
        if (StringUtils.isNotBlank((CharSequence)customMailServerPassword)) {
            this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_PASSWORD", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)customMailServerPassword, (CharSequence)""))));
        }
    }

    public void setCustomMailServerTls(Boolean customMailServerTls) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_TLS", (Object)BooleanUtils.toString((Boolean)customMailServerTls, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getCustomMailServerTls() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_CUSTOM_MAIL_SERVER_TLS"))), (boolean)false);
    }

    public String getSecretKeyProvidedByCrowdSso() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.MO2FA_SECRET_KEY_PROVIDED_BY_CROWD_SSO")), (CharSequence)"");
    }

    public void setSecretKeyProvidedByCrowdSso(String keyProvidedByCrowdSso) {
        this.pluginSettings.put("miniorange.twofactor.MO2FA_SECRET_KEY_PROVIDED_BY_CROWD_SSO", (Object)keyProvidedByCrowdSso);
    }
}

