/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorKnowledgeBaseAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorKnowledgeBaseAction.class);
    private static final String KNOWLEDGE_BASE_VM_PATH = "/templates/com/miniorange/twofactor/crowd/knowledgeBase.vm";
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private UserManager userManager;
    private TemplateRenderer renderer;
    private MoTwoFactorPluginHandler pluginHandler;
    private LoginUriProvider loginUriProvider;
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorKnowledgeBaseAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, UserManager userManager, TemplateRenderer renderer, MoTwoFactorPluginHandler pluginHandler, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Knowledge Base Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(KNOWLEDGE_BASE_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private Map<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("contextPath", this.pluginSettings.getBaseUrl());
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("isLicenseVerified", this.pluginSettings.getLicenseVerified());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

