/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.entity.MoAdminsLogEntity;
import com.miniorange.twofactor.crowd.common.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.scheduler.AuditLogScheduler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAuditLogs
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAuditLogs.class);
    MoTwoFactorCrowdPluginSettings pluginSettings;
    private static final String AUDITLOGS_VM_PATH = "/templates/com/miniorange/twofactor/crowd/auditLogs.vm";
    private TemplateRenderer renderer;
    UserManager userManager;
    LoginUriProvider loginUriProvider;
    MoTwoFactorCommonPluginSettings settings;
    MoTwoFactorPluginHandler pluginHandler;
    MoTwoFactorPluginConfiguration pluginConfiguration;
    MoLogEntityService service;
    MoAdminsAuditService moAdminsAuditService;
    AuditLogScheduler auditLogScheduler;
    public String message = "";
    public ArrayList errorMessage;
    private Integer currentIndex = 1;
    private Integer adminsAuditLogsCurrentIndex = 1;
    private Integer startIndex;
    private Integer prevIndex;
    private Integer nextIndex;
    private Integer endIndex;
    private Integer lastIndex;
    private Integer totalLogs;
    private Integer start;
    private Integer end;
    private String deletionScheduleDate;

    public MoTwoFactorAuditLogs(MoTwoFactorCrowdPluginSettings pluginSettings, MoLogEntityService moLogEntityService, MoAdminsAuditService moAdminsAuditService, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler, UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorPluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        this.service = moLogEntityService;
        this.moAdminsAuditService = moAdminsAuditService;
        this.pluginSettings = pluginSettings;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfiguration = pluginConfiguration;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("AuditLogs Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            String auditLogSelectedAction = MoTwoFactorUtility.sanitizeText(request.getParameter("auditLogSelectedAction"));
            if (StringUtils.isEmpty((CharSequence)auditLogSelectedAction)) {
                auditLogSelectedAction = this.settings.getAuditLogsSelectedAction();
            }
            LOGGER.debug("auditLogSelectedAction is : " + auditLogSelectedAction);
            Map<String, Object> context = StringUtils.equalsIgnoreCase((CharSequence)auditLogSelectedAction, (CharSequence)"EndUserAuditLogAction") ? this.performDisplayLogs(request, response) : this.perfromDisplayAdminUsersLogs(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(AUDITLOGS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Execute called in MoTwoFactorAuditLogs...");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            String auditLogSelectedAction;
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is not registered.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
            }
            if (StringUtils.isEmpty((CharSequence)(auditLogSelectedAction = request.getParameter("auditLogSelectedAction")))) {
                auditLogSelectedAction = this.settings.getAuditLogsSelectedAction();
            }
            Map<String, Object> context = StringUtils.equalsIgnoreCase((CharSequence)auditLogSelectedAction, (CharSequence)"EndUserAuditLogAction") ? this.performDisplayLogs(request, response) : this.perfromDisplayAdminUsersLogs(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(AUDITLOGS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    private Map<String, Object> performDisplayLogs(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("performDisplayLogs called");
        String startIndexAsString = "";
        String endIndexAsString = "";
        Boolean toStoreAuditLog = Boolean.FALSE;
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        ArrayList<HashMap> moLogEntitesHashMap = new ArrayList<HashMap>();
        String auditLogUsernameSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("auditLogUsernameSearchKeyword"));
        String auditLogIpSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("auditLogIpSearchKeyword"));
        String filterUsersByAction = request.getParameter("filterUsersByAction");
        String filterUsersByPeriod = request.getParameter("filterUsersByPeriod");
        Boolean auditLogsUserDetailsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("auditLogsUserDetailsSubmitted"));
        Boolean autoDeleteAuditLogsDetailsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("autoDeleteAuditLogsDetailsSubmitted"));
        Boolean autoDeleteAuditLogsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("autoDeleteAuditLogsSubmitted"));
        Boolean autoDeleteAuditLogs = BooleanUtils.toBoolean((String)request.getParameter("autoDeleteAuditLogs"));
        String autoDeleteLogsAfterDays = request.getParameter("autoDeleteLogsAfterDays");
        String numberOfLogsToBeRetaine = request.getParameter("numberOfLogsToBeRetained");
        if (numberOfLogsToBeRetaine == null || numberOfLogsToBeRetaine.isEmpty()) {
            numberOfLogsToBeRetaine = "20000";
        }
        Integer numberOfLogsToBeRetained = Integer.parseInt(numberOfLogsToBeRetaine);
        String customSchedulerTime = request.getParameter("customSchedulerTime");
        Boolean recordAuditLogsToggleButton = BooleanUtils.toBoolean((String)request.getParameter("recordAuditLogsToggleButton"));
        try {
            if (StringUtils.isBlank((CharSequence)auditLogUsernameSearchKeyword)) {
                auditLogUsernameSearchKeyword = "";
            }
            if (StringUtils.isBlank((CharSequence)auditLogIpSearchKeyword)) {
                auditLogIpSearchKeyword = "";
            }
            if (StringUtils.isBlank((CharSequence)filterUsersByAction)) {
                filterUsersByAction = "All Actions";
            }
            if (StringUtils.isBlank((CharSequence)filterUsersByPeriod)) {
                filterUsersByPeriod = "All Days";
            }
            this.currentIndex = request.getParameter("currentIndex") == null ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(request.getParameter("currentIndex")));
            if (BooleanUtils.toBoolean((Boolean)auditLogsUserDetailsSubmitted)) {
                startIndexAsString = "";
                endIndexAsString = "";
            } else if (BooleanUtils.toBoolean((Boolean)autoDeleteAuditLogsDetailsSubmitted)) {
                StringBuilder builder = new StringBuilder();
                if (BooleanUtils.toBoolean((Boolean)recordAuditLogsToggleButton) != this.settings.getRecordAuditLogsToggleButton()) {
                    toStoreAuditLog = Boolean.TRUE;
                    builder.append("Record Audit Logs :" + BooleanUtils.toBoolean((Boolean)recordAuditLogsToggleButton) + "////");
                    this.settings.setRecordAuditLogsToggleButton(BooleanUtils.toBoolean((Boolean)recordAuditLogsToggleButton));
                }
                if (BooleanUtils.toBoolean((Boolean)recordAuditLogsToggleButton)) {
                    HashMap<String, String> auditLogsHashMap = this.populateAuditLogHashMap();
                    ArrayList<String> recordAuditLogConsent = new ArrayList<String>();
                    for (String s2 : auditLogsHashMap.keySet()) {
                        String auditLogAction = MoTwoFactorUtility.sanitizeText(request.getParameter(auditLogsHashMap.get(s2)));
                        if (!StringUtils.isNotBlank((CharSequence)auditLogAction) || !StringUtils.equalsIgnoreCase((CharSequence)auditLogAction, (CharSequence)"true")) continue;
                        recordAuditLogConsent.add(s2);
                    }
                    LOGGER.debug("recordAuditLogConsent :" + String.valueOf(recordAuditLogConsent));
                    if (!recordAuditLogConsent.equals(this.settings.getRecordAuditLogFilter())) {
                        toStoreAuditLog = Boolean.TRUE;
                        builder.append("Record Audit Logs list: Updated ////");
                    }
                    this.settings.setRecordAuditLogFilter(recordAuditLogConsent);
                }
                if (BooleanUtils.toBoolean((Boolean)autoDeleteAuditLogs)) {
                    if (StringUtils.isNotBlank((CharSequence)autoDeleteLogsAfterDays)) {
                        int days = Integer.parseInt(autoDeleteLogsAfterDays);
                        if (days < 1) {
                            this.errorMessage.add("Invalid number of days entered. Days must be greater than 1.");
                            this.settings.setAutoDeleteAuditLogs(false);
                        } else {
                            LOGGER.debug("Auto delete audit logs after given days = " + days);
                            if (!this.settings.getDaysForAutoDeleteLogs().equals(days)) {
                                toStoreAuditLog = Boolean.TRUE;
                                builder.append("Auto Delete Audit Logs Days :" + days + "////");
                            }
                            this.settings.setDaysForAutoDeleteLogs(days);
                            if (!this.settings.getAutoDeleteAuditLogs()) {
                                toStoreAuditLog = Boolean.TRUE;
                                builder.append("Auto Delete Audit Logs :" + BooleanUtils.toBoolean((Boolean)autoDeleteAuditLogs) + "////");
                            }
                            this.settings.setAutoDeleteAuditLogs(true);
                            LOGGER.debug("numberOfLogsToBeRetained :" + numberOfLogsToBeRetained);
                            if (numberOfLogsToBeRetained != null && !numberOfLogsToBeRetained.equals(this.settings.getNumberOfLogsToBeRetained())) {
                                toStoreAuditLog = Boolean.TRUE;
                                builder.append("Entries to be Retained :" + numberOfLogsToBeRetained + "////");
                            }
                            this.settings.setNumberOfLogsToBeRetained(numberOfLogsToBeRetained);
                            if (StringUtils.isNotBlank((CharSequence)customSchedulerTime)) {
                                LOGGER.debug("customScheduler Time :" + customSchedulerTime);
                                if (!StringUtils.equals((CharSequence)customSchedulerTime, (CharSequence)this.settings.getCustomSchedulerTime())) {
                                    toStoreAuditLog = Boolean.TRUE;
                                    builder.append("Custom Scheduler time :" + customSchedulerTime + "////");
                                }
                                this.settings.setCustomSchedulerTime(customSchedulerTime);
                            } else {
                                Calendar cal = Calendar.getInstance();
                                int currentHour = cal.get(11);
                                int currentMinutes = cal.get(12);
                                Object currentTime = "";
                                currentTime = currentMinutes < 10 ? currentHour + ":0" + currentMinutes : currentHour + ":" + currentMinutes;
                                LOGGER.debug("currentTime :" + (String)currentTime);
                                builder.append("Custom Scheduler time :" + (String)currentTime + "////");
                                this.settings.setCustomSchedulerTime((String)currentTime);
                            }
                            this.message = "Audit Logs settings updated. We have started removing the audit logs.";
                            LOGGER.debug("Scheduling Task");
                            this.auditLogScheduler.schedule();
                        }
                        LocalDate localDate = LocalDate.now();
                        this.deletionScheduleDate = localDate.plusDays(this.settings.getDaysForAutoDeleteLogs().intValue()).toString();
                    } else {
                        this.errorMessage.add("No.of days cannot be blank! Please enter a valid number greater than or equal to 1.");
                        this.settings.setAutoDeleteAuditLogs(false);
                    }
                } else {
                    if (this.settings.getAutoDeleteAuditLogs()) {
                        toStoreAuditLog = Boolean.TRUE;
                        builder.append("Auto Delete Audit Logs :" + BooleanUtils.toBoolean((Boolean)autoDeleteAuditLogs) + "////");
                    }
                    this.message = "Audit Logs settings updated. We have stopped removing the audit logs.";
                    this.settings.setAutoDeleteAuditLogs(false);
                    LOGGER.debug("Un-scheduling Task");
                    this.auditLogScheduler.unschedule();
                }
                if (toStoreAuditLog.booleanValue()) {
                    this.pluginHandler.storeAdminsAuditLogs("-", "Updated Audit Log settings", builder.toString(), request);
                }
            } else {
                String usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("logsUsernameSearchKeywordUrl"));
                String ipSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("logsIpSearchKeywordUrl"));
                String actionSearchFilter = request.getParameter("actionSearchFilter");
                String periodSearchFilter = request.getParameter("periodSearchFilter");
                if (usernameSearchKeyword != null) {
                    auditLogUsernameSearchKeyword = usernameSearchKeyword.trim();
                }
                if (ipSearchKeyword != null) {
                    auditLogIpSearchKeyword = ipSearchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)actionSearchFilter)) {
                    filterUsersByAction = actionSearchFilter.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)periodSearchFilter)) {
                    filterUsersByPeriod = periodSearchFilter.trim();
                }
                startIndexAsString = request.getParameter("startIndex");
                endIndexAsString = request.getParameter("endIndex");
            }
            LOGGER.debug("Username:" + auditLogUsernameSearchKeyword);
            List<Object> aoAuditLogs = new ArrayList();
            aoAuditLogs = this.service.getLogs(this.currentIndex, filterUsersByAction, filterUsersByPeriod, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword, 20);
            this.totalLogs = this.service.getSize(filterUsersByAction, filterUsersByPeriod, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword);
            LocalDate localDate = LocalDate.now();
            this.deletionScheduleDate = localDate.plusDays(this.settings.getAutoDeleteAuditLogsAfterDays().intValue()).toString();
            ArrayList filteredLogs = new ArrayList();
            for (int i = 0; i < aoAuditLogs.size(); ++i) {
                MoLogEntity moLogEntity = (MoLogEntity)aoAuditLogs.get(i);
                if (moLogEntity == null) continue;
                HashMap<String, String> moLogEntityHash = new HashMap<String, String>();
                moLogEntityHash.put("user", moLogEntity.getUserName());
                SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
                moLogEntityHash.put("dateTime", formatter.format(moLogEntity.getDateAndTime()));
                moLogEntityHash.put("ipAddress", moLogEntity.getIpAddress());
                moLogEntityHash.put("action", moLogEntity.getAction());
                moLogEntityHash.put("type", moLogEntity.getLoginMethod());
                filteredLogs.add(moLogEntityHash);
            }
            this.setAuditIndexes(this.currentIndex, this.totalLogs);
            this.start = (this.currentIndex - 1) * 20;
            this.end = Math.min(this.start + 20, filteredLogs.size());
            int count = 0;
            for (int i = 0; i < filteredLogs.size(); ++i) {
                moLogEntitesHashMap.add(count, (HashMap)filteredLogs.get(i));
                ++count;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error " + String.valueOf(e));
            this.errorMessage.add("An error occurred.");
        }
        Map<String, Object> context = this.initializeConfig(this.currentIndex, this.startIndex, this.prevIndex, this.nextIndex, this.endIndex, this.lastIndex, this.totalLogs, this.start, this.end, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword, filterUsersByAction, filterUsersByPeriod, moLogEntitesHashMap);
        context.put("pageAccessType", pageAccessType);
        context.put("exportAuditLogsUrl", this.pluginSettings.getExportAuditLogsUrl());
        context.put("autoDeleteLogsAfterDays", this.settings.getDaysForAutoDeleteLogs().toString());
        context.put("numberOfLogsToBeRetained", this.settings.getNumberOfLogsToBeRetained());
        context.put("recordAuditLogFilter", this.settings.getRecordAuditLogFilter());
        context.put("customSchedulerTime", this.settings.getCustomSchedulerTime());
        context.put("recordAuditLogsToggleButton", this.settings.getRecordAuditLogsToggleButton());
        return context;
    }

    public HashMap<String, String> populateAuditLogHashMap() {
        HashMap<String, String> auditLoghashMap = new HashMap<String, String>();
        auditLoghashMap.put("Login Successful", "loginSuccessful");
        auditLoghashMap.put("Login Failed", "loginFailed");
        auditLoghashMap.put("2FA Configuration Successful", "ConfigurationSuccessful");
        auditLoghashMap.put("2FA Configuration Failed", "ConfigurationFailed");
        auditLoghashMap.put("Skipped 2FA (Remembered Device)", "loginFromRememberedDevice");
        auditLoghashMap.put("Temporarily Locked", "temporarilyLocked");
        auditLoghashMap.put("Skipped 2FA (Based on group)", "skipped2FABasedOnGroup");
        auditLoghashMap.put("Skipped 2FA (Whitelisted IP)", "skipped2FAWhitelistedIP");
        auditLoghashMap.put("Skipped 2FA (on SSO)", "skipped2FAOnSSO");
        auditLoghashMap.put("Skipped 2FA (on Crowd SSO)", "skipped2FAOnCrowdSSO");
        auditLoghashMap.put("Skipped 2FA (One time 2FA)", "skipped2FAOnOneTime2fa");
        return auditLoghashMap;
    }

    private Map<String, Object> perfromDisplayAdminUsersLogs(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        LOGGER.debug("perfromDisplayAdminUsersLogs called");
        String startIndexAsString = "";
        String endIndexAsString = "";
        this.message = "";
        this.currentIndex = request.getParameter("currentIndex") == null ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(request.getParameter("currentIndex")));
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        String filterUsersByAdminsAction = MoTwoFactorUtility.sanitizeText(request.getParameter("filterUsersByAdminsAction"));
        String performedOnSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("performedOnSearchKeyword"));
        String performedBySearchKeyword = request.getParameter("performedBySearchKeyword");
        String moreDetailsSearchKeyword = request.getParameter("moreDetailsSearchKeyword");
        Boolean adminsAuditLogsDetailsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("adminsAuditLogsDetailsSubmitted"));
        String filterUsersByPeriod = request.getParameter("filterUsersByPeriod");
        performedOnSearchKeyword = StringUtils.isBlank((CharSequence)performedOnSearchKeyword) ? "" : MoTwoFactorUtility.sanitizeText(performedOnSearchKeyword).trim();
        performedBySearchKeyword = StringUtils.isBlank((CharSequence)performedBySearchKeyword) ? "" : MoTwoFactorUtility.sanitizeText(performedBySearchKeyword).trim();
        moreDetailsSearchKeyword = StringUtils.isBlank((CharSequence)moreDetailsSearchKeyword) ? "" : MoTwoFactorUtility.sanitizeText(moreDetailsSearchKeyword).trim();
        if (BooleanUtils.toBoolean((Boolean)adminsAuditLogsDetailsSubmitted)) {
            startIndexAsString = "";
            endIndexAsString = "";
        } else {
            if (StringUtils.isNotBlank((CharSequence)performedOnSearchKeyword)) {
                performedOnSearchKeyword = performedOnSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)performedBySearchKeyword)) {
                performedBySearchKeyword = performedBySearchKeyword.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)moreDetailsSearchKeyword)) {
                moreDetailsSearchKeyword = moreDetailsSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)filterUsersByAdminsAction)) {
                filterUsersByAdminsAction = filterUsersByAdminsAction.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)filterUsersByPeriod)) {
                filterUsersByPeriod = filterUsersByPeriod.trim();
            }
            startIndexAsString = request.getParameter("startIndex");
            endIndexAsString = request.getParameter("endIndex");
        }
        if (StringUtils.isBlank((CharSequence)filterUsersByAdminsAction)) {
            filterUsersByAdminsAction = "All Actions";
        }
        if (StringUtils.isBlank((CharSequence)filterUsersByPeriod)) {
            filterUsersByPeriod = "All Days";
        }
        LOGGER.debug("moreDetailsSearchKeyword :" + moreDetailsSearchKeyword);
        LOGGER.debug("filterUsersByAdminsAction :" + filterUsersByAdminsAction);
        List<Object> aoAdminsAuditLogs = new ArrayList();
        aoAdminsAuditLogs = this.moAdminsAuditService.getLogs(this.currentIndex, filterUsersByAdminsAction, performedOnSearchKeyword, performedBySearchKeyword, filterUsersByPeriod, moreDetailsSearchKeyword, 20);
        LOGGER.debug("Admins Audit Logs :" + String.valueOf(aoAdminsAuditLogs));
        LOGGER.debug("Admins audit log size :" + this.moAdminsAuditService.all().size());
        LOGGER.debug(" Admins aoAuditLogs size :" + aoAdminsAuditLogs.size());
        LOGGER.debug(" currentIndex :" + this.currentIndex);
        ArrayList filteredLogs = new ArrayList();
        for (int i = 0; i < aoAdminsAuditLogs.size(); ++i) {
            MoAdminsLogEntity moAdminsLogEntity = (MoAdminsLogEntity)aoAdminsAuditLogs.get(i);
            if (moAdminsLogEntity == null) continue;
            LOGGER.debug("moAdminsLogEntity :" + String.valueOf(moAdminsLogEntity));
            HashMap<String, Object> moAdminsLogEntityHash = new HashMap<String, Object>();
            moAdminsLogEntityHash.put("performedOn", moAdminsLogEntity.getPerformedOn());
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            moAdminsLogEntityHash.put("dateTime", formatter.format(moAdminsLogEntity.getDateAndTime()));
            moAdminsLogEntityHash.put("details", StringUtils.splitByWholeSeparator((String)moAdminsLogEntity.getMoreDetails(), (String)"////"));
            moAdminsLogEntityHash.put("action", moAdminsLogEntity.getAction());
            moAdminsLogEntityHash.put("performedBy", moAdminsLogEntity.getPerformedBy());
            filteredLogs.add(moAdminsLogEntityHash);
        }
        LOGGER.debug("filtered logs size :" + filteredLogs.size());
        this.totalLogs = this.moAdminsAuditService.getSize(filterUsersByAdminsAction, performedOnSearchKeyword, performedBySearchKeyword, filterUsersByPeriod, moreDetailsSearchKeyword);
        this.setAuditIndexes(this.currentIndex, this.totalLogs);
        this.start = (this.currentIndex - 1) * 20;
        this.end = Math.min(this.start + 20, filteredLogs.size());
        ArrayList<HashMap> moLogEntitesHashMap = new ArrayList<HashMap>();
        int count = 0;
        for (int i = 0; i < filteredLogs.size(); ++i) {
            moLogEntitesHashMap.add(count, (HashMap)filteredLogs.get(i));
            ++count;
        }
        Map<String, Object> context = this.initializeConfig(this.currentIndex, this.startIndex, this.prevIndex, this.nextIndex, this.endIndex, this.lastIndex, this.totalLogs, this.start, this.end, "", "", "", filterUsersByPeriod, moLogEntitesHashMap);
        context.put("exportAuditLogsUrl", this.pluginConfiguration.getExportAuditLogsUrl());
        context.put("filterUsersByAdminsAction", filterUsersByAdminsAction);
        context.put("performedOnSearchKeyword", performedOnSearchKeyword);
        context.put("performedBySearchKeyword", performedBySearchKeyword);
        context.put("moreDetailsSearchKeyword", moreDetailsSearchKeyword);
        context.put("filterUsersByPeriod", filterUsersByPeriod);
        context.put("aoAdminsAuditLogs", aoAdminsAuditLogs);
        context.put("moLogEntitesHashMap", moLogEntitesHashMap);
        context.put("pageAccessType", pageAccessType);
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            context.put("message", this.message);
        }
        if (!this.errorMessage.isEmpty()) {
            context.put("errorMessage", this.errorMessage);
        }
        return context;
    }

    private Map<String, Object> initializeConfig(Integer currentIndex, Integer startIndex, Integer prevIndex, Integer nextIndex, Integer endIndex, Integer lastIndex, Integer totalLogs, Integer start, Integer end, String auditLogUsernameSearchKeyword, String auditLogIpSearchKeyword, String filterUsersByAction, String filterUsersByPeriod, List<HashMap> moLogEntitesHashMap) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("auditLogUsernameSearchKeyword", auditLogUsernameSearchKeyword);
        context.put("auditLogIpSearchKeyword", auditLogIpSearchKeyword);
        context.put("filterUsersByAction", filterUsersByAction);
        context.put("filterUsersByPeriod", filterUsersByPeriod);
        context.put("currentIndex", currentIndex);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("prevIndex", prevIndex);
        context.put("nextIndex", nextIndex);
        context.put("totalLogs", totalLogs);
        context.put("lastIndex", lastIndex);
        context.put("start", start);
        context.put("end", end);
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("auditLogSelectedAction", this.settings.getAuditLogsSelectedAction());
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("contextPath", this.pluginSettings.getBaseUrl());
        context.put("filterUsersByPeriod", filterUsersByPeriod);
        context.put("moLogEntitesHashMap", moLogEntitesHashMap);
        context.put("autoDeleteAuditLogs", this.settings.getAutoDeleteAuditLogs());
        context.put("autoDeleteLogsAfterDays", this.settings.getDaysForAutoDeleteLogs().toString());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("isLicenseVerified", this.pluginSettings.getLicenseVerified());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("daysForInfo", this.settings.getDaysForAutoDeleteLogs().toString());
        return context;
    }

    private void setAuditIndexes(Integer currentIndex, Integer tableSize) {
        this.lastIndex = tableSize % 20 != 0 ? Integer.valueOf(tableSize / 20 + 1) : Integer.valueOf(tableSize / 20);
        if (tableSize == 20) {
            this.lastIndex = 1;
        }
        this.prevIndex = currentIndex == 1 ? 1 : currentIndex - 1;
        this.nextIndex = currentIndex == this.lastIndex ? this.lastIndex : currentIndex + 1;
        this.startIndex = currentIndex % 5 == 0 ? currentIndex - 4 : currentIndex - (currentIndex % 5 - 1);
        this.endIndex = Integer.min(this.lastIndex, currentIndex % 5 == 0 ? currentIndex : currentIndex + (5 - currentIndex % 5));
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

