/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAdaptiveAuthenticationAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdaptiveAuthenticationAction.class);
    private static final String ADAPTIVEAUTHENTICATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/adaptiveauthentication.vm";
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings crowdPluginSettings;
    private UserManager userManager;
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorAdaptiveAuthenticationAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, MoTwoFactorCrowdPluginSettings crowdPluginSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.crowdPluginSettings = crowdPluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorAdaptiveAuthenticationAction Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("IP_Restriction");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            this.message = "";
            this.errorMessage = new ArrayList();
            Map<String, Object> context = this.performUserManagement(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(ADAPTIVEAUTHENTICATION_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorAdaptiveAuthenticationAction Servlet doPost() called.");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("IP_Restriction");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            this.message = "";
            this.errorMessage = new ArrayList();
            Map<String, Object> context = this.performUserManagement(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(ADAPTIVEAUTHENTICATION_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private Map<String, Object> performUserManagement(HttpServletRequest request, HttpServletResponse response) throws UnknownHostException {
        Map<String, Object> context;
        LOGGER.debug("performUserManagement called");
        String ipAddress = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddress"));
        String ipAddressMessage = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddressMessage"));
        Boolean whiteListIpFormSubmitted = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("whiteListIpFormSubmitted")));
        StringBuilder builder = new StringBuilder();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getIpManagementSelectedAction(), (CharSequence)"WhitelistIpAction")) {
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            String whiteListIpSearchKeyword = "";
            if (whiteListIpFormSubmitted.booleanValue()) {
                if (StringUtils.isNotBlank((CharSequence)ipAddress)) {
                    if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(ipAddress))) {
                        String validIpAddress = this.pluginHandler.getValidIpAddress(ipAddress);
                        Map<String, String> WhiteistIpAddressAndMessagesInMap = this.settings.getWhitelistIpAddressWithMessages();
                        if (WhiteistIpAddressAndMessagesInMap.containsKey(validIpAddress)) {
                            if (StringUtils.isEmpty((CharSequence)ipAddressMessage) && !WhiteistIpAddressAndMessagesInMap.get(validIpAddress).isEmpty()) {
                                ipAddressMessage = WhiteistIpAddressAndMessagesInMap.get(validIpAddress);
                            }
                        } else if (StringUtils.isEmpty((CharSequence)ipAddressMessage)) {
                            ipAddressMessage = "-";
                        }
                        boolean shouldAddAuditlog = !WhiteistIpAddressAndMessagesInMap.containsKey(validIpAddress) || !StringUtils.equals((CharSequence)WhiteistIpAddressAndMessagesInMap.get(validIpAddress), (CharSequence)ipAddressMessage);
                        this.pluginHandler.saveWhitelistIpAddressAndMessagesInMap(validIpAddress, ipAddressMessage);
                        if (shouldAddAuditlog) {
                            builder.append("Added IP for Whitelisting");
                            builder.append("////");
                            builder.append("Ip Address:" + validIpAddress);
                            builder.append("////");
                            builder.append("IP Description:" + ipAddressMessage.trim());
                            this.pluginHandler.storeAdminsAuditLogs("IP Whitelist", "Updated IP restrictions Tab", builder.toString(), request);
                        }
                        ipAddress = "";
                        ipAddressMessage = "";
                        LOGGER.info("Successfully Added Whitelist IP Address");
                        this.message = "Successfully added Whitelist IP address.";
                    } else {
                        LOGGER.error("Invalid IP Address added");
                        this.errorMessage.add("Invalid IP Address. Please add the valid one.");
                    }
                } else {
                    LOGGER.error("Empty IP Address added");
                    this.errorMessage.add("IP Address is Empty. Please add the valid one.");
                }
                whiteListIpSearchKeyword = "";
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                whiteListIpSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("whiteListIpSearchKeyword"));
                if (StringUtils.isBlank((CharSequence)whiteListIpSearchKeyword)) {
                    whiteListIpSearchKeyword = "";
                }
                if (BooleanUtils.toBoolean((Boolean)whiteListIpFormSubmitted)) {
                    startIndexAsString = "";
                    endIndexAsString = "";
                } else {
                    String searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("whiteListIpSearchKeywordUrl"));
                    if (searchKeyword != null) {
                        whiteListIpSearchKeyword = searchKeyword.trim();
                    }
                    startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                    endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
                }
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString);
                endIndex = Integer.parseInt(endIndexAsString);
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            LOGGER.info("Searching for Whitelist IP using " + whiteListIpSearchKeyword);
            Map<String, String> whitelistIpAddressWithMessagesMap = this.pluginHandler.getStoredIpAddressWithMessage(this.settings.getWhitelistIpAddressWithMessages(), whiteListIpSearchKeyword.trim(), 100);
            Map<String, String> currentPageWhiteListIpAddressWithMessagesMap = this.pluginHandler.getSelectedDetailsForPaginationForIpAddress(whitelistIpAddressWithMessagesMap, startIndex - 1, endIndex - 1);
            Integer numberOfPages = whitelistIpAddressWithMessagesMap.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (whitelistIpAddressWithMessagesMap.size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            context = this.initializeWhitelistDetails(whiteListIpSearchKeyword, ipAddress, ipAddressMessage, selectedPage, startIndex, endIndex, whitelistIpAddressWithMessagesMap, currentPageWhiteListIpAddressWithMessagesMap, numberOfPages, numberOfRecordsPerPage, request);
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                context.put("message", this.message);
            } else if (!this.errorMessage.isEmpty()) {
                context.put("errorMessage", this.errorMessage);
            }
        } else {
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            Boolean blackListIpFormSubmitted = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("blackListIpFormSubmitted")));
            String blackListIpSearchKeyword = "";
            if (BooleanUtils.toBoolean((Boolean)blackListIpFormSubmitted)) {
                Boolean hasError = Boolean.FALSE;
                if (StringUtils.isNotBlank((CharSequence)ipAddress)) {
                    if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(ipAddress))) {
                        String validIpAddress = this.pluginHandler.getValidIpAddress(ipAddress);
                        Map<String, String> BlacklistIpAddressAndMessagesInMap = this.settings.getBlacklistIpAddressWithMessages();
                        if (BlacklistIpAddressAndMessagesInMap.containsKey(validIpAddress)) {
                            if (StringUtils.isEmpty((CharSequence)ipAddressMessage) && !BlacklistIpAddressAndMessagesInMap.get(validIpAddress).isEmpty()) {
                                ipAddressMessage = BlacklistIpAddressAndMessagesInMap.get(validIpAddress);
                            }
                        } else if (StringUtils.isEmpty((CharSequence)ipAddressMessage)) {
                            ipAddressMessage = "-";
                        }
                        boolean shouldAddAuditlog = !BlacklistIpAddressAndMessagesInMap.containsKey(validIpAddress) || !StringUtils.equals((CharSequence)BlacklistIpAddressAndMessagesInMap.get(validIpAddress), (CharSequence)ipAddressMessage);
                        this.pluginHandler.saveBlacklistIpAddressAndMessagesInMap(validIpAddress, ipAddressMessage);
                        if (shouldAddAuditlog) {
                            builder.append("Added IP for blocking");
                            builder.append("////");
                            builder.append("Ip Address:" + validIpAddress);
                            builder.append("////");
                            builder.append("IP Description:" + ipAddressMessage.trim());
                            this.pluginHandler.storeAdminsAuditLogs("IP Blacklist", "Updated IP restrictions Tab", builder.toString(), request);
                        }
                        ipAddress = "";
                        ipAddressMessage = "";
                        hasError = Boolean.FALSE;
                    } else {
                        hasError = Boolean.TRUE;
                        LOGGER.error("Invalid IP Address added");
                        this.errorMessage.add("Invalid IP Address. Please add the valid one.");
                    }
                } else {
                    hasError = Boolean.TRUE;
                    LOGGER.error("Empty IP Address added");
                    this.errorMessage.add("IP Address is empty. Please add the valid one.");
                }
                if (!hasError.booleanValue()) {
                    LOGGER.info("Successfully save configuration");
                    this.message = "Blacklist settings updated.";
                }
                blackListIpSearchKeyword = "";
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String searchKeyword;
                blackListIpSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("blackListIpSearchKeyword"));
                if (StringUtils.isBlank((CharSequence)blackListIpSearchKeyword)) {
                    blackListIpSearchKeyword = "";
                }
                if ((searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("blackListIpSearchKeywordUrl"))) != null) {
                    blackListIpSearchKeyword = searchKeyword.trim();
                }
                startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString);
                endIndex = Integer.parseInt(endIndexAsString);
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            LOGGER.info("Searching for Blacklist IP using " + blackListIpSearchKeyword);
            Map<String, String> blacklistIpAddressWithMessagesMap = this.pluginHandler.getStoredIpAddressWithMessage(this.settings.getBlacklistIpAddressWithMessages(), blackListIpSearchKeyword.trim(), 100);
            Map<String, String> currentPageBlackListIpAddressWithMessagesMap = this.pluginHandler.getSelectedDetailsForPaginationForIpAddress(blacklistIpAddressWithMessagesMap, startIndex - 1, endIndex - 1);
            Integer numberOfPages = blacklistIpAddressWithMessagesMap.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (blacklistIpAddressWithMessagesMap.size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            context = this.initializeBlacklistDetails(blackListIpSearchKeyword, ipAddress, ipAddressMessage, selectedPage, startIndex, endIndex, blacklistIpAddressWithMessagesMap, currentPageBlackListIpAddressWithMessagesMap, numberOfPages, numberOfRecordsPerPage, request);
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                context.put("message", this.message);
            } else if (!this.errorMessage.isEmpty()) {
                context.put("errorMessage", this.errorMessage);
            }
        }
        if (BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("ClientRequestedIPHeaderSubmitted")))) {
            String clientIpRequestHeader = MoTwoFactorUtility.sanitizeText(request.getParameter("clientIpRequestHeader"));
            if (!StringUtils.equals((CharSequence)clientIpRequestHeader, (CharSequence)this.settings.getClientIpRequestHeader())) {
                builder = new StringBuilder();
                builder.append("Updated Request header");
                builder.append("//// ////");
                builder.append("Http Request Header: " + clientIpRequestHeader);
                builder.append("//// ////");
                this.pluginHandler.storeAdminsAuditLogs("Request Header", "Updated IP restrictions Tab", builder.toString(), request);
            }
            this.settings.setClientIpRequestHeader(clientIpRequestHeader);
            response.setIntHeader("Refresh", 0);
        }
        context.put("currentIPAddress", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("licenseType", this.crowdPluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.crowdPluginSettings.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.crowdPluginSettings.isNoOfUserExceed());
        context.put("isLicenseExpired", this.crowdPluginSettings.isLicenseExpired());
        context.put("daysLeftToExpire", this.crowdPluginSettings.getDaysLeftToExpire());
        return context;
    }

    private Map<String, Object> initializeBlacklistDetails(String blackListIpSearchKeyword, String ipAddress, String ipAddressMessage, Integer selectedPage, Integer startIndex, Integer endIndex, Map<String, String> blacklistIpAddressWithMessagesMap, Map<String, String> currentPageBlackListIpAddressWithMessagesMap, Integer numberOfPages, Integer numberOfRecordsPerPage, HttpServletRequest request) {
        LOGGER.debug("inside initializeBlacklistDetails...");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("blackListIpSearchKeyword", blackListIpSearchKeyword);
        context.put("ipAddress", ipAddress);
        context.put("ipAddressMessage", ipAddressMessage);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("blacklistIpAddressWithMessagesMap", blacklistIpAddressWithMessagesMap);
        context.put("currentPageBlackListIpAddressWithMessagesMap", currentPageBlackListIpAddressWithMessagesMap);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("ipManagementSelectedAction", this.settings.getIpManagementSelectedAction());
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("clientIpRequestHeader", this.settings.getClientIpRequestHeader());
        context.put("displayRequestHeader", this.settings.getRequestInfo(request));
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("IP_Restriction"));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        return context;
    }

    private Map<String, Object> initializeWhitelistDetails(String whiteListIpSearchKeyword, String ipAddress, String ipAddressMessage, Integer selectedPage, Integer startIndex, Integer endIndex, Map<String, String> whitelistIpAddressWithMessagesMap, Map<String, String> currentPageWhiteListIpAddressWithMessagesMap, Integer numberOfPages, Integer numberOfRecordsPerPage, HttpServletRequest request) {
        LOGGER.debug("inside initializeWhitelistDetails...");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("whiteListIpSearchKeyword", whiteListIpSearchKeyword);
        context.put("ipAddress", ipAddress);
        context.put("ipAddressMessage", ipAddressMessage);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("whitelistIpAddressWithMessagesMap", whitelistIpAddressWithMessagesMap);
        context.put("currentPageWhiteListIpAddressWithMessagesMap", currentPageWhiteListIpAddressWithMessagesMap);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        context.put("ipManagementSelectedAction", this.settings.getIpManagementSelectedAction());
        context.put("message", "");
        context.put("errorMessage", "");
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("clientIpRequestHeader", this.settings.getClientIpRequestHeader());
        context.put("displayRequestHeader", this.settings.getRequestInfo(request));
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("IP_Restriction"));
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        return context;
    }

    private Boolean validateIpAddress(String ipAddress) {
        try {
            if (StringUtils.isBlank((CharSequence)ipAddress)) {
                return Boolean.FALSE;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)(ipAddress = ipAddress.trim()), (CharSequence)".") || StringUtils.endsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)".")) {
                return Boolean.FALSE;
            }
            String[] segment = ipAddress.split("/");
            if (segment.length == 2) {
                InetAddress inetAddress = this.pluginHandler.isIPaddressValid(segment[0]);
                if (inetAddress.getAddress().length == 4) {
                    if (Integer.parseInt(segment[1]) <= 32 && Integer.parseInt(segment[1]) >= 1) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (inetAddress.getAddress().length == 16) {
                    if (Integer.parseInt(segment[1]) <= 128 && Integer.parseInt(segment[1]) >= 1) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            InetAddress inetAddress = this.pluginHandler.isIPaddressValid(ipAddress);
            if (inetAddress.getAddress().length == 4) {
                String[] parts = ipAddress.split("\\.");
                if (parts.length < 1 || parts.length > 4) {
                    return Boolean.FALSE;
                }
                for (String part : parts) {
                    int i = Integer.parseInt(part);
                    if (i >= 0 && i <= 255 && part.length() <= 3) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (inetAddress.getAddress().length == 16) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public List<String> getNumberOfPagesList(int numberOfPages) {
        ArrayList<String> numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= numberOfPages; ++i) {
            numberOfPagesList.add("" + i);
        }
        return numberOfPagesList;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TemplateRenderer renderer) {
        this.renderer = renderer;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoTwoFactorCrowdPluginSettings getCrowdPluginSettings() {
        return this.crowdPluginSettings;
    }

    public void setCrowdPluginSettings(MoTwoFactorCrowdPluginSettings crowdPluginSettings) {
        this.crowdPluginSettings = crowdPluginSettings;
    }
}

