/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.inject.Named;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class PluginInstallEvent
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(PluginInstallEvent.class);
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    public static HashMap<String, List<String>> encryptionKeys;

    public PluginInstallEvent(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Plugin installed");
        if (StringUtils.isBlank((CharSequence)this.pluginSettings.getLicenseVerifiedWithoutDefaultValue())) {
            this.generateTrial();
        }
        this.generateDynamicEncryptionKeys();
    }

    public void destroy() throws Exception {
    }

    private void generateTrial() {
        try {
            LOGGER.debug("Generating freemium trial");
            Date expiry = DateUtils.addMonths((Date)new Date(), (int)1);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
            this.pluginSettings.setCustomerAPIKey("NA");
            this.pluginSettings.setCustomerEmail("-");
            this.pluginSettings.setCustomerId("NA");
            this.pluginSettings.setCustomerTokenKey("NYFz3WIfBEn3DUHx");
            this.pluginSettings.setLicenseVerified(Boolean.TRUE);
            this.pluginSettings.setLicenseType("TRIAL");
            this.pluginSettings.setLicencedUsers(10);
            this.pluginSettings.setLicenseExpireDate(dateFormatter.format(expiry));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating freemium license", e);
        }
    }

    public void generateDynamicEncryptionKeys() {
        if (encryptionKeys == null) {
            encryptionKeys = new HashMap();
        }
        ArrayList<String> currKeyDetails = new ArrayList<String>();
        String currentEncryptionKey = MoTwoFactorUtility.generateRandomString(16);
        Calendar calendar = Calendar.getInstance();
        long validUntilTime = calendar.getTimeInMillis() + 120000L;
        currKeyDetails.add(currentEncryptionKey);
        currKeyDetails.add(String.valueOf(validUntilTime));
        encryptionKeys.put("currentKey", currKeyDetails);
        ArrayList<String> prevKeyDetails = new ArrayList<String>();
        prevKeyDetails.add("CROWD2FADYNAMICSUCCESS");
        prevKeyDetails.add(String.valueOf(0));
        encryptionKeys.put("previousKey", prevKeyDetails);
    }
}

