/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.mail.MailConfiguration;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.mail.SMTPServer;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.duosecurity.client.Http;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.miniorange.twofactor.crowd.Customer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.PluginInstallEvent;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonAuditLogDetails;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.common.entity.MoAdminsLogEntity;
import com.miniorange.twofactor.crowd.common.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.utility.MoHttpUtils;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class MoTwoFactorPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorPluginHandler.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private CrowdService crowdService;
    private UserManager userManager;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MailManager mailManager;
    private TransactionTemplate transactionTemplate;
    private MoAdminsAuditService moAdminsAuditService;
    private MoLogEntityService moLogEntityService;
    private CrowdDirectoryService crowdDirectoryService;
    private DirectoryManager directoryManager;
    private ApplicationManager applicationManager;

    public MoTwoFactorPluginHandler(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, CrowdService crowdService, MoTwoFactorCrowdPluginSettings pluginSettings, MailManager mailManager, TransactionTemplate transactionTemplate, MoAdminsAuditService moAdminsAuditService, MoLogEntityService moLogEntityService, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.pluginSettings = pluginSettings;
        this.mailManager = mailManager;
        this.transactionTemplate = transactionTemplate;
        this.moAdminsAuditService = moAdminsAuditService;
        this.moLogEntityService = moLogEntityService;
        this.directoryManager = directoryManager;
        this.applicationManager = applicationManager;
    }

    public void saveAdvanced2FASettings(Boolean enableBruteForceProtection, String bruteForceNumberOfAttempts, String bruteForceTimeInterval, String bruteForceCustomTimeInterval, String bruteForceCustomTimeDuration, String emailTemplateBruteForce, Boolean enableRememberMeDevice, String rememberMeDeviceDuration, Boolean allowUserSpecificRememberMeDeviceDuration, Boolean bypass2faAfterCrowdSso, String secretKeyForOneTime2FAValidation, String bypass2FACookieDomain, Boolean ignore2FAAfterSso, String skip2faUrls, Map<String, String> pagesWithGroupAccessMapping, Boolean multiLingualSupportToggle, Boolean allowedToReconfigureMethod, Boolean enableEnforceCurrentMethod, String primaryMethodForUser, Boolean showAllConfiguredMethodsDirectly, Boolean showRemaining2FAMethodsAfterConfiguration, String keyProvidedByCrowdSso, Boolean redirectionBasedOnAbsoluteUrl, Map<String, String> mfaMethodsBasedOnGroupsNewMap, List<String> fallBackMethods, HttpServletRequest request) {
        String Page;
        LOGGER.debug("Saving Advanced Two Factor Settings : , enableRememberMeDevice : " + enableRememberMeDevice + ", rememberMeDeviceDuration : " + rememberMeDeviceDuration + ", allowUserSpecificRememberMeDeviceDuration : " + allowUserSpecificRememberMeDeviceDuration + ", enableBruteForceProtection : " + enableBruteForceProtection + ", bruteForceNumberOfAttempts : " + bruteForceNumberOfAttempts + ", bruteForceTimeInterval : " + bruteForceTimeInterval + ", bruteForceCustomTimeInterval : " + bruteForceCustomTimeInterval + ", bruteForceCustomTimeDuration : " + bruteForceCustomTimeDuration + ", emailTemplateBruteForce : " + emailTemplateBruteForce + ", bypass2FACookieDomain : " + bypass2FACookieDomain + ", secretKeyForOneTime2FAValidation : " + secretKeyForOneTime2FAValidation + ", bypass2faAfterCrowdSso : " + bypass2faAfterCrowdSso + ", ignore2FAAfterSso : " + ignore2FAAfterSso + ", skip2faUrls : " + skip2faUrls + ",redirectionBasedOnAbsoluteUrl :" + redirectionBasedOnAbsoluteUrl + ", pagesWithGroupAccessMapping :" + String.valueOf(pagesWithGroupAccessMapping) + ", multiLingualSupportToggle : " + multiLingualSupportToggle + ", allowedToReconfigureMethod: " + allowedToReconfigureMethod + ", enableEnforceCurrentMethod: " + enableEnforceCurrentMethod + ", primaryMethodForUser: " + primaryMethodForUser + ", showAllConfiguredMethodsDirectly: " + showAllConfiguredMethodsDirectly + ", showRemaining2FAMethodsAfterConfiguration: " + showRemaining2FAMethodsAfterConfiguration + ", keyProvidedByCrowdSso: " + keyProvidedByCrowdSso + ",mfaMethodsBasedOnGroupsNewMap :" + String.valueOf(mfaMethodsBasedOnGroupsNewMap) + ",fallBackMethods :" + String.valueOf(fallBackMethods));
        StringBuilder builder = new StringBuilder();
        ArrayList<String> addedMethods = new ArrayList<String>();
        ArrayList<String> removedMethods = new ArrayList<String>();
        List<String> oldFallBackMethods = this.settings.getFallBackMethods();
        if (mfaMethodsBasedOnGroupsNewMap.isEmpty()) {
            fallBackMethods = new ArrayList<String>();
        }
        for (String method : oldFallBackMethods) {
            if (fallBackMethods.contains(method)) continue;
            removedMethods.add(method);
        }
        for (String method : fallBackMethods) {
            if (oldFallBackMethods.contains(method)) continue;
            addedMethods.add(method);
        }
        if (addedMethods.size() > 0) {
            builder.append("Added Methods for Fallback: " + String.valueOf(addedMethods));
            builder.append("////");
        }
        if (removedMethods.size() > 0) {
            builder.append("Removed Methods for Fallback: " + String.valueOf(removedMethods));
            builder.append("//// ////");
        }
        Map<String, String> mfaMethodsBasedOngroupsOldMap = this.settings.getMfaMethodsBasedOnGroupsMap();
        int count = 1;
        for (Map.Entry<String, String> k : mfaMethodsBasedOnGroupsNewMap.entrySet()) {
            if (mfaMethodsBasedOngroupsOldMap.containsKey(k.getKey())) {
                if (StringUtils.equalsIgnoreCase((CharSequence)k.getValue(), (CharSequence)mfaMethodsBasedOngroupsOldMap.get(k.getKey()))) continue;
                Page = k.getKey();
                if (!builder.toString().contains("Updated")) {
                    builder.append("////");
                    builder.append("Updated-");
                    builder.append("////");
                }
                builder.append(count).append(") ").append(Page).append(": ").append(k.getValue());
                builder.append("////");
                ++count;
                continue;
            }
            Page = k.getKey();
            if (!builder.toString().contains("Updated")) {
                builder.append("////");
                builder.append("Updated-");
                builder.append("////");
            }
            builder.append(count).append(") ").append(Page).append(": ").append(k.getValue());
            builder.append("////");
            ++count;
        }
        for (Map.Entry<String, String> k : mfaMethodsBasedOngroupsOldMap.entrySet()) {
            if (mfaMethodsBasedOnGroupsNewMap.containsKey(k.getKey())) continue;
            Page = k.getKey();
            if (!builder.toString().contains("Removed-")) {
                builder.append("////");
                builder.append("////");
                builder.append("Removed-");
                builder.append("////");
            }
            builder.append(count).append(") ").append(Page).append(": ").append(k.getValue());
            builder.append("////");
            ++count;
        }
        if (builder.length() != 0) {
            this.storeAdminsAuditLogs("2FA Methods Based on Groups", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setMfaMethodsBasedOnGroupsMap(mfaMethodsBasedOnGroupsNewMap);
        this.settings.setFallBackMethods(fallBackMethods);
        builder = new StringBuilder();
        if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice) != this.settings.getEnableRememberMeDevice() || rememberMeDeviceDuration != null && Integer.parseInt(rememberMeDeviceDuration) != this.settings.getRememberMeDeviceDuration() || BooleanUtils.toBoolean((Boolean)allowUserSpecificRememberMeDeviceDuration) != this.settings.getAllowUserSpecificRememberMeDeviceDuration()) {
            if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice) != this.settings.getEnableRememberMeDevice()) {
                builder.append("Remember My Device status: " + BooleanUtils.toBoolean((Boolean)enableRememberMeDevice));
                builder.append("////");
            }
            if (rememberMeDeviceDuration != null && Integer.parseInt(rememberMeDeviceDuration) != this.settings.getRememberMeDeviceDuration()) {
                builder.append("Expiry Time (in Days): " + Integer.parseInt(rememberMeDeviceDuration));
                builder.append("////");
            }
            if (BooleanUtils.toBoolean((Boolean)allowUserSpecificRememberMeDeviceDuration) != this.settings.getAllowUserSpecificRememberMeDeviceDuration()) {
                builder.append("Allow User Specific Remember My Device Status:  " + BooleanUtils.toBoolean((Boolean)allowUserSpecificRememberMeDeviceDuration));
                builder.append("////");
            }
            this.storeAdminsAuditLogs("Remember My Device", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setEnableRememberMeDevice(enableRememberMeDevice);
        if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice)) {
            this.settings.setRememberMeDeviceDuration(Integer.parseInt(rememberMeDeviceDuration));
            this.settings.setAllowUserSpecificRememberMeDeviceDuration(allowUserSpecificRememberMeDeviceDuration);
        }
        builder = new StringBuilder();
        if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection) != this.settings.getEnableBruteForceProtection() || bruteForceNumberOfAttempts != null && Integer.parseInt(bruteForceNumberOfAttempts) != this.settings.getBruteForceNumberOfAttempts() || bruteForceTimeInterval != null && !bruteForceTimeInterval.equals(this.settings.getBruteForceTimeInterval()) || emailTemplateBruteForce != null && !StringUtils.equals((CharSequence)emailTemplateBruteForce, (CharSequence)this.settings.getEmailTemplateBruteForce())) {
            if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection) != this.settings.getEnableBruteForceProtection()) {
                builder.append("Brute Force Protection Status:  " + BooleanUtils.toBoolean((Boolean)enableBruteForceProtection));
                builder.append("////");
            }
            if (bruteForceNumberOfAttempts != null && Integer.parseInt(bruteForceNumberOfAttempts) != this.settings.getBruteForceNumberOfAttempts()) {
                builder.append("Number of Attempts: " + bruteForceNumberOfAttempts);
                builder.append("////");
            }
            if (bruteForceTimeInterval != null && !bruteForceTimeInterval.equals(this.settings.getBruteForceTimeInterval())) {
                builder.append("User Locked out Period: " + bruteForceTimeInterval);
                builder.append("////");
            }
            if (!StringUtils.equals((CharSequence)emailTemplateBruteForce, (CharSequence)this.settings.getEmailTemplateBruteForce()) && enableBruteForceProtection.booleanValue()) {
                builder.append("Email Template updated");
                builder.append("////");
            }
            this.storeAdminsAuditLogs("Brute Force Protection", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setEnableBruteForceProtection(enableBruteForceProtection);
        if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection)) {
            this.settings.setBruteForceNumberOfAttempts(Integer.parseInt(bruteForceNumberOfAttempts));
            this.settings.setBruteForceTimeInterval(bruteForceTimeInterval);
            this.settings.setBruteForceCustomTimeInterval(bruteForceCustomTimeInterval);
            this.settings.setBruteForceCustomTimeDuration(Integer.parseInt(bruteForceCustomTimeDuration));
            this.settings.setEmailTemplateBruteForce(emailTemplateBruteForce);
        }
        this.modifyAndSaveStringOfSkip2FAUrls(skip2faUrls, request);
        builder = new StringBuilder();
        if (BooleanUtils.toBoolean((Boolean)bypass2faAfterCrowdSso) != this.settings.getBypass2faAfterCrowdSso() || StringUtils.isNotBlank((CharSequence)bypass2FACookieDomain) && !StringUtils.equals((CharSequence)bypass2FACookieDomain, (CharSequence)this.settings.getBypass2FACookieDomain()) || StringUtils.isNotBlank((CharSequence)secretKeyForOneTime2FAValidation) && !StringUtils.equals((CharSequence)secretKeyForOneTime2FAValidation, (CharSequence)this.settings.getSecretKeyForOneTime2FAValidation())) {
            if (BooleanUtils.toBoolean((Boolean)bypass2faAfterCrowdSso) != this.settings.getBypass2faAfterCrowdSso()) {
                builder.append("One Time 2FA Validation Status:  " + BooleanUtils.toBoolean((Boolean)bypass2faAfterCrowdSso));
                builder.append("////");
            }
            if (StringUtils.isNotBlank((CharSequence)bypass2FACookieDomain) && !StringUtils.equals((CharSequence)bypass2FACookieDomain, (CharSequence)this.settings.getBypass2FACookieDomain())) {
                builder.append("Crowd SSO Domain: " + bypass2FACookieDomain);
                builder.append("////");
            }
            if (StringUtils.isNotBlank((CharSequence)secretKeyForOneTime2FAValidation) && !StringUtils.equals((CharSequence)secretKeyForOneTime2FAValidation, (CharSequence)this.settings.getSecretKeyForOneTime2FAValidation())) {
                builder.append("Secret Key: " + secretKeyForOneTime2FAValidation);
                builder.append("////");
            } else if (StringUtils.isBlank((CharSequence)secretKeyForOneTime2FAValidation)) {
                builder.append("Secret Key: MO2FA_BYPASS_2FA");
                builder.append("////");
            }
            this.storeAdminsAuditLogs("One Time 2FA Validation", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setBypass2faAfterCrowdSso(bypass2faAfterCrowdSso);
        this.settings.setBypass2FACookieDomain(bypass2FACookieDomain);
        this.settings.setSecretKeyForOneTime2FAValidation(secretKeyForOneTime2FAValidation);
        builder = new StringBuilder();
        if (BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso) != this.settings.getIgnore2FAAfterSso() || StringUtils.isNotBlank((CharSequence)keyProvidedByCrowdSso) && !StringUtils.equals((CharSequence)keyProvidedByCrowdSso, (CharSequence)this.settings.getSecretKeyProvidedByCrowdSso())) {
            if (BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso) != this.settings.getIgnore2FAAfterSso()) {
                builder.append("Skip 2FA for Crowd SSO Users: " + BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso));
                builder.append("////");
            }
            if (StringUtils.isNotBlank((CharSequence)keyProvidedByCrowdSso) && !StringUtils.equals((CharSequence)keyProvidedByCrowdSso, (CharSequence)this.settings.getSecretKeyProvidedByCrowdSso())) {
                builder.append("Secret Key Provided by Crowd SSO: " + keyProvidedByCrowdSso);
                builder.append("////");
            }
            this.storeAdminsAuditLogs("Skip 2FA on SSO", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setIgnore2FAAfterSso(ignore2FAAfterSso);
        if (BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso)) {
            this.settings.setSecretKeyProvidedByCrowdSso(keyProvidedByCrowdSso);
        }
        this.settings.setGroupsWithAdminPagesAccess(pagesWithGroupAccessMapping);
        if (BooleanUtils.toBoolean((Boolean)multiLingualSupportToggle) != this.settings.getMultiLingualSupportToggle()) {
            this.storeAdminsAuditLogs("Multilingual Support for Users", "Updated Advanced Options Tab", "Multilingual Support for Users :  " + BooleanUtils.toBoolean((Boolean)multiLingualSupportToggle), request);
        }
        this.settings.setMultiLingualSupportToggle(multiLingualSupportToggle);
        if (BooleanUtils.toBoolean((Boolean)allowedToReconfigureMethod) != this.settings.getAllowToReconfigureConfigured2faMethod()) {
            if (BooleanUtils.toBoolean((Boolean)allowedToReconfigureMethod)) {
                this.storeAdminsAuditLogs("Allow to Reconfigure 2FA Method", "Updated Advanced Options Tab", "Enabled Allow to Reconfigure 2FA method", request);
            } else {
                this.storeAdminsAuditLogs("Allow to Reconfigure 2FA Method", "Updated Advanced Options Tab", "Disabled Allow to Reconfigure 2FA method", request);
            }
        }
        this.settings.setAllowToReconfigureConfigured2faMethod(allowedToReconfigureMethod);
        if (BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod) != this.settings.getEnableEnforce2faMethodForUser() || !primaryMethodForUser.equalsIgnoreCase(this.settings.getPrimary2faMethodForUser()) && BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod)) {
            builder = new StringBuilder();
            if (BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod) != this.settings.getEnableEnforce2faMethodForUser()) {
                builder.append("Enforce 2fa Method: " + BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod));
                builder.append("//// ////");
            }
            if (BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod)) {
                builder.append("Method: " + primaryMethodForUser);
                builder.append("//// ////");
            }
            this.storeAdminsAuditLogs("Enforce 2FA Method", "Updated Advanced Options Tab", builder.toString(), request);
        }
        this.settings.setEnableEnforce2faMethodForUser(enableEnforceCurrentMethod);
        this.settings.setPrimary2faMethodForUser(primaryMethodForUser);
        if (BooleanUtils.toBoolean((Boolean)showAllConfiguredMethodsDirectly) != this.settings.getShowAllConfiguredMethodToUser()) {
            this.storeAdminsAuditLogs("Show All Configured Methods Validation", "Updated Advanced Options Tab", "Show All Configured Methods to User for 2FA Validation :  " + BooleanUtils.toBoolean((Boolean)showAllConfiguredMethodsDirectly), request);
        }
        this.settings.setShowAllConfiguredMethodToUser(showAllConfiguredMethodsDirectly);
        if (BooleanUtils.toBoolean((Boolean)redirectionBasedOnAbsoluteUrl) != this.settings.getRedirectionBasedOnAbsoluteUrl()) {
            this.storeAdminsAuditLogs("Redirection Based on Absolute URL", "Updated Advanced Options Tab", "Redirection Based on Absolute URL :  " + BooleanUtils.toBoolean((Boolean)redirectionBasedOnAbsoluteUrl), request);
        }
        this.settings.setRedirectionBasedOnAbsoluteUrl(redirectionBasedOnAbsoluteUrl);
        if (BooleanUtils.toBoolean((Boolean)showRemaining2FAMethodsAfterConfiguration) != this.settings.getShowRemaining2FAMethodsAfterInlineRegistration()) {
            this.storeAdminsAuditLogs("Show Remaining 2FA methods after configuration", "Updated Advanced Options Tab", "Show Remaining 2FA methods after configuration :  " + BooleanUtils.toBoolean((Boolean)showRemaining2FAMethodsAfterConfiguration), request);
        }
        this.settings.setShowRemaining2FAMethodsAfterInlineRegistration(showRemaining2FAMethodsAfterConfiguration);
    }

    public void modifyAndSaveStringOfSkip2FAUrls(String skip2FAUrls, HttpServletRequest request) {
        List<String> skip2FAForGivenUrlList = this.settings.getSkip2FAForGivenUrlList();
        String[] urls2 = skip2FAUrls.split(";");
        for (int index = 0; index < urls2.length; ++index) {
            urls2[index] = StringUtils.trim((String)urls2[index]);
            if (urls2[index].isEmpty() || skip2FAForGivenUrlList.contains(urls2[index])) continue;
            if (request != null) {
                this.storeAdminsAuditLogs("Skip 2FA for API", "Updated Advanced Options Tab", "Added :  " + urls2[index], request);
            }
            skip2FAForGivenUrlList.add(urls2[index]);
        }
        this.settings.setSkip2FAForGivenUrlList(skip2FAForGivenUrlList);
    }

    public void save2FATemplateSettings(String welcomeMessageTemplate, String configureGoogleAuthenticatorTemplate, String validateGoogleAuthenticatorTemplate, String configureSecurityQuestionTemplate, String validateSecurityQuestionTemplate, String configureOtpOverEmailTemplate, String validateOtpOverEmailTemplate, String configureOtpOverSMSTemplate, String validateOtpOverSMSTemplate, String configureDuoPushNotificationTemplate, String validateDuoPushNotificationTemplate, String configureHardwareTokenTemplate, String validateHardwareTokenTemplate, String configureWebAuthenticationTemplate, String validateWebAuthenticationTemplate, String configureBackupCodeTemplate, String validateBackupCodeTemplate, String lockedUsersTemplate, String blocklistIpTemplate, String inlineRegistration_2faMethodListTemplate, String inlineRegistration_backupMethodListTemplate, String inlineRegistration_remaining2faMethodsListTemplate, String validate_2faMethodListTemplate, List<String> securityQuestionsList, HttpServletRequest request) {
        LOGGER.debug("Calling save2FATemplateSettings");
        StringBuilder builder = new StringBuilder();
        builder.append("Updated templates for://// ////");
        if (!this.pluginSettings.getWelcomeMessageTemplate().equals(welcomeMessageTemplate)) {
            builder.append("Welcome Prompt////");
            this.pluginSettings.setWelcomeMessageTemplate(welcomeMessageTemplate);
        }
        if (!this.pluginSettings.getInlineRegistration_2faMethodListTemplate().equals(inlineRegistration_2faMethodListTemplate)) {
            builder.append("Inline Registration 2FA Method List////");
            this.pluginSettings.setInlineRegistration_2faMethodListTemplate(inlineRegistration_2faMethodListTemplate);
        }
        if (!this.pluginSettings.getValidate_2faMethodListTemplate().equals(validate_2faMethodListTemplate)) {
            builder.append("Validate 2FA Method List////");
            this.pluginSettings.setValidate_2faMethodListTemplate(validate_2faMethodListTemplate);
        }
        if (!this.pluginSettings.getInlineRegistration_backupMethodListTemplate().equals(inlineRegistration_backupMethodListTemplate)) {
            builder.append("Inline Registration Backup Method////");
            this.pluginSettings.setInlineRegistration_backupMethodListTemplate(inlineRegistration_backupMethodListTemplate);
        }
        if (!this.pluginSettings.getInlineRegistration_remaining2faMethodsListTemplate().equals(inlineRegistration_remaining2faMethodsListTemplate)) {
            builder.append("Inline Registration Remaining 2FA Method List////");
            this.pluginSettings.setInlineRegistration_remaining2faMethodsListTemplate(inlineRegistration_remaining2faMethodsListTemplate);
        }
        if (!this.pluginSettings.getConfigureGoogleAuthenticatorTemplate().equals(configureGoogleAuthenticatorTemplate)) {
            builder.append("Configure Mobile Authenticator ////");
            this.pluginSettings.setConfigureGoogleAuthenticatorTemplate(configureGoogleAuthenticatorTemplate);
        }
        if (!this.pluginSettings.getValidateGoogleAuthenticatorTemplate().equals(validateGoogleAuthenticatorTemplate)) {
            builder.append("Validate Mobile Authenticator ////");
            this.pluginSettings.setValidateGoogleAuthenticatorTemplate(validateGoogleAuthenticatorTemplate);
        }
        if (!this.pluginSettings.getConfigureSecurityQuestionTemplate().equals(configureSecurityQuestionTemplate)) {
            builder.append("Configure Security Question  ////");
            this.pluginSettings.setConfigureSecurityQuestionTemplate(configureSecurityQuestionTemplate);
        }
        if (!this.pluginSettings.getValidateSecurityQuestionTemplate().equals(validateSecurityQuestionTemplate)) {
            builder.append("Validate Security Question  ////");
            this.pluginSettings.setValidateSecurityQuestionTemplate(validateSecurityQuestionTemplate);
        }
        if (!this.pluginSettings.getConfigureOtpOverEmailTemplate().equals(configureOtpOverEmailTemplate)) {
            builder.append("Configure OTP Over Email  ////");
            this.pluginSettings.setConfigureOtpOverEmailTemplate(configureOtpOverEmailTemplate);
        }
        if (!this.pluginSettings.getValidateOtpOverEmailTemplate().equals(validateOtpOverEmailTemplate)) {
            builder.append("Validate OTP Over Email  ////");
            this.pluginSettings.setValidateOtpOverEmailTemplate(validateOtpOverEmailTemplate);
        }
        if (!this.pluginSettings.getConfigureBackupCodeTemplate().equals(configureBackupCodeTemplate)) {
            builder.append("Configure Backup Code  ////");
            this.pluginSettings.setConfigureBackupCodeTemplate(configureBackupCodeTemplate);
        }
        if (!this.pluginSettings.getValidateBackupCodeTemplate().equals(validateBackupCodeTemplate)) {
            builder.append("Validate Backup Code  ////");
            this.pluginSettings.setValidateBackupCodeTemplate(validateBackupCodeTemplate);
        }
        if (!this.pluginSettings.getLockedUserTemplate().equals(lockedUsersTemplate)) {
            builder.append("Locked Users Template  ////");
            this.pluginSettings.setLockedUserTemplate(lockedUsersTemplate);
        }
        if (!this.pluginSettings.getBlocklistIpTemplate().equals(blocklistIpTemplate)) {
            builder.append("Blocklist IP Template  ////");
            this.pluginSettings.setBlocklistIpTemplate(blocklistIpTemplate);
        }
        if (!this.pluginSettings.getConfigureWebAuthnHardwareTokenTemplate().equals(configureHardwareTokenTemplate)) {
            builder.append("Configure Yubikey Hardware Token  ////");
            this.pluginSettings.setConfigureWebAuthnHardwareTokenTemplate(configureHardwareTokenTemplate);
        }
        if (!this.pluginSettings.getValidateWebAuthnHardwareTokenTemplate().equals(validateHardwareTokenTemplate)) {
            builder.append("Validate Yubikey Hardware Token  ////");
            this.pluginSettings.setValidateWebAuthnHardwareTokenTemplate(validateHardwareTokenTemplate);
        }
        if (!this.pluginSettings.getConfigureOtpOverSmsTemplate().equals(configureOtpOverSMSTemplate)) {
            builder.append("Configure OTP over SMS  ////");
            this.pluginSettings.setConfigureOtpOverSmsTemplate(configureOtpOverSMSTemplate);
        }
        if (!this.pluginSettings.getValidateOtpOverSmsTemplate().equals(validateOtpOverSMSTemplate)) {
            builder.append("Validate OTP over SMS  ////");
            this.pluginSettings.setValidateOtpOverSmsTemplate(validateOtpOverSMSTemplate);
        }
        if (!this.pluginSettings.getConfigureWebAuthnAs2faMethodTemplate().equals(configureWebAuthenticationTemplate)) {
            builder.append("Configure Web Authentication  ////");
            this.pluginSettings.setConfigureWebAuthnAs2faMethodTemplate(configureWebAuthenticationTemplate);
        }
        if (!this.pluginSettings.getValidateWebAuthnAs2faMethodTemplate().equals(validateWebAuthenticationTemplate)) {
            builder.append("Validate Web Authentication  ////");
            this.pluginSettings.setValidateWebAuthnAs2faMethodTemplate(validateWebAuthenticationTemplate);
        }
        if (!this.pluginSettings.getConfigureDuoPushNotificationTemplate().equals(configureDuoPushNotificationTemplate)) {
            builder.append("Configure Duo Push Notification  ////");
            this.pluginSettings.setConfigureDuoPushNotificationTemplate(configureDuoPushNotificationTemplate);
        }
        if (!this.pluginSettings.getValidateDuoPushNotificationTemplate().equals(validateDuoPushNotificationTemplate)) {
            builder.append("Validate Duo Push Notification  ////");
            this.pluginSettings.setValidateDuoPushNotificationTemplate(validateDuoPushNotificationTemplate);
        }
        if (securityQuestionsList.size() == 0) {
            securityQuestionsList = MoTwoFactorUtility.getQuestionList();
        }
        this.settings.setSecurityQuestionsList(securityQuestionsList);
        if (builder.length() > 31) {
            this.storeAdminsAuditLogs("-", "Updated Look and Feel Tab", builder.toString(), request);
        }
    }

    public List<String> getFromList(List<String> userList, String searchKeyword, String userStatusFilter, String userSearchParameter, int maxCount) {
        if (StringUtils.isBlank((CharSequence)searchKeyword) && StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") && !StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
            int endIndex = Math.min(userList.size(), maxCount + 20);
            return userList.subList(maxCount, endIndex);
        }
        Boolean isActiveList = Boolean.TRUE;
        if (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"InActiveUsers")) {
            isActiveList = Boolean.FALSE;
        }
        LinkedList<String> userToReturn = new LinkedList<String>();
        int count = 0;
        if (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
            Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
            for (Map.Entry<String, String> entry : configuredMobileNumbers.entrySet()) {
                if (!entry.getValue().contains(searchKeyword) || !userList.contains(entry.getKey())) continue;
                if (!StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers")) {
                    EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)entry.getKey())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1);
                    List usersFromSystem = (List)this.crowdService.search((Query)query);
                    if (usersFromSystem.isEmpty() || ++count <= maxCount) continue;
                    userToReturn.add(entry.getKey());
                    if (userToReturn.size() != 20) continue;
                    return userToReturn;
                }
                if (++count <= maxCount) continue;
                userToReturn.add(entry.getKey());
                if (userToReturn.size() != 20) continue;
                return userToReturn;
            }
        } else {
            EntityQuery query = StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") ? (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim())})).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())})).returningAtMost(-1)) : (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1));
            Iterable usersFromSystem = this.crowdService.search((Query)query);
            for (User user : usersFromSystem) {
                String username = user.getName();
                if (!userList.contains(username)) continue;
                if (count >= maxCount) {
                    userToReturn.add(username);
                    if (userToReturn.size() == 20) {
                        return userToReturn;
                    }
                }
                ++count;
            }
        }
        return userToReturn;
    }

    public void storeAdminsAuditLogs(String performedOn, String action, String details, HttpServletRequest request) {
        try {
            String ip = "";
            Calendar calendar = Calendar.getInstance();
            long timeMilliSecs = calendar.getTimeInMillis();
            Date newdate = new Date(timeMilliSecs);
            String CurrentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
            UserProfile crowdUser = this.userManager.getUserProfile(CurrentLoggedInUser);
            LOGGER.debug("performedOn : " + performedOn);
            LOGGER.debug("action: " + action);
            LOGGER.debug("details: " + details);
            if (request != null) {
                ip = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
            }
            if (StringUtils.isBlank((CharSequence)details) || details.length() == 0) {
                details = "-";
            }
            if (performedOn.contains("GoogleAuthenticator")) {
                performedOn = "Mobile Authenticator";
            }
            if (crowdUser != null) {
                this.moAdminsAuditService.add(performedOn, crowdUser.getFullName() + "(" + ip + ")", newdate, action, details);
            } else {
                this.moAdminsAuditService.add(performedOn, "System", newdate, action, details);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while storing Admins Audit logs", e);
        }
    }

    public Integer getSizeOfUserList(List<String> userList, String searchKeyword, String userStatusFilter, String userSearchParameter) {
        if (StringUtils.isBlank((CharSequence)searchKeyword.trim()) && StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") && !StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
            return userList.size();
        }
        LOGGER.debug("Counting the size for UserList with search keyword :" + searchKeyword);
        int count = 0;
        Boolean isActiveList = Boolean.TRUE;
        if (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"InActiveUsers")) {
            isActiveList = Boolean.FALSE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
            Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
            for (Map.Entry<String, String> entry : configuredMobileNumbers.entrySet()) {
                if (!entry.getValue().contains(searchKeyword) || !userList.contains(entry.getKey())) continue;
                if (!StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers")) {
                    EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)entry.getKey())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1);
                    List usersFromSystem = (List)this.crowdService.search((Query)query);
                    if (usersFromSystem.isEmpty()) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
            return count;
        }
        EntityQuery query = StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") ? (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim())})).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())})).returningAtMost(-1)) : (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1));
        Iterable usersFromSystem = this.crowdService.search((Query)query);
        for (User user : usersFromSystem) {
            String username = user.getName();
            if (!userList.contains(username)) continue;
            ++count;
        }
        return count;
    }

    public Integer getTotalUserCount(String usernameSearchKeyword, String userStatusFilter, String userSearchParameter) {
        LOGGER.debug("Fetching users with searchQuery for total users count=" + usernameSearchKeyword);
        Boolean isActiveList = Boolean.TRUE;
        if (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"InActiveUsers")) {
            isActiveList = Boolean.FALSE;
        }
        int count = 0;
        if (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
            Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
            for (Map.Entry<String, String> entry : configuredMobileNumbers.entrySet()) {
                if (!entry.getValue().contains(usernameSearchKeyword)) continue;
                if (!StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers")) {
                    EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)entry.getKey())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1);
                    List usersFromSystem = (List)this.crowdService.search((Query)query);
                    if (usersFromSystem.isEmpty()) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        } else {
            EntityQuery query = StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") && (StringUtils.isBlank((CharSequence)usernameSearchKeyword) || StringUtils.isEmpty((CharSequence)usernameSearchKeyword)) ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(0).returningAtMost(Integer.MAX_VALUE) : (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") ? (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword.trim())})).startingAt(0).returningAtMost(Integer.MAX_VALUE) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword.trim())})).startingAt(0).returningAtMost(Integer.MAX_VALUE)) : (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).startingAt(0).returningAtMost(Integer.MAX_VALUE) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).startingAt(0).returningAtMost(Integer.MAX_VALUE)));
            try {
                count = ((Collection)this.crowdService.search((Query)query)).size();
            }
            catch (Exception e) {
                LOGGER.debug("An error occurred while fetching the users");
            }
        }
        return count;
    }

    public List<String> getFromListForGroups(List<String> groupList, String searchKeyword, int maxCount) {
        LOGGER.debug("Inside getFromListForGroups");
        if (maxCount == -1) {
            return groupList;
        }
        LinkedList<String> groupToReturn = new LinkedList<String>();
        int currentCount = 0;
        for (String groupName : groupList) {
            if (currentCount < maxCount) {
                ++currentCount;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)searchKeyword) || StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)searchKeyword.trim())) {
                groupToReturn.add(groupName);
                ++currentCount;
            }
            if (groupToReturn.size() != 20) continue;
            LOGGER.debug("groupToReturn = " + String.valueOf(groupToReturn));
            return groupToReturn;
        }
        LOGGER.debug("groupToReturn = " + String.valueOf(groupToReturn));
        return groupToReturn;
    }

    public List<String> getUserFromCrowdUsingUsername(final String usernameSearchKeyword, final String userStatusFilter, final String userSearchParameter, final int userCount) {
        final ArrayList<String> availableUser = new ArrayList<String>();
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                EntityQuery query;
                if (userCount == -1) {
                    query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                } else {
                    Boolean isActiveList = Boolean.TRUE;
                    if (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"InActiveUsers")) {
                        isActiveList = Boolean.FALSE;
                    }
                    LinkedList<String> userToReturn = new LinkedList<String>();
                    int count = 0;
                    if (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"mobilenumber")) {
                        Map<String, String> configuredMobileNumbers = MoTwoFactorPluginHandler.this.settings.getConfiguredMobileNumbers();
                        for (Map.Entry<String, String> entry : configuredMobileNumbers.entrySet()) {
                            if (!entry.getValue().contains(usernameSearchKeyword)) continue;
                            if (!StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers")) {
                                EntityQuery query2 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)entry.getKey())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).returningAtMost(-1);
                                List usersFromSystem = (List)MoTwoFactorPluginHandler.this.crowdService.search((Query)query2);
                                if (usersFromSystem.isEmpty() || ++count <= userCount) continue;
                                userToReturn.add(entry.getKey());
                                if (userToReturn.size() != 20) continue;
                                return userToReturn;
                            }
                            if (++count <= userCount) continue;
                            userToReturn.add(entry.getKey());
                            if (userToReturn.size() != 20) continue;
                            return userToReturn;
                        }
                        return userToReturn;
                    }
                    query = StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") && (StringUtils.isBlank((CharSequence)usernameSearchKeyword) || StringUtils.isEmpty((CharSequence)usernameSearchKeyword)) ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(userCount).returningAtMost(20) : (StringUtils.equalsIgnoreCase((CharSequence)userStatusFilter, (CharSequence)"AllUsers") ? (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword.trim())})).startingAt(userCount).returningAtMost(20) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword.trim())})).startingAt(userCount).returningAtMost(20)) : (StringUtils.equalsIgnoreCase((CharSequence)userSearchParameter, (CharSequence)"username") ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).startingAt(userCount).returningAtMost(20) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword.trim())}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActiveList)})).startingAt(userCount).returningAtMost(20)));
                }
                Iterable usersFromSystem = MoTwoFactorPluginHandler.this.crowdService.search((Query)query);
                for (User user : usersFromSystem) {
                    if (availableUser.contains(user.getName())) continue;
                    availableUser.add(user.getName());
                }
                LOGGER.debug("availableUser = " + String.valueOf(availableUser));
                return availableUser;
            }
        });
        return availableUser;
    }

    public List<String> autoDeleteAuditLogs(List<String> auditLogsList, Integer daysForAutoDeleteLogs) throws ParseException {
        ArrayList<MoTwoFactorCommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<MoTwoFactorCommonAuditLogDetails>();
        ArrayList<String> updatedListAfterRemoval = new ArrayList<String>();
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            MoTwoFactorCommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), MoTwoFactorCommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger((String)daysForAutoDeleteLogs.toString()).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((MoTwoFactorCommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getLoginDateWithTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            updatedListAfterRemoval.add(gson.toJson(listOfAuditLogsObjects.get(counter)));
        }
        return updatedListAfterRemoval;
    }

    public Integer getSizeOfGroupsList(List<String> groupList, String searchKeyword) {
        LOGGER.debug("Inside getFromListForGroups");
        LinkedList<String> groupToReturn = new LinkedList<String>();
        if (StringUtils.isBlank((CharSequence)searchKeyword.trim())) {
            return groupList.size();
        }
        for (String groupName : groupList) {
            if (!StringUtils.isBlank((CharSequence)searchKeyword) && !StringUtils.containsIgnoreCase((CharSequence)groupName, (CharSequence)searchKeyword.trim())) continue;
            groupToReturn.add(groupName);
        }
        LOGGER.debug("groupToReturn = " + String.valueOf(groupToReturn));
        return groupToReturn.size();
    }

    public Integer getTotalGroupsSize(String groupnameSearchKeyword) {
        EntityQuery query = StringUtils.isBlank((CharSequence)groupnameSearchKeyword) || StringUtils.isEmpty((CharSequence)groupnameSearchKeyword) ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1) : QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupnameSearchKeyword)).returningAtMost(-1);
        try {
            return ((Collection)this.crowdService.search((Query)query)).size();
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while fetching the users");
            return 0;
        }
    }

    public List<String> getGroupsFromCrowdUsingGroupname(String groupnameSearchKeyword, int groupCount) {
        ArrayList<String> availableGroups = new ArrayList<String>();
        EntityQuery query = groupCount == -1 ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1) : (StringUtils.isBlank((CharSequence)groupnameSearchKeyword) || StringUtils.isEmpty((CharSequence)groupnameSearchKeyword) ? QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(groupCount).returningAtMost(20) : QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupnameSearchKeyword)).startingAt(groupCount).returningAtMost(20));
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (availableGroups.contains(group.getName())) continue;
            availableGroups.add(group.getName());
        }
        return availableGroups;
    }

    public List<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
        LOGGER.debug("query =  " + String.valueOf(query));
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups2 = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups2) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public List<String> getAllUsersInGroup(String groupName) {
        Iterable users = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        ArrayList<String> usersPresent = new ArrayList<String>();
        for (User userObject : users) {
            usersPresent.add(userObject.getName());
        }
        return usersPresent;
    }

    public List<Map<String, String>> getUserData(List<String> usernameList) {
        ArrayList<Map<String, String>> userData = new ArrayList<Map<String, String>>();
        TreeMap<String, String> usernameEmailMap = new TreeMap<String, String>();
        TreeMap<String, String> usernameFullNameMap = new TreeMap<String, String>();
        TreeMap<String, String> mobileNumbersMap = new TreeMap<String, String>();
        Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
        for (String username : usernameList) {
            UserProfile user = this.userManager.getUserProfile(username);
            if (user == null) {
                usernameEmailMap.put(username, "");
                usernameFullNameMap.put(username, "");
                mobileNumbersMap.put(username, "");
                continue;
            }
            usernameEmailMap.put(username, user.getEmail());
            usernameFullNameMap.put(username, user.getFullName());
            mobileNumbersMap.put(username, configuredMobileNumbers.getOrDefault(username, "-"));
        }
        userData.add(usernameEmailMap);
        userData.add(usernameFullNameMap);
        userData.add(mobileNumbersMap);
        return userData;
    }

    public List<String> getListOf2FAConfiguredUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorConfiguredUsers = this.settings.getListOf2FAConfiguredUsers();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorConfiguredUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorEnable2FAForUsers = this.settings.getEnable2FAForUsersList();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorEnable2FAForUsers.contains(username) || selectedUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getListOf2FAEnabledGroupsUsingGroupname(List<String> groupnameList) {
        List<String> twoFactorEnable2FAForGroups = this.settings.getEnable2FAForGroupsList();
        ArrayList<String> selectedGroups = new ArrayList<String>();
        for (String groupName : groupnameList) {
            if (!twoFactorEnable2FAForGroups.contains(groupName) || selectedGroups.contains(groupName)) continue;
            selectedGroups.add(groupName);
        }
        return selectedGroups;
    }

    public InetAddress isIPaddressValid(String ipAddress) throws UnknownHostException {
        String[] segments = ipAddress.split("/");
        segments[0] = segments[0].replace(".*", "");
        InetAddress inetAddress = InetAddress.getByName(segments[0]);
        return inetAddress;
    }

    public List<String> getListOf2FADisabledUsersUsingUsername(List<String> usernameList) {
        List<String> twoFactorDisable2FAForUsers = this.settings.getDisable2FAForUsersList();
        ArrayList<String> selectedUsers = new ArrayList<String>();
        for (String username : usernameList) {
            if (!twoFactorDisable2FAForUsers.contains(username) || selectedUsers.contains(username)) continue;
            selectedUsers.add(username);
        }
        return selectedUsers;
    }

    public List<String> getFromListForDirectories(List<String> directoryList, String searchKeyword, int maxCount) {
        LOGGER.debug("Calling getFromListForDirectories");
        if (maxCount == -1) {
            return directoryList;
        }
        LinkedList<String> directoryToReturn = new LinkedList<String>();
        int currentCount = 0;
        for (String directoryName : directoryList) {
            if (currentCount < maxCount) {
                ++currentCount;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)searchKeyword) || StringUtils.containsIgnoreCase((CharSequence)directoryName, (CharSequence)searchKeyword.trim())) {
                directoryToReturn.add(directoryName);
                ++currentCount;
            }
            if (directoryToReturn.size() != 20) continue;
            return directoryToReturn;
        }
        return directoryToReturn;
    }

    public Integer getSizeOfDirectoriesList(List<String> directoryList, String searchKeyword) {
        LOGGER.debug("Calling getSizeOfDirectoriesList");
        LinkedList<String> directoryToReturn = new LinkedList<String>();
        if (StringUtils.isBlank((CharSequence)searchKeyword.trim())) {
            return directoryList.size();
        }
        for (String directoryName : directoryList) {
            if (!StringUtils.isBlank((CharSequence)searchKeyword) && !StringUtils.containsIgnoreCase((CharSequence)directoryName, (CharSequence)searchKeyword.trim())) continue;
            directoryToReturn.add(directoryName);
        }
        return directoryToReturn.size();
    }

    public Integer getTotalDirectoriesSize(String directoryNameSearchKeyword) {
        LOGGER.debug("Calling getTotalDirectoriesSize");
        List<String> availableDirectories = new ArrayList<String>();
        Application crowdApplication = null;
        try {
            crowdApplication = this.applicationManager.findByName("crowd");
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (crowdApplication == null) {
            LOGGER.debug("Crowd application not found.");
            return availableDirectories.size();
        }
        List directoryMappings = crowdApplication.getApplicationDirectoryMappings();
        for (ApplicationDirectoryMapping mapping : directoryMappings) {
            Directory directory = mapping.getDirectory();
            if (directory == null) continue;
            availableDirectories.add(directory.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)directoryNameSearchKeyword)) {
            String lowerCaseKeyword = directoryNameSearchKeyword.toLowerCase();
            availableDirectories = availableDirectories.stream().filter(name -> name.toLowerCase().contains(lowerCaseKeyword)).collect(Collectors.toList());
        }
        return availableDirectories.size();
    }

    public List<String> getDirectoryFromCrowdUsingDirectoryname(String directoryNameSearchKeyword, int startIndex) {
        LOGGER.debug("Calling getDirectoryFromCrowdUsingDirectoryname");
        List<String> availableDirectories = new ArrayList<String>();
        Application crowdApplication = null;
        try {
            crowdApplication = this.applicationManager.findByName("crowd");
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (crowdApplication == null) {
            LOGGER.debug("Crowd application not found.");
            return availableDirectories;
        }
        List directoryMappings = crowdApplication.getApplicationDirectoryMappings();
        for (ApplicationDirectoryMapping mapping : directoryMappings) {
            Directory directory = mapping.getDirectory();
            if (directory == null) continue;
            availableDirectories.add(directory.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)directoryNameSearchKeyword)) {
            availableDirectories = availableDirectories.stream().filter(name -> name.toLowerCase().contains(directoryNameSearchKeyword.toLowerCase())).collect(Collectors.toList());
        }
        int itemsPerPage = 20;
        int totalItems = availableDirectories.size();
        int endIndex = Math.min(startIndex + itemsPerPage, totalItems);
        if (startIndex >= totalItems) {
            availableDirectories.clear();
        } else {
            availableDirectories = availableDirectories.subList(startIndex, endIndex);
        }
        LOGGER.debug("Returning directories from index " + startIndex + " to " + (endIndex - 1) + " with count: " + availableDirectories.size());
        return availableDirectories;
    }

    public List<String> getAllUsersInDirectory(String directoryName) {
        List users;
        LOGGER.debug("Calling getAllUsersInDirectory");
        Directory directoryy = null;
        try {
            directoryy = this.directoryManager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        EntityQuery userQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        try {
            users = this.directoryManager.searchUsers(directoryy.getId().longValue(), userQuery);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> usersPresent = new ArrayList<String>();
        for (User user : users) {
            usersPresent.add(user.getName());
        }
        return usersPresent;
    }

    public List<String> getAllGroupsInDirectory(String directoryName) {
        List groups2;
        LOGGER.debug("Calling getAllGroupsInDirectory");
        Directory directory = null;
        try {
            directory = this.directoryManager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException("Directory not found: " + directoryName, e);
        }
        EntityQuery groupQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.group.Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        try {
            groups2 = this.directoryManager.searchGroups(directory.getId().longValue(), groupQuery);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Failed to retrieve groups from directory: " + directoryName, e);
        }
        ArrayList<String> groupsPresent = new ArrayList<String>();
        for (com.atlassian.crowd.model.group.Group group : groups2) {
            groupsPresent.add(group.getName());
        }
        return groupsPresent;
    }

    public List<String> getListOf2FAEnabledDirectoriesUsingDirectoryname(List<String> directorynameList) {
        LOGGER.debug("Calling getListOf2FAEnabledDirectoriesUsingDirectoryname");
        List<String> twoFactorEnable2FAForDirectories = this.settings.getEnable2FAForDirectoriesList();
        ArrayList<String> selectedDirectories = new ArrayList<String>();
        for (String directoryName : directorynameList) {
            if (!twoFactorEnable2FAForDirectories.contains(directoryName) || selectedDirectories.contains(directoryName)) continue;
            selectedDirectories.add(directoryName);
        }
        return selectedDirectories;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        LOGGER.debug("Selected Details : " + String.valueOf(selectedDetailsPagination));
        return selectedDetailsPagination;
    }

    public Map<String, String> getMapOfUsernameEmail(List<String> usernameList) {
        TreeMap<String, String> usernameEmailMap = new TreeMap<String, String>();
        for (String username : usernameList) {
            UserProfile userProfile = this.userManager.getUserProfile(username);
            if (userProfile == null) {
                usernameEmailMap.put(username, "");
                continue;
            }
            usernameEmailMap.put(username, userProfile.getEmail());
        }
        return usernameEmailMap;
    }

    public void redirectToValidUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling redirectToValidUrl for User");
        String currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isEmpty((CharSequence)currentLoggedInUser) || StringUtils.isBlank((CharSequence)currentLoggedInUser)) {
            LOGGER.debug("User is not Logged in");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        } else {
            LOGGER.debug("User is Logged in : " + currentLoggedInUser);
            HttpSession session = request.getSession();
            String referer = (String)session.getAttribute("Referer");
            LOGGER.debug("Current Referer : " + referer);
            if (StringUtils.isNotBlank((CharSequence)referer) && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/inlineregistration_") && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/validate_") && !StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"/plugins/servlet/twofactor/loadingPage")) {
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(referer);
            } else if (MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request) != null) {
                Cookie returnToCookie = MoTwoFactorUtility.getCookie("CROWD_RETURNTOCOOKIE", request);
                String decryptedReturnToCookie = this.decryptWithDynamicKey(returnToCookie);
                if (decryptedReturnToCookie == null || !decryptedReturnToCookie.contains(this.pluginConfiguration.getBaseUrl())) {
                    decryptedReturnToCookie = this.pluginConfiguration.getBaseUrl();
                }
                decryptedReturnToCookie = MoTwoFactorUtility.sanitizeText(decryptedReturnToCookie);
                LOGGER.debug("Redirected using CROWD_RETURNTOCOOKIE value : " + decryptedReturnToCookie);
                MoTwoFactorUtility.clearCookie(request, response, "CROWD_RETURNTOCOOKIE");
                response.sendRedirect(decryptedReturnToCookie);
            } else if (request.getSession() != null && request.getSession().getAttribute("RELAY_STATE") != null && StringUtils.isNotEmpty((CharSequence)request.getSession().getAttribute("RELAY_STATE").toString()) && StringUtils.isNotBlank((CharSequence)request.getSession().getAttribute("RELAY_STATE").toString())) {
                LOGGER.debug("User Logged in via SSO redirecting it to relay state");
                String relay_state = request.getSession().getAttribute("RELAY_STATE").toString();
                if (!relay_state.contains(this.pluginConfiguration.getBaseUrl())) {
                    relay_state = this.pluginConfiguration.getBaseUrl().concat(relay_state);
                }
                response.sendRedirect(relay_state);
            } else {
                LOGGER.debug("Redirecting to Base URL");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            }
        }
    }

    public List<String> getOldLogs(List<String> auditLogsList, String username, String ip, String action, String period) throws ParseException {
        ArrayList<String> filteredAuditLogsList = new ArrayList<String>();
        ArrayList<MoTwoFactorCommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<MoTwoFactorCommonAuditLogDetails>();
        Collections.reverse(auditLogsList);
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            MoTwoFactorCommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), MoTwoFactorCommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            if (!StringUtils.isBlank((CharSequence)username) && !StringUtils.containsIgnoreCase((CharSequence)((MoTwoFactorCommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getUsername(), (CharSequence)username) || !StringUtils.isBlank((CharSequence)ip) && !StringUtils.equals((CharSequence)((MoTwoFactorCommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getIpAddress(), (CharSequence)ip) || !StringUtils.equals((CharSequence)"All Actions", (CharSequence)action) && !StringUtils.equals((CharSequence)((MoTwoFactorCommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getAction(), (CharSequence)action)) continue;
            if (StringUtils.equals((CharSequence)"All Days", (CharSequence)period)) {
                filteredAuditLogsList.add(auditLogsList.get(counter));
                continue;
            }
            long intervalSelected = NumberUtils.createInteger((String)String.valueOf(period)).intValue();
            long intervalSelectedInMilliSecs = intervalSelected * 86400000L;
            long timeInPast = timeMilliSecs - intervalSelectedInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((MoTwoFactorCommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getLoginDateWithTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            filteredAuditLogsList.add(auditLogsList.get(counter));
        }
        return filteredAuditLogsList;
    }

    public String exportAuditLogs(String action, String period, String username, String ip, List<HashMap> filteredAuditLogsList, String clearLogs, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            List<Object> aoAuditLogs = new ArrayList();
            aoAuditLogs = this.moLogEntityService.getLogs(0, action, period, username, ip, -1);
            for (int i = 0; i < aoAuditLogs.size(); ++i) {
                MoLogEntity moLogEntity = (MoLogEntity)aoAuditLogs.get(i);
                if (moLogEntity != null) {
                    HashMap<String, String> moLogEntityHash = new HashMap<String, String>();
                    moLogEntityHash.put("user", moLogEntity.getUserName());
                    SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
                    moLogEntityHash.put("dateTime", formatter.format(moLogEntity.getDateAndTime()));
                    moLogEntityHash.put("ipAddress", moLogEntity.getIpAddress());
                    moLogEntityHash.put("action", moLogEntity.getAction());
                    moLogEntityHash.put("type", moLogEntity.getLoginMethod());
                    filteredAuditLogsList.add(moLogEntityHash);
                }
                String str = ",,Date : " + String.valueOf(new Date(System.currentTimeMillis())) + "\n";
                StringJoiner stringJoiner = new StringJoiner(",");
                stringJoiner.add("Sr.no");
                stringJoiner.add("Username");
                stringJoiner.add("Date");
                stringJoiner.add("IP Address");
                stringJoiner.add("Action");
                stringJoiner.add("2FA Method");
            }
            if (BooleanUtils.toBoolean((String)clearLogs)) {
                this.moLogEntityService.delete(0);
                this.storeAdminsAuditLogs("-", "Cleared Authentication logs", "", request);
            }
            this.storeAdminsAuditLogs("End User Audit Logs", "Export Logs", "-", request);
            String str = ",,Date : " + String.valueOf(new Date(System.currentTimeMillis())) + "\n";
            StringJoiner stringJoiner = new StringJoiner(",");
            stringJoiner.add("Sr.no");
            stringJoiner.add("Username");
            stringJoiner.add("Date");
            stringJoiner.add("IP Address");
            stringJoiner.add("Action");
            stringJoiner.add("2FA Method");
            str = str + stringJoiner.toString() + "\n";
            int listCounter = 0;
            for (int counter = 0; counter < filteredAuditLogsList.size(); ++counter) {
                stringJoiner = new StringJoiner(",");
                stringJoiner.add("" + ++listCounter);
                stringJoiner.add(filteredAuditLogsList.get(counter).get("user").toString());
                stringJoiner.add(filteredAuditLogsList.get(counter).get("dateTime").toString());
                stringJoiner.add(filteredAuditLogsList.get(counter).get("ipAddress").toString());
                stringJoiner.add(filteredAuditLogsList.get(counter).get("action").toString());
                stringJoiner.add(filteredAuditLogsList.get(counter).get("type").toString());
                str = str + stringJoiner.toString() + "\n";
            }
            return str;
        }
        catch (Exception e) {
            LOGGER.error("Error occured while Exporting Authentication Audit Logs " + String.valueOf(e));
            return null;
        }
    }

    public String exportAdminAuditLogs(String performedBy, String performedOn, String details, String action, String period, List<HashMap> filteredAuditLogsList, String clearLogs, String pageAccess, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            List<Object> aoAdminsAuditLogs = new ArrayList();
            aoAdminsAuditLogs = this.moAdminsAuditService.getLogs(0, action, performedOn, performedBy, period, details, -1);
            for (int i = 0; i < aoAdminsAuditLogs.size(); ++i) {
                MoAdminsLogEntity moAdminsLogEntity = (MoAdminsLogEntity)aoAdminsAuditLogs.get(i);
                if (moAdminsLogEntity == null) continue;
                HashMap<String, String> moAdminsLogEntityHash = new HashMap<String, String>();
                moAdminsLogEntityHash.put("performedOn", moAdminsLogEntity.getPerformedOn());
                SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
                moAdminsLogEntityHash.put("dateTime", formatter.format(moAdminsLogEntity.getDateAndTime()));
                moAdminsLogEntityHash.put("details", moAdminsLogEntity.getMoreDetails());
                moAdminsLogEntityHash.put("action", moAdminsLogEntity.getAction());
                moAdminsLogEntityHash.put("performedBy", moAdminsLogEntity.getPerformedBy());
                filteredAuditLogsList.add(moAdminsLogEntityHash);
            }
            if (BooleanUtils.toBoolean((String)clearLogs) && pageAccess.contains("readwrite")) {
                this.moAdminsAuditService.deleteLogs();
                this.storeAdminsAuditLogs("-", "Cleared Configuration logs", "", request);
            }
            this.storeAdminsAuditLogs("Configuration Audit Logs", "Export Logs", "-", request);
            String str = ",,Date : " + String.valueOf(new Date(System.currentTimeMillis())) + "\n";
            StringJoiner adminStringJoiner = new StringJoiner(",");
            adminStringJoiner.add("Sr.no");
            adminStringJoiner.add("Action");
            adminStringJoiner.add("Performed On");
            adminStringJoiner.add("Performed By");
            adminStringJoiner.add("Date");
            adminStringJoiner.add("More Details");
            str = str + adminStringJoiner.toString() + "\n";
            int listCounter = 0;
            for (int counter = 0; counter < filteredAuditLogsList.size(); ++counter) {
                adminStringJoiner = new StringJoiner(",");
                adminStringJoiner.add("" + ++listCounter);
                adminStringJoiner.add(filteredAuditLogsList.get(counter).get("action").toString());
                adminStringJoiner.add(filteredAuditLogsList.get(counter).get("performedOn").toString());
                adminStringJoiner.add(filteredAuditLogsList.get(counter).get("performedBy").toString());
                adminStringJoiner.add(filteredAuditLogsList.get(counter).get("dateTime").toString());
                adminStringJoiner.add(filteredAuditLogsList.get(counter).get("details").toString());
                str = str + adminStringJoiner.toString() + "\n";
            }
            return str;
        }
        catch (Exception e) {
            LOGGER.error("Error occured while exporting Configuration Audit Logs " + String.valueOf(e));
            return null;
        }
    }

    public Boolean shouldConsiderMo2FA(String username, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)username)) {
            LOGGER.debug("User is not logged in");
            return false;
        }
        Boolean twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
        if (BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
            LOGGER.debug("2FA already performed");
            return false;
        }
        LOGGER.debug("User is logged in & valid license found.");
        MoTwoFactorCommonUserSettings twoFactorUserSettings = this.settings.getUserSettings(username);
        if (this.check2FAIsEnabledForUser(username, twoFactorUserSettings, request).booleanValue()) {
            LOGGER.debug("Two Factor is enabled");
            if (this.checkIsTwofactorUrl(request)) {
                LOGGER.debug("Is twofactor URL");
                return false;
            }
            twoFactorVerified = MoTwoFactorUtility.isTwoFactorVerified(request);
            LOGGER.debug("Is Session for Verified " + twoFactorVerified);
            if (!BooleanUtils.toBoolean((Boolean)twoFactorVerified)) {
                LOGGER.debug("Is Remember me enabled : " + BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()));
                if (this.checkAndEvaluateDeviceDetails(username, request, twoFactorUserSettings).booleanValue() && BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice())) {
                    LOGGER.debug("Current Device is in Remember My device List");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Remembered Device)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
                if (BooleanUtils.toBoolean((Boolean)this.isInStoredIpAddress(currentIpAddress, this.settings.getWhitelistIpAddressWithMessages()))) {
                    LOGGER.debug("Current IP Address is in Whitelist IP Address");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Whitelisted IP)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return false;
                }
                LOGGER.debug("2FA not performed");
                return true;
            }
            LOGGER.debug("2FA performed");
            return false;
        }
        LOGGER.debug("Two Factor is not enabled");
        return false;
    }

    private boolean checkIsTwofactorUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String contextPath = request.getContextPath();
        LOGGER.debug("URL : " + url);
        LOGGER.debug("Context Path : " + contextPath);
        if (url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2faenabledinfo") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_googleauthenticator") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_otpoveremail") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_otpoversms") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_backupmethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_duopushnotification") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_u2fhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_securityquestion") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_backupcode") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otp") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_2famethodlist") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otpoveremail") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_otpoversms") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_duopushnotification") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_webauthnas2famethod") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_u2fhardwaretoken") || url.equals(contextPath + "/plugins/servlet/twofactor/validate_webauthnhardwaretoken") || url.equals(contextPath + "/plugins/servlet/webAuthn/MoSecureUtil") || url.equals(contextPath + "/plugins/servlet/webAuthn/MoSaveCredentials") || url.equals(contextPath + "/plugins/servlet/webAuthn/DataStore") || url.equals(contextPath + "/plugins/servlet/webAuthn/FinishAssertion")) {
            LOGGER.error("Is Two factor URL");
            return Boolean.TRUE;
        }
        LOGGER.error("Is not 2FA URL");
        return Boolean.FALSE;
    }

    private Boolean checkAndEvaluateDeviceDetails(String username, HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserSettings) {
        Boolean shouldIgnore2FA = Boolean.FALSE;
        if (twoFactorUserSettings.getRememberMeDeviceDetails().size() > 0) {
            String currentDeviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
            currentDeviceDetails = currentDeviceDetails.replaceAll(" ", "");
            LOGGER.debug("Current Device Details : " + currentDeviceDetails);
            String userAgent = request.getHeader("User-Agent");
            userAgent = userAgent.replaceAll(";", ":");
            userAgent = userAgent.replaceAll(" ", "");
            if (StringUtils.isNotBlank((CharSequence)currentDeviceDetails) && !StringUtils.containsIgnoreCase((CharSequence)currentDeviceDetails, (CharSequence)userAgent)) {
                LOGGER.debug("Invalid Agent Found. " + userAgent);
                currentDeviceDetails = "";
            }
            List<String> rememberMeDeviceDetails = twoFactorUserSettings.getRememberMeDeviceDetails();
            LOGGER.debug("Stored Device Details : " + String.valueOf(rememberMeDeviceDetails));
            for (int i = rememberMeDeviceDetails.size() - 1; i >= 0; --i) {
                long storeTimeInMili;
                String storedDeviceDetails = rememberMeDeviceDetails.get(i);
                storedDeviceDetails = storedDeviceDetails.replaceAll(" ", "");
                long currentTimeInMili = System.currentTimeMillis();
                if (currentTimeInMili > (storeTimeInMili = Long.parseLong(storedDeviceDetails.split("=====")[1]))) {
                    rememberMeDeviceDetails.remove(i);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)currentDeviceDetails) || !StringUtils.containsIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails) && !StringUtils.startsWithIgnoreCase((CharSequence)storedDeviceDetails, (CharSequence)currentDeviceDetails)) continue;
                shouldIgnore2FA = Boolean.TRUE;
            }
            twoFactorUserSettings.setRememberMeDeviceDetails(rememberMeDeviceDetails);
            LOGGER.debug("Stored Device Details After change : " + String.valueOf(rememberMeDeviceDetails));
            this.settings.setUserSettings(username, twoFactorUserSettings);
        }
        LOGGER.debug("Is Current Device store : " + shouldIgnore2FA);
        return shouldIgnore2FA;
    }

    /*
     * WARNING - void declaration
     */
    public String findValidUrlToRedirect(String username, HttpServletRequest request) {
        LOGGER.debug("Calling findValidUrlToRedirect");
        List<String> twoFactorConfiguredUser = this.settings.getListOf2FAConfiguredUsers();
        Boolean is2FAConfigured = twoFactorConfiguredUser.contains(username);
        String url = "";
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        List<String> configured2FAMethodsByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
        List<String> enabled2faMethods = this.settings.get2FAMethodForUserList();
        List<String> enabledBackupMethods = this.settings.getBackupMethodForUserList();
        LOGGER.debug("All enabled (as primary) 2FA methods = " + String.valueOf(enabled2faMethods));
        LOGGER.debug("All enabled backup 2FA methods = " + String.valueOf(enabledBackupMethods));
        LOGGER.debug("All configured 2FA methods = " + String.valueOf(configured2FAMethodsByUser));
        boolean is2FAMethodConfiguredBasedOnGroups = Boolean.FALSE;
        for (String string : configured2FAMethodsByUser) {
            if (!enabled2faMethods.contains(string) || !this.isPageAllowed(string, username).booleanValue()) continue;
            is2FAMethodConfiguredBasedOnGroups = Boolean.TRUE;
            LOGGER.debug("\n\n is2FAMethodConfiguredBasedOnGroups:" + is2FAMethodConfiguredBasedOnGroups);
            break;
        }
        String referer = request.getHeader("referer");
        if (!(BooleanUtils.toBoolean((Boolean)is2FAConfigured) || referer != null && referer.contains("/plugins/servlet/twofactor/inlineregistration_backupmethodlist"))) {
            for (String configuredMethodByUser : configured2FAMethodsByUser) {
                if (!enabled2faMethods.contains(configuredMethodByUser) || twoFactorConfiguredUser.contains(username)) continue;
                twoFactorConfiguredUser.add(username);
                this.settings.setListOf2FAConfiguredUsers(twoFactorConfiguredUser);
                is2FAConfigured = Boolean.TRUE;
            }
        }
        if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured) && StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String string = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(string);
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        if (!BooleanUtils.toBoolean((Boolean)is2FAConfigured) || !is2FAMethodConfiguredBasedOnGroups) {
            if (configured2FAMethodsByUser.size() == 0 || !is2FAMethodConfiguredBasedOnGroups) {
                LOGGER.debug("2FA is Not configured. Redirecting for inline registration :- Showing 2FA enabled message");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2faenabledinfo");
            } else if (enabledBackupMethods.size() > 1) {
                LOGGER.debug("2FA is Not configured. Showing Backup method list");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
            } else {
                Map<String, String> map = this.settings.getInlineRegistrationUrls();
                Boolean isBackupMethodNotEnabled = Boolean.TRUE;
                for (String methodName : map.keySet()) {
                    if (!enabledBackupMethods.contains(methodName) || !this.isPageAllowed(methodName, username).booleanValue()) continue;
                    LOGGER.debug("2FA is Not configured. Redirecting for inline registration :-" + methodName);
                    url = this.pluginConfiguration.getBaseUrl().concat(map.get(methodName));
                    isBackupMethodNotEnabled = Boolean.FALSE;
                    break;
                }
                if (isBackupMethodNotEnabled.booleanValue()) {
                    LOGGER.debug("Backup Method is disabled after configuring primary 2FA.");
                    this.settings.addTo2FAConfiguredUsersList(username);
                    url = this.pluginConfiguration.getBaseUrl().concat("/console/secure/console.action");
                }
            }
            LOGGER.debug("Removing user from configured 2FA list.");
            List<String> list = this.settings.getListOf2FAConfiguredUsers();
            list.removeAll(Collections.singleton(username));
            this.settings.setListOf2FAConfiguredUsers(list);
            if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
                String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
                twoFactorUserClass.setUserSalt(userSpecific_salt_key);
            }
            this.settings.setUserSettings(username, twoFactorUserClass);
        } else {
            void var12_23;
            LOGGER.debug("2FA is Configured.");
            LOGGER.debug("Enable force 2fa method for user : " + this.settings.getEnableEnforce2faMethodForUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser())) {
                String string = this.settings.getPrimary2faMethodForUser();
                LOGGER.debug("Primary method for User : " + string);
                LOGGER.debug("Current primary User method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (this.isPageAllowed(string, username).booleanValue() && !StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    if (configured2FAMethodsByUser.contains(string)) {
                        twoFactorUserClass.setCurrent2FAMethod(string);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                        LOGGER.debug("Updated the primary method as enforced by the admin");
                    } else {
                        LOGGER.debug("Enforced primary method not updated as it is not configured");
                    }
                }
            }
            boolean bl = false;
            for (int counter = 0; counter < configured2FAMethodsByUser.size(); ++counter) {
                String methodName = configured2FAMethodsByUser.get(counter);
                if (!this.isPageAllowed(methodName, username).booleanValue() || !enabled2faMethods.contains(methodName) && !enabledBackupMethods.contains(methodName)) continue;
                ++var12_23;
            }
            LOGGER.debug("totalEnabledAndConfiguredMethods = " + (int)var12_23);
            Map<String, String> validateUrls = this.settings.getValidationUrls();
            LOGGER.debug("Should show All Configured Method TO User : " + this.settings.getShowAllConfiguredMethodToUser());
            if (BooleanUtils.toBoolean((Boolean)this.settings.getShowAllConfiguredMethodToUser()) && var12_23 > true) {
                LOGGER.debug("Showing the list of configured 2FA methods");
                url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist");
            } else {
                if (var12_23 == false) {
                    LOGGER.debug("Configuring another enabled method");
                    twoFactorConfiguredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(twoFactorConfiguredUser);
                    LOGGER.debug("2FA is not configured as per enabled methods. Redirecting for inline registration :- Showing 2FA enabled message");
                    url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2faenabledinfo");
                    return url;
                }
                if (enabled2faMethods.contains(twoFactorUserClass.getCurrent2FAMethod()) && this.isPageAllowed(twoFactorUserClass.getCurrent2FAMethod(), username).booleanValue()) {
                    LOGGER.debug("Validating using the primary method or the current method");
                    LOGGER.debug("Current 2FA method : " + twoFactorUserClass.getCurrent2FAMethod());
                    url = this.pluginConfiguration.getBaseUrl().concat(validateUrls.get(twoFactorUserClass.getCurrent2FAMethod()));
                } else {
                    for (int counter = 0; counter < configured2FAMethodsByUser.size(); ++counter) {
                        String method = configured2FAMethodsByUser.get(counter);
                        if (!enabled2faMethods.contains(method) && !enabledBackupMethods.contains(method)) continue;
                        LOGGER.debug("Validating using an enabled and configured 2FA method other than the primary/current method");
                        if (!this.isPageAllowed(method, username).booleanValue()) continue;
                        url = this.pluginConfiguration.getBaseUrl().concat(validateUrls.get(method));
                        break;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                LOGGER.debug("Removing user from configured 2FA list.");
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                configuredUser.removeAll(Collections.singleton(username));
                this.settings.setListOf2FAConfiguredUsers(configuredUser);
                twoFactorUserClass = new MoTwoFactorCommonUserSettings();
                this.settings.setUserSettings(username, twoFactorUserClass);
                url = this.pluginConfiguration.getBaseUrl().concat("/console/secure/console.action");
            }
        }
        return url;
    }

    public String getPrimaryConfigured2faMethod(List<String> configured2FAByUserList) {
        if (configured2FAByUserList.contains("GoogleAuthenticator")) {
            return "GoogleAuthenticator";
        }
        if (configured2FAByUserList.contains("OtpOverEmail")) {
            return "OtpOverEmail";
        }
        if (configured2FAByUserList.contains("OtpOverSms")) {
            return "OtpOverSms";
        }
        if (configured2FAByUserList.contains("WebAuthn")) {
            return "WebAuthn";
        }
        if (configured2FAByUserList.contains("YubikeyHardwareTokenAsU2F")) {
            return "YubikeyHardwareTokenAsU2F";
        }
        if (configured2FAByUserList.contains("SecurityQuestion")) {
            return "SecurityQuestion";
        }
        return "";
    }

    private Boolean check2FAIsEnabledForUser(String username, MoTwoFactorCommonUserSettings twoFactorUserSettings, HttpServletRequest request) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor())) {
            List<String> excludeGroups = this.settings.getExclude2faForGroupList();
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            if (excludeGroups.size() > 0) {
                LOGGER.debug("Exclude Groups : " + String.valueOf(excludeGroups));
                List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
                LOGGER.debug("User Groups : " + String.valueOf(userGroups));
                for (String group : excludeGroups) {
                    if (!userGroups.contains(group) || !enable2FAForUsersList.contains(username)) continue;
                    LOGGER.debug("Group is present in Exclude Groups.");
                    this.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Skipped 2FA (Based on group)", "-");
                    HttpSession session = request.getSession();
                    session.setAttribute("2fa_verification", (Object)true);
                    return Boolean.FALSE;
                }
            }
            if (enable2FAForUsersList.contains(username)) {
                return Boolean.TRUE;
            }
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!disable2FAForUsersList.contains(username)) {
                if (this.settings.getEnable2FAForAllUsers().booleanValue()) {
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
                List<String> groupsOfUser = this.pluginConfiguration.getUsersGroup(username);
                for (String g2 : enable2FAForGroupsList) {
                    if (!groupsOfUser.contains(g2)) continue;
                    enable2FAForUsersList.add(username);
                    this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                    return Boolean.TRUE;
                }
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
        }
        return Boolean.FALSE;
    }

    public Map<String, String> getStoredIpAddressWithMessage(Map<String, String> StoredIpAddressWithMessage, String ipSearchKeyword, int limit) {
        HashMap<String, String> searchedAddressWithMessage = new HashMap();
        if (limit == -1) {
            searchedAddressWithMessage = StoredIpAddressWithMessage;
            return searchedAddressWithMessage;
        }
        for (Map.Entry<String, String> entry : StoredIpAddressWithMessage.entrySet()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)entry.getKey(), (CharSequence)ipSearchKeyword)) continue;
            searchedAddressWithMessage.put(entry.getKey(), entry.getValue());
        }
        if (searchedAddressWithMessage.size() > limit) {
            LinkedHashMap<String, String> selectedIpAddressWithMessage = new LinkedHashMap<String, String>();
            for (Map.Entry entry : searchedAddressWithMessage.entrySet()) {
                selectedIpAddressWithMessage.put((String)entry.getKey(), (String)entry.getValue());
            }
            return selectedIpAddressWithMessage;
        }
        return searchedAddressWithMessage;
    }

    public Map<String, String> getStoredIpAddresses(Map<String, String> storedIpAddresses, String ipSearchKeyword, int limit) {
        HashMap<String, String> searchedAddressWithMessage = new HashMap();
        if (limit == -1) {
            searchedAddressWithMessage = storedIpAddresses;
            return searchedAddressWithMessage;
        }
        for (Map.Entry<String, String> entry : storedIpAddresses.entrySet()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)entry.getKey(), (CharSequence)ipSearchKeyword)) continue;
            searchedAddressWithMessage.put(entry.getKey(), entry.getValue());
        }
        if (searchedAddressWithMessage.size() > limit) {
            LinkedHashMap<String, String> selectedIpAddressWithMessage = new LinkedHashMap<String, String>();
            for (Map.Entry entry : searchedAddressWithMessage.entrySet()) {
                selectedIpAddressWithMessage.put((String)entry.getKey(), (String)entry.getValue());
            }
            return selectedIpAddressWithMessage;
        }
        return searchedAddressWithMessage;
    }

    public void saveWhitelistIpAddress(String ipAddress) {
        List<String> whitelistIpAddress = this.settings.getWhitelistIpAddresses();
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress));
        whitelistIpAddress.removeAll(Collections.singleton(ipAddress.trim()));
        whitelistIpAddress.add(ipAddress.trim());
        this.settings.setWhitelistIpAddresses(whitelistIpAddress);
    }

    public void saveWhitelistIpAddressAndMessagesInMap(String ipAddress, String ipAddressMessage) {
        Map<String, String> whitelistIpAddressAndMessagesInMap = this.settings.getWhitelistIpAddressWithMessages();
        whitelistIpAddressAndMessagesInMap.put(ipAddress, ipAddressMessage);
        this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressAndMessagesInMap);
    }

    public void saveBlacklistIpAddressAndMessagesInMap(String ipAddress, String ipAddressMessage) {
        Map<String, String> blacklistIpAddressAndMessagesInMap = this.settings.getBlacklistIpAddressWithMessages();
        blacklistIpAddressAndMessagesInMap.put(ipAddress, ipAddressMessage);
        this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressAndMessagesInMap);
    }

    public String getValidIpAddress(String ipAddress) throws UnknownHostException {
        int count;
        InetAddress inetAddress = this.isIPaddressValid(ipAddress);
        Object correctIpAddress = inetAddress.getAddress().length == 4 ? ((count = ipAddress.split("\\.").length) == 1 ? ipAddress.trim() + ".*.*.*" : (count == 2 ? ipAddress.trim() + ".*.*" : (count == 3 ? ipAddress.trim() + ".*" : ipAddress.trim()))) : ipAddress;
        return correctIpAddress;
    }

    public Map<String, String> getSelectedDetailsForPaginationForIpAddress(Map<String, String> detailsList, Integer startIndex, Integer endIndex) {
        TreeMap<String, String> selectedDetailsPagination = new TreeMap<String, String>();
        int counter = -1;
        for (String entry : detailsList.keySet()) {
            if (++counter < startIndex || counter > endIndex) continue;
            selectedDetailsPagination.put(entry, detailsList.get(entry));
        }
        LOGGER.debug("Selected Details for IP Address: " + String.valueOf(selectedDetailsPagination));
        return selectedDetailsPagination;
    }

    public Boolean isInStoredIpAddress(String ipAddress, Map<String, String> storedIpAddresses) {
        Boolean isPresent = Boolean.FALSE;
        LOGGER.debug("Current IP Address : " + ipAddress);
        LOGGER.debug("Stored IP Addresses : " + String.valueOf(storedIpAddresses));
        try {
            InetAddress currentInetAddress = this.isIPaddressValid(ipAddress);
            if (currentInetAddress.getAddress().length == 4) {
                int ipSize = 0;
                int ipLength = 0;
                for (String storedIpAddress : storedIpAddresses.keySet()) {
                    if (this.isIPaddressValid(storedIpAddress).getAddress().length != 4) continue;
                    String[] segment = storedIpAddress.split("/");
                    if (segment.length == 2) {
                        SubnetUtils subnetUtils = new SubnetUtils(storedIpAddress);
                        if (!subnetUtils.getInfo().isInRange(ipAddress) && !StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)subnetUtils.getInfo().getBroadcastAddress()) && !StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)subnetUtils.getInfo().getNetworkAddress())) continue;
                        isPresent = Boolean.TRUE;
                    } else {
                        ipLength = storedIpAddress.split("\\*").length;
                        if (ipLength > 0) {
                            storedIpAddress = storedIpAddress.replace(".*", "");
                        }
                        if ((ipSize = storedIpAddress.split("\\.").length) == 4) {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)ipAddress, (CharSequence)storedIpAddress)) continue;
                            isPresent = Boolean.TRUE;
                        } else {
                            if (!StringUtils.startsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)(storedIpAddress + "."))) continue;
                            isPresent = Boolean.TRUE;
                        }
                    }
                    break;
                }
            } else {
                for (String storedIpAddress : storedIpAddresses.keySet()) {
                    InetAddress networkAddress = this.isIPaddressValid(storedIpAddress);
                    if (networkAddress.getAddress().length != 16) continue;
                    String[] segments = storedIpAddress.split("/");
                    if (segments.length == 2) {
                        if (!this.isIPV6AddressInSubnet(ipAddress, storedIpAddress)) continue;
                        isPresent = true;
                    } else {
                        if (!networkAddress.getCanonicalHostName().equals(currentInetAddress.getCanonicalHostName())) continue;
                        isPresent = true;
                    }
                    break;
                }
            }
            return isPresent;
        }
        catch (Exception e) {
            LOGGER.debug("Error:" + e.getMessage());
            return Boolean.FALSE;
        }
    }

    private boolean isIPV6AddressInSubnet(String address, String networkIPAddress) throws UnknownHostException {
        String[] cidrParts = networkIPAddress.split("/");
        String networkAddress = cidrParts[0];
        int prefixLength = Integer.parseInt(cidrParts[1]);
        BigInteger bitmask = BigInteger.ONE.shiftLeft(128).subtract(BigInteger.ONE.shiftLeft(128 - prefixLength));
        byte[] maskBytes = bitmask.toByteArray();
        byte[] mask = new byte[16];
        System.arraycopy(maskBytes, maskBytes.length - 16, mask, 0, 16);
        byte[] networkBytes = InetAddress.getByName(networkAddress).getAddress();
        byte[] lowerBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            lowerBytes[i] = (byte)(networkBytes[i] & mask[i]);
        }
        byte[] upperBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            upperBytes[i] = (byte)(networkBytes[i] | ~mask[i]);
        }
        String startIPAddress = InetAddress.getByAddress(lowerBytes).getHostAddress();
        String endIPAddress = InetAddress.getByAddress(upperBytes).getHostAddress();
        String addressWithoutSubnetPrefix = address.split("%")[0];
        IPv6Address startIP = IPv6Address.fromString(startIPAddress);
        IPv6Address endIP = IPv6Address.fromString(endIPAddress);
        IPv6AddressRange ipRange = IPv6AddressRange.fromFirstAndLast(startIP, endIP);
        IPv6Address inputIPAddress = IPv6Address.fromString(addressWithoutSubnetPrefix);
        return ipRange.contains(inputIPAddress);
    }

    public Boolean checkBruteForceInvalidAttemptAction(HttpServletRequest request) {
        if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableBruteForceProtection())) {
            HttpSession session = request.getSession();
            int count = 0;
            if (session.getAttribute("2fa_invalid_validation_attempt_count") != null) {
                count = (Integer)session.getAttribute("2fa_invalid_validation_attempt_count");
            }
            LOGGER.debug("Count : " + ++count);
            LOGGER.debug("Count : " + this.settings.getBruteForceNumberOfAttempts());
            if (count >= this.settings.getBruteForceNumberOfAttempts()) {
                try {
                    String username = this.pluginConfiguration.getCurrentLoggedInUser();
                    UserProfile user = this.pluginConfiguration.getCrowdUser();
                    Boolean isNotSoloAdmin = this.shouldLockedOutUser(username);
                    if (isNotSoloAdmin.booleanValue()) {
                        this.sendEmailBruteForce(request, user);
                    } else {
                        this.sendAlertEmailToSoloAdmin(request, user);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to send email : " + String.valueOf(e));
                }
                return Boolean.FALSE;
            }
            session.setAttribute("2fa_invalid_validation_attempt_count", (Object)count);
        }
        return Boolean.TRUE;
    }

    public void performBruteForceUserLockAction(String username, HttpServletRequest request) {
        long currentTimeInMili = System.currentTimeMillis();
        LOGGER.debug("currentTimeInMili : " + currentTimeInMili);
        long newTimeInMili = this.getBruteForceLockingTimeInMili() + currentTimeInMili;
        LOGGER.debug("newTimeInMili : " + newTimeInMili);
        String currentIp = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
        LOGGER.debug("Current IP : " + currentIp);
        String fieldValue = Long.toString(newTimeInMili) + "=====" + currentIp;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        lockedUserDetails.put(username, fieldValue);
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    private long getBruteForceLockingTimeInMili() {
        long newTimeInMili = 0L;
        long minutesMilis = 60000L;
        long hoursMilis = 3600000L;
        long daysMilis = 86400000L;
        String bruteForceTimeInterval = this.settings.getBruteForceTimeInterval();
        String bruteForceCustomTimeInterval = this.settings.getBruteForceCustomTimeInterval();
        Integer bruteForceCustomTimeDuration = this.settings.getBruteForceCustomTimeDuration();
        if (StringUtils.equalsIgnoreCase((CharSequence)bruteForceTimeInterval, (CharSequence)"custom")) {
            switch (bruteForceCustomTimeInterval) {
                case "minutes": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * minutesMilis;
                    break;
                }
                case "hours": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * hoursMilis;
                    break;
                }
                case "days": {
                    newTimeInMili = (long)bruteForceCustomTimeDuration.intValue() * daysMilis;
                }
            }
        } else {
            switch (bruteForceTimeInterval) {
                case "15 minutes": {
                    newTimeInMili = 15L * minutesMilis;
                    break;
                }
                case "30 minutes": {
                    newTimeInMili = 30L * minutesMilis;
                    break;
                }
                case "1 hour": {
                    newTimeInMili = hoursMilis;
                    break;
                }
                case "5 hours": {
                    newTimeInMili = 5L * hoursMilis;
                    break;
                }
                case "1 day": {
                    newTimeInMili = daysMilis;
                    break;
                }
                case "7 days": {
                    newTimeInMili = 7L * hoursMilis;
                }
            }
        }
        return newTimeInMili;
    }

    public Boolean isUserLocked(String username) {
        long currentTimeInMili;
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        String fieldValue = lockedUserDetails.get(username);
        long storedTime = Long.parseLong(fieldValue.split("=====")[0]);
        if (storedTime > (currentTimeInMili = System.currentTimeMillis())) {
            return Boolean.TRUE;
        }
        lockedUserDetails.remove(username);
        this.settings.setLockedUserDetails(lockedUserDetails);
        return Boolean.FALSE;
    }

    public void performUserLogout(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        LOGGER.debug("Performing Logout for :" + username);
        HttpSession session = request.getSession();
        session.invalidate();
    }

    public Map<String, String> getLockedUserDetailsUsingUsername(String usernameSearchKeyword, int userCount) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        if (userCount == -1) {
            return lockedUserDetails;
        }
        TreeMap<String, String> tempLockedUserDetails = new TreeMap<String, String>();
        for (String username : lockedUserDetails.keySet()) {
            if (StringUtils.containsIgnoreCase((CharSequence)username, (CharSequence)usernameSearchKeyword)) {
                tempLockedUserDetails.put(username, lockedUserDetails.get(username));
            }
            if (tempLockedUserDetails.size() < userCount) continue;
            return tempLockedUserDetails;
        }
        return tempLockedUserDetails;
    }

    public Map<String, String> getSelectedDetailsForPagination(Map<String, String> detailsList, Integer startIndex, Integer endIndex) {
        TreeMap<String, String> selectedDetailsPagination = new TreeMap<String, String>();
        int count = 0;
        for (String username : detailsList.keySet()) {
            if (++count < startIndex || count > endIndex) continue;
            String fieldValue = detailsList.get(username);
            Object storedDate = new Date(Long.parseLong(fieldValue.split("=====")[0])).toString();
            storedDate = (String)storedDate + "=====" + fieldValue.split("=====")[1];
            selectedDetailsPagination.put(username, (String)storedDate);
        }
        LOGGER.debug("Selected Details : " + String.valueOf(selectedDetailsPagination));
        return selectedDetailsPagination;
    }

    public void performLockedUserDetailsCleanUp() {
        LOGGER.debug("Performing Locked User Details Cleanup");
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        long currentTime = System.currentTimeMillis();
        ArrayList<String> detailsNeedsToBeRemoved = new ArrayList<String>();
        for (String username : lockedUserDetails.keySet()) {
            String fieldValue = lockedUserDetails.get(username);
            long storedValue = Long.parseLong(fieldValue.split("=====")[0]);
            if (currentTime <= storedValue) continue;
            detailsNeedsToBeRemoved.add(username);
        }
        LOGGER.debug("Locked User Details before remove : " + String.valueOf(lockedUserDetails));
        for (String username : detailsNeedsToBeRemoved) {
            lockedUserDetails.remove(username);
        }
        LOGGER.debug("Locked User Details after remove : " + String.valueOf(lockedUserDetails));
        this.settings.setLockedUserDetails(lockedUserDetails);
    }

    public Boolean shouldLockedOutUser(String username) {
        UserProfile user = this.userManager.getUserProfile(username);
        Boolean isAdmin = user != null && (this.userManager.isSystemAdmin(user.getUserKey()) || this.userManager.isAdmin(user.getUserKey()));
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            if (this.isOnlyUnlockedAdminUser(username).booleanValue()) {
                LOGGER.debug("Single Unlock Admin. Unable to unlock the user : " + username);
                return Boolean.FALSE;
            }
            LOGGER.debug("Not a single Admin Locked user: " + username);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    private Boolean isOnlyUnlockedAdminUser(String username) {
        Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
        int numberOfUnlockedAdminUsers = 0;
        List<String> administratorUsers = this.getAllUsersInGroup("crowd-administrators");
        Iterator<String> iterator2 = administratorUsers.iterator();
        while (iterator2.hasNext()) {
            if (numberOfUnlockedAdminUsers > 0) {
                return Boolean.FALSE;
            }
            String adminUsername = iterator2.next();
            if (StringUtils.equalsIgnoreCase((CharSequence)adminUsername, (CharSequence)username) || lockedUserDetails.get(adminUsername) != null) continue;
            ++numberOfUnlockedAdminUsers;
        }
        if (numberOfUnlockedAdminUsers == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<String> generateBackupCode() {
        ArrayList<String> backupCode = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            backupCode.add(this.randomAlphaNumeric(15));
        }
        return backupCode;
    }

    public List<String> encodeBackupCode(List<String> backupCodes) {
        ArrayList<String> encryptedBackupCode = new ArrayList<String>();
        for (String backupCode : backupCodes) {
            encryptedBackupCode.add(MoTwoFactorUtility.encryptString(backupCode, this.pluginConfiguration.SECRETE_KEY));
        }
        return encryptedBackupCode;
    }

    private String randomAlphaNumeric(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    private String randomNumericString(int count) {
        String ALPHA_NUMERIC_STRING = "0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public Boolean isSmtpConfigured() {
        return BooleanUtils.toBoolean((Boolean)this.mailManager.isConfigured());
    }

    public Boolean isDuoPushNotificationSettingsConfigured() {
        return StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationIntegrationKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationSecretKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getDuoPushNotificationHostName());
    }

    public Boolean isValidIntegrationKeyAndSecretKey(String integrationKey, String secretKey, String hostName) {
        LOGGER.info("Validating DUO IntegrationKey, SecretKey, and HostName");
        try {
            if (StringUtils.isBlank((CharSequence)integrationKey) && StringUtils.isBlank((CharSequence)secretKey) && StringUtils.isBlank((CharSequence)hostName)) {
                return true;
            }
            Http duoHttp = new Http("GET", hostName, "/auth/v2/check");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            LOGGER.debug("DUO details check Validation response: " + httpResponse);
            return jsonObject.get("stat") != null && StringUtils.equalsIgnoreCase((CharSequence)"OK", (CharSequence)jsonObject.get("stat").getAsString());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while validating Duo credentials: {}", e);
            return false;
        }
    }

    public JsonObject sendDuoPushNotificationPreauth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPushNotificationPreauth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        LOGGER.debug("integrationKey::" + integrationKey);
        LOGGER.debug("secretKey::" + secretKey);
        LOGGER.debug("hostName::" + hostName);
        Http duoHttp = new Http("POST", hostName, "/auth/v2/preauth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Push Preauth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            JsonObject result = new JsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("Json Object Response - result");
                result.addProperty("result", responseJsonObject.get("result").getAsString());
                LOGGER.debug("inside push preauth result :" + responseJsonObject.get("result").getAsString());
            }
            if (responseJsonObject.has("enroll_portal_url")) {
                LOGGER.debug("Json Object Response - enroll_portal_url");
                result.addProperty("enroll_portal_url", responseJsonObject.get("enroll_portal_url").getAsString());
                LOGGER.debug("inside push preauth enroll_portal_url :" + responseJsonObject.get("enroll_portal_url").getAsString());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(e));
            return null;
        }
    }

    public Boolean sendDuoPushNotificationAuth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPushNotificationAuth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        Http duoHttp = new Http("POST", hostName, "/auth/v2/auth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("factor", "push");
        duoHttp.addParam("hostname", "Crowd Server");
        duoHttp.addParam("device", "auto");
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside sendDuoPushNotificationAuth try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Push Auth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("return::" + StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString()));
                return StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(e));
        }
        LOGGER.debug("return value::False");
        return Boolean.FALSE;
    }

    public Boolean sendDuoPhoneCallAuth(String username, HttpServletRequest request) {
        LOGGER.debug("Calling sendDuoPhoneCallAuth");
        String integrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        String secretKey = this.settings.getDuoPushNotificationSecretKey();
        String hostName = this.settings.getDuoPushNotificationHostName();
        Http duoHttp = new Http("POST", hostName, "/auth/v2/auth");
        duoHttp.addParam("username", username);
        duoHttp.addParam("factor", "mobile_otp");
        duoHttp.addParam("hostname", "Crowd Server");
        duoHttp.addParam("device", "auto");
        duoHttp.addParam("ipaddr", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
        try {
            LOGGER.debug("inside sendDuoPhoneCallAuth try");
            duoHttp.signRequest(integrationKey, secretKey);
            String httpResponse = duoHttp.executeRequestRaw();
            LOGGER.debug("httpResponse inside Call Auth: " + httpResponse);
            JsonObject jsonObject = new JsonParser().parse(httpResponse).getAsJsonObject();
            JsonObject responseJsonObject = jsonObject.get("response").getAsJsonObject();
            if (responseJsonObject.has("result")) {
                LOGGER.debug("return::" + StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString()));
                return StringUtils.equalsIgnoreCase((CharSequence)"allow", (CharSequence)responseJsonObject.get("result").getAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(e));
        }
        LOGGER.debug("return value::False");
        return Boolean.FALSE;
    }

    public Boolean isSmsGatewayConfigured() {
        if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
            return StringUtils.isNotBlank((CharSequence)this.settings.getApiKey()) && StringUtils.isNotBlank((CharSequence)this.settings.getCustomerKey());
        }
        return StringUtils.isNotBlank((CharSequence)this.settings.getSmsGatewayUrl());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendOtpOnSms(HttpServletRequest request, UserProfile user, String countryCode, String mobileNumber) throws Exception {
        CloseableHttpClient httpClient;
        long currentTimeInMili;
        HttpSession session;
        block9: {
            LOGGER.debug("countryCode: " + countryCode);
            LOGGER.debug("mobileNumber: " + mobileNumber);
            session = request.getSession(true);
            currentTimeInMili = System.currentTimeMillis();
            if (session.getAttribute("last_otp_sent_time") != null) {
                long lastOtpSentTime = (Long)session.getAttribute("last_otp_sent_time");
                LOGGER.debug("currentTimeInMili: " + currentTimeInMili);
                LOGGER.debug("lastOtpSentTime: " + lastOtpSentTime);
                if (currentTimeInMili - lastOtpSentTime < 15000L) {
                    return;
                }
            } else {
                LOGGER.debug("last_otp_sent_time not found in session");
            }
            httpClient = HttpClients.createDefault();
            if (StringUtils.equals((CharSequence)this.settings.getSmsGateway(), (CharSequence)"miniOrange Gateway")) {
                HttpPost postRequest = this.sendOtpUsingMiniOrangeGateway(currentTimeInMili, user.getEmail(), countryCode, mobileNumber);
                CloseableHttpResponse response = httpClient.execute(postRequest);
                LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
                if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                    LOGGER.debug("Response Entity found. Reading Response payload.");
                    String status = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                    LOGGER.debug("Response payload: " + status);
                    JSONObject jsonResponseObject = new JSONObject(status);
                    String responseStatus = jsonResponseObject.get("status").toString();
                    if (StringUtils.equals((CharSequence)responseStatus, (CharSequence)"FAILED") || StringUtils.equals((CharSequence)responseStatus, (CharSequence)"ERROR")) {
                        LOGGER.error("Error in sending SMS using MiniOrange Gateway. " + jsonResponseObject.get("message").toString());
                        throw new Exception("Error in sending SMS using MiniOrange Gateway");
                    }
                    String txId = jsonResponseObject.get("txId").toString();
                    LOGGER.debug("txId: " + txId);
                    session.setAttribute("txId", (Object)txId);
                    break block9;
                } else {
                    LOGGER.error("Response Entity NOT found. Returning EMPTY string. Error in sending SMS using MiniOrange Gateway");
                    throw new Exception("Error in sending SMS using MiniOrange Gateway");
                }
            }
            String otp = this.randomNumericString(this.settings.getOtpLength());
            String message = this.settings.getSmsTemplate();
            message = StringUtils.replace((String)message, (String)"$$username$$", (String)user.getUsername());
            message = StringUtils.replace((String)message, (String)"$$otp$$", (String)otp);
            String smsGatewayUrl = this.settings.getSmsGatewayUrl();
            smsGatewayUrl = StringUtils.replace((String)smsGatewayUrl, (String)"##phone##", (String)(countryCode + mobileNumber));
            smsGatewayUrl = StringUtils.replace((String)smsGatewayUrl, (String)"##message##", (String)URLEncoder.encode(message, "UTF-8"));
            HttpPost postRequest = new HttpPost(smsGatewayUrl);
            postRequest.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = httpClient.execute(postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String status = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Response payload: " + status);
            } else {
                LOGGER.error("Response Entity NOT found. Returning EMPTY string.");
            }
            LOGGER.debug("otp: " + otp);
            session.setAttribute("sms_otp_code", (Object)otp);
        }
        httpClient.close();
        long newTimeInMili = (long)(this.settings.getOtpValidityDuration() * 60000) + currentTimeInMili;
        session.setAttribute("otp_expiry_time", (Object)newTimeInMili);
        session.setAttribute("last_otp_sent_time", (Object)currentTimeInMili);
        session.setAttribute("mobileNumber", (Object)mobileNumber);
        session.setAttribute("countryCode", (Object)countryCode);
        LOGGER.debug("SMS sent successfully");
    }

    public HttpPost sendOtpUsingMiniOrangeGateway(long currentTimeInMili, String emailAddress, String countryCode, String mobileNumber) throws Exception {
        String generateUrl = "https://login.xecurify.com/moas/api/auth/challenge";
        String customerKey = this.settings.getCustomerKey();
        String apiKey = this.settings.getApiKey();
        String jsonRequestString = "{\"customerKey\":\"" + customerKey + "\" ,\"email\" : \" " + emailAddress + "\" ,\"phone\":\"" + countryCode + mobileNumber + "\" ,\"authType\" : \"SMS\" ,\"transactionName\" : \"CUSTOM-OTP-VERIFICATION\"}";
        return this.getPostRequestObjectForMiniOrangeGateway(currentTimeInMili, jsonRequestString, generateUrl, customerKey, apiKey);
    }

    public HttpPost getPostRequestObjectForMiniOrangeGateway(long currentTimeInMili, String jsonRequestString, String url, String customerKey, String apiKey) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String stringToHash = customerKey + String.valueOf(currentTimeInMili) + apiKey;
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        byte[] messageDigest = md.digest(stringToHash.getBytes());
        BigInteger no = new BigInteger(1, messageDigest);
        Object hashValue = no.toString(16);
        while (((String)hashValue).length() < 32) {
            hashValue = "0" + (String)hashValue;
        }
        HttpPost postRequest = new HttpPost(url);
        StringEntity input = new StringEntity(jsonRequestString);
        input.setContentType("application/json");
        postRequest.setEntity(input);
        postRequest.setHeader("Customer-Key", customerKey);
        postRequest.setHeader("Timestamp", String.valueOf(currentTimeInMili));
        postRequest.setHeader("Authorization", (String)hashValue);
        return postRequest;
    }

    public Boolean validateOtpUsingMiniOrangeGateway(long currentTimeInMili, String otp, String txId) throws Exception {
        String validateUrl = "https://login.xecurify.com/moas/api/auth/validate";
        String customerKey = this.settings.getCustomerKey();
        String apiKey = this.settings.getApiKey();
        String jsonRequestString = "{\"txId\":\"" + txId + "\",\"token\":\"" + otp + "\"}";
        HttpPost postRequest = this.getPostRequestObjectForMiniOrangeGateway(currentTimeInMili, jsonRequestString, validateUrl, customerKey, apiKey);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute(postRequest);
        LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
        if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
            LOGGER.debug("Response Entity found. Reading Response payload.");
            String status = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
            LOGGER.debug("Response payload: " + status);
            JSONObject jsonResponseObject = new JSONObject(status);
            String responseStatus = jsonResponseObject.get("status").toString();
            if (StringUtils.isNotBlank((CharSequence)responseStatus) && (StringUtils.equals((CharSequence)responseStatus, (CharSequence)"FAILED") || StringUtils.equals((CharSequence)responseStatus, (CharSequence)"ERROR"))) {
                LOGGER.error("OTP validation failed: " + jsonResponseObject.get("message").toString());
                httpClient.close();
                return false;
            }
        } else {
            LOGGER.error("Response Entity NOT found. Returning EMPTY string.");
            throw new Exception("Error in sending SMS using miniOrange Gateway");
        }
        httpClient.close();
        return response.getStatusLine().getStatusCode() == 200;
    }

    public String sendEmail(String subject, String body, String toMail) {
        try {
            Boolean StartTLS;
            String mailFrom;
            String mailServerPassword;
            String mailServerUsername;
            Integer port;
            String hostname;
            String protocol;
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
            if (this.settings.getCustomMailServer().booleanValue()) {
                LOGGER.debug("Custom Mail Server is enabled");
                protocol = this.settings.getCustomMailServerProtocol();
                hostname = this.settings.getCustomMailServerHostName();
                port = Integer.parseInt(this.settings.getCustomMailServerSmtpPort());
                mailServerUsername = MoTwoFactorUtility.decryptString(this.settings.getCustomMailServerUsername(), "MO2FA_CUSTOM_MAIL_SERVER_USERNAME");
                mailServerPassword = MoTwoFactorUtility.decryptString(this.settings.getCustomMailServerPassword(), "MO2FA_CUSTOM_MAIL_SERVER_PASSWORD");
                mailFrom = this.settings.getCustomMailServerFromAddress();
                StartTLS = this.settings.getCustomMailServerTls();
            } else {
                LOGGER.debug("Using default SMTP mail server");
                MailConfiguration mailserver = this.mailManager.getMailConfiguration();
                SMTPServer smtpServer = mailserver.getSmtpServer();
                protocol = "SMTP";
                hostname = smtpServer.getHost();
                port = Integer.parseInt(String.valueOf(smtpServer.getPort()));
                mailServerUsername = smtpServer.getUsername();
                mailServerPassword = smtpServer.getPassword();
                mailFrom = String.valueOf(smtpServer.getFrom());
                StartTLS = smtpServer.isStartTLS();
            }
            if (!(mailServerUsername.isEmpty() && mailServerPassword.isEmpty() && mailFrom.isEmpty())) {
                LOGGER.debug("Sending Mail");
                Properties properties = System.getProperties();
                LOGGER.debug("system properties = " + String.valueOf(properties));
                LOGGER.debug("Details: protocol = " + protocol + " hostname = " + hostname + " port = " + port + " mailFrom = " + mailFrom);
                properties.setProperty("mail.transport.protocol", String.valueOf(protocol).toLowerCase());
                properties.setProperty("mail.smtps.host", hostname);
                if (String.valueOf(protocol) == "SMTPS") {
                    properties.setProperty("mail.smtp.starttls.enable", "true");
                    if (port == null) {
                        port = 465;
                    }
                    if (!mailServerUsername.isEmpty() && !mailServerPassword.isEmpty()) {
                        properties.setProperty("mail.smtps.auth", "true");
                    }
                    properties.setProperty("mail.smtps.port", String.valueOf(port));
                } else {
                    if (StartTLS.booleanValue()) {
                        properties.setProperty("mail.smtp.starttls.enable", "true");
                    }
                    if (port == null) {
                        port = 25;
                    }
                    if (!mailServerUsername.isEmpty() && !mailServerPassword.isEmpty()) {
                        properties.setProperty("mail.smtp.auth", "true");
                    }
                    properties.setProperty("mail.smtp.port", String.valueOf(port));
                }
                properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                LOGGER.debug("Updated properties = " + String.valueOf(properties));
                Session sessionObject = Session.getDefaultInstance((Properties)properties);
                LOGGER.debug("sessionObject = " + String.valueOf(sessionObject));
                MimeMessage message = new MimeMessage(sessionObject);
                message.setSubject(subject);
                message.setContent((Object)body, "text/html");
                message.setSender((Address)new InternetAddress(mailFrom));
                message.setFrom((Address)new InternetAddress(mailFrom));
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toMail));
                LOGGER.debug("composed mail = " + String.valueOf(message));
                if (!mailServerUsername.isEmpty() && !mailServerPassword.isEmpty()) {
                    Transport transport = sessionObject.getTransport();
                    transport.connect(hostname, port.intValue(), mailServerUsername, mailServerPassword);
                    transport.sendMessage((Message)message, message.getRecipients(Message.RecipientType.TO));
                    LOGGER.debug("Successfully sent email");
                    transport.close();
                } else {
                    Transport.send((Message)message);
                    LOGGER.debug("Successfully sent email without authenticating mail server");
                }
            } else {
                LOGGER.debug("Mail server details are empty. Not sending email");
                Thread.currentThread().setContextClassLoader(threadClassLoader);
                return "Mail server details are empty. Not sending email";
            }
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
        catch (Exception e) {
            LOGGER.error("Error while sending Email from OTP over Email Custom Mail Server :", e);
            return "Error while sending Email from OTP over Email Custom Mail Server :" + e.getMessage();
        }
        return "Success";
    }

    public String sendOtpOnEmail(HttpServletRequest request, UserProfile crowdUser) throws Exception {
        if (this.isSmtpConfigured().booleanValue() || this.settings.getCustomMailServer().booleanValue()) {
            HttpSession httpSession = request.getSession(true);
            long currentTimeInMili = System.currentTimeMillis();
            if (httpSession.getAttribute("last_otp_sent_time") != null) {
                long lastOtpSentTime = (Long)httpSession.getAttribute("last_otp_sent_time");
                LOGGER.debug("currentTimeInMili: " + currentTimeInMili);
                LOGGER.debug("lastOtpSentTime: " + lastOtpSentTime);
                if (currentTimeInMili - lastOtpSentTime < 15000L) {
                    LOGGER.debug("OTP mail not sent");
                    return "OTP mail not sent";
                }
            } else {
                LOGGER.debug("last_otp_sent_time not found in session");
            }
            String otp = this.randomNumericString(this.settings.getOtpLength());
            String subject = this.settings.getEmailSubject();
            String body = this.settings.getEmailTemplate();
            body = StringUtils.replaceIgnoreCase((String)body, (String)"$$username$$", (String)crowdUser.getUsername());
            body = StringUtils.replaceIgnoreCase((String)body, (String)"$$otp$$", (String)otp);
            String message = this.sendEmail(subject, body, crowdUser.getEmail());
            LOGGER.debug(" Message received from Mail server:" + message);
            if (StringUtils.equalsIgnoreCase((CharSequence)message, (CharSequence)"Success")) {
                httpSession.setAttribute("otp_code", (Object)otp);
                long newTimeInMili = (long)(this.settings.getOtpValidityDuration() * 60000) + currentTimeInMili;
                httpSession.setAttribute("otp_expiry_time", (Object)newTimeInMili);
                httpSession.setAttribute("last_otp_sent_time", (Object)currentTimeInMili);
                LOGGER.debug("Send email successfully");
            }
            return message;
        }
        LOGGER.debug("Mail Sever is Not Configured ");
        return "Failed";
    }

    public void sendEmailBruteForce(HttpServletRequest request, UserProfile user) throws Exception {
        if (this.isSmtpConfigured().booleanValue() || this.settings.getCustomMailServer().booleanValue()) {
            String subject = "Your Crowd account is temporarily locked.";
            String body = this.settings.getEmailTemplateBruteForce();
            String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
            if (body.contains("$$ipaddress$$")) {
                body = body.replace("$$ipaddress$$", currentIpAddress);
            }
            String message = this.sendEmail(subject, body, user.getEmail());
            LOGGER.debug("Status of email sent for locked account:" + message);
        } else {
            LOGGER.debug("Crowd account is temporarily locked but no mail is sent as no mail server is configured.");
        }
    }

    public void sendAlertEmailToSoloAdmin(HttpServletRequest request, UserProfile user) throws Exception {
        if (this.isSmtpConfigured().booleanValue()) {
            String subject = "Your Crowd account may be hacked.";
            String body = this.settings.getEmailTemplateBruteForceForSoloAdmin();
            String currentIpAddress = MoTwoFactorUtility.getCurrentIpAddress(request, this.settings);
            if (body.contains("$$ipaddress$$")) {
                body = body.replace("$$ipaddress$$", currentIpAddress);
            }
            if (body.contains("$$username$$")) {
                body = body.replace("$$username$$", user.getEmail());
            }
            String message = this.sendEmail(subject, body, user.getEmail());
            LOGGER.debug("Successfully sent an alert email to solo admin." + message);
        } else {
            LOGGER.debug("Unable to send an alert email to solo admin as no mail server is configured.");
        }
    }

    public void sendEmailReset2fa(UserProfile crowdUser) throws Exception {
        if (this.isSmtpConfigured().booleanValue() || this.settings.getCustomMailServer().booleanValue()) {
            String subject = "Your Crowd second factor got reset.";
            String body = this.settings.getReset2faEmailTemplate();
            String message = this.sendEmail(subject, body, crowdUser.getEmail());
            LOGGER.debug("Status of alert email sent to the user:" + message);
        } else {
            LOGGER.debug("Unable to send an alert email to user as no mail server is configured.");
        }
    }

    public String getInlineRegistrationBackupMethodUrl(HttpServletRequest request, List<String> configuredMethodsByUser, String username) {
        String url = "";
        List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
        ArrayList<String> remainingMethods = new ArrayList<String>();
        for (String method : enabledBackupMethodList) {
            if (configuredMethodsByUser.contains(method) || !this.isPageAllowed(method, username).booleanValue()) continue;
            remainingMethods.add(method);
        }
        if (remainingMethods.size() == 0) {
            LOGGER.debug("No backup method Enabled or backup method is already configured.");
            return url;
        }
        if (remainingMethods.size() > 1) {
            LOGGER.debug("Redirecting to Backup Method List");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupmethodlist");
        } else if (remainingMethods.contains("SecurityQuestion")) {
            LOGGER.debug("Redirecting to Security Question");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
        } else if (remainingMethods.contains("OtpOverEmail")) {
            LOGGER.debug("Redirecting to OTP Over Email");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
        } else if (remainingMethods.contains("OtpOverSms")) {
            LOGGER.debug("Redirecting to OTP Over SMS");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms");
        } else if (remainingMethods.contains("GoogleAuthenticator")) {
            LOGGER.debug("Redirecting to Mobile Authenticator");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
        } else if (remainingMethods.contains("YubikeyHardwareTokenAsU2F")) {
            LOGGER.debug("Redirecting to Yubikey Hardware");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
        } else if (remainingMethods.contains("WebAuthn")) {
            LOGGER.debug("Redirecting to Web Authn");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
        } else if (remainingMethods.contains("DuoPushNotification")) {
            LOGGER.debug("Redirecting to Duo Push Notification");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification");
        } else if (remainingMethods.contains("BackupCode")) {
            LOGGER.debug("Redirecting to Backup Code");
            url = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_backupcode");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            HttpSession session = request.getSession();
            session.setAttribute("considering_backup_method", (Object)true);
        }
        return url;
    }

    public Boolean isSystemAdmin() {
        Boolean isAdmin = Boolean.FALSE;
        String CurrentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)CurrentLoggedInUser)) {
            UserProfile userProfile = this.userManager.getUserProfile(CurrentLoggedInUser);
            LOGGER.debug("Current Logged In User : " + CurrentLoggedInUser);
            if (this.userManager.isAdmin(userProfile.getUserKey())) {
                isAdmin = Boolean.TRUE;
                return isAdmin;
            }
        }
        return isAdmin;
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/rest/customer/key", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders("16555", "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            LOGGER.debug("response: " + response);
            if (StringUtils.equals((CharSequence)response, (CharSequence)"The customer is not valid")) {
                throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "Couldn't verify your account. Please contact support at support-atlassian@miniorange.atlassian.net", null);
            }
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    Long customerId = Long.valueOf(jsonObj.getString("id"));
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "Couldn't verify your account. Please contact support at support-atlassian@miniorange.atlassian.net", null);
            }
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("An account verification error occurred ", e);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(String customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", customerId);
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public Boolean verifyLicense(MoTwoFactorCrowdPluginSettings pluginSettings, String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", pluginSettings.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", pluginSettings.getBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(pluginSettings.getCustomerID(), pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("Verify license response: " + response);
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                LOGGER.debug(" statusNode : " + statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    this.getLicencedUsers(pluginSettings);
                    pluginSettings.setCustomerLicenseKey(key);
                    pluginSettings.setLicenseVerified(Boolean.TRUE);
                    return true;
                }
                return false;
            }
            LOGGER.debug("Please contact support. Response String: " + response);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying license key", e);
            return false;
        }
    }

    public void getLicencedUsers(MoTwoFactorCrowdPluginSettings pluginSettings) {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", pluginSettings.getCustomerID());
            jsonObject.put("applicationName", "crowd_2FA_premium_plan");
            String json = jsonObject.toString();
            String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(pluginSettings.getCustomerID(), pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("check customer license response: " + response);
            if (MoTwoFactorPluginHandler.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")).toString(), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    pluginSettings.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    pluginSettings.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    LOGGER.debug("No. of licensed users = " + licensedUsers);
                    if (licensedUsers > 0) {
                        pluginSettings.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            LOGGER.error("Please contact support. Response String: " + response);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("an error occurred while getting licensed users", e);
            throw new MoTwoFactorPluginException(MoTwoFactorPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean checkLicenseCondition() {
        if (this.pluginSettings.isNoOfUserExceed().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue()) {
            if (this.pluginSettings.getMailSent().booleanValue()) {
                this.deactivateAndRemoveCustomerAccount();
                return false;
            }
            LOGGER.debug("Sending User limit exceeded email");
            this.sendEmail("You have exceeded license users count for miniOrange Crowd 2FA plugin. Please update you license otherwise plugin will stop working after 7 days from now", "Hello,<br><br>You have exceeded allowed users count (" + this.pluginSettings.getLicencedUsers() + " users) on your Crowd Server. <br>Your account will be deactivated after 7 days.Please upgrade your license.Contact us at support-atlassian@miniorange.atlassian.net to get more information and to upgrade your license.<br><br>Thanks,<br>miniOrange");
            this.pluginSettings.setMailSent(true);
        } else {
            this.pluginSettings.setMailSent(false);
        }
        return true;
    }

    public void sendEmail(String subject, String content) {
        try {
            LOGGER.debug("Sending email alert");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", this.pluginSettings.getCustomerID());
            jsonObject.put("sendEmail", true);
            JSONObject emailObject = new JSONObject();
            emailObject.put("customerKey", this.pluginSettings.getCustomerID());
            emailObject.put("fromEmail", "info@miniorange.com");
            emailObject.put("bccEmail", "info@miniorange.com");
            emailObject.put("fromName", "miniOrange");
            emailObject.put("toEmail", this.pluginSettings.getCustomerEmail());
            emailObject.put("toName", this.pluginSettings.getCustomerEmail());
            emailObject.put("subject", subject);
            emailObject.put("content", content);
            jsonObject.put("email", emailObject);
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/notify/send", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(this.pluginSettings.getCustomerID(), this.pluginSettings.getCustomerAPIKey()));
            LOGGER.debug("Email alert response: " + response);
        }
        catch (Exception e) {
            LOGGER.error("Error ocurred while sending email " + String.valueOf(e));
        }
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            if (this.pluginSettings.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", this.pluginSettings.getCustomerLicenseKey());
                jsonObject.put("customerKey", this.pluginSettings.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", this.pluginSettings.getBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = MoTwoFactorUtility.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", MoTwoFactorPluginHandler.getAuthorizationHeaders(this.pluginSettings.getCustomerID(), this.pluginSettings.getCustomerAPIKey()));
                LOGGER.debug("Deactivate license response: " + response);
            }
            this.pluginSettings.removeCustomerAccount();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while deactivating the license.", e);
            this.pluginSettings.removeCustomerAccount();
        }
    }

    private static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public void storeAuditLogs(String username, String ip, String action, String loginMethod) {
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        Date newdate = new Date(timeMilliSecs);
        if (this.settings.getRecordAuditLogsToggleButton().booleanValue() && this.settings.getRecordAuditLogFilter().contains(action)) {
            this.moLogEntityService.add(username, ip, newdate, action, loginMethod);
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public int checkNumberOfLoginAttemptsLeft(HttpServletRequest request, String username) {
        if (this.settings.getEnableBruteForceProtection().booleanValue()) {
            if (!this.isOnlyUnlockedAdminUser(username).booleanValue()) {
                HttpSession session = request.getSession();
                Integer loginAttemptsLeft = session.getAttribute("2fa_invalid_validation_attempt_count") != null ? Integer.valueOf(this.settings.getBruteForceNumberOfAttempts() - (Integer)session.getAttribute("2fa_invalid_validation_attempt_count")) : Integer.valueOf(this.settings.getBruteForceNumberOfAttempts() - 0);
                return loginAttemptsLeft;
            }
            LOGGER.debug("Unlimited login attempts available as user is a solo admin");
            return -1;
        }
        LOGGER.debug("Unlimited login attempts available as Brute Force Protection is not enabled");
        return -1;
    }

    public String getPageAccessForCurrentUser(String pageName) {
        if (this.isSystemAdmin().booleanValue()) {
            return "readwrite";
        }
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        String accessType = "";
        Map<String, String> groupsWithAdminPagesAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        List<String> userGroups = this.pluginConfiguration.getAllGroupsOfUser(username);
        List<Object> pageAccessGroups_read = new ArrayList();
        if (groupsWithAdminPagesAccessMap.get(pageName + "_read") != null) {
            pageAccessGroups_read = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_read").split(","));
        }
        List<Object> pageAccessGroups_readwrite = new ArrayList();
        if (groupsWithAdminPagesAccessMap.get(pageName + "_readwrite") != null) {
            pageAccessGroups_readwrite = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_readwrite").split(","));
        }
        if (!(userGroups.isEmpty() || pageAccessGroups_read.isEmpty() && pageAccessGroups_readwrite.isEmpty())) {
            for (String group : userGroups) {
                if (!pageAccessGroups_read.isEmpty() && pageAccessGroups_read.contains(group)) {
                    accessType = "read";
                }
                if (pageAccessGroups_readwrite.isEmpty() || !pageAccessGroups_readwrite.contains(group)) continue;
                accessType = "readwrite";
                break;
            }
        }
        return accessType;
    }

    public List<String> getUserAccessiblePages() {
        ArrayList<String> pages = new ArrayList<String>();
        Boolean isSystemAdmin = this.isSystemAdmin();
        Map<String, String> groupsWithAdminPagesAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
        List<String> pageNames = this.getPluginPages();
        for (String pageName : pageNames) {
            if (isSystemAdmin.booleanValue()) {
                pages.add(pageName + "_readwrite");
                continue;
            }
            List<Object> pageAccessGroups_read = new ArrayList();
            if (groupsWithAdminPagesAccessMap.get(pageName + "_read") != null) {
                pageAccessGroups_read = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_read").split(","));
            }
            List<Object> pageAccessGroups_readwrite = new ArrayList();
            if (groupsWithAdminPagesAccessMap.get(pageName + "_readwrite") != null) {
                pageAccessGroups_readwrite = Arrays.asList(groupsWithAdminPagesAccessMap.get(pageName + "_readwrite").split(","));
            }
            for (String string : pageAccessGroups_read) {
                if (!userGroups.contains(string)) continue;
                pages.add(pageName + "_read");
            }
            for (String string : pageAccessGroups_readwrite) {
                if (!userGroups.contains(string)) continue;
                pages.add(pageName + "_readwrite");
            }
        }
        return pages;
    }

    public List<String> getPluginPages() {
        ArrayList<String> pageNames = new ArrayList<String>();
        pageNames.add("Basic_Configuration");
        pageNames.add("User_Management");
        pageNames.add("IP_Restriction");
        pageNames.add("Advanced_Settings");
        pageNames.add("Audit_Logs");
        pageNames.add("LookAndFeel");
        pageNames.add("TroubleShooting");
        return pageNames;
    }

    public Boolean isTwoFactorVerifiedOrIsTwoFactorDisabled(HttpServletRequest request) {
        Boolean verifiedOrDisabled = Boolean.FALSE;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            List<String> enable2FAUserList = this.settings.getEnable2FAForUsersList();
            Boolean enabledForUser = enable2FAUserList.contains(username);
            Boolean verified = MoTwoFactorUtility.isTwoFactorVerified(request);
            Boolean enabledForCrowd = this.settings.getEnableTwoFactor();
            if (!enabledForCrowd.booleanValue() || !enabledForUser.booleanValue() || verified.booleanValue()) {
                verifiedOrDisabled = Boolean.TRUE;
            } else {
                List<String> excludeGroups = this.settings.getExclude2faForGroupList();
                if (excludeGroups.size() > 0) {
                    List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
                    for (String group : excludeGroups) {
                        if (!userGroups.contains(group)) continue;
                        verifiedOrDisabled = Boolean.TRUE;
                        break;
                    }
                }
            }
            LOGGER.debug("Two Factor Verified Or Two Factor Disabled :" + verifiedOrDisabled);
            return verifiedOrDisabled;
        }
        LOGGER.error("No Logged in user found");
        return false;
    }

    public Boolean isPageAllowed(String pageName, String username) {
        List<String> userGroups = this.pluginConfiguration.getUsersGroup(username);
        Map<String, String> mfaMethodsBasedOnGroupsMap = this.settings.getMfaMethodsBasedOnGroupsMap();
        LOGGER.debug("Checking if method(" + pageName + ")is allowed for the user (" + username + ")");
        if (mfaMethodsBasedOnGroupsMap.containsKey(pageName)) {
            List<String> restrictedGroups = Arrays.asList(mfaMethodsBasedOnGroupsMap.get(pageName).split(","));
            for (String group : restrictedGroups) {
                if (!userGroups.contains(group)) continue;
                return true;
            }
            if (this.settings.getFallBackMethods().contains(pageName)) {
                List<String> allPageSet = this.settings.get2FAMethodForUserList();
                for (String page : allPageSet) {
                    if (mfaMethodsBasedOnGroupsMap.get(page) != null) {
                        List<String> restrictedGroupsForPage = Arrays.asList(mfaMethodsBasedOnGroupsMap.get(page).split(","));
                        if (restrictedGroupsForPage.isEmpty() || Collections.disjoint(userGroups, restrictedGroupsForPage)) continue;
                        return false;
                    }
                    LOGGER.debug(page + ": this method is not added in 2FA Methods Based on Groups, so this user is not in fallback category.");
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public String decryptWithDynamicKey(Cookie cookie) {
        try {
            if (cookie == null) {
                return null;
            }
            String cookieValue = "";
            if (PluginInstallEvent.encryptionKeys.containsKey("currentKey")) {
                String currentDecryptionKey = PluginInstallEvent.encryptionKeys.get("currentKey").get(0);
                cookieValue = MoTwoFactorUtility.decryptString(cookie.getValue(), currentDecryptionKey);
            }
            if (StringUtils.isBlank((CharSequence)cookieValue) && PluginInstallEvent.encryptionKeys.containsKey("previousKey")) {
                String prevDecryptionKey = PluginInstallEvent.encryptionKeys.get("previousKey").get(0);
                cookieValue = MoTwoFactorUtility.decryptString(cookie.getValue(), prevDecryptionKey);
            }
            return cookieValue;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while decrypting cookieValue ", e);
            return "";
        }
    }
}

