/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.model.ChunkableDataItem;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Map
extends ChunkableDataItem {
    private final HashMap<DataItem, DataItem> map;
    private final List<DataItem> keys = new LinkedList<DataItem>();

    public Map() {
        super(MajorType.MAP);
        this.map = new HashMap();
    }

    public Map(int initialCapacity) {
        super(MajorType.MAP);
        this.map = new HashMap(initialCapacity);
    }

    public Map put(DataItem key, DataItem value) {
        if (this.map.put(key, value) == null) {
            this.keys.add(key);
        }
        return this;
    }

    public DataItem get(DataItem key) {
        return this.map.get(key);
    }

    public DataItem remove(DataItem key) {
        return this.map.remove(key);
    }

    public Collection<DataItem> getKeys() {
        return this.keys;
    }

    public Collection<DataItem> getValues() {
        return this.map.values();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map other = (Map)object;
            return this.map.equals(other.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isChunked()) {
            stringBuilder.append("{_ ");
        } else {
            stringBuilder.append("{ ");
        }
        for (Map.Entry<DataItem, DataItem> entry : this.map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        if (stringBuilder.toString().endsWith(", ")) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

