/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.UnicodeString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class UnicodeStringDecoder
extends AbstractDecoder<UnicodeString> {
    private static final Charset UTF8 = Charset.forName("UTF8");

    public UnicodeStringDecoder(CborDecoder decoder, InputStream inputStream2) {
        super(decoder, inputStream2);
    }

    @Override
    public UnicodeString decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            if (this.decoder.isAutoDecodeInfinitiveUnicodeStrings()) {
                return this.decodeInfinitiveLength();
            }
            UnicodeString unicodeString = new UnicodeString(null);
            unicodeString.setChunked(true);
            return unicodeString;
        }
        return this.decodeFixedLength(length);
    }

    private UnicodeString decodeInfinitiveLength() throws CborException {
        ByteArrayOutputStream bytes;
        block3: {
            MajorType majorType;
            bytes = new ByteArrayOutputStream();
            while (true) {
                DataItem dataItem = this.decoder.decodeNext();
                majorType = dataItem.getMajorType();
                if (Special.BREAK.equals(dataItem)) break block3;
                if (majorType != MajorType.UNICODE_STRING) break;
                UnicodeString unicodeString = (UnicodeString)dataItem;
                try {
                    bytes.write(unicodeString.toString().getBytes(UTF8));
                }
                catch (IOException ioException) {
                    throw new CborException(ioException);
                }
            }
            throw new CborException("Unexpected major type " + (Object)((Object)majorType));
        }
        return new UnicodeString(new String(bytes.toByteArray(), UTF8));
    }

    private UnicodeString decodeFixedLength(long length) throws CborException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream((int)length);
        for (long i = 0L; i < length; ++i) {
            bytes.write(this.nextSymbol());
        }
        return new UnicodeString(new String(bytes.toByteArray(), UTF8));
    }
}

