/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.builder;

import co.nstant.in.cbor.builder.AbstractBuilder;
import co.nstant.in.cbor.builder.ArrayBuilder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;

public class MapBuilder<T extends AbstractBuilder<?>>
extends AbstractBuilder<T> {
    private final Map map;

    public MapBuilder(T parent, Map map) {
        super(parent);
        this.map = map;
    }

    public MapBuilder<T> put(DataItem key, DataItem value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<T> put(long key, long value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, boolean value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, float value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, double value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, byte[] value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, String value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, long value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, boolean value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, float value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, double value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, byte[] value) {
        this.map.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, String value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public ArrayBuilder<MapBuilder<T>> putArray(long key) {
        Array array = new Array();
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> putArray(String key) {
        Array array = new Array();
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> startArray(String key) {
        Array array = new Array();
        array.setChunked(true);
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public MapBuilder<MapBuilder<T>> putMap(long key) {
        Map nestedMap = new Map();
        this.put(this.convert(key), nestedMap);
        return new MapBuilder<MapBuilder<T>>(this, nestedMap);
    }

    public T end() {
        return (T)((AbstractBuilder)this.getParent());
    }
}

