/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class MoHttpUtils {
    private static Log LOGGER = LogFactory.getLog(MoHttpUtils.class);
    private static MoSettings settings;

    public MoHttpUtils(MoSettings settings) {
        MoHttpUtils.settings = settings;
    }

    public static String sendGetRequest(String url) {
        try {
            LOGGER.debug("MoHttpUtils sendGetRequest Sending GET request to " + url);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(getRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String data = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                httpClient.close();
                return data;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public static String sendPostRequest(String url, List<NameValuePair> data, String contentType, HashMap headers) {
        try {
            LOGGER.debug("HttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data + " & base url :- " + settings.getApplicationBaseUrl());
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            LOGGER.debug("httpClient : " + httpClient);
            url = settings.getApplicationBaseUrl() + "/plugins/servlet" + url;
            LOGGER.debug("Hitting URL : " + url);
            HttpPost postRequest = new HttpPost(url);
            LOGGER.debug("Post Request : " + postRequest.toString());
            if (headers != null) {
                Iterator iterator2 = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator2.hasNext()) {
                        Map.Entry pairs = iterator2.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data);
            entity.setContentType(contentType);
            postRequest.setEntity(entity);
            LOGGER.debug("Executing post request : " + postRequest.toString());
            return MoHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            LOGGER.debug("Error in sending post request, " + e.toString());
            e.printStackTrace();
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute(postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                LOGGER.debug("Response Entity found. Reading Response payload.");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug("Response payload: " + status);
                httpClient.close();
                LOGGER.debug("Status" + status);
                return status;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.debug("Error in executing post request, " + e.toString());
            e.printStackTrace();
            return "Failed";
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory(sslConnectionFactory);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslConnectionFactory).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager(registry);
        builder.setConnectionManager(ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner(routePlanner).setConnectionManager(ccm).build();
        return httpclient;
    }

    public static MoSettings getSettings() {
        return settings;
    }

    public static void setSettings(MoSettings settings) {
        MoHttpUtils.settings = settings;
    }
}

