/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.webauthn.utils.CableSessionData;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationExtensionsClientInputs {
    public List<CableSessionData> cableAuthentication;
    public KeyPair rpPublicKey;
    JsonObject registrationExtensions;
    private static int EC_COORDINATE_LENGTH = 32;
    private static int EC_PUBLIC_KEY_LENGTH = 65;
    private static byte EC_PUBLIC_KEY_PREFIX = (byte)4;

    public static AuthenticationExtensionsClientInputs parse(String parameter) {
        Gson gson = new Gson();
        return gson.fromJson(parameter, AuthenticationExtensionsClientInputs.class);
    }

    public void addCableSessionData(CableSessionData cableSessionData) {
        if (this.cableAuthentication == null) {
            this.cableAuthentication = new ArrayList<CableSessionData>();
        }
        this.cableAuthentication.add(cableSessionData);
    }

    public JsonObject getJsonObject() {
        JsonObject result = new JsonObject();
        if (this.cableAuthentication != null) {
            JsonArray cableSessionDatas = new JsonArray();
            for (CableSessionData sessionData : this.cableAuthentication) {
                cableSessionDatas.add(sessionData.getJsonObject());
            }
            result.add("cableAuthentication", cableSessionDatas);
        }
        return result;
    }

    public KeyPair addCableRegistrationData() throws Exception {
        if (this.registrationExtensions == null) {
            this.registrationExtensions = new JsonObject();
        }
        try {
            KeyPair keyPair = this.generateKeyPair();
            JsonObject cableRegistration = new JsonObject();
            JsonArray versionArray = new JsonArray();
            JsonObject ver = new JsonObject();
            ver.addProperty("value", 1L);
            versionArray.add(ver);
            cableRegistration.add("versions", versionArray);
            cableRegistration.addProperty("rpPublicKey", BaseEncoding.base64().encode(AuthenticationExtensionsClientInputs.compressECPublicKey((ECPublicKey)keyPair.getPublic())));
            this.registrationExtensions.add("cableRegistration", cableRegistration);
            return keyPair;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JsonObject getRegistrationExtensions() {
        return this.registrationExtensions;
    }

    private KeyPair generateKeyPair() throws Exception {
        ECGenParameterSpec spec = new ECGenParameterSpec("secp256r1");
        KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
        gen.initialize(spec);
        KeyPair keyPair = gen.generateKeyPair();
        return keyPair;
    }

    public static byte[] compressECPublicKey(ECPublicKey publicKey) {
        byte[] x = publicKey.getW().getAffineX().toByteArray();
        byte[] y = publicKey.getW().getAffineY().toByteArray();
        byte[] output = new byte[EC_PUBLIC_KEY_LENGTH];
        System.arraycopy(y, y.length - EC_COORDINATE_LENGTH, output, output.length - EC_COORDINATE_LENGTH, EC_COORDINATE_LENGTH);
        System.arraycopy(x, x.length - EC_COORDINATE_LENGTH, output, 1, EC_COORDINATE_LENGTH);
        output[0] = EC_PUBLIC_KEY_PREFIX;
        return output;
    }
}

