/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUserResetSettings
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorUserResetSettings.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private UserManager userManager;

    public MoTwoFactorUserResetSettings(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String referer = request.getHeader("referer");
        String currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        Boolean isAdmin = Boolean.FALSE;
        LOGGER.debug("MoResetSettingsServlet logged in Crowd user : " + currentLoggedInUser);
        LOGGER.debug("Referer = " + referer);
        if (StringUtils.isNotBlank((CharSequence)currentLoggedInUser)) {
            UserProfile user = this.userManager.getRemoteUser();
            isAdmin = Boolean.FALSE;
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                isAdmin = Boolean.TRUE;
            }
        }
        if (StringUtils.containsIgnoreCase((CharSequence)referer, (CharSequence)"userdetails") && BooleanUtils.toBoolean((Boolean)isAdmin)) {
            String username = request.getParameter("username").trim().toLowerCase();
            String usernameSearchKeyword = request.getParameter("usernameSearchKeywordUrl").trim().toLowerCase();
            String status = "";
            List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
            if (configuredUser.contains(username)) {
                configuredUser.remove(username);
                status = "SUCCESS";
            } else {
                status = "ERROR";
            }
            this.settings.setListOf2FAConfiguredUsers(configuredUser);
            if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
                this.settings.removeUserSettings(username);
            }
            String startIndex = request.getParameter("startIndex");
            String endIndex = request.getParameter("endIndex");
            if (StringUtils.isBlank((CharSequence)startIndex) || StringUtils.isBlank((CharSequence)endIndex)) {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/userdetails?action=reset2fa&username=" + username + "&status=" + status + "&usernameSearchKeywordUrl=" + usernameSearchKeyword));
            } else {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/userdetails?action=reset2fa&username=" + username + "&status=" + status + "&usernameSearchKeywordUrl=" + usernameSearchKeyword + "&startIndex=" + startIndex + "&endIndex=" + endIndex));
            }
        } else {
            LOGGER.debug("You don't have an access to Reset the 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

