/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorTestTemplateChanges
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorTestTemplateChanges.class);
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorTestTemplateChanges(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorTestTemplateChanges doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            HttpSession session = request.getSession();
            String templatePage = (String)session.getAttribute("templatePage");
            session.removeAttribute("templatePage");
            if (StringUtils.isNotBlank((CharSequence)templatePage)) {
                UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
                String displayName = userProfile.getFullName();
                if (StringUtils.isBlank((CharSequence)displayName)) {
                    displayName = username;
                }
                templatePage = templatePage.replace("type=\"submit\"", "type=\"button\"");
                templatePage = templatePage.replace("<meta name='decorator' content='atl.general'>", "");
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("username", displayName);
                context.put("logoutUrl", "#");
                context.put("nextPage", "#");
                String secretKey = "0123456789";
                String qrcode = MoTwoFactorUtility.generateQrCode(secretKey, username, this.settings.getAppLabel("Crowd"));
                context.put("qrcode", qrcode);
                context.put("secretKey", secretKey);
                List<String> backupCodes = this.generateTestBackUpCodes();
                context.put("backupCodes", backupCodes);
                context.put("downloadBackupCodeUrl", "#");
                if (this.settings.getSecurityQuestionsList().isEmpty()) {
                    this.settings.setSecurityQuestionsList(MoTwoFactorUtility.getQuestionList());
                }
                context.put("questionList", this.settings.getSecurityQuestionsList());
                context.put("securityQuestionNumber", this.getSecurityQuestionNumber(2));
                context.put("successMessage", "");
                context.put("warningMessage", new ArrayList());
                context.put("errorMessage", new ArrayList());
                context.put("countryCode", this.settings.getDefaultContryCode());
                context.put("mobileNumber", "74********");
                context.put("shouldShowLinkToValidateListMethod", "#");
                context.put("validate2faMethodListUrl", "#");
                context.put("questionsListForUser", this.getSecurityQuestionForUsers());
                context.put("otp", "$$$");
                context.put("googleAuthenticatorEnabled", Boolean.TRUE);
                context.put("otpOverSmsEnabled", Boolean.TRUE);
                context.put("securityQuestionEnabled", Boolean.TRUE);
                context.put("backupCodeEnabled", Boolean.TRUE);
                context.put("errorMessage", "");
                context.put("continueConfigurationUrl", "#");
                context.put("skipConfigurationUrl", "#");
                context.put("googleAuthenticatorConfigured", Boolean.TRUE);
                context.put("otpOverSmsConfigured", Boolean.TRUE);
                context.put("securityQuestionConfigured", Boolean.TRUE);
                String result = this.renderer.renderFragment(templatePage, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
        }
        LOGGER.debug("user is not logged in ");
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write("Issue with page rendering. Please try again.");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorTestTemplateChanges doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String templatePage = request.getParameter("templatePage");
            HttpSession session = request.getSession();
            session.setAttribute("templatePage", (Object)templatePage);
            response.setStatus(200);
            return;
        }
        response.setStatus(500);
    }

    private List<String> getSecurityQuestionForUsers() {
        ArrayList<String> securityQuestions = new ArrayList<String>();
        securityQuestions.add("This is Question 1");
        securityQuestions.add("This is Question 2");
        return securityQuestions;
    }

    private List<String> getSecurityQuestionNumber(int securityQuestionCount) {
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    private List<String> generateTestBackUpCodes() {
        ArrayList<String> backupCode = new ArrayList<String>();
        for (int i = 0; i < 15; ++i) {
            backupCode.add(this.randomAlphaNumericString(15));
        }
        return backupCode;
    }

    private String randomAlphaNumericString(int count) {
        String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

