/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxCallsViewServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxCallsViewServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private Boolean responseSent;

    public MoTwoFactorAjaxCallsViewServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Calling Ajax View access");
        String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action"));
        LOGGER.debug("action to perform :" + action);
        this.responseSent = Boolean.FALSE;
        if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
            LOGGER.error("Invalid license found");
            this.sendErrorResponse("Invalid License Found", response);
            return;
        }
        if (!this.pluginHandler.isTwoFactorVerifiedOrIsTwoFactorDisabled(request).booleanValue()) {
            LOGGER.error("Either 2FA is not verified by the user or 2FA is disabled for them");
            this.sendErrorResponse("Not enough permission", response);
            return;
        }
        List<String> userAccessiblePages = this.pluginHandler.getUserAccessiblePages();
        if (userAccessiblePages.contains("User_Management_read") || userAccessiblePages.contains("User_Management_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "ChangeUserManagementSelectedAction": {
                    this.changeUserManagementSelectedAction(request, response);
                    break;
                }
                case "fetchGroups": {
                    this.fetchGroups(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("IP_Restriction_read") || userAccessiblePages.contains("IP_Restriction_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "ChangeIpManagementSelectedAction": {
                    this.changeIpManagementSelectedAction(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("Advanced_Settings_read") || userAccessiblePages.contains("Advanced_Settings_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "fetchGroups": {
                    this.fetchGroups(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("Audit_Logs_read") || userAccessiblePages.contains("Audit_Logs_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "ChangeAuditLogsSelectedAction": {
                    this.ChangeAuditLogsSelectedAction(request, response);
                }
            }
        }
        if (!this.responseSent.booleanValue()) {
            LOGGER.error("The Requested method is not allowed or the user do not have enough access");
            response.setContentType("application/json");
            response.sendError(405, "The requested method is not allowed or user does not have not enough . Choose valid Method");
        }
    }

    private void ChangeAuditLogsSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        this.settings.setAuditLogsSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void changeIpManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = MoTwoFactorUtility.sanitizeText(request.getParameter("selectedAction"));
        this.settings.setIpManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void fetchGroups(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Calling fetchGroups");
        try {
            String search = MoTwoFactorUtility.sanitizeText(StringUtils.trim((String)request.getParameter("search")));
            List<String> groups2 = this.pluginHandler.getGroupsFromCrowdUsingGroupname(search, 0);
            JsonObject data = new JsonObject();
            JsonArray resultArray = new JsonArray();
            for (String groupName : groups2) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", groupName);
                jsonObject.addProperty("text", groupName);
                resultArray.add(jsonObject);
            }
            LOGGER.debug("Sending array : " + resultArray);
            data.add("results", resultArray);
            this.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching groups ", e);
        }
    }

    private void changeUserManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String selectedAction = request.getParameter("selectedAction");
        this.settings.setUserManagementSelectedAction(selectedAction);
        this.sendSuccessFullResponse("Success", response);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }
}

