/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAdvancedSettings
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdvancedSettings.class);
    private static final String VM_PATH = "/templates/com/miniorange/twofactor/crowd/advancedsettings.vm";
    private UserManager userManager;
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    public String message = "";
    public ArrayList errorMessage;
    public Boolean showWarningMssg;

    public MoTwoFactorAdvancedSettings(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Advanced Settings Servlet doGet() called.");
        this.showWarningMssg = false;
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Advanced_Settings");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            String primaryMethodForUser = this.settings.getPrimary2faMethodForUser();
            this.renderer.render(VM_PATH, this.initializeConfig(primaryMethodForUser), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Advanced Settings Servlet doPost() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Advanced_Settings");
        this.errorMessage = new ArrayList();
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            Boolean redirectionBasedOnAbsoluteUrl = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("redirectionBasedOnAbsoluteUrl")));
            Boolean settingsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("settingsSubmitted")));
            String primaryMethodForUser = MoTwoFactorUtility.sanitizeText(request.getParameter("primaryMethodForUser"));
            if (BooleanUtils.toBoolean((Boolean)settingsSubmitted)) {
                Object groups2;
                Boolean allowUserSpecificRememberMeDeviceDuration = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("allowUserSpecificRememberMeDeviceDuration")));
                Boolean enableRememberMeDevice = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("enableRememberMeDevice")));
                String rememberMeDeviceDuration = MoTwoFactorUtility.sanitizeText(request.getParameter("rememberMeDeviceDuration"));
                this.showWarningMssg = false;
                String totalGroupsWithAdminPagesAccessConfigs = MoTwoFactorUtility.sanitizeText(request.getParameter("totalGroupsWithAdminPagesAccessConfigs"));
                int j = Integer.parseInt(totalGroupsWithAdminPagesAccessConfigs);
                HashMap<String, String> groupsWithAdminPagesAccessMapping = new HashMap<String, String>();
                for (int i = 0; i < j; ++i) {
                    String pageName = MoTwoFactorUtility.sanitizeText(request.getParameter("PageName_" + i));
                    String accessType = MoTwoFactorUtility.sanitizeText(request.getParameter("AccessType_" + i));
                    String value = MoTwoFactorUtility.sanitizeText(request.getParameter("includeGroups_" + i));
                    if (StringUtils.isEmpty((CharSequence)pageName) && StringUtils.isEmpty((CharSequence)accessType) && StringUtils.isEmpty((CharSequence)value)) continue;
                    if (StringUtils.isNotEmpty((CharSequence)pageName) && StringUtils.isNotEmpty((CharSequence)accessType) && StringUtils.isNotEmpty((CharSequence)value)) {
                        String key = pageName + "_" + accessType;
                        groups2 = Arrays.asList(value.split(","));
                        if (!groupsWithAdminPagesAccessMapping.keySet().isEmpty() && groupsWithAdminPagesAccessMapping.containsKey(key)) {
                            String existingGroups = (String)groupsWithAdminPagesAccessMapping.get(key);
                            Iterator iterator2 = groups2.iterator();
                            while (iterator2.hasNext()) {
                                String group = (String)iterator2.next();
                                if (!existingGroups.contains(group)) {
                                    existingGroups = existingGroups + "," + (String)group;
                                    continue;
                                }
                                this.showWarningMssg = true;
                            }
                            groupsWithAdminPagesAccessMapping.put(key, existingGroups);
                            continue;
                        }
                        groupsWithAdminPagesAccessMapping.put(key, value);
                        continue;
                    }
                    this.showWarningMssg = true;
                }
                int totalCntFor2faMethodBasedOnGroups = Integer.parseInt(MoTwoFactorUtility.sanitizeText(request.getParameter("totalCntFor2faMethodBasedOnGroups")));
                int totalCntForSaving2faMethodBasedOnGroups = Integer.parseInt(MoTwoFactorUtility.sanitizeText(request.getParameter("totalCntForSaving2faMethodBasedOnGroups")));
                HashMap<String, String> mfaMethodsBasedOnGroupsNewMap = new HashMap<String, String>();
                for (int i = 0; i < totalCntForSaving2faMethodBasedOnGroups; ++i) {
                    String method = MoTwoFactorUtility.sanitizeText(request.getParameter("method_" + i));
                    groups2 = MoTwoFactorUtility.sanitizeText(request.getParameter("mfaMethodsBasedOnGroups_" + i));
                    if (!StringUtils.isNotBlank((CharSequence)method) || !StringUtils.isNotBlank((CharSequence)groups2)) continue;
                    List<String> groupsList = Arrays.asList(((String)groups2).split(","));
                    if (!mfaMethodsBasedOnGroupsNewMap.keySet().isEmpty() && mfaMethodsBasedOnGroupsNewMap.containsKey(method)) {
                        String existingGroups = (String)mfaMethodsBasedOnGroupsNewMap.get(method);
                        for (String group : groupsList) {
                            if (existingGroups.contains(group)) continue;
                            existingGroups = existingGroups + "," + group;
                        }
                        mfaMethodsBasedOnGroupsNewMap.put(method, existingGroups);
                        continue;
                    }
                    mfaMethodsBasedOnGroupsNewMap.put(method, (String)groups2);
                }
                String[] fallBackMethodsString = request.getParameterValues("fallBackMethods");
                List<Object> fallBackMethods = totalCntFor2faMethodBasedOnGroups != 0 && fallBackMethodsString.length != 0 ? Arrays.asList(fallBackMethodsString) : new ArrayList();
                Boolean enableBruteForceProtection = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("enableBruteForceProtection")));
                String bruteForceNumberOfAttempts = MoTwoFactorUtility.sanitizeText(request.getParameter("bruteForceNumberOfAttempts"));
                String bruteForceTimeInterval = MoTwoFactorUtility.sanitizeText(request.getParameter("bruteForceTimeInterval"));
                String bruteForceCustomTimeInterval = MoTwoFactorUtility.sanitizeText(request.getParameter("bruteForceCustomTimeInterval"));
                String bruteForceCustomTimeDuration = MoTwoFactorUtility.sanitizeText(request.getParameter("bruteForceCustomTimeDuration"));
                String emailTemplateBruteForce = request.getParameter("emailTemplateBruteForce");
                String skip2faUrls = MoTwoFactorUtility.sanitizeText(request.getParameter("skip2faUrls"));
                Boolean enableOneTime2fa = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("enableOneTime2fa")));
                String byPassCookieDomain = MoTwoFactorUtility.sanitizeText(request.getParameter("byPassCookieDomain"));
                String secretKeyForOneTime2FAValidation = MoTwoFactorUtility.sanitizeText(request.getParameter("secretKeyForOneTime2FAValidation"));
                Boolean ignore2FAAfterSso = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("ignore2FAAfterSso")));
                Boolean allowToReconfigureMethod = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("allowToReconfigureMethod")));
                Boolean enableEnforceCurrentMethod = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("enableEnforceCurrentMethod")));
                Boolean showAllConfiguredMethodsDirectly = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("showAllConfiguredMethodsDirectly")));
                Boolean showRemaining2FAMethodsAfterConfiguration = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("showRemaining2FAMethodsAfterConfiguration")));
                Boolean multiLingualSupportToggle = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("multiLingualSupportToggle")));
                Boolean bypass2faAfterCrowdSso = Boolean.parseBoolean(MoTwoFactorUtility.sanitizeText(request.getParameter("bypass2faAfterCrowdSso")));
                String keyProvidedByCrowdSso = MoTwoFactorUtility.sanitizeText(request.getParameter("keyProvidedByCrowdSso"));
                LOGGER.debug("enableOneTime2fa :" + enableOneTime2fa);
                if (StringUtils.isNotBlank((CharSequence)byPassCookieDomain) && byPassCookieDomain.startsWith(".")) {
                    byPassCookieDomain = byPassCookieDomain.substring(1);
                }
                Boolean hasError = BooleanUtils.toBoolean((Boolean)this.doValidate(enableRememberMeDevice, rememberMeDeviceDuration, enableBruteForceProtection, allowUserSpecificRememberMeDeviceDuration, bruteForceNumberOfAttempts, bruteForceTimeInterval, bruteForceCustomTimeInterval, bruteForceCustomTimeDuration, ignore2FAAfterSso, bypass2faAfterCrowdSso, enableEnforceCurrentMethod, primaryMethodForUser, byPassCookieDomain, keyProvidedByCrowdSso, totalCntFor2faMethodBasedOnGroups, fallBackMethodsString));
                StringBuilder builder = new StringBuilder();
                builder.append("Page : Groups : Access Type");
                builder.append("////");
                Map<String, String> groupsWithAdminPagesAccessOldMap = this.settings.getGroupsWithAdminPagesAccess();
                int count = 1;
                for (Map.Entry k : groupsWithAdminPagesAccessMapping.entrySet()) {
                    String accessType;
                    String Page;
                    int lastIndex;
                    if (groupsWithAdminPagesAccessOldMap.containsKey(k.getKey())) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)k.getValue()), (CharSequence)groupsWithAdminPagesAccessOldMap.get(k.getKey()))) continue;
                        lastIndex = ((String)k.getKey()).lastIndexOf("_");
                        Page = ((String)k.getKey()).substring(0, lastIndex).replace("_", " ");
                        accessType = ((String)k.getKey()).split("_")[((String)k.getKey()).split("_").length - 1];
                        accessType = accessType.contains("write") ? "EDIT" : "VIEW";
                        builder.append(count).append(") ").append(Page).append(": ").append((String)k.getValue()).append(": ").append(accessType);
                        builder.append("////");
                        ++count;
                        continue;
                    }
                    lastIndex = ((String)k.getKey()).lastIndexOf("_");
                    Page = ((String)k.getKey()).substring(0, lastIndex).replace("_", " ");
                    accessType = ((String)k.getKey()).split("_")[((String)k.getKey()).split("_").length - 1];
                    accessType = accessType.contains("write") ? "EDIT" : "VIEW";
                    builder.append(count).append(") ").append(Page).append(": ").append((String)k.getValue()).append(": ").append(accessType);
                    builder.append("////");
                    ++count;
                }
                if (count != 1) {
                    this.pluginHandler.storeAdminsAuditLogs("Access to plugins pages", "Updated Advanced Options Tab", builder.toString(), request);
                }
                if (!hasError.booleanValue()) {
                    this.pluginHandler.saveAdvanced2FASettings(enableBruteForceProtection, bruteForceNumberOfAttempts, bruteForceTimeInterval, bruteForceCustomTimeInterval, bruteForceCustomTimeDuration, emailTemplateBruteForce, enableRememberMeDevice, rememberMeDeviceDuration, allowUserSpecificRememberMeDeviceDuration, bypass2faAfterCrowdSso, secretKeyForOneTime2FAValidation, byPassCookieDomain, ignore2FAAfterSso, skip2faUrls, groupsWithAdminPagesAccessMapping, multiLingualSupportToggle, allowToReconfigureMethod, enableEnforceCurrentMethod, primaryMethodForUser, showAllConfiguredMethodsDirectly, showRemaining2FAMethodsAfterConfiguration, keyProvidedByCrowdSso, redirectionBasedOnAbsoluteUrl, mfaMethodsBasedOnGroupsNewMap, fallBackMethods, request);
                    this.message = "Advanced Options Updated.";
                    LOGGER.info("Successfully save configuration");
                }
            }
            HashMap<String, Object> context = this.initializeConfig(primaryMethodForUser);
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                context.put("message", this.message);
            } else if (!this.errorMessage.isEmpty()) {
                context.put("errorMessage", this.errorMessage);
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    public Boolean doValidate(Boolean enableRememberMeDevice, String rememberMeDeviceDuration, Boolean enableBruteForceProtection, Boolean allowUserSpecificRememberMeDeviceDuration, String bruteForceNumberOfAttempts, String bruteForceTimeInterval, String bruteForceCustomTimeInterval, String bruteForceCustomTimeDuration, Boolean ignore2FAAfterSso, Boolean bypass2faAfterCrowdSso, Boolean enableEnforceCurrentMethod, String primaryMethodForUser, String byPassCookieDomain, String keyProvidedByCrowdSso, int totalCntFor2faMethodBasedOnGroups, String[] fallBackMethodsString) {
        int number;
        LOGGER.debug("Configure Action doValidate");
        Boolean hasError = Boolean.FALSE;
        try {
            if (BooleanUtils.toBoolean((Boolean)enableRememberMeDevice)) {
                number = Integer.parseInt(rememberMeDeviceDuration);
                LOGGER.debug("number : " + number);
                if (number > 365 || number < 1) {
                    this.errorMessage.add("The expiry time must be between 1 and 365.");
                    hasError = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            this.errorMessage.add("Please enter valid Expiry Time. Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection) && ((number = Integer.parseInt(bruteForceNumberOfAttempts)) > 10 || number < 1)) {
                this.errorMessage.add("Invalid Number of Login attempts Entered. The Login Attempt must be between 1 and 10.");
                hasError = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.errorMessage.add("Please enter valid Number of Login attempts. Number of Login attempts should be in number format.");
            hasError = Boolean.TRUE;
        }
        if (!BooleanUtils.toBoolean((Boolean)bypass2faAfterCrowdSso)) {
            bypass2faAfterCrowdSso = Boolean.FALSE;
        }
        try {
            if (BooleanUtils.toBoolean((Boolean)enableBruteForceProtection)) {
                if (!this.getBruteForceTimeIntervalArray().contains(bruteForceTimeInterval)) {
                    this.errorMessage.add("Please select valid Time Interval");
                    hasError = Boolean.TRUE;
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"custom", (CharSequence)bruteForceTimeInterval)) {
                    if (!this.getBruteForceCustomTimeIntervalArray().contains(bruteForceCustomTimeInterval)) {
                        this.errorMessage.add("Please select valid Time Custom Interval");
                        hasError = Boolean.TRUE;
                    } else {
                        int number2 = Integer.parseInt(bruteForceCustomTimeDuration);
                        if (number2 < 1) {
                            this.errorMessage.add("The Custom Locking Expiry Time should be greater than equal to 1.");
                            hasError = Boolean.TRUE;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.errorMessage.add("Please enter valid Locking Expiry Time. Locking Expiry Time should be in number format.");
            hasError = Boolean.TRUE;
        }
        List<String> twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        if (twoFactorMethodForUserList != null && !twoFactorMethodForUserList.isEmpty() && BooleanUtils.toBoolean((Boolean)enableEnforceCurrentMethod) && !twoFactorMethodForUserList.contains(primaryMethodForUser)) {
            this.errorMessage.add("Please select the valid Primary method. It should be among selected 2fa methods for end users.");
            hasError = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)ignore2FAAfterSso) && StringUtils.isBlank((CharSequence)keyProvidedByCrowdSso)) {
            this.errorMessage.add("Empty Secret Key Provided by Crowd SSO. Please add valid secret key.");
            hasError = Boolean.TRUE;
        }
        if (BooleanUtils.toBoolean((Boolean)bypass2faAfterCrowdSso) && !this.validateOneTime2faDomain(byPassCookieDomain).booleanValue()) {
            this.errorMessage.add("Invalid Crowd Cookie Domain found. Please add valid Cookie Domain Provided by Crowd.");
            hasError = Boolean.TRUE;
        }
        LOGGER.debug("totalCntFor2faMethodBasedOnGroups :" + totalCntFor2faMethodBasedOnGroups);
        if (totalCntFor2faMethodBasedOnGroups != 0 && fallBackMethodsString == null) {
            this.errorMessage.add("Fall back method or 2FA Methods Based on Groups can not be empty.");
            hasError = Boolean.TRUE;
        } else if (fallBackMethodsString != null && Collections.disjoint(twoFactorMethodForUserList, Arrays.asList(fallBackMethodsString))) {
            this.errorMessage.add("Select at least one primary method in fallback method.");
            hasError = Boolean.TRUE;
        }
        return hasError;
    }

    public Boolean validateOneTime2faDomain(String bypassCookieDomain) {
        String domainRegex = "^[a-zA-Z0-9.-]{2,}$";
        String urlRegex = "^(https?|ftp)://[^\\s/$.?#].[^\\s]*$";
        Pattern domainRegexPattern = Pattern.compile(domainRegex);
        Pattern urlRegexPattern = Pattern.compile(urlRegex);
        Matcher domainRegexMatcher = domainRegexPattern.matcher(bypassCookieDomain);
        Matcher urlRegexMatcher = urlRegexPattern.matcher(bypassCookieDomain);
        if (domainRegexMatcher.matches() && !urlRegexMatcher.matches()) {
            return true;
        }
        return false;
    }

    private HashMap<String, Object> initializeConfig(String primaryMethodForUser) {
        LOGGER.debug("inside initializeConfig...");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("enableRememberMeDevice", this.settings.getEnableRememberMeDevice());
        context.put("rememberMeDeviceDuration", this.settings.getRememberMeDeviceDuration());
        context.put("allowUserSpecificRememberMeDeviceDuration", this.settings.getAllowUserSpecificRememberMeDeviceDuration());
        context.put("enableBruteForceProtection", this.settings.getEnableBruteForceProtection());
        context.put("bruteForceNumberOfAttempts", this.settings.getBruteForceNumberOfAttempts());
        context.put("bruteForceTimeInterval", this.settings.getBruteForceTimeInterval());
        context.put("bruteForceCustomTimeInterval", this.settings.getBruteForceCustomTimeInterval());
        context.put("bruteForceCustomTimeDuration", this.settings.getBruteForceCustomTimeDuration());
        context.put("emailTemplateBruteForce", this.settings.getEmailTemplateBruteForce());
        context.put("skip2faUrls", this.settings.getSkip2faUrls());
        context.put("bypass2FACookieDomain", this.settings.getBypass2FACookieDomain());
        context.put("secretKeyForOneTime2FAValidation", this.settings.getSecretKeyForOneTime2FAValidation());
        context.put("ignore2FAAfterSso", this.settings.getIgnore2FAAfterSso());
        context.put("keyProvidedByCrowdSso", this.settings.getSecretKeyProvidedByCrowdSso());
        context.put("allowToReconfigureMethod", this.settings.getAllowToReconfigureConfigured2faMethod());
        context.put("enableEnforceCurrentMethod", this.settings.getEnableEnforce2faMethodForUser());
        context.put("primaryMethodForUser", this.settings.getPrimary2faMethodForUser());
        context.put("showAllConfiguredMethodsDirectly", this.settings.getShowAllConfiguredMethodToUser());
        context.put("showRemaining2FAMethodsAfterConfiguration", this.settings.getShowRemaining2FAMethodsAfterInlineRegistration());
        context.put("skip2FAForGivenUrlList", this.settings.getSkip2FAForGivenUrlList());
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("showWarningMssg", this.showWarningMssg);
        context.put("bypass2faAfterCrowdSso", this.settings.getBypass2faAfterCrowdSso());
        context.put("byPassCookieDomain", this.settings.getBypass2FACookieDomain());
        Map<String, String> groupsWithAdminPageAccessMap = this.settings.getGroupsWithAdminPagesAccess();
        TreeMap<String, String> groupsWithAdminPagesAccess = new TreeMap<String, String>();
        int totalGroupsWithAdminPagesAccessConfigs = 0;
        for (Map.Entry<String, String> entry : groupsWithAdminPageAccessMap.entrySet()) {
            groupsWithAdminPagesAccess.put(entry.getKey(), entry.getValue());
        }
        totalGroupsWithAdminPagesAccessConfigs = groupsWithAdminPagesAccess.keySet().isEmpty() ? 0 : groupsWithAdminPagesAccess.keySet().size();
        List<String> pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("pagesAccessibleToUser", pagesAccessibleToUser);
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("Advanced_Settings"));
        context.put("totalGroupsWithAdminPagesAccessConfigs", totalGroupsWithAdminPagesAccessConfigs);
        context.put("groupsWithAdminPagesAccess", groupsWithAdminPagesAccess);
        Map<String, String> mfaMethodsBasedOnGroupsMap = this.settings.getMfaMethodsBasedOnGroupsMap();
        TreeMap<String, String> mfaMethodsBasedOnGroups = new TreeMap<String, String>();
        int totalCntFor2faMethodBasedOnGroups = 0;
        for (Map.Entry<String, String> entry : mfaMethodsBasedOnGroupsMap.entrySet()) {
            mfaMethodsBasedOnGroups.put(entry.getKey(), entry.getValue());
        }
        totalCntFor2faMethodBasedOnGroups = mfaMethodsBasedOnGroups.keySet().isEmpty() ? 0 : mfaMethodsBasedOnGroupsMap.keySet().size();
        context.put("totalCntFor2faMethodBasedOnGroups", totalCntFor2faMethodBasedOnGroups);
        context.put("totalCntForSaving2faMethodBasedOnGroups", totalCntFor2faMethodBasedOnGroups);
        context.put("mfaMethodsBasedOnGroupsMap", mfaMethodsBasedOnGroupsMap);
        context.put("fallBackMethods", this.settings.getFallBackMethods());
        List<String> methodsForUser = this.settings.get2FAMethodForUserList();
        context.put("showPrimaryMethodWarning", methodsForUser.contains(primaryMethodForUser));
        ArrayList<String> enabledMethods = new ArrayList<String>();
        enabledMethods.addAll(this.settings.get2FAMethodForUserList());
        enabledMethods.addAll(this.settings.getBackupMethodForUserList());
        context.put("enabledMethods", enabledMethods);
        List<String> primary2FAMethods = this.settings.get2FAMethodForUserList();
        context.put("enabledMethods", enabledMethods);
        context.put("primary2FAMethods", primary2FAMethods);
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("isLicenseExpired", this.pluginSettings.isLicenseExpired());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("smtpConfigured", this.pluginHandler.isSmtpConfigured());
        context.put("redirectionBasedOnAbsoluteUrl", this.settings.getRedirectionBasedOnAbsoluteUrl());
        context.put("customMailServer", this.settings.getCustomMailServer());
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private List<String> getBruteForceTimeIntervalArray() {
        ArrayList<String> bruteForceTimeIntervalArray = new ArrayList<String>();
        bruteForceTimeIntervalArray.add("15 minutes");
        bruteForceTimeIntervalArray.add("30 minutes");
        bruteForceTimeIntervalArray.add("1 hour");
        bruteForceTimeIntervalArray.add("5 hours");
        bruteForceTimeIntervalArray.add("1 day");
        bruteForceTimeIntervalArray.add("7 days");
        bruteForceTimeIntervalArray.add("custom");
        return bruteForceTimeIntervalArray;
    }

    private List<String> getBruteForceCustomTimeIntervalArray() {
        ArrayList<String> bruteForceCustomTimeIntervalArray = new ArrayList<String>();
        bruteForceCustomTimeIntervalArray.add("minutes");
        bruteForceCustomTimeIntervalArray.add("hours");
        bruteForceCustomTimeIntervalArray.add("days");
        return bruteForceCustomTimeIntervalArray;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TemplateRenderer renderer) {
        this.renderer = renderer;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

