/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoEncryptionUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorCrowdPluginSettings {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorCrowdPluginSettings.class);
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private LicenseHandler licenseHandler;
    private PropertyManager propertyManager;

    public MoTwoFactorCrowdPluginSettings(PluginSettingsFactory pluginSettingsFactory, PluginSettings pluginSettings, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, LicenseHandler licenseHandler, PropertyManager propertyManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.licenseHandler = licenseHandler;
        this.propertyManager = propertyManager;
    }

    public String getWelcomeMessageTemplate() {
        String template = this.settings.getWelcomeMessageTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_showinfo.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.settings.setConfigureDuoPushNotificationTemplate(duoPushNotificationTemplate);
    }

    public String getConfigureDuoPushNotificationTemplate() {
        String template = this.settings.getConfigureDuoPushNotificationTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_duopushnotification.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setWelcomeMessageTemplate(String welcomeMessageTemplate) {
        this.settings.setWelcomeMessageTemplate(welcomeMessageTemplate);
    }

    public String getInlineRegistration_2faMethodListTemplate() {
        String template = this.settings.getInlineRegistration_2faMethodListTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_2famethodlist.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setInlineRegistration_2faMethodListTemplate(String inlineRegistration_2faMethodListTemplate) {
        this.settings.setInlineRegistration_2faMethodListTemplate(inlineRegistration_2faMethodListTemplate);
    }

    public String getValidate_2faMethodListTemplate() {
        String template = this.settings.getValidate_2faMethodListTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_2famethodlist.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidate_2faMethodListTemplate(String validate_2faMethodListTemplate) {
        this.settings.setValidate_2faMethodListTemplate(validate_2faMethodListTemplate);
    }

    public String getInlineRegistration_backupMethodListTemplate() {
        String template = this.settings.getInlineRegistration_backupMethodListTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_backupmethodlist.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setInlineRegistration_backupMethodListTemplate(String inlineRegistration_backupMethodListTemplate) {
        this.settings.setInlineRegistration_backupMethodListTemplate(inlineRegistration_backupMethodListTemplate);
    }

    public String getInlineRegistration_remaining2faMethodsListTemplate() {
        String template = this.settings.getInlineRegistration_remaining2faMethodsListTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_remaining2famethods.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setInlineRegistration_remaining2faMethodsListTemplate(String inlineRegistration_remaining2faMethodsListTemplate) {
        this.settings.setInlineRegistration_remaining2faMethodsListTemplate(inlineRegistration_remaining2faMethodsListTemplate);
    }

    public void setValidateDuoPushNotificationTemplate(String duoPushNotificationTemplate) {
        this.settings.setValidateDuoPushNotificationTemplate(duoPushNotificationTemplate);
    }

    public String getValidateDuoPushNotificationTemplate() {
        String template = this.settings.getValidateDuoPushNotificationTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_duopushnotification.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public String getConfigureGoogleAuthenticatorTemplate() {
        String template = this.settings.getConfigureGoogleAuthenticatorTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_googleauthenticator.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.settings.setConfigureGoogleAuthenticatorTemplate(googleAuthenticatorTemplate);
    }

    public String getValidateGoogleAuthenticatorTemplate() {
        String template = this.settings.getValidateGoogleAuthenticatorTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_otp.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateGoogleAuthenticatorTemplate(String googleAuthenticatorTemplate) {
        this.settings.setValidateGoogleAuthenticatorTemplate(googleAuthenticatorTemplate);
    }

    public String getConfigureSecurityQuestionTemplate() {
        String template = this.settings.getConfigureSecurityQuestionTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_securityquestion.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.settings.setConfigureSecurityQuestionTemplate(securityQuestionTemplate);
    }

    public String getValidateSecurityQuestionTemplate() {
        String template = this.settings.getValidateSecurityQuestionTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_securityquestion.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateSecurityQuestionTemplate(String securityQuestionTemplate) {
        this.settings.setValidateSecurityQuestionTemplate(securityQuestionTemplate);
    }

    public String getConfigureU2FHardwareTokenTemplate() {
        String template = this.settings.getConfigureU2FHardwareTokenTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_webauthnhardwaretoken.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureU2FHardwareTokenTemplate(String configureU2FHardwareTokenTemplate) {
        this.settings.setConfigureU2FHardwareTokenTemplate(configureU2FHardwareTokenTemplate);
    }

    public String getConfigureWebAuthnHardwareTokenTemplate() {
        String template = this.settings.getConfigureWebAuthnHardwareTokenTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_webauthnhardwaretoken.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureWebAuthnHardwareTokenTemplate(String configureWebAuthnHardwareTokenTemplate) {
        this.settings.setConfigureWebAuthnHardwareTokenTemplate(configureWebAuthnHardwareTokenTemplate);
    }

    public String getValidateWebAuthnHardwareTokenTemplate() {
        String template = this.settings.getValidateWebAuthnHardwareTokenTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_webauthnhardwareToken.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateWebAuthnHardwareTokenTemplate(String validateWebAuthnHardwareTokenTemplate) {
        this.settings.setValidateWebAuthnHardwareTokenTemplate(validateWebAuthnHardwareTokenTemplate);
    }

    public void setConfigureWebAuthnAs2faMethodTemplate(String configureWebAuthnAs2faMethodTemplate) {
        this.settings.setConfigureWebAuthnAs2faMethodTemplate(configureWebAuthnAs2faMethodTemplate);
    }

    public String getConfigureWebAuthnAs2faMethodTemplate() {
        String template = this.settings.getConfigureWebAuthnAs2faMethodTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_webauthnas2famethod.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateWebAuthnAs2faMethodTemplate(String validateWebAuthnAs2faMethodTemplate) {
        this.settings.setValidateWebAuthnAs2faMethodTemplate(validateWebAuthnAs2faMethodTemplate);
    }

    public String getValidateWebAuthnAs2faMethodTemplate() {
        String template = this.settings.getValidateWebAuthnAs2faMethodTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_webauthnas2famethod.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public String getConfigureOtpOverEmailTemplate() {
        String template = this.settings.getConfigureOtpOverEmailTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_otpoveremail.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.settings.setConfigureOtpOverEmailTemplate(otpOverEmailTemplate);
    }

    public String getValidateOtpOverEmailTemplate() {
        String template = this.settings.getValidateOtpOverEmailTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_otpoveremail.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateOtpOverEmailTemplate(String otpOverEmailTemplate) {
        this.settings.setValidateOtpOverEmailTemplate(otpOverEmailTemplate);
    }

    public String getConfigureOtpOverSmsTemplate() {
        String template = this.settings.getConfigureOtpOverSmsTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_otpoversms.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        if (!template.contains("minio_token")) {
            String[] htmlList = template.split("\n");
            List<String> linesList = Arrays.asList(htmlList);
            String finalTemplate = "";
            for (String line : linesList) {
                finalTemplate = finalTemplate + line + "\n";
                if (!StringUtils.contains((CharSequence)line, (CharSequence)"otp-Code")) continue;
                finalTemplate = finalTemplate + "<input type=\"hidden\" name=\"minio_token\" id=\"minio_token\" value=\"$minio_token\"/>\n";
            }
            return finalTemplate;
        }
        return template;
    }

    public void setConfigureOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.settings.setConfigureOtpOverSmsTemplate(otpOverSmsTemplate);
    }

    public String getValidateOtpOverSmsTemplate() {
        String template = this.settings.getValidateOtpOverSmsTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_otpoversms.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateOtpOverSmsTemplate(String otpOverSmsTemplate) {
        this.settings.setValidateOtpOverSmsTemplate(otpOverSmsTemplate);
    }

    public String getConfigureBackupCodeTemplate() {
        String template = this.settings.getConfigureBackupCodeTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/inlineregistration_backupcode.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setConfigureBackupCodeTemplate(String backupCodeTemplate) {
        this.settings.setConfigureBackupCodeTemplate(backupCodeTemplate);
    }

    public String getValidateBackupCodeTemplate() {
        String template = this.settings.getValidateBackupCodeTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/validate_backupcode.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setValidateBackupCodeTemplate(String backupCodeTemplate) {
        this.settings.setValidateBackupCodeTemplate(backupCodeTemplate);
    }

    public String getLockedUserTemplate() {
        String template = this.settings.getLockedUserTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/userlocked_showinfo.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setLockedUserTemplate(String lockedUserTemplate) {
        this.settings.setLockedUserTemplate(lockedUserTemplate);
    }

    public String getBlocklistIpTemplate() {
        String template = this.settings.getBlocklistIpTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            try {
                String templatePath = "/templates/com/miniorange/twofactor/crowd/accessdenied.vm";
                template = IOUtils.toString((InputStream)MoTwoFactorCrowdPluginSettings.class.getResourceAsStream(templatePath), (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e);
                return "";
            }
        }
        return template;
    }

    public void setBlocklistIpTemplate(String blocklistIpTemplate) {
        this.settings.setBlocklistIpTemplate(blocklistIpTemplate);
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public String getCustomerID() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.CUSTOMER_ID"))).trim();
    }

    public void setCustomerId(String customerId) {
        this.pluginSettings.put("miniorange.twofactor.CUSTOMER_ID", (Object)customerId);
    }

    public String getCustomerEmail() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.CUSTOMER_EMAIL")));
    }

    public void setCustomerEmail(String email) {
        this.pluginSettings.put("miniorange.twofactor.CUSTOMER_EMAIL", (Object)StringUtils.trimToEmpty((String)email));
    }

    public String getCustomerAPIKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.CUSTOMER_API_KEY"))).trim();
    }

    public void setCustomerAPIKey(String customerId) {
        this.pluginSettings.put("miniorange.twofactor.CUSTOMER_API_KEY", (Object)customerId);
    }

    public String getCustomerTokenKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.CUSTOMER_TOKEN_KEY")));
    }

    public void setCustomerTokenKey(String customerId) {
        this.pluginSettings.put("miniorange.twofactor.CUSTOMER_TOKEN_KEY", (Object)customerId);
    }

    public Boolean isCustomerRegistered() {
        if (StringUtils.isBlank((CharSequence)this.getCustomerID()) || StringUtils.isBlank((CharSequence)this.getCustomerEmail()) || StringUtils.isBlank((CharSequence)this.getCustomerAPIKey()) || StringUtils.isBlank((CharSequence)this.getCustomerTokenKey())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getLicencedUsers() {
        try {
            String licencedUsers = (String)this.pluginSettings.get("miniorange.twofactor.LICENCED_USERS");
            return Integer.valueOf(licencedUsers);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setLicencedUsers(Integer userCount) {
        String licencedUsers = userCount.toString();
        this.pluginSettings.put("miniorange.twofactor.LICENCED_USERS", (Object)licencedUsers);
    }

    public String getCustomerLicenseKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.CUSTOMER_LICENSE_KEY")));
    }

    public void setCustomerLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.twofactor.CUSTOMER_LICENSE_KEY", (Object)StringUtils.trimToEmpty((String)licenseKey));
    }

    public Boolean getMailSent() {
        return BooleanUtils.toBoolean((String)((String)this.pluginSettings.get("miniorange.twofactor.MAIL_SENT")));
    }

    public void setMailSent(Boolean mailSent) {
        this.pluginSettings.put("miniorange.twofactor.MAIL_SENT", (Object)BooleanUtils.toString((Boolean)mailSent, (String)"true", (String)"false", (String)"false"));
    }

    public void setLicenseVerified(Boolean licenseVerified) {
        String value = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), BooleanUtils.toString((Boolean)licenseVerified, (String)"true", (String)"false", (String)"false"));
        this.pluginSettings.put("miniorange.twofactor.LICENSE_VERIFIED", (Object)value);
    }

    public Boolean getLicenseVerified() {
        String value = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.LICENSE_VERIFIED")));
        return StringUtils.isNotBlank((CharSequence)value) ? BooleanUtils.toBoolean((String)MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), value)) : false;
    }

    public String getLicenseType() {
        String licenseTypeValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.IS_TRIAL_LICENSE"))));
        return licenseTypeValue;
    }

    public void setLicenseType(String licenseType) {
        String licenseTypeValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseType);
        this.pluginSettings.put("miniorange.twofactor.IS_TRIAL_LICENSE", (Object)licenseTypeValue);
    }

    public String getLicenseExpireDate() {
        String licenseExpireDateValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.LICENSE_EXPIRE_DATE"))));
        return licenseExpireDateValue;
    }

    public String getLicenseVerifiedWithoutDefaultValue() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.twofactor.LICENSE_VERIFIED")));
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        String licenseExpireDateValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseExpireDate);
        this.pluginSettings.put("miniorange.twofactor.LICENSE_EXPIRE_DATE", (Object)licenseExpireDateValue);
    }

    public Boolean isNoOfUserExceed() {
        try {
            Integer licencedUsers = this.getLicencedUsers();
            if (licencedUsers > 20000) {
                return Boolean.FALSE;
            }
            Integer crowdUserTier = this.propertyManager.getCurrentLicenseResourceTotal();
            if (crowdUserTier > licencedUsers) {
                LOGGER.debug("No of Crowd user exceeded");
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while licensed user check ", e);
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseExpired() {
        try {
            String licenseExpireDateString = this.getLicenseExpireDate();
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            Date currentDate = new Date();
            if (!currentDate.before(licenseExpireDate)) {
                LOGGER.debug("License is expired");
                this.setLicenseVerified(Boolean.FALSE);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license", e);
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseExpired(String licenseExpireDateString) {
        try {
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            Date currentDate = new Date();
            if (!currentDate.before(licenseExpireDate)) {
                LOGGER.debug("License is expired");
                this.setLicenseVerified(Boolean.FALSE);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license", e);
        }
        return Boolean.FALSE;
    }

    public Integer getDaysLeftToExpire() {
        try {
            String licenseExpireDateString = this.getLicenseExpireDate();
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            Date currentDate = new Date();
            Integer daysLeft = (int)((licenseExpireDate.getTime() - currentDate.getTime()) / 86400000L);
            if (daysLeft >= 0) {
                LOGGER.debug("Days Left to Expire : " + daysLeft);
                return daysLeft;
            }
            LOGGER.debug("License Expired.");
            return -2;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while calculating days left to expire", e);
            return -1;
        }
    }

    public Boolean isTrialLicense() {
        String licenseType = this.getLicenseType();
        if (StringUtils.equalsIgnoreCase((CharSequence)licenseType, (CharSequence)"TRIAL")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void removeCustomerAccount() {
        this.pluginSettings.put("miniorange.twofactor.LICENSE_VERIFIED", (Object)MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), "false"));
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_TOKEN_KEY");
        this.pluginSettings.remove("miniorange.twofactor.CUSTOMER_LICENSE_KEY");
        this.pluginSettings.remove("miniorange.twofactor.ACTIVE_USERS");
        this.pluginSettings.remove("miniorange.twofactor.LICENCED_USERS");
        this.pluginSettings.remove("miniorange.twofactor.LICENSE_EXPIRE_DATE");
        this.pluginSettings.remove("miniorange.twofactor.IS_TRIAL_LICENSE");
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.settings.getMultiLingualSupportToggle();
    }

    public String getBaseUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.twofactor.BASE_URL")), (CharSequence)this.pluginConfiguration.getBaseUrl());
    }

    public String getExportAuditLogsUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/exportAuditLogs");
    }
}

