/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.encoder;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.AbstractEncoder;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.SimpleValue;
import java.io.OutputStream;

public class ByteStringEncoder
extends AbstractEncoder<ByteString> {
    public ByteStringEncoder(CborEncoder encoder, OutputStream outputStream2) {
        super(encoder, outputStream2);
    }

    @Override
    public void encode(ByteString byteString) throws CborException {
        byte[] bytes = byteString.getBytes();
        if (byteString.isChunked()) {
            this.encodeTypeChunked(MajorType.BYTE_STRING);
            if (bytes != null) {
                this.encode(new ByteString(bytes));
            }
        } else if (bytes == null) {
            this.encoder.encode(SimpleValue.NULL);
        } else {
            this.encodeTypeAndLength(MajorType.BYTE_STRING, bytes.length);
            this.write(bytes);
        }
    }
}

