/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistration
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistration.class);
    private static final String INLINEREGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_showinfo.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorInlineRegistration(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginHandler pluginHandler) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistration doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && !this.settings.getListOf2FAConfiguredUsers().contains(username)) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            String nextPageUrl = "";
            Map<String, String> inlineRegistrationUrls = this.settings.getInlineRegistrationUrls();
            List<String> methodsForUser = this.settings.get2FAMethodForUserList();
            String method = this.settings.getPrimary2faMethodForUser();
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser()) && methodsForUser.contains(method)) {
                LOGGER.debug("Enforce Primary method is selected : " + method);
                if (this.pluginHandler.isPageAllowed(method, username).booleanValue()) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat(inlineRegistrationUrls.get(method));
                }
            }
            if (StringUtils.isBlank((CharSequence)nextPageUrl)) {
                int enabledAndConfiguredPrimaryAndBackupMethods = 0;
                for (String methods : methodsForUser) {
                    if (!this.pluginHandler.isPageAllowed(methods, username).booleanValue()) continue;
                    ++enabledAndConfiguredPrimaryAndBackupMethods;
                }
                if (enabledAndConfiguredPrimaryAndBackupMethods > 1) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2famethodlist");
                } else {
                    for (String methodName : inlineRegistrationUrls.keySet()) {
                        if (!methodsForUser.contains(methodName) || !this.pluginHandler.isPageAllowed(methodName, username).booleanValue()) continue;
                        nextPageUrl = this.pluginConfiguration.getBaseUrl().concat(inlineRegistrationUrls.get(methodName));
                        break;
                    }
                }
            }
            context.put("nextPage", nextPageUrl);
            String template = this.pluginSettings.getWelcomeMessageTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(INLINEREGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

