/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.crowd.scheduler.UpdateLicenseService;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAccountDetailsAction
extends HttpServlet {
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private TemplateRenderer renderer;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UpdateLicenseService updateLicenseService;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAccountDetailsAction.class);
    private static final String ACCOUNTDETAILS_VM_PATH = "/templates/com/miniorange/twofactor/crowd/account.vm";
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorAccountDetailsAction(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCommonPluginSettings settings, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginHandler pluginHandler, UpdateLicenseService updateLicenseService, MoTwoFactorPluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.updateLicenseService = updateLicenseService;
        this.pluginConfiguration = pluginConfiguration;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorAccountDetailsAction Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("User_Management");
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render(ACCOUNTDETAILS_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Account Details Action: execute() called");
        this.message = "";
        this.errorMessage = new ArrayList();
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("User_Management");
        try {
            if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                    return;
                }
                String reregister = MoTwoFactorUtility.sanitizeText(request.getParameter("reregister"));
                String checklicense = MoTwoFactorUtility.sanitizeText(request.getParameter("checklicense"));
                if (reregister != null && BooleanUtils.toBoolean((String)reregister)) {
                    LOGGER.debug("deactivating customer account");
                    this.pluginHandler.deactivateAndRemoveCustomerAccount();
                    this.updateLicenseService.unschedule();
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                    return;
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                    return;
                }
                if (this.pluginSettings.isCustomerRegistered().booleanValue() && BooleanUtils.toBoolean((String)checklicense)) {
                    LOGGER.debug("check license...");
                    this.pluginHandler.getLicencedUsers(this.pluginSettings);
                    this.message = "License check success";
                }
            } else {
                response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(ACCOUNTDETAILS_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        }
        catch (MoTwoFactorPluginException e) {
            this.pluginHandler.deactivateAndRemoveCustomerAccount();
            LOGGER.error(e.getMessage());
            this.errorMessage.add("License Not Found. Please contact support-atlassian@miniorange.atlassian.net for more details.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
            return;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while while verifying license against registered account ", e);
            this.initializeConfig();
            this.errorMessage.add("An error occurred please check logs for more information");
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(ACCOUNTDETAILS_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        }
    }

    private Map<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("email", this.pluginSettings.getCustomerEmail());
        context.put("customerId", this.pluginSettings.getCustomerID());
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("licensedUser", this.pluginSettings.getLicencedUsers());
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("multiLingualSupportToggle", this.pluginSettings.getMultiLingualSupportToggle());
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

